#-------------------------------------------------------------------------------
#  a2w/core/ext/Container.pm:
#  Extension module with additional processing functionalities
#
#  Author  : Fa. Maas
#
#  V103   2021-06-10    AFP-1046: Extended to get page id (in which object exists) and unique name
#
#  V102   2020-10-12    AFP-979: Extended with _toString() API to dump object
#
#  V101   2020-03-05    a. AFP-929: Extended to support foreground color attribute
#                       b. AFP-929: Extended with unique colors count API
#
#  V100   2018-01-10    Initial Release
#
#-------------------------------------------------------------------------------

#
# NOTE:
# Though the filename is a2w/core/ext/Container.pm, in actual it is 'a2w::Container' module extension
#

package a2w::Container;

use a2w::Container;
use a2w::core::log::Logger;

#-----------------------------------------------------------------------
# Workers
#-----------------------------------------------------------------------
#------------------------------------------------------------------------
# _getType
#
# Get type of object
#
# Returns
#   Object type
#
#------------------------------------------------------------------------
sub _getType{
    $this = shift;
    
    #---- Get logger
    $theLoggerLocal = a2w::core::log::Logger->getSingleton();
    my $bLogTmp = $theLoggerLocal->isRegistered( __PACKAGE__ );

    if ( $bLogTmp ){
        $theLoggerLocal->logFunctionName( __PACKAGE__, "_getType" );
    }

    return "container";
}

#------------------------------------------------------------------------
# _getAttribute
#
# Get value of given attribute
#
# Parameter
# 1. Attribute name
#
# Returns
#   Attribute value, if such attribute exists
#   undef otherwise
#
#------------------------------------------------------------------------
sub _getAttribute{
    $this = shift;
    
    #---- Get logger
    $theLoggerLocal = a2w::core::log::Logger->getSingleton();
    my $bLogTmp = $theLoggerLocal->isRegistered( __PACKAGE__ );

    if ( $bLogTmp ){
        $theLoggerLocal->logFunctionName( __PACKAGE__, "_getAttribute" );
    }

    #---- Get Parameter
    # 1. Attribute name
    # 2. POM object wrapper (optional)
    #
    my $sAttrNamePar = lc( shift );
    my $pomObjectPar = undef;
    if ( @_ > 0 ){
        $pomObjectPar = shift;
    }

    #---- Searches POM object first and then kernel object ----#
    if ( $pomObjectPar != undef ){
        #---- Attribute name to id mapping
        my $hrefObjAttrMapTmp = {
              'xpos'  => $a2w::core::dm::Constants::AT_XPOS
            , 'ypos'  => $a2w::core::dm::Constants::AT_YPOS
            , 'angle' => $a2w::core::dm::Constants::AT_ANGLE
            , 'color' => $a2w::core::dm::Constants::AT_COLOR         # V101a Change
            , 'pagefirst' => $a2w::core::dm::Constants::AT_PAGEFIRST
            , 'pagelast' => $a2w::core::dm::Constants::AT_PAGELAST
            , 'pageid' => $a2w::core::dm::Constants::AT_PAGE_ID      # V103 Change
        };
        if ( $hrefObjAttrMapTmp->{ $sAttrNamePar } != undef ){
            return $pomObjectPar->{ $hrefObjAttrMapTmp->{ $sAttrNamePar } };
        }
        my $hrefContAttrMapTmp = {
              'width'      => $a2w::core::dm::Constants::OI_CONTAINER_WIDTH
            , 'height'     => $a2w::core::dm::Constants::OI_CONTAINER_HEIGHT
            , 'name'       => $a2w::core::dm::Constants::OI_CONTAINER_NAME
            , 'resolution' => $a2w::core::dm::Constants::OI_CONTAINER_RESOLUTION
            , 'objecttype' => $a2w::core::dm::Constants::OI_CONTAINER_OBJECTTYPE
        };
        if ( $hrefContAttrMapTmp->{ $sAttrNamePar } != undef ){
            return $pomObjectPar->{ $a2w::core::dm::Constants::AT_OBJINFO }{ $hrefContAttrMapTmp->{ $sAttrNamePar } };
        }
    }

    #---- Attribute name to accessor method mapping
    my $hrefMethodMapTmp = {
          'xpos'               => 'getXPos'
        , 'ypos'               => 'getYPos'
        , 'angle'              => 'getAngle'
        , 'name'               => 'getName'
        , 'data'               => 'getData'
        , 'datalen'            => 'getDataLength'
        , 'compression'        => 'getCompression'
        , 'bitsperpixel'       => 'getBitsPerPixel'
        , 'samplesperpixel'    => 'getSamplesPerPixel'
        , 'width'              => 'getWidth'
        , 'height'             => 'getHeight'
        , 'presentationwidth'  => 'getPresentationWidth'
        , 'presentationheight' => 'getPresentationHeight'
        , 'uniquecolorscount'  => 'getUniqueColorsCount' # V101b Change
        , 'uniquename'         => 'getUniqueName'        # V104 Change
    };
    my $sMethodNameTmp = $hrefMethodMapTmp->{ $sAttrNamePar };
    if ( $sMethodNameTmp eq "" ){
        #---- Name to method mapping undefined, return undef
        return undef;
    }

    return $this->$sMethodNameTmp();
}

# V102 Begin
#------------------------------------------------------------------------
# _toString
#
# Returns stringified object info
#
#------------------------------------------------------------------------
sub _toString{
    $this = shift;

    #---- Get logger
    $theLoggerLocal = a2w::core::log::Logger->getSingleton();
    my $bLogTmp = $theLoggerLocal->isRegistered( __PACKAGE__ );

    if ( $bLogTmp ){
        $theLoggerLocal->logFunctionName( __PACKAGE__, "_toString" );
    }

    return   "cnt>" . $this->getName() . "<"
           . "@(" . $this->getXPos() . "," . $this->getYPos() . ")"
           . " IPos(x:" . $this->getIncludedXPosition() . ",Y:" . $this->getIncludedYPosition() . ")"
           . " W=" . $this->getWidth()
           . " H=" . $this->getHeight()
           . " T=" . $this->getObjectTypeName()
           . " POType=" . $this->getPaginatedObjectType()
           . " POOffset=" . $this->getPaginatedObjectOffset()
           . " Filename=" . $this->getFilename()
           ;
}
# V102 End

1;
__END__
