#-------------------------------------------------------------------------------
#  a2w/core/ext/Line.pm:
#  Extension module with additional processing functionalities
#
#  Author  : Fa. Maas
#
#  V103   2021-06-10    AFP-1046: Extended to get page id (in which object exists)
#
#  V102   2020-10-12    AFP-979: Extended with _toString() API to dump object
#
#  V101   2018-01-27    AFP-456: Extended with constants for page begin/end marking
#
#  V100   2014-06-26    Initial Release
#
#-------------------------------------------------------------------------------

#
# NOTE:
# Though the filename is a2w/core/ext/Line.pm, in actual it is 'a2w::Line' module extension
#

package a2w::Line;

use a2w::Line;
use a2w::core::log::Logger;

#-----------------------------------------------------------------------
# Workers
#-----------------------------------------------------------------------
#------------------------------------------------------------------------
# _getType
#
# Get type of object
#
# Returns
#   Object type
#
#------------------------------------------------------------------------
sub _getType{
    $this = shift;
    
    #---- Get logger
    $theLoggerLocal = a2w::core::log::Logger->getSingleton();
    my $bLogTmp = $theLoggerLocal->isRegistered( __PACKAGE__ );

    if ( $bLogTmp ){
        $theLoggerLocal->logFunctionName( __PACKAGE__, "_getType" );
    }

    return "line";
}

#------------------------------------------------------------------------
# _getAttribute
#
# Get value of given attribute
#
# Parameter
# 1. Attribute name
#
# Returns
#   Attribute value, if such attribute exists
#   undef otherwise
#
#------------------------------------------------------------------------
sub _getAttribute{
    $this = shift;
    
    #---- Get logger
    $theLoggerLocal = a2w::core::log::Logger->getSingleton();
    my $bLogTmp = $theLoggerLocal->isRegistered( __PACKAGE__ );

    if ( $bLogTmp ){
        $theLoggerLocal->logFunctionName( __PACKAGE__, "_getAttribute" );
    }

    #---- Get Parameter
    # 1. Attribute name
    # 2. POM object wrapper (optional)
    #
    my $sAttrNamePar = lc( shift );
    my $pomObjectPar = undef;
    if ( @_ > 0 ){
        $pomObjectPar = shift;
    }

    #---- Searches POM object first and then kernel object ----#
    if ( $pomObjectPar != undef ){
        #---- Attribute name to id mapping
        my $hrefObjAttrMapTmp = {
              'xpos'  => $a2w::core::dm::Constants::AT_XPOS
            , 'ypos'  => $a2w::core::dm::Constants::AT_YPOS
            , 'angle' => $a2w::core::dm::Constants::AT_ANGLE
            , 'color' => $a2w::core::dm::Constants::AT_COLOR
            , 'pagefirst' => $a2w::core::dm::Constants::AT_PAGEFIRST # V101 Change
            , 'pagelast' => $a2w::core::dm::Constants::AT_PAGELAST   # V101 Change
            , 'pageid' => $a2w::core::dm::Constants::AT_PAGE_ID      # V103 Change
        };
        if ( $hrefObjAttrMapTmp->{ $sAttrNamePar } != undef ){
            return $pomObjectPar->{ $hrefObjAttrMapTmp->{ $sAttrNamePar } };
        }
        my $hrefLneAttrMapTmp = {
              'width'      => $a2w::core::dm::Constants::OI_LINE_WIDTH
            , 'length'     => $a2w::core::dm::Constants::OI_LINE_LENGTH
        };
        if ( $hrefLneAttrMapTmp->{ $sAttrNamePar } != undef ){
            return $pomObjectPar->{ $a2w::core::dm::Constants::AT_OBJINFO }{ $hrefLneAttrMapTmp->{ $sAttrNamePar } };
        }
    }

    #---- Attribute name to accessor method mapping
    my $hrefMethodMapTmp = {
          'xpos'       => 'getXPos'
        , 'ypos'       => 'getYPos'
        , 'width'      => 'getWidth'
        , 'length'     => 'getLength'
        , 'color'      => 'getColor'
        , 'horizontal' => 'isHorizontal'
        , 'vertical'   => 'isVertical'
        , 'negative'   => 'isNegative'
    };
    my $sMethodNameTmp = $hrefMethodMapTmp->{ $sAttrNamePar };
    if ( $sMethodNameTmp eq "" ){
        #---- Name to method mapping undefined, return undef
        return undef;
    }

    return $this->$sMethodNameTmp();
}

# V102 Begin
#------------------------------------------------------------------------
# _toString
#
# Returns stringified object info
#
#------------------------------------------------------------------------
sub _toString{
    $this = shift;

    #---- Get logger
    $theLoggerLocal = a2w::core::log::Logger->getSingleton();
    my $bLogTmp = $theLoggerLocal->isRegistered( __PACKAGE__ );

    if ( $bLogTmp ){
        $theLoggerLocal->logFunctionName( __PACKAGE__, "_toString" );
    }

    return   "lin><"
           . "@(" . $this->getXPos() . "," . $this->getYPos() . ")"
           . " W=" . $this->getWidth()
           . " L=". $this->getLength()
           ;
}
# V102 End

1;
__END__
