module.exports = {
    //"ANY2PDF_CLR": "Any(AFP, PTOCA(MODCA-IS1/2), BMP, PCX, JPG, TIF) 2 PDF Color Conversion",
    "ANY2PDF_CLR": {
        "props": {
            "OutputFormat": "PDF",
            "Color":        "on",
            "Host":         "sanlam"
        }
    },
    //"ANY2PDFA_CLR": "Any(AFP, PTOCA(MODCA-IS1/2), BMP, PCX, JPG, TIF) 2 PDF/A Color Conversion",
    "ANY2PDFA_CLR": {
        "props": {
            "OutputFormat": "PDFA",
            "Color":        "on",
            "Host":         "sanlam"
        }
    },
    //"ANY2PDF_B&W": "Any(AFP, PTOCA(MODCA-IS1/2), BMP, PCX, JPG, TIF) 2 PDF B/W Conversion",
    "ANY2PDF_B&W": {
        "props": {
            "OutputFormat": "PDF",
            "Color":        "off",
            "Host":         "sanlam"
        }
    },
    //"ANY2PDFA_B&W": "Any(AFP, PTOCA(MODCA-IS1/2), BMP, PCX, JPG, TIF) 2 PDF/A B/W Conversion",
    "ANY2PDFA_B&W": {
        "props": {
            "OutputFormat": "PDFA",
            "Color":        "off",
            "Host":         "sanlam"
        }
    },
    //"ANY2TIF_B&W": "Any(AFP, PTOCA(MODCA-IS1/2), BMP, PCX, JPG, TIF) 2 TIFF B/W Conversion",
    "ANY2TIF_B&W": {
        "props": {
            "OutputFormat":     "TIF",
            "Resolution":       "96",
            "FormatType":       "G4",
            "Color":            "off",
            "JPEGQuality":      "30",
            "Host":             "sanlam"
        }
    },
    //"ANY2TIF_CLR": "Any(AFP, PTOCA(MODCA-IS1/2), BMP, PCX, JPG, TIF) 2 TIFF Color Conversion",
    "ANY2TIF_CLR": {
        "props": {
            "OutputFormat":     "TIF",
            "Resolution":       "96",
            "FormatType":       "LZW",
            "Color":            "on",
            "JPEGQuality":      "30",
            "Host":             "sanlam"
        }
    },
    //"ANY2AFP_CLR": "Any (AFP, PTOCA(MODCA-IS1/2), BMP, PCX, JPG, TIF) 2 AFP Color Conversion",
    "ANY2AFP_CLR": {
        "props": {
            "OutputFormat":     "AFP",
            "Color":            "on",
            "Host":             "sanlam"
        }
    },
    //"ANY2PNG_CLR": "Any(AFP, PTOCA(MODCA-IS1/2), BMP, PCX, JPG, TIF) 2 PNG Color Conversion",
    "ANY2PNG_CLR": {
        "props": {
            "OutputFormat":     "PNG",
            "Resolution":       "200",
            "Color":            "on",
            "Host":             "sanlam"
        }
    },
    //"PDF2AFP_CLR": "PDF 2 AFP Color Conversion",
    "PDF2AFP_CLR": {
        "props": {
            "OutputFormat":     "AFP",
            "Color":            "on",
            "Host":             "sanlam"
        }
    },
    //"PDF2AFP_GRS": "PDF 2 AFP Grayscale Conversion",
    "PDF2AFP_GRS": {
        "props": {
            "OutputFormat":     "AFP",
            "Color":            "off",
            "Host":             "sanlam"
        }
    },
    //"PDF2AFP_B&W": "PDF 2 AFP B/W Conversion",
    "PDF2AFP_B&W": {
        "props": {
            "OutputFormat":     "AFP",
            "FormatType":       "BW",
            "Color":            "off",
            "Host":             "sanlam"
        }
    },
    //"PDF2TIF_CLR": "PDF 2 TIFF Color Conversion",
    "PDF2TIF_CLR": {
        "props": {
            "CodedOutput":      "off",
            "OutputFormat":     "TIF",
            "Resolution":       "200",
            "FormatType":       "LZW",
            "Color":            "on",
            "Host":             "sanlam"
        }
    },
    //"PDF2TIF_B&W": "PDF 2 TIFF B/W Conversion",
    "PDF2TIF_B&W": {
        "props": {
            "CodedOutput":      "off",
            "OutputFormat":     "TIF",
            "Resolution":       "200",
            "FormatType":       "G4",
            "Color":            "off",
            "Host":             "sanlam"
        }
    },
    //"PDF2PNG_CLR": "PDF 2 PNG Color Conversion",
    "PDF2PNG_CLR": {
        "props": {
            "CodedOutput":      "off",
            "OutputFormat":     "PNG",
            "Resolution":       "200",
            "Color":            "on",
            "Host":             "sanlam"
        }
    },
    //"PDF2PNG_B&W": "PDF 2 PNG B/W Conversion",
    "PDF2PNG_B&W": {
        "props": {
            "CodedOutput":      "off",
            "OutputFormat":     "PNG",
            "Resolution":       "200",
            "Color":            "off",
            "Host":             "sanlam"
        }
    },
    //"PDF2JPG_CLR": "PDF 2 JPEG Color Conversion",
    "PDF2JPG_CLR": {
        "props": {
            "CodedOutput":      "off",
            "OutputFormat":     "JPG",
            "Resolution":       "200",
            "Color":            "on",
            "Host":             "sanlam"
        }
    },
    //"PDF2GIF_CLR": "PDF 2 GIF Color Conversion",
    "PDF2GIF_CLR": {
        "props": {
            "CodedOutput":      "off",
            "OutputFormat":     "GIF",
            "Resolution":       "200",
            "Color":            "on",
            "Host":             "sanlam"
        }
    },
    //"ASYNCAFP2PDF_CLR": "Async Transformation. AFP 2 PDF Conversion",
    "ASYNCAFP2PDF_CLR": {
        "props": {
            "FileCreationMode": "doc_index",
            "OutputFormat":     "PDF",
            "Color":            "off",
            "Host":             "sanlam"
        }
    },
    //"ASYNCANY2STATUS": "Async Transformation Status",
    "ASYNCANY2STATUS": {
        "props": {
            "Host":             "sanlam"
        }
    },
    //"PDF2PDF": "PDF 2 PDF Secure Conversion",
    "PDF2PDF": {
        "props": {
        }
    },
    //"PDF2MERGE": "PDF 2 PDF Merge Conversion",
    "PDF2MERGE": {
        "props": {
        }
    },
    //"LPD2PDF_CLR": "LPD 2 PDF Color Conversion",
    "LPD2PDF_CLR": {
        "props": {
            "InputFormat":      "LPD",
            "SPOOLFILETYPE":    "ASCII",
            "OutputFormat":     "PDF",
            "Color":            "on",   
            "FileCreationMode": "DOC_COLD",
            "ScriptProcedure":  "txt2pdf.pm",
            "Host":             "sanlam"
        }
    },
    //"LPD2TIF_B&W": "LPD 2 TIFF B/W Conversion",
    "LPD2TIF_B&W": {
        "props": {
            "InputFormat":      "LPD",
            "SPOOLFILETYPE":    "ASCII",
            "OutputFormat":     "TIF",
            "Resolution":       "200",
            "FormatType":       "G4",
            "Color":            "off",
            "FileCreationMode": "DOC_COLD",
            "ScriptProcedure":  "txt2pdf.pm",
            "Host":             "sanlam"
        }
    },
    //"LPD2TIF_CLR": "LPD 2 TIFF Color Conversion",
    "LPD2TIF_CLR": {
        "props": {
            "InputFormat":      "LPD",
            "SPOOLFILETYPE":    "ASCII",
            "OutputFormat":     "TIF",
            "Resolution":       "200",
            "FormatType":       "LZW",
            "Color":            "on",
            "FileCreationMode": "DOC_COLD",
            "ScriptProcedure":  "txt2pdf.pm",
            "Host":             "sanlam"
        }
    },
    //"GIF2PDF_CLR": "GIF 2 PDF Color Conversion",
    "GIF2PDF_CLR": {
        "props": {
            "OutputFormat":     "PDF",
            "Color":            "on",
            "EndingPage":       "1",
            "Host":             "sanlam"
        }
    },
    //"GIF2TIF_B&W": "GIF 2 TIFF B/W Conversion",
    "GIF2TIF_B&W": {
        "props": {
            "OutputFormat":     "TIF",
            "Resolution":       "200",
            "FormatType":       "G4",
            "Color":            "off",
            "EndingPage":       "1",
            "Host":             "sanlam"
        }
    },
    //"GIF2TIF_CLR": "GIF 2 TIFF Color Conversion",
    "GIF2TIF_CLR": {
        "props": {
            "OutputFormat":     "TIF",
            "Resolution":       "200",
            "FormatType":       "LZW",
            "Color":            "on",
            "EndingPage":       "1",
            "Host":             "sanlam"
        }
    },
    //"GIF2AFP_CLR": "GIF 2 AFP Color Conversion",
    "GIF2AFP_CLR": {
        "props": {
            "OutputFormat":     "AFP",
            "Color":            "on",
            "EndingPage":       "1",
            "Host":             "sanlam"
        }
    },
    //"JPG2PDF_CLR": "JPG 2 PDF Color Conversion",
    "JPG2PDF_CLR": {
        "props": {
            "OutputFormat":     "PDF",
            "Color":            "on",
            "Host":             "sanlam"
        }
    },
    //"JPG2TIF_B&W": "JPG 2 TIFF B/W Conversion",
    "JPG2TIF_B&W": {
        "props": {
            "OutputFormat":     "TIF",
            "Resolution":       "200",
            "FormatType":       "JPG",
            "JPEGQuality":      "50",
            "Color":            "off",
            "Host":             "sanlam"
        }
    },
    //"JPG2TIF_CLR": "JPG 2 TIFF Color Conversion",
    "JPG2TIF_CLR": {
        "props": {
            "OutputFormat":     "TIF",
            "Resolution":       "96",
            "FormatType":       "JPG",
            "JPEGQuality":      "30",
            "Color":            "on",
            "Host":             "sanlam"
        }
    },
    //"JPG2AFP_CLR": "JPG 2 AFP Color Conversion",
    "JPG2AFP_CLR": {
        "props": {
            "OutputFormat":     "AFP",
            "Color":            "on",
            "Host":             "sanlam"
        }
    },
    //"HTML2PDF": "HTML Table 2 PDF Conversion",
    "HTML2PDF": {
        "props": {
            "InputType" : "HTMLT",
            "OutputType": "PDF"
        }
    },
    //"MHT2PDF": "HTML 2 PDF Conversion",
    "MHT2PDF": {
        "props": {
            "disableSmartShrinking": true,
            "ignore": ["QFont::setPixelSize: Pixel size <= 0 (0)", "Exit with code 1 due to network error: ContentNotFoundError"],
            "loadErrorHandling" : "ignore"
        }
    }, 
    //"MHT2TIF": "HTML 2 TIF Conversion",
    "MHT2TIF": {
        "props": {
            "disableSmartShrinking": true,
            "ignore": ["QFont::setPixelSize: Pixel size <= 0 (0)", "Exit with code 1 due to network error: ContentNotFoundError"],
            "loadErrorHandling" : "ignore"
        }
    }, 
    //"MHT2TIF_B&W": "HTML 2 TIF B/W Conversion",
    "MHT2TIF_B&W": {
        "props": {
            "disableSmartShrinking": true,
            "ignore": ["QFont::setPixelSize: Pixel size <= 0 (0)", "Exit with code 1 due to network error: ContentNotFoundError"],
            "loadErrorHandling" : "ignore"
        }
    }, 
    //"HTML2TIF": "HTML Table 2 TIF Conversion",
    "HTML2TIF": {
        "props": {
            "InputType" : "HTMLT",
            "OutputType": "TIF"
        }
    }, 
    //"WORD2TIF": "Word Document 2 TIF Conversion",
    "WORD2TIF": {
        "props": {
            "InputType" : "WORD",
            "OutputType": "TIF"
        }
    },
    //"WORD2PDF": "Word Document 2 PDF Conversion",
    "WORD2PDF": {
        "props": {
            "InputType" : "WORD",
            "OutputType": "PDF"
        }
    },
    //"RTF2TIF": "RTF Document 2 TIF Conversion",
    "RTF2TIF": {
        "props": {
            "InputType" : "RTF",
            "OutputType": "TIF"
        }
    },
    //"RTF2PDF": "RTF Document 2 PDF Conversion",
    "RTF2PDF": {
        "props": {
            "InputType" : "RTF",
            "OutputType": "PDF"
        }
    },
    //"EXCEL2TIF": "Excel Document 2 TIF Conversion",
    "EXCEL2TIF": {
        "props": {
            "InputType" : "EXCEL",
            "OutputType": "TIF"
        }
    },
    //"EXCEL2PDF": "Excel Document 2 PDF Conversion",
    "EXCEL2PDF": {
        "props": {
            "InputType" : "EXCEL",
            "OutputType": "PDF"
        }
    }
}
