module.exports = {
	"desc": "oxsnps officeclient plugin",
	"enable": "on",
	"log": {
		"level": "DEBUG"
	},
	"routes": [
		{
			"path": "/services/officeclient/version",
			"method": "get",
			"service": "version",
			"enable": "on"
		},
		{
			"path": "/services/officeclient/conf",
			"method": "get",
			"service": "conf",
			"enable": "on"
		},
		{
			"path": "/services/officeclient/conf",
			"method": "post",
			"service": "conf",
			"enable": "on"
		},
		{
			"path": "/services/officeclient/ping",
			"method": "get",
			"service": "ping",
			"enable": "on"
		},
		{
			"path": "/services/officeclient/transform",
			"method": "post",
			"service": "transform",
			"enable": "on"
		}
	],
	"middlewares": [
		{
			"name": "body-parser",
			"handler": "json",
			"routes": [
				{
					"path": [
						"/services/officeclient/*"
					],
					"parms": {
						"limit": "1mb"
					}
				}
			]
		},
		{
			"name": "express",
			"handler": "static",
			"routes": [
				{
					"path": [
						"/oxsnps-officeclient/api"
					],
					"parms": "/opt/OTS/node_modules/oxsnps-officeclient/swagger"
				}
			]
		}
	],
	"maxresptime": 1000,
	"office": {
		"engine": "libreoffice",
		"server": {
			"protocol": "http",
			"hostname": "localhost",
			"port": 1075,
			"httptimeout": 60000,
			"retryOptions": {
				"interval": 10000,
				"count": 5,
				"errorCodes": [
					"ECONNREFUSED",
					"ECONNRESET",
					502,
					504
				]
			},
			"respEncoding": "utf-8",
			"context": ""
		},
		"uris": {
			"transform": "/services/office2any/transform",
			"ping": "/services/office2any/ping"
		},
		"retry": {
			"count": 5,
			"interval": 10000
		},
		"execOptions": {
			"timeout": 60000
		}
	},
	"module": "oxsnps-officeclient",
	"version": "1.0.0",
	"longDesc": "oxsnps officeclient plugin"
}