module.exports = {
	"desc": "qpdf oxsnps plugin",
	"enable": "on",
	"log": {
		"level": "DEBUG"
	},
	"routes": [
		{
			"path": "/services/qpdf/version",
			"method": "get",
			"service": "version",
			"enable": "on"
		},
		{
			"path": "/services/qpdf/conf",
			"method": "get",
			"service": "conf",
			"enable": "on"
		},
		{
			"path": "/services/qpdf/conf",
			"method": "post",
			"service": "conf",
			"enable": "on"
		},
		{
			"path": "/services/qpdf/process",
			"method": "post",
			"service": "process",
			"enable": "on"
		},
		{
			"path": "/services/qpdf/process",
			"method": "get",
			"service": "process",
			"enable": "on"
		}
	],
	"middlewares": [
		{
			"name": "body-parser",
			"handler": "json",
			"routes": [
				{
					"path": [
						"/services/qpdf/*"
					],
					"parms": {
						"limit": "1mb"
					}
				}
			]
		},
		{
			"name": "express",
			"handler": "static",
			"routes": [
				{
					"path": [
						"/oxsnps-qpdf/api"
					],
					"parms": "/opt/OTS/node_modules/oxsnps-qpdf/swagger"
				}
			]
		}
	],
	"defaultArgs": [
		"--no-warn",
		"--warning-exit-0"
	],
	"module": "oxsnps-qpdf",
	"version": "4.0.6",
	"longDesc": "qpdf oxsnps plugin"
}