"use strict";
var semver = require('semver')
  ;

// jshint plugin
// test plugin
// 

var SVN_USERNAME = process.env.SVN_USERNAME
  , SVN_PWD      = process.env.SVN_PASSWORD
  ;

module.exports = function (grunt) {
    require('logfile-grunt')(grunt, {filePath: './log/grunt.log', clearLogFile: true, keepColors: true});

    // configuration
    grunt.initConfig({
    	// Get package.json content as JSON
    	pkg: grunt.file.readJSON('package.json'),

    	// Publish to local npm registry
		publish:{
		    main:{
		        options:{
		        	// ignore these directories
		            ignore: ['node_modules', 'log', 'temp', '.svn'],
		            // Local npm registry
		            registry: 'https://development.oxseed.net/sinopia/'
		        },
		        src: [
		        	// publish current directory
		            './'
		        ]
		    }
		},

		// Tag a version in plugin
		svn_tag:{
			main:{	
    			options:{
      				tag: '<%= pkg.name %>' + '-'+'v<%= pkg.version %>',
      				commitMessage: 'Tag for release v<%= pkg.version %>'
    			}
  			}
  		},

  		// Execute shell command
		exec:{
			// Commit package.json changes to svn
		    svn_commit_versnr:{
		      command: 'svn --username ' + SVN_USERNAME + ' --password ' + SVN_PWD + ' commit package.json -m "version number increased in package.json"',
		      stdout: true,
		      stderr: true
		    }
		},

		// Get tasks defined in Gruntfile.js
 		availabletasks:{
            tasks:{
				options:{
					// Group tasks
					groups:{
                		'Deployment tasks': ['doc', 'release'],
                		'Help tasks': ['help']
            		},
					filter: 'include',
					tasks: ['release', 'help', 'doc'],
					// Show only user defined tasks
					showTasks: ['user']
        		}
            }
        },

        // Refer to http://usejsdoc.org/about-commandline.html to get info about parameters
        // Refer to https://github.com/terryweiss/docstrap#configuring-the-template to get info about config.file(jsdoc.conf.json)
        // destination path and configure file will be specified later as .../../doc and ../../jsdoc.conf.json so that 
        // all plugins use same doc directory and same config file.
        jsdoc: {
            dist: {
                src: ['./package.json', './*.js', './conf/*.json', './README.md'],
                options: {
                    'destination': '../../doc',
                    'template'   : 'node_modules/grunt-jsdoc/node_modules/ink-docstrap/template',
                    'configure'  : '../../conf/jsdoc.json',
                    'verbose'    : true,
                    'private'    : false,
                    'recurse'    : true,
                    'access'     : 'public',
                    'readme'     : 'README.md'
                }
            }
        }        

   	});

    // Needed grunt plugins
	grunt.loadNpmTasks('grunt-publish');
	grunt.loadNpmTasks('grunt-svn-tag');
	grunt.loadNpmTasks('grunt-exec');
	grunt.loadNpmTasks('grunt-jsdoc');
	grunt.loadNpmTasks('grunt-available-tasks');

	// Increase version number in package.json
	grunt.registerTask('inc_pkg_version', 'Increase version in package.json', function(){
		var pkgJson = grunt.file.readJSON('package.json');
		pkgJson.version = semver.inc(pkgJson.version, 'patch');
		grunt.file.write('package.json', JSON.stringify(pkgJson, null, '\t') );

		// Commit Package.json in svn
		grunt.task.run('exec:svn_commit_versnr');
	});

	// Release task
	grunt.registerTask('release', 'Release plugin', ['svn_tag:main', 'publish:main', 'inc_pkg_version']);

    // Help task
    grunt.registerTask('help', 'Get available tasks', ['availabletasks::tasks']);

	// Documentation task
    grunt.registerTask('doc', 'Generate Plugin Documentation', ['jsdoc']);

    // Default task
    grunt.registerTask('default', ['availabletasks::tasks']);
};