module.exports = {
    "desc": 	"Spawn command line tools",
    "enable": 	"on",
	"log": {
		// Available Log Levels are DEBUG, INFO, WARN and ERROR
		"level": process.env[process.env.OXSNPS_SERVER_PREFIX + "LOG_LEVEL_OXSNPS_SPAWN"] ||
				process.env[process.env.OXSNPS_SERVER_PREFIX + "LOG_LEVEL"] ||
				"WARN"
	},
    "routes": [
		{
			"path": 	"/services/spawn/version",
			"method": 	"get",
			"service": 	"version"
		},
		{	
			"path": 	"/services/spawn/conf",
			"method": 	"get",
			"service": 	"conf"
		},
		{
			"path": 	"/services/spawn/conf",
			"method":	"post",
			"service":	"conf"
		},
		{
			"path": 	"/services/spawn/execute",
			"method":	"post",
			"service":	"execute"
		},
		{
			"path": 	"/services/spawn/execute",
			"method":	"get",
			"service":	"execute"
		}
    ],
    "middlewares":[
        {
            "name": "body-parser",
            "handler": "json",
            "routes":[
                {
                    "path": ["/services/spawn/*"],
                    "parms": {"limit": "1mb"}  
                }
            ]
        }    
    ]
}
