'use strict';

var app = angular.module('pluginsApp', ['ngAnimate', 'ngRoute'])
  .config(function($routeProvider) {
    $routeProvider      
      .when('/',                        { templateUrl: '/partials/plugins.html',      controller: 'PluginsCtrl' }) 
      .when('/core',                    { templateUrl: '/partials/cores.html',        controller: 'CoresCtrl' })
      .when('/coreroutes?:y',           { templateUrl: '/partials/coreRoutes.html',   controller: 'CoreRoutesCtrl' })
      .when('/pluginroutes?:x',         { templateUrl: '/partials/pluginRoutes.html', controller: 'PluginRoutesCtrl' })
      .when('/deploy',                  { templateUrl: '/partials/deploy.html' })
      .when('/test',                    { templateUrl: '/partials/test.html' })
      .otherwise({ redirectTo: '/'});
  })

  .controller('PluginsCtrl', function($scope, $http){

    $http.get('appservices/pm/routes').then(function(pmRoutesResponse) {
      $scope.plugins = pmRoutesResponse.data;

      for(var i = 0; i < $scope.plugins.length; i++) {
        var plugin = $scope.plugins[i];
        plugin.button = {};
        if(plugin.enable === "on"){
          plugin.button.label = "On";
          plugin.button.state = true;        
        }
        else{
          plugin.button.label = "Off";
          plugin.button.state = false;        
        }
      }
      $scope.orderProp = 'module';
    })

    $scope.toggle = function(plugin){
      var enable = (plugin.enable === 'on')? false : true;
      $http.get('/appservices/pm/' + (enable ? 'enable' : 'disable') + '?module=' + plugin.module)
      .success(function(data, status, headers, config){
        plugin.enable = (enable ? 'on' : 'off');
        plugin.button = (enable ? {label: "On", state: true } : {label: "Off", state: false });
      })
      .error(function(errMsg){
        alert(errMsg);
      })
    }

    $scope.setLogLevel = function(plugin,log){
      if(log !== plugin.logLevel.toUpperCase()){
       $http.get('/appservices/pm/setloglevel?module=' + plugin.module + '&loglevel=' + log)
       .success(function(data, status, headers, config){
          plugin.logLevel = log;
        })
        .error(function(errMsg){
          alert(errMsg);
        });        
      }
    }
  })

  .controller('PluginRoutesCtrl', ['$scope', '$routeParams', '$http',
  function($scope, $routeParams, $http) {
    $scope.plugin = JSON.parse($routeParams.plugin);
    $scope.logLevels = ['INFO', 'DEBUG', 'ERROR'];

    for(var i = 0; i < $scope.plugin.routes.length; i++) {
      var route = $scope.plugin.routes[i];
      route.button = {};
      if(route.enable === "on"){
        route.button.label = "On";
        route.button.state = true;        
      }
      else{
        route.button.label = "Off";
        route.button.state = false;        
      }
    }

    $scope.setLogLevel = function(plugin,log){
      if(log !== plugin.logLevel.toUpperCase()){
       $http.get('/appservices/pm/setloglevel?module=' + plugin.module + '&loglevel=' + log)
       .success(function(data, status, headers, config){
          plugin.logLevel = log;
        })
        .error(function(errMsg){
          alert(errMsg);
        });        
      }
    }

    $scope.toggle = function(route, plugin){
      var enable = (route.enable === 'on')? false : true;
      $http.get('/appservices/pm/' + (enable ? 'enableroute' : 'disableroute') + '?module=' + plugin.module + '&route={"path":"' + route.path + '"}')
      .success(function(data, status, headers, config){
        route.enable = (enable ? 'on' : 'off');
        route.button = (enable ? {label: "On", state: true } : {label: "Off", state: false });
      })
      .error(function(errMsg){
        alert(errMsg);
      })
    }
    $scope.orderProp = 'path';
  }])

  .controller('CoresCtrl', function($scope, $http){
    $http.get('appservices/routes').then(function(RoutesResponse){
      $scope.cores = RoutesResponse.data;

/*!!!
      angular.forEach($scope.cores, function(core){
        // http://localhost:1026/appservices/backup/getloglevel?module=pm
        $http.get(core.baseRoute + '/getloglevel?module=pm').then(function(CoreResponse){
          core.logLevel = CoreResponse.data;
        });
      });
!!!*/      
    });

    $scope.getLogLevel = function(core){
      // http://localhost:1026/appservices/backup/getloglevel?module=pm
      $http.get(core.baseRoute + '/getloglevel?module=pm').then(function(CoreResponse){
        core.logLevel = CoreResponse.data;
        return core.logLevel;
      });
    }

    $scope.setLogLevel = function(core,log){
      if(log !== core.logLevel){
        // http://localhost:1026/appservices/backup/setloglevel?module=pm&loglevel=DEBUG
        $http.get(core.baseRoute + '/setloglevel?module=pm' + '&loglevel=' + log)
        .success(function(data, status, headers, config){
          core.logLevel = log;
        })
        .error(function(errMsg){
          alert(errMsg);                
        })
      }
    }
    $scope.orderProp = 'name';
  })

  .controller('CoreRoutesCtrl', ['$scope', '$routeParams', '$http',
  function($scope, $routeParams, $http){
    $scope.core = JSON.parse($routeParams.core);
    $scope.orderProp = 'path';
  }])