let appname = "oxs-office-server"

module.exports.getHostname = function () {
    return require('os').hostname().split('.')[0]
}

module.exports = {
     "apps": [
        {
            "name":             appname,
            "script":           "./node_modules/oxsnps-core/server.js",
            "args":             [ appname ],
            "watch":            false,
            "autorestart":      false,
            "exec_mode":        "fork_mode",
            "cwd":              "/usr/lib/node_modules/" + appname,
            "log_file":         (process.env["OXS_OFFICE_LOGS_PATH"] || process.env["OXS_LOGS_PATH"] || "/mnt/logs/" + appname + "/" + exports.getHostname()) + "/" + appname + ".log",
            "merge_logs":       true,
            "env": {
                // DMS2_STATE_FILES_PATH is defined globally, when it is defined oxsnps-core looks for oxsnps-statefilewatcher (for backward compatibility)
                // Since oxsnps-statefilewatcher is not needed for oxs-office-server, overwrite its value to "" 
                "DMS2_STATE_FILES_PATH": "",            

                "UV_THREADPOOL_SIZE":               64,
                "OXSNPS_SERVER_PREFIX":             "OXS_OFFICE_",
                "OXS_OFFICE_LOG_LEVEL":             process.env["OXS_OFFICE_LOG_LEVEL"] || "INFO",
                "OXS_OFFICE_PORT":                  process.env["OXS_OFFICE_PORT"] || 1075,
                "OXS_OFFICE_LOGS_PATH":             process.env["OXS_OFFICE_LOGS_PATH"]                || process.env["OXS_LOGS_PATH"]               || "/mnt/logs/" + appname + "/" + exports.getHostname(),
                "OXS_OFFICE_TRANSFER_WORK_PATH":    (process.env["OXS_OFFICE_ROOT_TRANSFER_WORK_PATH"] || process.env["OXS_ROOT_TRANSFER_WORK_PATH"] || "/mnt/tmp/")  + appname + "/" + exports.getHostname(),
                
                "OXS_OFFICE_DMT_ENV":               false, 
                "OXS_OFFICE_STOP_ON_INIT_ERRORS":   process.env["OXS_OFFICE_STOP_ON_INIT_ERRORS"]  || process.env["OXS_STOP_ON_INIT_ERRORS"] || true,
                "OXS_OFFICE_ENV_NAME":              process.env["OXS_OFFICE_ENV_NAME"]             || process.env["OXS_ENV_NAME"]            || process.env["NODE_ENV"],
                "OXS_OFFICE_ENV_DISABLE_SWAGGER":   process.env["OXS_OFFICE_ENV_DISABLE_SWAGGER"]  || process.env["OXS_ENV_DISABLE_SWAGGER"] || ['production'],

                // Cron job time to clean work directories. Default is to run at 0th minute of every hour. Refer to https://github.com/kelektiv/node-cron/blob/master/README.md
                "OXS_OFFICE_TRANSFER_WORK_PATH_CLEAN_CRON_TIME": process.env["OXS_OFFICE_TRANSFER_WORK_PATH_CLEAN_CRON_TIME"] || process.env["OXS_TRANSFER_WORK_PATH_CLEAN_CRON_TIME"] || "00 00 * * * *",

                // Specifies the time to live in minutes for work directory files. Default is to delete files that are older than 30 minutes.
                "OXS_OFFICE_TRANSFER_WORK_PATH_EXPIRY_PERIOD": process.env["OXS_OFFICE_TRANSFER_WORK_PATH_EXPIRY_PERIOD"] || process.env["OXS_TRANSFER_WORK_PATH_EXPIRY_PERIOD"] || 30,

                // Cron job options to log server alive status. Default is to log status every hour at INFO level.
                // For cronTime options, refer to https://www.npmjs.com/package/cron-job-manager and http://crontab.org/
                // logLevel => <debug|info|warn|error> Default is "info".
                "OXS_OFFICE_LOG_SERVER_ALIVE_STATUS": process.env["OXS_OFFICE_LOG_SERVER_ALIVE_STATUS"] || process.env["OXS_LOG_SERVER_ALIVE_STATUS"] || {"logLevel": "info", "cronTime": "0 0 * * * *", "message":"'Server is running for ' + (days >0 ? days + ' days, ': '') + (hours >0 ? hours + ' hours, ': '') + minutes + ' minutes and ' + seconds + ' seconds'"},

                // Document('doc', 'docx', 'odt', 'rtf') to PDF transformation options.
                "OXS_OFFICE_O2A_LO_DOC2PDF_OPTIONS": process.env["OXS_OFFICE_O2A_LO_DOC2PDF_OPTIONS"] || 
														{
															'SelectPdfVersion': 0,      // 0 => Standard PDF v1.4, 1 = PDF/A-1
															'ExportFormFields': true,   // Export form fields or flatten them
															'MaxImageResolution': 300,  // DPI limit for images 
															'Quality': 75,              // JPEG Quality
															'TaggedPDF': true           // Export with accessibility tags
															// 'EncryptFile': true|false    // Password-protect the PDF
															// 'DocumentOpenPassword':      // Open password (used with EncryptFile=true)
															// 'UserPassword:               // Permissions password (used with EncryptFile=true)
														},

                // Excel sheet ('xls', 'xlsx', 'ods') to PDF transformation options.
				"OXS_OFFICE_O2A_LO_SHEET2PDF_OPTIONS": process.env["OXS_OFFICE_O2A_LO_SHEET2PDF_OPTIONS"] || 
														{
															'SelectPdfVersion': 0,      // 0 => Standard PDF v1.4, 1 = PDF/A-1
															'AllSheets': true,      // Export all sheets
															'SinglePageSheets': true,   // Force each sheet on a single page
															'MaxImageResolution': 300,  // DPI limit for images 
															'FitToWidth': true,
															'Orientation':'landscape',
														  //  'PageRange':1,
															'Quality': 75               // JPEG Quality
															// 'EncryptFile': true|false    // Password-protect the PDF
															// 'DocumentOpenPassword':      // Open password (used with EncryptFile=true)
															// 'UserPassword:               // Permissions password (used with EncryptFile=true)
														},
                                                        
                // Plugins LOG Level
                "OXS_OFFICE_LOG_LEVEL_OXSNPS_ASSERT":           process.env["OXS_OFFICE_LOG_LEVEL_OXSNPS_ASSERT"]           || "WARN",
                "OXS_OFFICE_LOG_LEVEL_OXSNPS_OFFICE2ANY":       process.env["OXS_OFFICE_LOG_LEVEL_OXSNPS_OFFICE2ANY"]       || "WARN",
                "OXS_OFFICE_LOG_LEVEL_OXSNPS_SPAWN":            process.env["OXS_OFFICE_LOG_LEVEL_OXSNPS_SPAWN"]            || "WARN"
                //"OXS_OFFICE_LOG_LEVEL_OXSNPS_UTILS":            process.env["OXS_OFFICE_LOG_LEVEL_OXSNPS_UTILS"]          || "WARN"
            }
        }
    ]
}
