let serverName = "oxs-office-server"

module.exports.getHostname = function () {
    return require('os').hostname().split('.')[0]
}

module.exports = {
    "name":            serverName,             // server name
    "description":     "OXS Office  Server",   // server description
    "version":         "3.0.0",                // server version
    "stopOnInitErrors": process.env[process.env.OXSNPS_SERVER_PREFIX + "STOP_ON_INIT_ERRORS"] || true,                // Default is true. true =>  throw the error and stop the server. 
                                            // false => Log the error, disable the plugin routes and proceed to load other plugins 

    // List all the OXSNPS plugins to be loaded for that server in that order
    // NOTE: !!!Order of plugin list is important for loading sequence!!!
    "pluginList":[
        "oxsnps-assert",
		"oxsnps-office2any",
        "oxsnps-spawn"
    ],

    "port":            process.env[process.env.OXSNPS_SERVER_PREFIX + "PORT"] || 1075,
    "DMS2Version":     "3.0",
    "logDir":          process.env[process.env.OXSNPS_SERVER_PREFIX + "LOGS_PATH"] || "/mnt/logs/" + serverName + "/" + exports.getHostname(),
	
    "log": {
        "appenders": {
            "consoleappender": {
                "type":        "console",
                "layout": {
                    "type":    "pattern",
                    "pattern": "[%d] [%p] %c - %m"
                }
            }
        },
        "categories": {
            "default": {
                "appenders": process.env[process.env.OXSNPS_SERVER_PREFIX + "LOG_APPENDERS"] || ["consoleappender"],
                "level":       process.env[process.env.OXSNPS_SERVER_PREFIX + "LOG_LEVEL"] || "INFO"
            }
        }
    },
    "tempDir": process.env[process.env.OXSNPS_SERVER_PREFIX + "TRANSFER_WORK_PATH"] || "/mnt/tmp/" + serverName + "/" + exports.getHostname(),    
    // Temp. directory cron job properties
    "tempDirProps":{
        // Run cron job at 0th minute of every hour. Refer to https://github.com/kelektiv/node-cron/blob/master/README.md
        "cronTime":    process.env[process.env.OXSNPS_SERVER_PREFIX + "TRANSFER_WORK_PATH_CLEAN_CRON_TIME"] || "00 00 * * * *", 
        // unit of interval. Default is "n" =>minutes
        // 'y' --> years,    'm' --> months, 'w' --> weeks, 
        // 'd' --> days,     'h' --> hours,  'n' --> minutes, 
        // 's' --> seconds,  's' --> seconds 'x' --> milliseconds 
        "unit":     process.env[process.env.OXSNPS_SERVER_PREFIX + "TRANSFER_WORK_PATH_EXPIRY_PERIOD_UNIT"] ||  "n",
        // Delete files that are older than interval time. (Default is 30 minutes).
        "interval":    process.env[process.env.OXSNPS_SERVER_PREFIX + "TRANSFER_WORK_PATH_EXPIRY_PERIOD"] || 30
    },
    "pluginDirs":    ["node_modules", "plugins"],
    // Cache properties
    "cache":{
        // Cache Directory
        "dir": process.env[process.env.OXSNPS_SERVER_PREFIX + "TRANSFER_CACHE_PATH"] || "/mnt/cache/" + exports.getHostname() + "/" + serverName,
        // Memory Cache Configuration
        "memory":{ 
            // Time in seconds to keep an entry in memory cache. Default is zero (keep entry for ever).
            "ttl":     0, 
            // Interval period in seconds to check and remove expired entries from cache. Default is 600 and value of zero means no periodic check.
            "checkperiod": 0 
        }
    },
    "pluginDirs":      ["node_modules", "plugins"],
	// Plugin that does startup tasks for this application
	"appStartPlugin": 	"oxsnps-assert",
	"startConditions": {
        // HA Servers to assert before starting the server
        "servers": {
        }
    },
	"middlewares":[
		{
			// Add static route for /api
			"name": 	"express",
			"handler": 	"static",
            "id":       "swagger",
			"routes":[
				{
					"path": ["/api/", "/"],				// define http://<host>:<port>/oxplore/api and http://<host>:<port>/oxplore/to map to the physical dir defined below to get static files. Both the route are needed. // V3.0.7
					"parms": process.env["OXSNPS_SERVER_ROOTDIR"] + '/swagger'	// physical dir where the files to be served are located (i.e. oxs-xxx-server/swagger)
				}
			]
		}
	],
	"tenants": process.env[process.env.OXSNPS_SERVER_PREFIX + "TENANTS"] || ["sanlam"],
	// Specifies the environment name (production, integration...)
    "envname": process.env[process.env.OXSNPS_SERVER_PREFIX + "ENV_NAME"] || undefined,
	// Specifies the array of environments for which swagger API should be disabled
    "disableSwagger": process.env[process.env.OXSNPS_SERVER_PREFIX + "ENV_DISABLE_SWAGGER"] ?  process.env.OXSNPS_SERVER_PREFIX + "ENV_DISABLE_SWAGGER" : [],       // v3.0.1
    "cronjobs":{        
        // Cron job options to log server alive status. Default is to log status every hour at INFO level.
        "logServerAliveStatus": process.env[process.env.OXSNPS_SERVER_PREFIX + "LOG_SERVER_ALIVE_STATUS"]
            ? process.env.OXSNPS_SERVER_PREFIX + "LOG_SERVER_ALIVE_STATUS" :
            {
                //"enable": "on|off", //  Default is on
                // "function": <Optional. Function name to handle cron job. Same as cron name "logServerAliveStatus">

                // cronTime  => <seconds minutes hours days months day-of-the-week>. 
                // Default is to log status every hour at INFO level.
                // cronTime can be set for every hour or every two hours or range of minutes/hours/. 
                // Refer to https://www.npmjs.com/package/cron-job-manager. http://crontab.org/
                "cronTime": '0 0 * * * *',

                //  <debug|info|warn|error> Default is info. Case sensitive.
                // "logLevel": "info", 

                // Default Log Message is "'Server is running ' + (days >0 ? days + ' days, ': '') + (hours >0 ? hours + ' hours, ': '') + minutes + ' mins and ' + seconds + ' secs'"
                // "message": <Optional. Log Message>
            }        
    }
}
