"use strict";
// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// ** This file is automatically generated by gapic-generator-typescript. **
// ** https://github.com/googleapis/gapic-generator-typescript **
// ** All changes to this file may be overwritten. **
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoggingServiceV2Client = void 0;
/* global window */
const gax = require("google-gax");
const google_gax_1 = require("google-gax");
const stream_1 = require("stream");
const jsonProtos = require("../../protos/protos.json");
/**
 * Client JSON configuration object, loaded from
 * `src/v2/logging_service_v2_client_config.json`.
 * This file defines retry strategy and timeouts for all API methods in this library.
 */
const gapicConfig = require("./logging_service_v2_client_config.json");
const version = require('../../../package.json').version;
/**
 *  Service for ingesting and querying logs.
 * @class
 * @memberof v2
 */
class LoggingServiceV2Client {
    /**
     * Construct an instance of LoggingServiceV2Client.
     *
     * @param {object} [options] - The configuration object.
     * The options accepted by the constructor are described in detail
     * in [this document](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#creating-the-client-instance).
     * The common options are:
     * @param {object} [options.credentials] - Credentials object.
     * @param {string} [options.credentials.client_email]
     * @param {string} [options.credentials.private_key]
     * @param {string} [options.email] - Account email address. Required when
     *     using a .pem or .p12 keyFilename.
     * @param {string} [options.keyFilename] - Full path to the a .json, .pem, or
     *     .p12 key downloaded from the Google Developers Console. If you provide
     *     a path to a JSON file, the projectId option below is not necessary.
     *     NOTE: .pem and .p12 require you to specify options.email as well.
     * @param {number} [options.port] - The port on which to connect to
     *     the remote host.
     * @param {string} [options.projectId] - The project ID from the Google
     *     Developer's Console, e.g. 'grape-spaceship-123'. We will also check
     *     the environment variable GCLOUD_PROJECT for your project ID. If your
     *     app is running in an environment which supports
     *     {@link https://developers.google.com/identity/protocols/application-default-credentials Application Default Credentials},
     *     your project ID will be detected automatically.
     * @param {string} [options.apiEndpoint] - The domain name of the
     *     API remote host.
     * @param {gax.ClientConfig} [options.clientConfig] - Client configuration override.
     *     Follows the structure of {@link gapicConfig}.
     * @param {boolean} [options.fallback] - Use HTTP fallback mode.
     *     In fallback mode, a special browser-compatible transport implementation is used
     *     instead of gRPC transport. In browser context (if the `window` object is defined)
     *     the fallback mode is enabled automatically; set `options.fallback` to `false`
     *     if you need to override this behavior.
     */
    constructor(opts) {
        var _a, _b;
        this._terminated = false;
        this.descriptors = {
            page: {},
            stream: {},
            longrunning: {},
            batching: {},
        };
        // Ensure that options include all the required fields.
        const staticMembers = this.constructor;
        const servicePath = (opts === null || opts === void 0 ? void 0 : opts.servicePath) || (opts === null || opts === void 0 ? void 0 : opts.apiEndpoint) || staticMembers.servicePath;
        this._providedCustomServicePath = !!((opts === null || opts === void 0 ? void 0 : opts.servicePath) || (opts === null || opts === void 0 ? void 0 : opts.apiEndpoint));
        const port = (opts === null || opts === void 0 ? void 0 : opts.port) || staticMembers.port;
        const clientConfig = (_a = opts === null || opts === void 0 ? void 0 : opts.clientConfig) !== null && _a !== void 0 ? _a : {};
        const fallback = (_b = opts === null || opts === void 0 ? void 0 : opts.fallback) !== null && _b !== void 0 ? _b : (typeof window !== 'undefined' && typeof (window === null || window === void 0 ? void 0 : window.fetch) === 'function');
        opts = Object.assign({ servicePath, port, clientConfig, fallback }, opts);
        // If scopes are unset in options and we're connecting to a non-default endpoint, set scopes just in case.
        if (servicePath !== staticMembers.servicePath && !('scopes' in opts)) {
            opts['scopes'] = staticMembers.scopes;
        }
        // Choose either gRPC or proto-over-HTTP implementation of google-gax.
        this._gaxModule = opts.fallback ? gax.fallback : gax;
        // Create a `gaxGrpc` object, with any grpc-specific options sent to the client.
        this._gaxGrpc = new this._gaxModule.GrpcClient(opts);
        // Save options to use in initialize() method.
        this._opts = opts;
        // Save the auth object to the client, for use by other methods.
        this.auth = this._gaxGrpc.auth;
        // Set useJWTAccessWithScope on the auth object.
        this.auth.useJWTAccessWithScope = true;
        // Set defaultServicePath on the auth object.
        this.auth.defaultServicePath = staticMembers.servicePath;
        // Set the default scopes in auth client if needed.
        if (servicePath === staticMembers.servicePath) {
            this.auth.defaultScopes = staticMembers.scopes;
        }
        // Determine the client header string.
        const clientHeader = [`gax/${this._gaxModule.version}`, `gapic/${version}`];
        if (typeof process !== 'undefined' && 'versions' in process) {
            clientHeader.push(`gl-node/${process.versions.node}`);
        }
        else {
            clientHeader.push(`gl-web/${this._gaxModule.version}`);
        }
        if (!opts.fallback) {
            clientHeader.push(`grpc/${this._gaxGrpc.grpcVersion}`);
        }
        else if (opts.fallback === 'rest') {
            clientHeader.push(`rest/${this._gaxGrpc.grpcVersion}`);
        }
        if (opts.libName && opts.libVersion) {
            clientHeader.push(`${opts.libName}/${opts.libVersion}`);
        }
        // Load the applicable protos.
        this._protos = this._gaxGrpc.loadProtoJSON(jsonProtos);
        // This API contains "path templates"; forward-slash-separated
        // identifiers to uniquely identify resources within the API.
        // Create useful helper objects for these.
        this.pathTemplates = {
            billingAccountCmekSettingsPathTemplate: new this._gaxModule.PathTemplate('billingAccounts/{billing_account}/cmekSettings'),
            billingAccountExclusionPathTemplate: new this._gaxModule.PathTemplate('billingAccounts/{billing_account}/exclusions/{exclusion}'),
            billingAccountLocationBucketPathTemplate: new this._gaxModule.PathTemplate('billingAccounts/{billing_account}/locations/{location}/buckets/{bucket}'),
            billingAccountLocationBucketViewPathTemplate: new this._gaxModule.PathTemplate('billingAccounts/{billing_account}/locations/{location}/buckets/{bucket}/views/{view}'),
            billingAccountLogPathTemplate: new this._gaxModule.PathTemplate('billingAccounts/{billing_account}/logs/{log}'),
            billingAccountSettingsPathTemplate: new this._gaxModule.PathTemplate('billingAccounts/{billing_account}/settings'),
            billingAccountSinkPathTemplate: new this._gaxModule.PathTemplate('billingAccounts/{billing_account}/sinks/{sink}'),
            folderCmekSettingsPathTemplate: new this._gaxModule.PathTemplate('folders/{folder}/cmekSettings'),
            folderExclusionPathTemplate: new this._gaxModule.PathTemplate('folders/{folder}/exclusions/{exclusion}'),
            folderLocationBucketPathTemplate: new this._gaxModule.PathTemplate('folders/{folder}/locations/{location}/buckets/{bucket}'),
            folderLocationBucketViewPathTemplate: new this._gaxModule.PathTemplate('folders/{folder}/locations/{location}/buckets/{bucket}/views/{view}'),
            folderLogPathTemplate: new this._gaxModule.PathTemplate('folders/{folder}/logs/{log}'),
            folderSettingsPathTemplate: new this._gaxModule.PathTemplate('folders/{folder}/settings'),
            folderSinkPathTemplate: new this._gaxModule.PathTemplate('folders/{folder}/sinks/{sink}'),
            logMetricPathTemplate: new this._gaxModule.PathTemplate('projects/{project}/metrics/{metric}'),
            organizationCmekSettingsPathTemplate: new this._gaxModule.PathTemplate('organizations/{organization}/cmekSettings'),
            organizationExclusionPathTemplate: new this._gaxModule.PathTemplate('organizations/{organization}/exclusions/{exclusion}'),
            organizationLocationBucketPathTemplate: new this._gaxModule.PathTemplate('organizations/{organization}/locations/{location}/buckets/{bucket}'),
            organizationLocationBucketViewPathTemplate: new this._gaxModule.PathTemplate('organizations/{organization}/locations/{location}/buckets/{bucket}/views/{view}'),
            organizationLogPathTemplate: new this._gaxModule.PathTemplate('organizations/{organization}/logs/{log}'),
            organizationSettingsPathTemplate: new this._gaxModule.PathTemplate('organizations/{organization}/settings'),
            organizationSinkPathTemplate: new this._gaxModule.PathTemplate('organizations/{organization}/sinks/{sink}'),
            projectPathTemplate: new this._gaxModule.PathTemplate('projects/{project}'),
            projectCmekSettingsPathTemplate: new this._gaxModule.PathTemplate('projects/{project}/cmekSettings'),
            projectExclusionPathTemplate: new this._gaxModule.PathTemplate('projects/{project}/exclusions/{exclusion}'),
            projectLocationBucketPathTemplate: new this._gaxModule.PathTemplate('projects/{project}/locations/{location}/buckets/{bucket}'),
            projectLocationBucketViewPathTemplate: new this._gaxModule.PathTemplate('projects/{project}/locations/{location}/buckets/{bucket}/views/{view}'),
            projectLogPathTemplate: new this._gaxModule.PathTemplate('projects/{project}/logs/{log}'),
            projectSettingsPathTemplate: new this._gaxModule.PathTemplate('projects/{project}/settings'),
            projectSinkPathTemplate: new this._gaxModule.PathTemplate('projects/{project}/sinks/{sink}'),
        };
        // Some of the methods on this service return "paged" results,
        // (e.g. 50 results at a time, with tokens to get subsequent
        // pages). Denote the keys used for pagination and results.
        this.descriptors.page = {
            listLogEntries: new this._gaxModule.PageDescriptor('pageToken', 'nextPageToken', 'entries'),
            listMonitoredResourceDescriptors: new this._gaxModule.PageDescriptor('pageToken', 'nextPageToken', 'resourceDescriptors'),
            listLogs: new this._gaxModule.PageDescriptor('pageToken', 'nextPageToken', 'logNames'),
        };
        // Some of the methods on this service provide streaming responses.
        // Provide descriptors for these.
        this.descriptors.stream = {
            tailLogEntries: new this._gaxModule.StreamDescriptor(gax.StreamType.BIDI_STREAMING, opts.fallback === 'rest'),
        };
        const protoFilesRoot = this._gaxModule.protobuf.Root.fromJSON(jsonProtos);
        // Some methods on this API support automatically batching
        // requests; denote this.
        this.descriptors.batching = {
            writeLogEntries: new this._gaxModule.BundleDescriptor('entries', ['log_name', 'resource', 'labels'], null, gax.createByteLengthFunction(
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            protoFilesRoot.lookupType('google.logging.v2.LogEntry'))),
        };
        // Put together the default options sent with requests.
        this._defaults = this._gaxGrpc.constructSettings('google.logging.v2.LoggingServiceV2', gapicConfig, opts.clientConfig || {}, { 'x-goog-api-client': clientHeader.join(' ') });
        // Set up a dictionary of "inner API calls"; the core implementation
        // of calling the API is handled in `google-gax`, with this code
        // merely providing the destination and request information.
        this.innerApiCalls = {};
        // Add a warn function to the client constructor so it can be easily tested.
        this.warn = gax.warn;
    }
    /**
     * Initialize the client.
     * Performs asynchronous operations (such as authentication) and prepares the client.
     * This function will be called automatically when any class method is called for the
     * first time, but if you need to initialize it before calling an actual method,
     * feel free to call initialize() directly.
     *
     * You can await on this method if you want to make sure the client is initialized.
     *
     * @returns {Promise} A promise that resolves to an authenticated service stub.
     */
    initialize() {
        var _a;
        // If the client stub promise is already initialized, return immediately.
        if (this.loggingServiceV2Stub) {
            return this.loggingServiceV2Stub;
        }
        // Put together the "service stub" for
        // google.logging.v2.LoggingServiceV2.
        this.loggingServiceV2Stub = this._gaxGrpc.createStub(this._opts.fallback
            ? this._protos.lookupService('google.logging.v2.LoggingServiceV2')
            : // eslint-disable-next-line @typescript-eslint/no-explicit-any
                this._protos.google.logging.v2.LoggingServiceV2, this._opts, this._providedCustomServicePath);
        // Iterate over each of the methods that the service provides
        // and create an API call method for each.
        const loggingServiceV2StubMethods = [
            'deleteLog',
            'writeLogEntries',
            'listLogEntries',
            'listMonitoredResourceDescriptors',
            'listLogs',
            'tailLogEntries',
        ];
        for (const methodName of loggingServiceV2StubMethods) {
            const callPromise = this.loggingServiceV2Stub.then(stub => (...args) => {
                if (this._terminated) {
                    if (methodName in this.descriptors.stream) {
                        const stream = new stream_1.PassThrough();
                        setImmediate(() => {
                            stream.emit('error', new google_gax_1.GoogleError('The client has already been closed.'));
                        });
                        return stream;
                    }
                    return Promise.reject('The client has already been closed.');
                }
                const func = stub[methodName];
                return func.apply(stub, args);
            }, (err) => () => {
                throw err;
            });
            const descriptor = this.descriptors.page[methodName] ||
                this.descriptors.stream[methodName] ||
                ((_a = this.descriptors.batching) === null || _a === void 0 ? void 0 : _a[methodName]) ||
                undefined;
            const apiCall = this._gaxModule.createApiCall(callPromise, this._defaults[methodName], descriptor);
            this.innerApiCalls[methodName] = apiCall;
        }
        return this.loggingServiceV2Stub;
    }
    /**
     * The DNS address for this API service.
     * @returns {string} The DNS address for this service.
     */
    static get servicePath() {
        return 'logging.googleapis.com';
    }
    /**
     * The DNS address for this API service - same as servicePath(),
     * exists for compatibility reasons.
     * @returns {string} The DNS address for this service.
     */
    static get apiEndpoint() {
        return 'logging.googleapis.com';
    }
    /**
     * The port for this API service.
     * @returns {number} The default port for this service.
     */
    static get port() {
        return 443;
    }
    /**
     * The scopes needed to make gRPC calls for every method defined
     * in this service.
     * @returns {string[]} List of default scopes.
     */
    static get scopes() {
        return [
            'https://www.googleapis.com/auth/cloud-platform',
            'https://www.googleapis.com/auth/cloud-platform.read-only',
            'https://www.googleapis.com/auth/logging.admin',
            'https://www.googleapis.com/auth/logging.read',
            'https://www.googleapis.com/auth/logging.write',
        ];
    }
    /**
     * Return the project ID used by this class.
     * @returns {Promise} A promise that resolves to string containing the project ID.
     */
    getProjectId(callback) {
        if (callback) {
            this.auth.getProjectId(callback);
            return;
        }
        return this.auth.getProjectId();
    }
    deleteLog(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                log_name: request.logName || '',
            });
        this.initialize();
        return this.innerApiCalls.deleteLog(request, options, callback);
    }
    writeLogEntries(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        this.initialize();
        return this.innerApiCalls.writeLogEntries(request, options, callback);
    }
    /**
     * Streaming read of log entries as they are ingested. Until the stream is
     * terminated, it will continue reading logs.
     *
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Stream}
     *   An object stream which is both readable and writable. It accepts objects
     *   representing [TailLogEntriesRequest]{@link google.logging.v2.TailLogEntriesRequest} for write() method, and
     *   will emit objects representing [TailLogEntriesResponse]{@link google.logging.v2.TailLogEntriesResponse} on 'data' event asynchronously.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#bi-directional-streaming)
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/logging_service_v2.tail_log_entries.js</caption>
     * region_tag:logging_v2_generated_LoggingServiceV2_TailLogEntries_async
     */
    tailLogEntries(options) {
        this.initialize();
        return this.innerApiCalls.tailLogEntries(null, options);
    }
    listLogEntries(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        this.initialize();
        return this.innerApiCalls.listLogEntries(request, options, callback);
    }
    /**
     * Equivalent to `method.name.toCamelCase()`, but returns a NodeJS Stream object.
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string[]} request.resourceNames
     *   Required. Names of one or more parent resources from which to
     *   retrieve log entries:
     *
     *   *  `projects/[PROJECT_ID]`
     *   *  `organizations/[ORGANIZATION_ID]`
     *   *  `billingAccounts/[BILLING_ACCOUNT_ID]`
     *   *  `folders/[FOLDER_ID]`
     *
     *   May alternatively be one or more views:
     *
     *    * `projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
     *    * `organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
     *    * `billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
     *    * `folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
     *
     *   Projects listed in the `project_ids` field are added to this list.
     * @param {string} [request.filter]
     *   Optional. A filter that chooses which log entries to return.  See [Advanced
     *   Logs Queries](https://cloud.google.com/logging/docs/view/advanced-queries).
     *   Only log entries that match the filter are returned.  An empty filter
     *   matches all log entries in the resources listed in `resource_names`.
     *   Referencing a parent resource that is not listed in `resource_names` will
     *   cause the filter to return no results. The maximum length of the filter is
     *   20000 characters.
     * @param {string} [request.orderBy]
     *   Optional. How the results should be sorted.  Presently, the only permitted
     *   values are `"timestamp asc"` (default) and `"timestamp desc"`. The first
     *   option returns entries in order of increasing values of
     *   `LogEntry.timestamp` (oldest first), and the second option returns entries
     *   in order of decreasing timestamps (newest first).  Entries with equal
     *   timestamps are returned in order of their `insert_id` values.
     * @param {number} [request.pageSize]
     *   Optional. The maximum number of results to return from this request. Default is 50.
     *   If the value is negative or exceeds 1000, the request is rejected. The
     *   presence of `next_page_token` in the response indicates that more results
     *   might be available.
     * @param {string} [request.pageToken]
     *   Optional. If present, then retrieve the next batch of results from the
     *   preceding call to this method.  `page_token` must be the value of
     *   `next_page_token` from the previous response.  The values of other method
     *   parameters should be identical to those in the previous call.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Stream}
     *   An object stream which emits an object representing [LogEntry]{@link google.logging.v2.LogEntry} on 'data' event.
     *   The client library will perform auto-pagination by default: it will call the API as many
     *   times as needed. Note that it can affect your quota.
     *   We recommend using `listLogEntriesAsync()`
     *   method described below for async iteration which you can stop as needed.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
     *   for more details and examples.
     */
    listLogEntriesStream(request, options) {
        request = request || {};
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        const defaultCallSettings = this._defaults['listLogEntries'];
        const callSettings = defaultCallSettings.merge(options);
        this.initialize();
        return this.descriptors.page.listLogEntries.createStream(this.innerApiCalls.listLogEntries, request, callSettings);
    }
    /**
     * Equivalent to `listLogEntries`, but returns an iterable object.
     *
     * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string[]} request.resourceNames
     *   Required. Names of one or more parent resources from which to
     *   retrieve log entries:
     *
     *   *  `projects/[PROJECT_ID]`
     *   *  `organizations/[ORGANIZATION_ID]`
     *   *  `billingAccounts/[BILLING_ACCOUNT_ID]`
     *   *  `folders/[FOLDER_ID]`
     *
     *   May alternatively be one or more views:
     *
     *    * `projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
     *    * `organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
     *    * `billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
     *    * `folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
     *
     *   Projects listed in the `project_ids` field are added to this list.
     * @param {string} [request.filter]
     *   Optional. A filter that chooses which log entries to return.  See [Advanced
     *   Logs Queries](https://cloud.google.com/logging/docs/view/advanced-queries).
     *   Only log entries that match the filter are returned.  An empty filter
     *   matches all log entries in the resources listed in `resource_names`.
     *   Referencing a parent resource that is not listed in `resource_names` will
     *   cause the filter to return no results. The maximum length of the filter is
     *   20000 characters.
     * @param {string} [request.orderBy]
     *   Optional. How the results should be sorted.  Presently, the only permitted
     *   values are `"timestamp asc"` (default) and `"timestamp desc"`. The first
     *   option returns entries in order of increasing values of
     *   `LogEntry.timestamp` (oldest first), and the second option returns entries
     *   in order of decreasing timestamps (newest first).  Entries with equal
     *   timestamps are returned in order of their `insert_id` values.
     * @param {number} [request.pageSize]
     *   Optional. The maximum number of results to return from this request. Default is 50.
     *   If the value is negative or exceeds 1000, the request is rejected. The
     *   presence of `next_page_token` in the response indicates that more results
     *   might be available.
     * @param {string} [request.pageToken]
     *   Optional. If present, then retrieve the next batch of results from the
     *   preceding call to this method.  `page_token` must be the value of
     *   `next_page_token` from the previous response.  The values of other method
     *   parameters should be identical to those in the previous call.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Object}
     *   An iterable Object that allows [async iteration](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols).
     *   When you iterate the returned iterable, each element will be an object representing
     *   [LogEntry]{@link google.logging.v2.LogEntry}. The API will be called under the hood as needed, once per the page,
     *   so you can stop the iteration when you don't need more results.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/logging_service_v2.list_log_entries.js</caption>
     * region_tag:logging_v2_generated_LoggingServiceV2_ListLogEntries_async
     */
    listLogEntriesAsync(request, options) {
        request = request || {};
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        const defaultCallSettings = this._defaults['listLogEntries'];
        const callSettings = defaultCallSettings.merge(options);
        this.initialize();
        return this.descriptors.page.listLogEntries.asyncIterate(this.innerApiCalls['listLogEntries'], request, callSettings);
    }
    listMonitoredResourceDescriptors(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        this.initialize();
        return this.innerApiCalls.listMonitoredResourceDescriptors(request, options, callback);
    }
    /**
     * Equivalent to `method.name.toCamelCase()`, but returns a NodeJS Stream object.
     * @param {Object} request
     *   The request object that will be sent.
     * @param {number} [request.pageSize]
     *   Optional. The maximum number of results to return from this request.
     *   Non-positive values are ignored.  The presence of `nextPageToken` in the
     *   response indicates that more results might be available.
     * @param {string} [request.pageToken]
     *   Optional. If present, then retrieve the next batch of results from the
     *   preceding call to this method.  `pageToken` must be the value of
     *   `nextPageToken` from the previous response.  The values of other method
     *   parameters should be identical to those in the previous call.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Stream}
     *   An object stream which emits an object representing [MonitoredResourceDescriptor]{@link google.api.MonitoredResourceDescriptor} on 'data' event.
     *   The client library will perform auto-pagination by default: it will call the API as many
     *   times as needed. Note that it can affect your quota.
     *   We recommend using `listMonitoredResourceDescriptorsAsync()`
     *   method described below for async iteration which you can stop as needed.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
     *   for more details and examples.
     */
    listMonitoredResourceDescriptorsStream(request, options) {
        request = request || {};
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        const defaultCallSettings = this._defaults['listMonitoredResourceDescriptors'];
        const callSettings = defaultCallSettings.merge(options);
        this.initialize();
        return this.descriptors.page.listMonitoredResourceDescriptors.createStream(this.innerApiCalls.listMonitoredResourceDescriptors, request, callSettings);
    }
    /**
     * Equivalent to `listMonitoredResourceDescriptors`, but returns an iterable object.
     *
     * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
     * @param {Object} request
     *   The request object that will be sent.
     * @param {number} [request.pageSize]
     *   Optional. The maximum number of results to return from this request.
     *   Non-positive values are ignored.  The presence of `nextPageToken` in the
     *   response indicates that more results might be available.
     * @param {string} [request.pageToken]
     *   Optional. If present, then retrieve the next batch of results from the
     *   preceding call to this method.  `pageToken` must be the value of
     *   `nextPageToken` from the previous response.  The values of other method
     *   parameters should be identical to those in the previous call.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Object}
     *   An iterable Object that allows [async iteration](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols).
     *   When you iterate the returned iterable, each element will be an object representing
     *   [MonitoredResourceDescriptor]{@link google.api.MonitoredResourceDescriptor}. The API will be called under the hood as needed, once per the page,
     *   so you can stop the iteration when you don't need more results.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/logging_service_v2.list_monitored_resource_descriptors.js</caption>
     * region_tag:logging_v2_generated_LoggingServiceV2_ListMonitoredResourceDescriptors_async
     */
    listMonitoredResourceDescriptorsAsync(request, options) {
        request = request || {};
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        const defaultCallSettings = this._defaults['listMonitoredResourceDescriptors'];
        const callSettings = defaultCallSettings.merge(options);
        this.initialize();
        return this.descriptors.page.listMonitoredResourceDescriptors.asyncIterate(this.innerApiCalls['listMonitoredResourceDescriptors'], request, callSettings);
    }
    listLogs(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                parent: request.parent || '',
            });
        this.initialize();
        return this.innerApiCalls.listLogs(request, options, callback);
    }
    /**
     * Equivalent to `method.name.toCamelCase()`, but returns a NodeJS Stream object.
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The resource name that owns the logs:
     *
     *   *  `projects/[PROJECT_ID]`
     *   *  `organizations/[ORGANIZATION_ID]`
     *   *  `billingAccounts/[BILLING_ACCOUNT_ID]`
     *   *  `folders/[FOLDER_ID]`
     * @param {number} [request.pageSize]
     *   Optional. The maximum number of results to return from this request.
     *   Non-positive values are ignored.  The presence of `nextPageToken` in the
     *   response indicates that more results might be available.
     * @param {string} [request.pageToken]
     *   Optional. If present, then retrieve the next batch of results from the
     *   preceding call to this method.  `pageToken` must be the value of
     *   `nextPageToken` from the previous response.  The values of other method
     *   parameters should be identical to those in the previous call.
     * @param {string[]} [request.resourceNames]
     *   Optional. The resource name that owns the logs:
     *
     *    * `projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
     *    * `organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
     *    * `billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
     *    * `folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
     *
     *   To support legacy queries, it could also be:
     *
     *   *  `projects/[PROJECT_ID]`
     *   *  `organizations/[ORGANIZATION_ID]`
     *   *  `billingAccounts/[BILLING_ACCOUNT_ID]`
     *   *  `folders/[FOLDER_ID]`
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Stream}
     *   An object stream which emits an object representing string on 'data' event.
     *   The client library will perform auto-pagination by default: it will call the API as many
     *   times as needed. Note that it can affect your quota.
     *   We recommend using `listLogsAsync()`
     *   method described below for async iteration which you can stop as needed.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
     *   for more details and examples.
     */
    listLogsStream(request, options) {
        request = request || {};
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                parent: request.parent || '',
            });
        const defaultCallSettings = this._defaults['listLogs'];
        const callSettings = defaultCallSettings.merge(options);
        this.initialize();
        return this.descriptors.page.listLogs.createStream(this.innerApiCalls.listLogs, request, callSettings);
    }
    /**
     * Equivalent to `listLogs`, but returns an iterable object.
     *
     * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The resource name that owns the logs:
     *
     *   *  `projects/[PROJECT_ID]`
     *   *  `organizations/[ORGANIZATION_ID]`
     *   *  `billingAccounts/[BILLING_ACCOUNT_ID]`
     *   *  `folders/[FOLDER_ID]`
     * @param {number} [request.pageSize]
     *   Optional. The maximum number of results to return from this request.
     *   Non-positive values are ignored.  The presence of `nextPageToken` in the
     *   response indicates that more results might be available.
     * @param {string} [request.pageToken]
     *   Optional. If present, then retrieve the next batch of results from the
     *   preceding call to this method.  `pageToken` must be the value of
     *   `nextPageToken` from the previous response.  The values of other method
     *   parameters should be identical to those in the previous call.
     * @param {string[]} [request.resourceNames]
     *   Optional. The resource name that owns the logs:
     *
     *    * `projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
     *    * `organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
     *    * `billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
     *    * `folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
     *
     *   To support legacy queries, it could also be:
     *
     *   *  `projects/[PROJECT_ID]`
     *   *  `organizations/[ORGANIZATION_ID]`
     *   *  `billingAccounts/[BILLING_ACCOUNT_ID]`
     *   *  `folders/[FOLDER_ID]`
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Object}
     *   An iterable Object that allows [async iteration](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols).
     *   When you iterate the returned iterable, each element will be an object representing
     *   string. The API will be called under the hood as needed, once per the page,
     *   so you can stop the iteration when you don't need more results.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/logging_service_v2.list_logs.js</caption>
     * region_tag:logging_v2_generated_LoggingServiceV2_ListLogs_async
     */
    listLogsAsync(request, options) {
        request = request || {};
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] =
            gax.routingHeader.fromParams({
                parent: request.parent || '',
            });
        const defaultCallSettings = this._defaults['listLogs'];
        const callSettings = defaultCallSettings.merge(options);
        this.initialize();
        return this.descriptors.page.listLogs.asyncIterate(this.innerApiCalls['listLogs'], request, callSettings);
    }
    // --------------------
    // -- Path templates --
    // --------------------
    /**
     * Return a fully-qualified billingAccountCmekSettings resource name string.
     *
     * @param {string} billing_account
     * @returns {string} Resource name string.
     */
    billingAccountCmekSettingsPath(billingAccount) {
        return this.pathTemplates.billingAccountCmekSettingsPathTemplate.render({
            billing_account: billingAccount,
        });
    }
    /**
     * Parse the billing_account from BillingAccountCmekSettings resource.
     *
     * @param {string} billingAccountCmekSettingsName
     *   A fully-qualified path representing billing_account_cmekSettings resource.
     * @returns {string} A string representing the billing_account.
     */
    matchBillingAccountFromBillingAccountCmekSettingsName(billingAccountCmekSettingsName) {
        return this.pathTemplates.billingAccountCmekSettingsPathTemplate.match(billingAccountCmekSettingsName).billing_account;
    }
    /**
     * Return a fully-qualified billingAccountExclusion resource name string.
     *
     * @param {string} billing_account
     * @param {string} exclusion
     * @returns {string} Resource name string.
     */
    billingAccountExclusionPath(billingAccount, exclusion) {
        return this.pathTemplates.billingAccountExclusionPathTemplate.render({
            billing_account: billingAccount,
            exclusion: exclusion,
        });
    }
    /**
     * Parse the billing_account from BillingAccountExclusion resource.
     *
     * @param {string} billingAccountExclusionName
     *   A fully-qualified path representing billing_account_exclusion resource.
     * @returns {string} A string representing the billing_account.
     */
    matchBillingAccountFromBillingAccountExclusionName(billingAccountExclusionName) {
        return this.pathTemplates.billingAccountExclusionPathTemplate.match(billingAccountExclusionName).billing_account;
    }
    /**
     * Parse the exclusion from BillingAccountExclusion resource.
     *
     * @param {string} billingAccountExclusionName
     *   A fully-qualified path representing billing_account_exclusion resource.
     * @returns {string} A string representing the exclusion.
     */
    matchExclusionFromBillingAccountExclusionName(billingAccountExclusionName) {
        return this.pathTemplates.billingAccountExclusionPathTemplate.match(billingAccountExclusionName).exclusion;
    }
    /**
     * Return a fully-qualified billingAccountLocationBucket resource name string.
     *
     * @param {string} billing_account
     * @param {string} location
     * @param {string} bucket
     * @returns {string} Resource name string.
     */
    billingAccountLocationBucketPath(billingAccount, location, bucket) {
        return this.pathTemplates.billingAccountLocationBucketPathTemplate.render({
            billing_account: billingAccount,
            location: location,
            bucket: bucket,
        });
    }
    /**
     * Parse the billing_account from BillingAccountLocationBucket resource.
     *
     * @param {string} billingAccountLocationBucketName
     *   A fully-qualified path representing billing_account_location_bucket resource.
     * @returns {string} A string representing the billing_account.
     */
    matchBillingAccountFromBillingAccountLocationBucketName(billingAccountLocationBucketName) {
        return this.pathTemplates.billingAccountLocationBucketPathTemplate.match(billingAccountLocationBucketName).billing_account;
    }
    /**
     * Parse the location from BillingAccountLocationBucket resource.
     *
     * @param {string} billingAccountLocationBucketName
     *   A fully-qualified path representing billing_account_location_bucket resource.
     * @returns {string} A string representing the location.
     */
    matchLocationFromBillingAccountLocationBucketName(billingAccountLocationBucketName) {
        return this.pathTemplates.billingAccountLocationBucketPathTemplate.match(billingAccountLocationBucketName).location;
    }
    /**
     * Parse the bucket from BillingAccountLocationBucket resource.
     *
     * @param {string} billingAccountLocationBucketName
     *   A fully-qualified path representing billing_account_location_bucket resource.
     * @returns {string} A string representing the bucket.
     */
    matchBucketFromBillingAccountLocationBucketName(billingAccountLocationBucketName) {
        return this.pathTemplates.billingAccountLocationBucketPathTemplate.match(billingAccountLocationBucketName).bucket;
    }
    /**
     * Return a fully-qualified billingAccountLocationBucketView resource name string.
     *
     * @param {string} billing_account
     * @param {string} location
     * @param {string} bucket
     * @param {string} view
     * @returns {string} Resource name string.
     */
    billingAccountLocationBucketViewPath(billingAccount, location, bucket, view) {
        return this.pathTemplates.billingAccountLocationBucketViewPathTemplate.render({
            billing_account: billingAccount,
            location: location,
            bucket: bucket,
            view: view,
        });
    }
    /**
     * Parse the billing_account from BillingAccountLocationBucketView resource.
     *
     * @param {string} billingAccountLocationBucketViewName
     *   A fully-qualified path representing billing_account_location_bucket_view resource.
     * @returns {string} A string representing the billing_account.
     */
    matchBillingAccountFromBillingAccountLocationBucketViewName(billingAccountLocationBucketViewName) {
        return this.pathTemplates.billingAccountLocationBucketViewPathTemplate.match(billingAccountLocationBucketViewName).billing_account;
    }
    /**
     * Parse the location from BillingAccountLocationBucketView resource.
     *
     * @param {string} billingAccountLocationBucketViewName
     *   A fully-qualified path representing billing_account_location_bucket_view resource.
     * @returns {string} A string representing the location.
     */
    matchLocationFromBillingAccountLocationBucketViewName(billingAccountLocationBucketViewName) {
        return this.pathTemplates.billingAccountLocationBucketViewPathTemplate.match(billingAccountLocationBucketViewName).location;
    }
    /**
     * Parse the bucket from BillingAccountLocationBucketView resource.
     *
     * @param {string} billingAccountLocationBucketViewName
     *   A fully-qualified path representing billing_account_location_bucket_view resource.
     * @returns {string} A string representing the bucket.
     */
    matchBucketFromBillingAccountLocationBucketViewName(billingAccountLocationBucketViewName) {
        return this.pathTemplates.billingAccountLocationBucketViewPathTemplate.match(billingAccountLocationBucketViewName).bucket;
    }
    /**
     * Parse the view from BillingAccountLocationBucketView resource.
     *
     * @param {string} billingAccountLocationBucketViewName
     *   A fully-qualified path representing billing_account_location_bucket_view resource.
     * @returns {string} A string representing the view.
     */
    matchViewFromBillingAccountLocationBucketViewName(billingAccountLocationBucketViewName) {
        return this.pathTemplates.billingAccountLocationBucketViewPathTemplate.match(billingAccountLocationBucketViewName).view;
    }
    /**
     * Return a fully-qualified billingAccountLog resource name string.
     *
     * @param {string} billing_account
     * @param {string} log
     * @returns {string} Resource name string.
     */
    billingAccountLogPath(billingAccount, log) {
        return this.pathTemplates.billingAccountLogPathTemplate.render({
            billing_account: billingAccount,
            log: log,
        });
    }
    /**
     * Parse the billing_account from BillingAccountLog resource.
     *
     * @param {string} billingAccountLogName
     *   A fully-qualified path representing billing_account_log resource.
     * @returns {string} A string representing the billing_account.
     */
    matchBillingAccountFromBillingAccountLogName(billingAccountLogName) {
        return this.pathTemplates.billingAccountLogPathTemplate.match(billingAccountLogName).billing_account;
    }
    /**
     * Parse the log from BillingAccountLog resource.
     *
     * @param {string} billingAccountLogName
     *   A fully-qualified path representing billing_account_log resource.
     * @returns {string} A string representing the log.
     */
    matchLogFromBillingAccountLogName(billingAccountLogName) {
        return this.pathTemplates.billingAccountLogPathTemplate.match(billingAccountLogName).log;
    }
    /**
     * Return a fully-qualified billingAccountSettings resource name string.
     *
     * @param {string} billing_account
     * @returns {string} Resource name string.
     */
    billingAccountSettingsPath(billingAccount) {
        return this.pathTemplates.billingAccountSettingsPathTemplate.render({
            billing_account: billingAccount,
        });
    }
    /**
     * Parse the billing_account from BillingAccountSettings resource.
     *
     * @param {string} billingAccountSettingsName
     *   A fully-qualified path representing billing_account_settings resource.
     * @returns {string} A string representing the billing_account.
     */
    matchBillingAccountFromBillingAccountSettingsName(billingAccountSettingsName) {
        return this.pathTemplates.billingAccountSettingsPathTemplate.match(billingAccountSettingsName).billing_account;
    }
    /**
     * Return a fully-qualified billingAccountSink resource name string.
     *
     * @param {string} billing_account
     * @param {string} sink
     * @returns {string} Resource name string.
     */
    billingAccountSinkPath(billingAccount, sink) {
        return this.pathTemplates.billingAccountSinkPathTemplate.render({
            billing_account: billingAccount,
            sink: sink,
        });
    }
    /**
     * Parse the billing_account from BillingAccountSink resource.
     *
     * @param {string} billingAccountSinkName
     *   A fully-qualified path representing billing_account_sink resource.
     * @returns {string} A string representing the billing_account.
     */
    matchBillingAccountFromBillingAccountSinkName(billingAccountSinkName) {
        return this.pathTemplates.billingAccountSinkPathTemplate.match(billingAccountSinkName).billing_account;
    }
    /**
     * Parse the sink from BillingAccountSink resource.
     *
     * @param {string} billingAccountSinkName
     *   A fully-qualified path representing billing_account_sink resource.
     * @returns {string} A string representing the sink.
     */
    matchSinkFromBillingAccountSinkName(billingAccountSinkName) {
        return this.pathTemplates.billingAccountSinkPathTemplate.match(billingAccountSinkName).sink;
    }
    /**
     * Return a fully-qualified folderCmekSettings resource name string.
     *
     * @param {string} folder
     * @returns {string} Resource name string.
     */
    folderCmekSettingsPath(folder) {
        return this.pathTemplates.folderCmekSettingsPathTemplate.render({
            folder: folder,
        });
    }
    /**
     * Parse the folder from FolderCmekSettings resource.
     *
     * @param {string} folderCmekSettingsName
     *   A fully-qualified path representing folder_cmekSettings resource.
     * @returns {string} A string representing the folder.
     */
    matchFolderFromFolderCmekSettingsName(folderCmekSettingsName) {
        return this.pathTemplates.folderCmekSettingsPathTemplate.match(folderCmekSettingsName).folder;
    }
    /**
     * Return a fully-qualified folderExclusion resource name string.
     *
     * @param {string} folder
     * @param {string} exclusion
     * @returns {string} Resource name string.
     */
    folderExclusionPath(folder, exclusion) {
        return this.pathTemplates.folderExclusionPathTemplate.render({
            folder: folder,
            exclusion: exclusion,
        });
    }
    /**
     * Parse the folder from FolderExclusion resource.
     *
     * @param {string} folderExclusionName
     *   A fully-qualified path representing folder_exclusion resource.
     * @returns {string} A string representing the folder.
     */
    matchFolderFromFolderExclusionName(folderExclusionName) {
        return this.pathTemplates.folderExclusionPathTemplate.match(folderExclusionName).folder;
    }
    /**
     * Parse the exclusion from FolderExclusion resource.
     *
     * @param {string} folderExclusionName
     *   A fully-qualified path representing folder_exclusion resource.
     * @returns {string} A string representing the exclusion.
     */
    matchExclusionFromFolderExclusionName(folderExclusionName) {
        return this.pathTemplates.folderExclusionPathTemplate.match(folderExclusionName).exclusion;
    }
    /**
     * Return a fully-qualified folderLocationBucket resource name string.
     *
     * @param {string} folder
     * @param {string} location
     * @param {string} bucket
     * @returns {string} Resource name string.
     */
    folderLocationBucketPath(folder, location, bucket) {
        return this.pathTemplates.folderLocationBucketPathTemplate.render({
            folder: folder,
            location: location,
            bucket: bucket,
        });
    }
    /**
     * Parse the folder from FolderLocationBucket resource.
     *
     * @param {string} folderLocationBucketName
     *   A fully-qualified path representing folder_location_bucket resource.
     * @returns {string} A string representing the folder.
     */
    matchFolderFromFolderLocationBucketName(folderLocationBucketName) {
        return this.pathTemplates.folderLocationBucketPathTemplate.match(folderLocationBucketName).folder;
    }
    /**
     * Parse the location from FolderLocationBucket resource.
     *
     * @param {string} folderLocationBucketName
     *   A fully-qualified path representing folder_location_bucket resource.
     * @returns {string} A string representing the location.
     */
    matchLocationFromFolderLocationBucketName(folderLocationBucketName) {
        return this.pathTemplates.folderLocationBucketPathTemplate.match(folderLocationBucketName).location;
    }
    /**
     * Parse the bucket from FolderLocationBucket resource.
     *
     * @param {string} folderLocationBucketName
     *   A fully-qualified path representing folder_location_bucket resource.
     * @returns {string} A string representing the bucket.
     */
    matchBucketFromFolderLocationBucketName(folderLocationBucketName) {
        return this.pathTemplates.folderLocationBucketPathTemplate.match(folderLocationBucketName).bucket;
    }
    /**
     * Return a fully-qualified folderLocationBucketView resource name string.
     *
     * @param {string} folder
     * @param {string} location
     * @param {string} bucket
     * @param {string} view
     * @returns {string} Resource name string.
     */
    folderLocationBucketViewPath(folder, location, bucket, view) {
        return this.pathTemplates.folderLocationBucketViewPathTemplate.render({
            folder: folder,
            location: location,
            bucket: bucket,
            view: view,
        });
    }
    /**
     * Parse the folder from FolderLocationBucketView resource.
     *
     * @param {string} folderLocationBucketViewName
     *   A fully-qualified path representing folder_location_bucket_view resource.
     * @returns {string} A string representing the folder.
     */
    matchFolderFromFolderLocationBucketViewName(folderLocationBucketViewName) {
        return this.pathTemplates.folderLocationBucketViewPathTemplate.match(folderLocationBucketViewName).folder;
    }
    /**
     * Parse the location from FolderLocationBucketView resource.
     *
     * @param {string} folderLocationBucketViewName
     *   A fully-qualified path representing folder_location_bucket_view resource.
     * @returns {string} A string representing the location.
     */
    matchLocationFromFolderLocationBucketViewName(folderLocationBucketViewName) {
        return this.pathTemplates.folderLocationBucketViewPathTemplate.match(folderLocationBucketViewName).location;
    }
    /**
     * Parse the bucket from FolderLocationBucketView resource.
     *
     * @param {string} folderLocationBucketViewName
     *   A fully-qualified path representing folder_location_bucket_view resource.
     * @returns {string} A string representing the bucket.
     */
    matchBucketFromFolderLocationBucketViewName(folderLocationBucketViewName) {
        return this.pathTemplates.folderLocationBucketViewPathTemplate.match(folderLocationBucketViewName).bucket;
    }
    /**
     * Parse the view from FolderLocationBucketView resource.
     *
     * @param {string} folderLocationBucketViewName
     *   A fully-qualified path representing folder_location_bucket_view resource.
     * @returns {string} A string representing the view.
     */
    matchViewFromFolderLocationBucketViewName(folderLocationBucketViewName) {
        return this.pathTemplates.folderLocationBucketViewPathTemplate.match(folderLocationBucketViewName).view;
    }
    /**
     * Return a fully-qualified folderLog resource name string.
     *
     * @param {string} folder
     * @param {string} log
     * @returns {string} Resource name string.
     */
    folderLogPath(folder, log) {
        return this.pathTemplates.folderLogPathTemplate.render({
            folder: folder,
            log: log,
        });
    }
    /**
     * Parse the folder from FolderLog resource.
     *
     * @param {string} folderLogName
     *   A fully-qualified path representing folder_log resource.
     * @returns {string} A string representing the folder.
     */
    matchFolderFromFolderLogName(folderLogName) {
        return this.pathTemplates.folderLogPathTemplate.match(folderLogName).folder;
    }
    /**
     * Parse the log from FolderLog resource.
     *
     * @param {string} folderLogName
     *   A fully-qualified path representing folder_log resource.
     * @returns {string} A string representing the log.
     */
    matchLogFromFolderLogName(folderLogName) {
        return this.pathTemplates.folderLogPathTemplate.match(folderLogName).log;
    }
    /**
     * Return a fully-qualified folderSettings resource name string.
     *
     * @param {string} folder
     * @returns {string} Resource name string.
     */
    folderSettingsPath(folder) {
        return this.pathTemplates.folderSettingsPathTemplate.render({
            folder: folder,
        });
    }
    /**
     * Parse the folder from FolderSettings resource.
     *
     * @param {string} folderSettingsName
     *   A fully-qualified path representing folder_settings resource.
     * @returns {string} A string representing the folder.
     */
    matchFolderFromFolderSettingsName(folderSettingsName) {
        return this.pathTemplates.folderSettingsPathTemplate.match(folderSettingsName).folder;
    }
    /**
     * Return a fully-qualified folderSink resource name string.
     *
     * @param {string} folder
     * @param {string} sink
     * @returns {string} Resource name string.
     */
    folderSinkPath(folder, sink) {
        return this.pathTemplates.folderSinkPathTemplate.render({
            folder: folder,
            sink: sink,
        });
    }
    /**
     * Parse the folder from FolderSink resource.
     *
     * @param {string} folderSinkName
     *   A fully-qualified path representing folder_sink resource.
     * @returns {string} A string representing the folder.
     */
    matchFolderFromFolderSinkName(folderSinkName) {
        return this.pathTemplates.folderSinkPathTemplate.match(folderSinkName)
            .folder;
    }
    /**
     * Parse the sink from FolderSink resource.
     *
     * @param {string} folderSinkName
     *   A fully-qualified path representing folder_sink resource.
     * @returns {string} A string representing the sink.
     */
    matchSinkFromFolderSinkName(folderSinkName) {
        return this.pathTemplates.folderSinkPathTemplate.match(folderSinkName).sink;
    }
    /**
     * Return a fully-qualified logMetric resource name string.
     *
     * @param {string} project
     * @param {string} metric
     * @returns {string} Resource name string.
     */
    logMetricPath(project, metric) {
        return this.pathTemplates.logMetricPathTemplate.render({
            project: project,
            metric: metric,
        });
    }
    /**
     * Parse the project from LogMetric resource.
     *
     * @param {string} logMetricName
     *   A fully-qualified path representing LogMetric resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromLogMetricName(logMetricName) {
        return this.pathTemplates.logMetricPathTemplate.match(logMetricName)
            .project;
    }
    /**
     * Parse the metric from LogMetric resource.
     *
     * @param {string} logMetricName
     *   A fully-qualified path representing LogMetric resource.
     * @returns {string} A string representing the metric.
     */
    matchMetricFromLogMetricName(logMetricName) {
        return this.pathTemplates.logMetricPathTemplate.match(logMetricName).metric;
    }
    /**
     * Return a fully-qualified organizationCmekSettings resource name string.
     *
     * @param {string} organization
     * @returns {string} Resource name string.
     */
    organizationCmekSettingsPath(organization) {
        return this.pathTemplates.organizationCmekSettingsPathTemplate.render({
            organization: organization,
        });
    }
    /**
     * Parse the organization from OrganizationCmekSettings resource.
     *
     * @param {string} organizationCmekSettingsName
     *   A fully-qualified path representing organization_cmekSettings resource.
     * @returns {string} A string representing the organization.
     */
    matchOrganizationFromOrganizationCmekSettingsName(organizationCmekSettingsName) {
        return this.pathTemplates.organizationCmekSettingsPathTemplate.match(organizationCmekSettingsName).organization;
    }
    /**
     * Return a fully-qualified organizationExclusion resource name string.
     *
     * @param {string} organization
     * @param {string} exclusion
     * @returns {string} Resource name string.
     */
    organizationExclusionPath(organization, exclusion) {
        return this.pathTemplates.organizationExclusionPathTemplate.render({
            organization: organization,
            exclusion: exclusion,
        });
    }
    /**
     * Parse the organization from OrganizationExclusion resource.
     *
     * @param {string} organizationExclusionName
     *   A fully-qualified path representing organization_exclusion resource.
     * @returns {string} A string representing the organization.
     */
    matchOrganizationFromOrganizationExclusionName(organizationExclusionName) {
        return this.pathTemplates.organizationExclusionPathTemplate.match(organizationExclusionName).organization;
    }
    /**
     * Parse the exclusion from OrganizationExclusion resource.
     *
     * @param {string} organizationExclusionName
     *   A fully-qualified path representing organization_exclusion resource.
     * @returns {string} A string representing the exclusion.
     */
    matchExclusionFromOrganizationExclusionName(organizationExclusionName) {
        return this.pathTemplates.organizationExclusionPathTemplate.match(organizationExclusionName).exclusion;
    }
    /**
     * Return a fully-qualified organizationLocationBucket resource name string.
     *
     * @param {string} organization
     * @param {string} location
     * @param {string} bucket
     * @returns {string} Resource name string.
     */
    organizationLocationBucketPath(organization, location, bucket) {
        return this.pathTemplates.organizationLocationBucketPathTemplate.render({
            organization: organization,
            location: location,
            bucket: bucket,
        });
    }
    /**
     * Parse the organization from OrganizationLocationBucket resource.
     *
     * @param {string} organizationLocationBucketName
     *   A fully-qualified path representing organization_location_bucket resource.
     * @returns {string} A string representing the organization.
     */
    matchOrganizationFromOrganizationLocationBucketName(organizationLocationBucketName) {
        return this.pathTemplates.organizationLocationBucketPathTemplate.match(organizationLocationBucketName).organization;
    }
    /**
     * Parse the location from OrganizationLocationBucket resource.
     *
     * @param {string} organizationLocationBucketName
     *   A fully-qualified path representing organization_location_bucket resource.
     * @returns {string} A string representing the location.
     */
    matchLocationFromOrganizationLocationBucketName(organizationLocationBucketName) {
        return this.pathTemplates.organizationLocationBucketPathTemplate.match(organizationLocationBucketName).location;
    }
    /**
     * Parse the bucket from OrganizationLocationBucket resource.
     *
     * @param {string} organizationLocationBucketName
     *   A fully-qualified path representing organization_location_bucket resource.
     * @returns {string} A string representing the bucket.
     */
    matchBucketFromOrganizationLocationBucketName(organizationLocationBucketName) {
        return this.pathTemplates.organizationLocationBucketPathTemplate.match(organizationLocationBucketName).bucket;
    }
    /**
     * Return a fully-qualified organizationLocationBucketView resource name string.
     *
     * @param {string} organization
     * @param {string} location
     * @param {string} bucket
     * @param {string} view
     * @returns {string} Resource name string.
     */
    organizationLocationBucketViewPath(organization, location, bucket, view) {
        return this.pathTemplates.organizationLocationBucketViewPathTemplate.render({
            organization: organization,
            location: location,
            bucket: bucket,
            view: view,
        });
    }
    /**
     * Parse the organization from OrganizationLocationBucketView resource.
     *
     * @param {string} organizationLocationBucketViewName
     *   A fully-qualified path representing organization_location_bucket_view resource.
     * @returns {string} A string representing the organization.
     */
    matchOrganizationFromOrganizationLocationBucketViewName(organizationLocationBucketViewName) {
        return this.pathTemplates.organizationLocationBucketViewPathTemplate.match(organizationLocationBucketViewName).organization;
    }
    /**
     * Parse the location from OrganizationLocationBucketView resource.
     *
     * @param {string} organizationLocationBucketViewName
     *   A fully-qualified path representing organization_location_bucket_view resource.
     * @returns {string} A string representing the location.
     */
    matchLocationFromOrganizationLocationBucketViewName(organizationLocationBucketViewName) {
        return this.pathTemplates.organizationLocationBucketViewPathTemplate.match(organizationLocationBucketViewName).location;
    }
    /**
     * Parse the bucket from OrganizationLocationBucketView resource.
     *
     * @param {string} organizationLocationBucketViewName
     *   A fully-qualified path representing organization_location_bucket_view resource.
     * @returns {string} A string representing the bucket.
     */
    matchBucketFromOrganizationLocationBucketViewName(organizationLocationBucketViewName) {
        return this.pathTemplates.organizationLocationBucketViewPathTemplate.match(organizationLocationBucketViewName).bucket;
    }
    /**
     * Parse the view from OrganizationLocationBucketView resource.
     *
     * @param {string} organizationLocationBucketViewName
     *   A fully-qualified path representing organization_location_bucket_view resource.
     * @returns {string} A string representing the view.
     */
    matchViewFromOrganizationLocationBucketViewName(organizationLocationBucketViewName) {
        return this.pathTemplates.organizationLocationBucketViewPathTemplate.match(organizationLocationBucketViewName).view;
    }
    /**
     * Return a fully-qualified organizationLog resource name string.
     *
     * @param {string} organization
     * @param {string} log
     * @returns {string} Resource name string.
     */
    organizationLogPath(organization, log) {
        return this.pathTemplates.organizationLogPathTemplate.render({
            organization: organization,
            log: log,
        });
    }
    /**
     * Parse the organization from OrganizationLog resource.
     *
     * @param {string} organizationLogName
     *   A fully-qualified path representing organization_log resource.
     * @returns {string} A string representing the organization.
     */
    matchOrganizationFromOrganizationLogName(organizationLogName) {
        return this.pathTemplates.organizationLogPathTemplate.match(organizationLogName).organization;
    }
    /**
     * Parse the log from OrganizationLog resource.
     *
     * @param {string} organizationLogName
     *   A fully-qualified path representing organization_log resource.
     * @returns {string} A string representing the log.
     */
    matchLogFromOrganizationLogName(organizationLogName) {
        return this.pathTemplates.organizationLogPathTemplate.match(organizationLogName).log;
    }
    /**
     * Return a fully-qualified organizationSettings resource name string.
     *
     * @param {string} organization
     * @returns {string} Resource name string.
     */
    organizationSettingsPath(organization) {
        return this.pathTemplates.organizationSettingsPathTemplate.render({
            organization: organization,
        });
    }
    /**
     * Parse the organization from OrganizationSettings resource.
     *
     * @param {string} organizationSettingsName
     *   A fully-qualified path representing organization_settings resource.
     * @returns {string} A string representing the organization.
     */
    matchOrganizationFromOrganizationSettingsName(organizationSettingsName) {
        return this.pathTemplates.organizationSettingsPathTemplate.match(organizationSettingsName).organization;
    }
    /**
     * Return a fully-qualified organizationSink resource name string.
     *
     * @param {string} organization
     * @param {string} sink
     * @returns {string} Resource name string.
     */
    organizationSinkPath(organization, sink) {
        return this.pathTemplates.organizationSinkPathTemplate.render({
            organization: organization,
            sink: sink,
        });
    }
    /**
     * Parse the organization from OrganizationSink resource.
     *
     * @param {string} organizationSinkName
     *   A fully-qualified path representing organization_sink resource.
     * @returns {string} A string representing the organization.
     */
    matchOrganizationFromOrganizationSinkName(organizationSinkName) {
        return this.pathTemplates.organizationSinkPathTemplate.match(organizationSinkName).organization;
    }
    /**
     * Parse the sink from OrganizationSink resource.
     *
     * @param {string} organizationSinkName
     *   A fully-qualified path representing organization_sink resource.
     * @returns {string} A string representing the sink.
     */
    matchSinkFromOrganizationSinkName(organizationSinkName) {
        return this.pathTemplates.organizationSinkPathTemplate.match(organizationSinkName).sink;
    }
    /**
     * Return a fully-qualified project resource name string.
     *
     * @param {string} project
     * @returns {string} Resource name string.
     */
    projectPath(project) {
        return this.pathTemplates.projectPathTemplate.render({
            project: project,
        });
    }
    /**
     * Parse the project from Project resource.
     *
     * @param {string} projectName
     *   A fully-qualified path representing Project resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromProjectName(projectName) {
        return this.pathTemplates.projectPathTemplate.match(projectName).project;
    }
    /**
     * Return a fully-qualified projectCmekSettings resource name string.
     *
     * @param {string} project
     * @returns {string} Resource name string.
     */
    projectCmekSettingsPath(project) {
        return this.pathTemplates.projectCmekSettingsPathTemplate.render({
            project: project,
        });
    }
    /**
     * Parse the project from ProjectCmekSettings resource.
     *
     * @param {string} projectCmekSettingsName
     *   A fully-qualified path representing project_cmekSettings resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromProjectCmekSettingsName(projectCmekSettingsName) {
        return this.pathTemplates.projectCmekSettingsPathTemplate.match(projectCmekSettingsName).project;
    }
    /**
     * Return a fully-qualified projectExclusion resource name string.
     *
     * @param {string} project
     * @param {string} exclusion
     * @returns {string} Resource name string.
     */
    projectExclusionPath(project, exclusion) {
        return this.pathTemplates.projectExclusionPathTemplate.render({
            project: project,
            exclusion: exclusion,
        });
    }
    /**
     * Parse the project from ProjectExclusion resource.
     *
     * @param {string} projectExclusionName
     *   A fully-qualified path representing project_exclusion resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromProjectExclusionName(projectExclusionName) {
        return this.pathTemplates.projectExclusionPathTemplate.match(projectExclusionName).project;
    }
    /**
     * Parse the exclusion from ProjectExclusion resource.
     *
     * @param {string} projectExclusionName
     *   A fully-qualified path representing project_exclusion resource.
     * @returns {string} A string representing the exclusion.
     */
    matchExclusionFromProjectExclusionName(projectExclusionName) {
        return this.pathTemplates.projectExclusionPathTemplate.match(projectExclusionName).exclusion;
    }
    /**
     * Return a fully-qualified projectLocationBucket resource name string.
     *
     * @param {string} project
     * @param {string} location
     * @param {string} bucket
     * @returns {string} Resource name string.
     */
    projectLocationBucketPath(project, location, bucket) {
        return this.pathTemplates.projectLocationBucketPathTemplate.render({
            project: project,
            location: location,
            bucket: bucket,
        });
    }
    /**
     * Parse the project from ProjectLocationBucket resource.
     *
     * @param {string} projectLocationBucketName
     *   A fully-qualified path representing project_location_bucket resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromProjectLocationBucketName(projectLocationBucketName) {
        return this.pathTemplates.projectLocationBucketPathTemplate.match(projectLocationBucketName).project;
    }
    /**
     * Parse the location from ProjectLocationBucket resource.
     *
     * @param {string} projectLocationBucketName
     *   A fully-qualified path representing project_location_bucket resource.
     * @returns {string} A string representing the location.
     */
    matchLocationFromProjectLocationBucketName(projectLocationBucketName) {
        return this.pathTemplates.projectLocationBucketPathTemplate.match(projectLocationBucketName).location;
    }
    /**
     * Parse the bucket from ProjectLocationBucket resource.
     *
     * @param {string} projectLocationBucketName
     *   A fully-qualified path representing project_location_bucket resource.
     * @returns {string} A string representing the bucket.
     */
    matchBucketFromProjectLocationBucketName(projectLocationBucketName) {
        return this.pathTemplates.projectLocationBucketPathTemplate.match(projectLocationBucketName).bucket;
    }
    /**
     * Return a fully-qualified projectLocationBucketView resource name string.
     *
     * @param {string} project
     * @param {string} location
     * @param {string} bucket
     * @param {string} view
     * @returns {string} Resource name string.
     */
    projectLocationBucketViewPath(project, location, bucket, view) {
        return this.pathTemplates.projectLocationBucketViewPathTemplate.render({
            project: project,
            location: location,
            bucket: bucket,
            view: view,
        });
    }
    /**
     * Parse the project from ProjectLocationBucketView resource.
     *
     * @param {string} projectLocationBucketViewName
     *   A fully-qualified path representing project_location_bucket_view resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromProjectLocationBucketViewName(projectLocationBucketViewName) {
        return this.pathTemplates.projectLocationBucketViewPathTemplate.match(projectLocationBucketViewName).project;
    }
    /**
     * Parse the location from ProjectLocationBucketView resource.
     *
     * @param {string} projectLocationBucketViewName
     *   A fully-qualified path representing project_location_bucket_view resource.
     * @returns {string} A string representing the location.
     */
    matchLocationFromProjectLocationBucketViewName(projectLocationBucketViewName) {
        return this.pathTemplates.projectLocationBucketViewPathTemplate.match(projectLocationBucketViewName).location;
    }
    /**
     * Parse the bucket from ProjectLocationBucketView resource.
     *
     * @param {string} projectLocationBucketViewName
     *   A fully-qualified path representing project_location_bucket_view resource.
     * @returns {string} A string representing the bucket.
     */
    matchBucketFromProjectLocationBucketViewName(projectLocationBucketViewName) {
        return this.pathTemplates.projectLocationBucketViewPathTemplate.match(projectLocationBucketViewName).bucket;
    }
    /**
     * Parse the view from ProjectLocationBucketView resource.
     *
     * @param {string} projectLocationBucketViewName
     *   A fully-qualified path representing project_location_bucket_view resource.
     * @returns {string} A string representing the view.
     */
    matchViewFromProjectLocationBucketViewName(projectLocationBucketViewName) {
        return this.pathTemplates.projectLocationBucketViewPathTemplate.match(projectLocationBucketViewName).view;
    }
    /**
     * Return a fully-qualified projectLog resource name string.
     *
     * @param {string} project
     * @param {string} log
     * @returns {string} Resource name string.
     */
    projectLogPath(project, log) {
        return this.pathTemplates.projectLogPathTemplate.render({
            project: project,
            log: log,
        });
    }
    /**
     * Parse the project from ProjectLog resource.
     *
     * @param {string} projectLogName
     *   A fully-qualified path representing project_log resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromProjectLogName(projectLogName) {
        return this.pathTemplates.projectLogPathTemplate.match(projectLogName)
            .project;
    }
    /**
     * Parse the log from ProjectLog resource.
     *
     * @param {string} projectLogName
     *   A fully-qualified path representing project_log resource.
     * @returns {string} A string representing the log.
     */
    matchLogFromProjectLogName(projectLogName) {
        return this.pathTemplates.projectLogPathTemplate.match(projectLogName).log;
    }
    /**
     * Return a fully-qualified projectSettings resource name string.
     *
     * @param {string} project
     * @returns {string} Resource name string.
     */
    projectSettingsPath(project) {
        return this.pathTemplates.projectSettingsPathTemplate.render({
            project: project,
        });
    }
    /**
     * Parse the project from ProjectSettings resource.
     *
     * @param {string} projectSettingsName
     *   A fully-qualified path representing project_settings resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromProjectSettingsName(projectSettingsName) {
        return this.pathTemplates.projectSettingsPathTemplate.match(projectSettingsName).project;
    }
    /**
     * Return a fully-qualified projectSink resource name string.
     *
     * @param {string} project
     * @param {string} sink
     * @returns {string} Resource name string.
     */
    projectSinkPath(project, sink) {
        return this.pathTemplates.projectSinkPathTemplate.render({
            project: project,
            sink: sink,
        });
    }
    /**
     * Parse the project from ProjectSink resource.
     *
     * @param {string} projectSinkName
     *   A fully-qualified path representing project_sink resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromProjectSinkName(projectSinkName) {
        return this.pathTemplates.projectSinkPathTemplate.match(projectSinkName)
            .project;
    }
    /**
     * Parse the sink from ProjectSink resource.
     *
     * @param {string} projectSinkName
     *   A fully-qualified path representing project_sink resource.
     * @returns {string} A string representing the sink.
     */
    matchSinkFromProjectSinkName(projectSinkName) {
        return this.pathTemplates.projectSinkPathTemplate.match(projectSinkName)
            .sink;
    }
    /**
     * Terminate the gRPC channel and close the client.
     *
     * The client will no longer be usable and all future behavior is undefined.
     * @returns {Promise} A promise that resolves when the client is closed.
     */
    close() {
        if (this.loggingServiceV2Stub && !this._terminated) {
            return this.loggingServiceV2Stub.then(stub => {
                this._terminated = true;
                stub.close();
            });
        }
        return Promise.resolve();
    }
}
exports.LoggingServiceV2Client = LoggingServiceV2Client;
//# sourceMappingURL=logging_service_v2_client.js.map