// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*eslint-disable block-scoped-var, id-length, no-control-regex, no-magic-numbers, no-prototype-builtins, no-redeclare, no-shadow, no-var, sort-vars*/
(function(global, factory) { /* global define, require, module */

    /* AMD */ if (typeof define === 'function' && define.amd)
        define(["protobufjs/minimal"], factory);

    /* CommonJS */ else if (typeof require === 'function' && typeof module === 'object' && module && module.exports)
        module.exports = factory(require("google-gax/build/src/protobuf").protobufMinimal);

})(this, function($protobuf) {
    "use strict";

    // Common aliases
    var $Reader = $protobuf.Reader, $Writer = $protobuf.Writer, $util = $protobuf.util;
    
    // Exported root namespace
    var $root = $protobuf.roots._google_cloud_pubsub_protos || ($protobuf.roots._google_cloud_pubsub_protos = {});
    
    $root.google = (function() {
    
        /**
         * Namespace google.
         * @exports google
         * @namespace
         */
        var google = {};
    
        google.pubsub = (function() {
    
            /**
             * Namespace pubsub.
             * @memberof google
             * @namespace
             */
            var pubsub = {};
    
            pubsub.v1 = (function() {
    
                /**
                 * Namespace v1.
                 * @memberof google.pubsub
                 * @namespace
                 */
                var v1 = {};
    
                v1.Publisher = (function() {
    
                    /**
                     * Constructs a new Publisher service.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a Publisher
                     * @extends $protobuf.rpc.Service
                     * @constructor
                     * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                     * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                     * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                     */
                    function Publisher(rpcImpl, requestDelimited, responseDelimited) {
                        $protobuf.rpc.Service.call(this, rpcImpl, requestDelimited, responseDelimited);
                    }
    
                    (Publisher.prototype = Object.create($protobuf.rpc.Service.prototype)).constructor = Publisher;
    
                    /**
                     * Creates new Publisher service using the specified rpc implementation.
                     * @function create
                     * @memberof google.pubsub.v1.Publisher
                     * @static
                     * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                     * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                     * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                     * @returns {Publisher} RPC service. Useful where requests and/or responses are streamed.
                     */
                    Publisher.create = function create(rpcImpl, requestDelimited, responseDelimited) {
                        return new this(rpcImpl, requestDelimited, responseDelimited);
                    };
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Publisher|createTopic}.
                     * @memberof google.pubsub.v1.Publisher
                     * @typedef CreateTopicCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.Topic} [response] Topic
                     */
    
                    /**
                     * Calls CreateTopic.
                     * @function createTopic
                     * @memberof google.pubsub.v1.Publisher
                     * @instance
                     * @param {google.pubsub.v1.ITopic} request Topic message or plain object
                     * @param {google.pubsub.v1.Publisher.CreateTopicCallback} callback Node-style callback called with the error, if any, and Topic
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Publisher.prototype.createTopic = function createTopic(request, callback) {
                        return this.rpcCall(createTopic, $root.google.pubsub.v1.Topic, $root.google.pubsub.v1.Topic, request, callback);
                    }, "name", { value: "CreateTopic" });
    
                    /**
                     * Calls CreateTopic.
                     * @function createTopic
                     * @memberof google.pubsub.v1.Publisher
                     * @instance
                     * @param {google.pubsub.v1.ITopic} request Topic message or plain object
                     * @returns {Promise<google.pubsub.v1.Topic>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Publisher|updateTopic}.
                     * @memberof google.pubsub.v1.Publisher
                     * @typedef UpdateTopicCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.Topic} [response] Topic
                     */
    
                    /**
                     * Calls UpdateTopic.
                     * @function updateTopic
                     * @memberof google.pubsub.v1.Publisher
                     * @instance
                     * @param {google.pubsub.v1.IUpdateTopicRequest} request UpdateTopicRequest message or plain object
                     * @param {google.pubsub.v1.Publisher.UpdateTopicCallback} callback Node-style callback called with the error, if any, and Topic
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Publisher.prototype.updateTopic = function updateTopic(request, callback) {
                        return this.rpcCall(updateTopic, $root.google.pubsub.v1.UpdateTopicRequest, $root.google.pubsub.v1.Topic, request, callback);
                    }, "name", { value: "UpdateTopic" });
    
                    /**
                     * Calls UpdateTopic.
                     * @function updateTopic
                     * @memberof google.pubsub.v1.Publisher
                     * @instance
                     * @param {google.pubsub.v1.IUpdateTopicRequest} request UpdateTopicRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.Topic>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Publisher|publish}.
                     * @memberof google.pubsub.v1.Publisher
                     * @typedef PublishCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.PublishResponse} [response] PublishResponse
                     */
    
                    /**
                     * Calls Publish.
                     * @function publish
                     * @memberof google.pubsub.v1.Publisher
                     * @instance
                     * @param {google.pubsub.v1.IPublishRequest} request PublishRequest message or plain object
                     * @param {google.pubsub.v1.Publisher.PublishCallback} callback Node-style callback called with the error, if any, and PublishResponse
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Publisher.prototype.publish = function publish(request, callback) {
                        return this.rpcCall(publish, $root.google.pubsub.v1.PublishRequest, $root.google.pubsub.v1.PublishResponse, request, callback);
                    }, "name", { value: "Publish" });
    
                    /**
                     * Calls Publish.
                     * @function publish
                     * @memberof google.pubsub.v1.Publisher
                     * @instance
                     * @param {google.pubsub.v1.IPublishRequest} request PublishRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.PublishResponse>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Publisher|getTopic}.
                     * @memberof google.pubsub.v1.Publisher
                     * @typedef GetTopicCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.Topic} [response] Topic
                     */
    
                    /**
                     * Calls GetTopic.
                     * @function getTopic
                     * @memberof google.pubsub.v1.Publisher
                     * @instance
                     * @param {google.pubsub.v1.IGetTopicRequest} request GetTopicRequest message or plain object
                     * @param {google.pubsub.v1.Publisher.GetTopicCallback} callback Node-style callback called with the error, if any, and Topic
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Publisher.prototype.getTopic = function getTopic(request, callback) {
                        return this.rpcCall(getTopic, $root.google.pubsub.v1.GetTopicRequest, $root.google.pubsub.v1.Topic, request, callback);
                    }, "name", { value: "GetTopic" });
    
                    /**
                     * Calls GetTopic.
                     * @function getTopic
                     * @memberof google.pubsub.v1.Publisher
                     * @instance
                     * @param {google.pubsub.v1.IGetTopicRequest} request GetTopicRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.Topic>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Publisher|listTopics}.
                     * @memberof google.pubsub.v1.Publisher
                     * @typedef ListTopicsCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.ListTopicsResponse} [response] ListTopicsResponse
                     */
    
                    /**
                     * Calls ListTopics.
                     * @function listTopics
                     * @memberof google.pubsub.v1.Publisher
                     * @instance
                     * @param {google.pubsub.v1.IListTopicsRequest} request ListTopicsRequest message or plain object
                     * @param {google.pubsub.v1.Publisher.ListTopicsCallback} callback Node-style callback called with the error, if any, and ListTopicsResponse
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Publisher.prototype.listTopics = function listTopics(request, callback) {
                        return this.rpcCall(listTopics, $root.google.pubsub.v1.ListTopicsRequest, $root.google.pubsub.v1.ListTopicsResponse, request, callback);
                    }, "name", { value: "ListTopics" });
    
                    /**
                     * Calls ListTopics.
                     * @function listTopics
                     * @memberof google.pubsub.v1.Publisher
                     * @instance
                     * @param {google.pubsub.v1.IListTopicsRequest} request ListTopicsRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.ListTopicsResponse>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Publisher|listTopicSubscriptions}.
                     * @memberof google.pubsub.v1.Publisher
                     * @typedef ListTopicSubscriptionsCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.ListTopicSubscriptionsResponse} [response] ListTopicSubscriptionsResponse
                     */
    
                    /**
                     * Calls ListTopicSubscriptions.
                     * @function listTopicSubscriptions
                     * @memberof google.pubsub.v1.Publisher
                     * @instance
                     * @param {google.pubsub.v1.IListTopicSubscriptionsRequest} request ListTopicSubscriptionsRequest message or plain object
                     * @param {google.pubsub.v1.Publisher.ListTopicSubscriptionsCallback} callback Node-style callback called with the error, if any, and ListTopicSubscriptionsResponse
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Publisher.prototype.listTopicSubscriptions = function listTopicSubscriptions(request, callback) {
                        return this.rpcCall(listTopicSubscriptions, $root.google.pubsub.v1.ListTopicSubscriptionsRequest, $root.google.pubsub.v1.ListTopicSubscriptionsResponse, request, callback);
                    }, "name", { value: "ListTopicSubscriptions" });
    
                    /**
                     * Calls ListTopicSubscriptions.
                     * @function listTopicSubscriptions
                     * @memberof google.pubsub.v1.Publisher
                     * @instance
                     * @param {google.pubsub.v1.IListTopicSubscriptionsRequest} request ListTopicSubscriptionsRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.ListTopicSubscriptionsResponse>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Publisher|listTopicSnapshots}.
                     * @memberof google.pubsub.v1.Publisher
                     * @typedef ListTopicSnapshotsCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.ListTopicSnapshotsResponse} [response] ListTopicSnapshotsResponse
                     */
    
                    /**
                     * Calls ListTopicSnapshots.
                     * @function listTopicSnapshots
                     * @memberof google.pubsub.v1.Publisher
                     * @instance
                     * @param {google.pubsub.v1.IListTopicSnapshotsRequest} request ListTopicSnapshotsRequest message or plain object
                     * @param {google.pubsub.v1.Publisher.ListTopicSnapshotsCallback} callback Node-style callback called with the error, if any, and ListTopicSnapshotsResponse
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Publisher.prototype.listTopicSnapshots = function listTopicSnapshots(request, callback) {
                        return this.rpcCall(listTopicSnapshots, $root.google.pubsub.v1.ListTopicSnapshotsRequest, $root.google.pubsub.v1.ListTopicSnapshotsResponse, request, callback);
                    }, "name", { value: "ListTopicSnapshots" });
    
                    /**
                     * Calls ListTopicSnapshots.
                     * @function listTopicSnapshots
                     * @memberof google.pubsub.v1.Publisher
                     * @instance
                     * @param {google.pubsub.v1.IListTopicSnapshotsRequest} request ListTopicSnapshotsRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.ListTopicSnapshotsResponse>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Publisher|deleteTopic}.
                     * @memberof google.pubsub.v1.Publisher
                     * @typedef DeleteTopicCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.protobuf.Empty} [response] Empty
                     */
    
                    /**
                     * Calls DeleteTopic.
                     * @function deleteTopic
                     * @memberof google.pubsub.v1.Publisher
                     * @instance
                     * @param {google.pubsub.v1.IDeleteTopicRequest} request DeleteTopicRequest message or plain object
                     * @param {google.pubsub.v1.Publisher.DeleteTopicCallback} callback Node-style callback called with the error, if any, and Empty
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Publisher.prototype.deleteTopic = function deleteTopic(request, callback) {
                        return this.rpcCall(deleteTopic, $root.google.pubsub.v1.DeleteTopicRequest, $root.google.protobuf.Empty, request, callback);
                    }, "name", { value: "DeleteTopic" });
    
                    /**
                     * Calls DeleteTopic.
                     * @function deleteTopic
                     * @memberof google.pubsub.v1.Publisher
                     * @instance
                     * @param {google.pubsub.v1.IDeleteTopicRequest} request DeleteTopicRequest message or plain object
                     * @returns {Promise<google.protobuf.Empty>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Publisher|detachSubscription}.
                     * @memberof google.pubsub.v1.Publisher
                     * @typedef DetachSubscriptionCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.DetachSubscriptionResponse} [response] DetachSubscriptionResponse
                     */
    
                    /**
                     * Calls DetachSubscription.
                     * @function detachSubscription
                     * @memberof google.pubsub.v1.Publisher
                     * @instance
                     * @param {google.pubsub.v1.IDetachSubscriptionRequest} request DetachSubscriptionRequest message or plain object
                     * @param {google.pubsub.v1.Publisher.DetachSubscriptionCallback} callback Node-style callback called with the error, if any, and DetachSubscriptionResponse
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Publisher.prototype.detachSubscription = function detachSubscription(request, callback) {
                        return this.rpcCall(detachSubscription, $root.google.pubsub.v1.DetachSubscriptionRequest, $root.google.pubsub.v1.DetachSubscriptionResponse, request, callback);
                    }, "name", { value: "DetachSubscription" });
    
                    /**
                     * Calls DetachSubscription.
                     * @function detachSubscription
                     * @memberof google.pubsub.v1.Publisher
                     * @instance
                     * @param {google.pubsub.v1.IDetachSubscriptionRequest} request DetachSubscriptionRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.DetachSubscriptionResponse>} Promise
                     * @variation 2
                     */
    
                    return Publisher;
                })();
    
                v1.MessageStoragePolicy = (function() {
    
                    /**
                     * Properties of a MessageStoragePolicy.
                     * @memberof google.pubsub.v1
                     * @interface IMessageStoragePolicy
                     * @property {Array.<string>|null} [allowedPersistenceRegions] MessageStoragePolicy allowedPersistenceRegions
                     * @property {boolean|null} [enforceInTransit] MessageStoragePolicy enforceInTransit
                     */
    
                    /**
                     * Constructs a new MessageStoragePolicy.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a MessageStoragePolicy.
                     * @implements IMessageStoragePolicy
                     * @constructor
                     * @param {google.pubsub.v1.IMessageStoragePolicy=} [properties] Properties to set
                     */
                    function MessageStoragePolicy(properties) {
                        this.allowedPersistenceRegions = [];
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * MessageStoragePolicy allowedPersistenceRegions.
                     * @member {Array.<string>} allowedPersistenceRegions
                     * @memberof google.pubsub.v1.MessageStoragePolicy
                     * @instance
                     */
                    MessageStoragePolicy.prototype.allowedPersistenceRegions = $util.emptyArray;
    
                    /**
                     * MessageStoragePolicy enforceInTransit.
                     * @member {boolean} enforceInTransit
                     * @memberof google.pubsub.v1.MessageStoragePolicy
                     * @instance
                     */
                    MessageStoragePolicy.prototype.enforceInTransit = false;
    
                    /**
                     * Creates a new MessageStoragePolicy instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.MessageStoragePolicy
                     * @static
                     * @param {google.pubsub.v1.IMessageStoragePolicy=} [properties] Properties to set
                     * @returns {google.pubsub.v1.MessageStoragePolicy} MessageStoragePolicy instance
                     */
                    MessageStoragePolicy.create = function create(properties) {
                        return new MessageStoragePolicy(properties);
                    };
    
                    /**
                     * Encodes the specified MessageStoragePolicy message. Does not implicitly {@link google.pubsub.v1.MessageStoragePolicy.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.MessageStoragePolicy
                     * @static
                     * @param {google.pubsub.v1.IMessageStoragePolicy} message MessageStoragePolicy message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    MessageStoragePolicy.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.allowedPersistenceRegions != null && message.allowedPersistenceRegions.length)
                            for (var i = 0; i < message.allowedPersistenceRegions.length; ++i)
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.allowedPersistenceRegions[i]);
                        if (message.enforceInTransit != null && Object.hasOwnProperty.call(message, "enforceInTransit"))
                            writer.uint32(/* id 2, wireType 0 =*/16).bool(message.enforceInTransit);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified MessageStoragePolicy message, length delimited. Does not implicitly {@link google.pubsub.v1.MessageStoragePolicy.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.MessageStoragePolicy
                     * @static
                     * @param {google.pubsub.v1.IMessageStoragePolicy} message MessageStoragePolicy message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    MessageStoragePolicy.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a MessageStoragePolicy message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.MessageStoragePolicy
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.MessageStoragePolicy} MessageStoragePolicy
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    MessageStoragePolicy.decode = function decode(reader, length, error) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.MessageStoragePolicy();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            if (tag === error)
                                break;
                            switch (tag >>> 3) {
                            case 1: {
                                    if (!(message.allowedPersistenceRegions && message.allowedPersistenceRegions.length))
                                        message.allowedPersistenceRegions = [];
                                    message.allowedPersistenceRegions.push(reader.string());
                                    break;
                                }
                            case 2: {
                                    message.enforceInTransit = reader.bool();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a MessageStoragePolicy message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.MessageStoragePolicy
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.MessageStoragePolicy} MessageStoragePolicy
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    MessageStoragePolicy.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a MessageStoragePolicy message.
                     * @function verify
                     * @memberof google.pubsub.v1.MessageStoragePolicy
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    MessageStoragePolicy.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.allowedPersistenceRegions != null && message.hasOwnProperty("allowedPersistenceRegions")) {
                            if (!Array.isArray(message.allowedPersistenceRegions))
                                return "allowedPersistenceRegions: array expected";
                            for (var i = 0; i < message.allowedPersistenceRegions.length; ++i)
                                if (!$util.isString(message.allowedPersistenceRegions[i]))
                                    return "allowedPersistenceRegions: string[] expected";
                        }
                        if (message.enforceInTransit != null && message.hasOwnProperty("enforceInTransit"))
                            if (typeof message.enforceInTransit !== "boolean")
                                return "enforceInTransit: boolean expected";
                        return null;
                    };
    
                    /**
                     * Creates a MessageStoragePolicy message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.MessageStoragePolicy
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.MessageStoragePolicy} MessageStoragePolicy
                     */
                    MessageStoragePolicy.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.MessageStoragePolicy)
                            return object;
                        var message = new $root.google.pubsub.v1.MessageStoragePolicy();
                        if (object.allowedPersistenceRegions) {
                            if (!Array.isArray(object.allowedPersistenceRegions))
                                throw TypeError(".google.pubsub.v1.MessageStoragePolicy.allowedPersistenceRegions: array expected");
                            message.allowedPersistenceRegions = [];
                            for (var i = 0; i < object.allowedPersistenceRegions.length; ++i)
                                message.allowedPersistenceRegions[i] = String(object.allowedPersistenceRegions[i]);
                        }
                        if (object.enforceInTransit != null)
                            message.enforceInTransit = Boolean(object.enforceInTransit);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a MessageStoragePolicy message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.MessageStoragePolicy
                     * @static
                     * @param {google.pubsub.v1.MessageStoragePolicy} message MessageStoragePolicy
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    MessageStoragePolicy.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.arrays || options.defaults)
                            object.allowedPersistenceRegions = [];
                        if (options.defaults)
                            object.enforceInTransit = false;
                        if (message.allowedPersistenceRegions && message.allowedPersistenceRegions.length) {
                            object.allowedPersistenceRegions = [];
                            for (var j = 0; j < message.allowedPersistenceRegions.length; ++j)
                                object.allowedPersistenceRegions[j] = message.allowedPersistenceRegions[j];
                        }
                        if (message.enforceInTransit != null && message.hasOwnProperty("enforceInTransit"))
                            object.enforceInTransit = message.enforceInTransit;
                        return object;
                    };
    
                    /**
                     * Converts this MessageStoragePolicy to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.MessageStoragePolicy
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    MessageStoragePolicy.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for MessageStoragePolicy
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.MessageStoragePolicy
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    MessageStoragePolicy.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.MessageStoragePolicy";
                    };
    
                    return MessageStoragePolicy;
                })();
    
                v1.SchemaSettings = (function() {
    
                    /**
                     * Properties of a SchemaSettings.
                     * @memberof google.pubsub.v1
                     * @interface ISchemaSettings
                     * @property {string|null} [schema] SchemaSettings schema
                     * @property {google.pubsub.v1.Encoding|null} [encoding] SchemaSettings encoding
                     * @property {string|null} [firstRevisionId] SchemaSettings firstRevisionId
                     * @property {string|null} [lastRevisionId] SchemaSettings lastRevisionId
                     */
    
                    /**
                     * Constructs a new SchemaSettings.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a SchemaSettings.
                     * @implements ISchemaSettings
                     * @constructor
                     * @param {google.pubsub.v1.ISchemaSettings=} [properties] Properties to set
                     */
                    function SchemaSettings(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * SchemaSettings schema.
                     * @member {string} schema
                     * @memberof google.pubsub.v1.SchemaSettings
                     * @instance
                     */
                    SchemaSettings.prototype.schema = "";
    
                    /**
                     * SchemaSettings encoding.
                     * @member {google.pubsub.v1.Encoding} encoding
                     * @memberof google.pubsub.v1.SchemaSettings
                     * @instance
                     */
                    SchemaSettings.prototype.encoding = 0;
    
                    /**
                     * SchemaSettings firstRevisionId.
                     * @member {string} firstRevisionId
                     * @memberof google.pubsub.v1.SchemaSettings
                     * @instance
                     */
                    SchemaSettings.prototype.firstRevisionId = "";
    
                    /**
                     * SchemaSettings lastRevisionId.
                     * @member {string} lastRevisionId
                     * @memberof google.pubsub.v1.SchemaSettings
                     * @instance
                     */
                    SchemaSettings.prototype.lastRevisionId = "";
    
                    /**
                     * Creates a new SchemaSettings instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.SchemaSettings
                     * @static
                     * @param {google.pubsub.v1.ISchemaSettings=} [properties] Properties to set
                     * @returns {google.pubsub.v1.SchemaSettings} SchemaSettings instance
                     */
                    SchemaSettings.create = function create(properties) {
                        return new SchemaSettings(properties);
                    };
    
                    /**
                     * Encodes the specified SchemaSettings message. Does not implicitly {@link google.pubsub.v1.SchemaSettings.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.SchemaSettings
                     * @static
                     * @param {google.pubsub.v1.ISchemaSettings} message SchemaSettings message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    SchemaSettings.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.schema != null && Object.hasOwnProperty.call(message, "schema"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.schema);
                        if (message.encoding != null && Object.hasOwnProperty.call(message, "encoding"))
                            writer.uint32(/* id 2, wireType 0 =*/16).int32(message.encoding);
                        if (message.firstRevisionId != null && Object.hasOwnProperty.call(message, "firstRevisionId"))
                            writer.uint32(/* id 3, wireType 2 =*/26).string(message.firstRevisionId);
                        if (message.lastRevisionId != null && Object.hasOwnProperty.call(message, "lastRevisionId"))
                            writer.uint32(/* id 4, wireType 2 =*/34).string(message.lastRevisionId);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified SchemaSettings message, length delimited. Does not implicitly {@link google.pubsub.v1.SchemaSettings.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.SchemaSettings
                     * @static
                     * @param {google.pubsub.v1.ISchemaSettings} message SchemaSettings message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    SchemaSettings.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a SchemaSettings message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.SchemaSettings
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.SchemaSettings} SchemaSettings
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    SchemaSettings.decode = function decode(reader, length, error) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.SchemaSettings();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            if (tag === error)
                                break;
                            switch (tag >>> 3) {
                            case 1: {
                                    message.schema = reader.string();
                                    break;
                                }
                            case 2: {
                                    message.encoding = reader.int32();
                                    break;
                                }
                            case 3: {
                                    message.firstRevisionId = reader.string();
                                    break;
                                }
                            case 4: {
                                    message.lastRevisionId = reader.string();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a SchemaSettings message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.SchemaSettings
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.SchemaSettings} SchemaSettings
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    SchemaSettings.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a SchemaSettings message.
                     * @function verify
                     * @memberof google.pubsub.v1.SchemaSettings
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    SchemaSettings.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.schema != null && message.hasOwnProperty("schema"))
                            if (!$util.isString(message.schema))
                                return "schema: string expected";
                        if (message.encoding != null && message.hasOwnProperty("encoding"))
                            switch (message.encoding) {
                            default:
                                return "encoding: enum value expected";
                            case 0:
                            case 1:
                            case 2:
                                break;
                            }
                        if (message.firstRevisionId != null && message.hasOwnProperty("firstRevisionId"))
                            if (!$util.isString(message.firstRevisionId))
                                return "firstRevisionId: string expected";
                        if (message.lastRevisionId != null && message.hasOwnProperty("lastRevisionId"))
                            if (!$util.isString(message.lastRevisionId))
                                return "lastRevisionId: string expected";
                        return null;
                    };
    
                    /**
                     * Creates a SchemaSettings message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.SchemaSettings
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.SchemaSettings} SchemaSettings
                     */
                    SchemaSettings.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.SchemaSettings)
                            return object;
                        var message = new $root.google.pubsub.v1.SchemaSettings();
                        if (object.schema != null)
                            message.schema = String(object.schema);
                        switch (object.encoding) {
                        default:
                            if (typeof object.encoding === "number") {
                                message.encoding = object.encoding;
                                break;
                            }
                            break;
                        case "ENCODING_UNSPECIFIED":
                        case 0:
                            message.encoding = 0;
                            break;
                        case "JSON":
                        case 1:
                            message.encoding = 1;
                            break;
                        case "BINARY":
                        case 2:
                            message.encoding = 2;
                            break;
                        }
                        if (object.firstRevisionId != null)
                            message.firstRevisionId = String(object.firstRevisionId);
                        if (object.lastRevisionId != null)
                            message.lastRevisionId = String(object.lastRevisionId);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a SchemaSettings message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.SchemaSettings
                     * @static
                     * @param {google.pubsub.v1.SchemaSettings} message SchemaSettings
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    SchemaSettings.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.schema = "";
                            object.encoding = options.enums === String ? "ENCODING_UNSPECIFIED" : 0;
                            object.firstRevisionId = "";
                            object.lastRevisionId = "";
                        }
                        if (message.schema != null && message.hasOwnProperty("schema"))
                            object.schema = message.schema;
                        if (message.encoding != null && message.hasOwnProperty("encoding"))
                            object.encoding = options.enums === String ? $root.google.pubsub.v1.Encoding[message.encoding] === undefined ? message.encoding : $root.google.pubsub.v1.Encoding[message.encoding] : message.encoding;
                        if (message.firstRevisionId != null && message.hasOwnProperty("firstRevisionId"))
                            object.firstRevisionId = message.firstRevisionId;
                        if (message.lastRevisionId != null && message.hasOwnProperty("lastRevisionId"))
                            object.lastRevisionId = message.lastRevisionId;
                        return object;
                    };
    
                    /**
                     * Converts this SchemaSettings to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.SchemaSettings
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    SchemaSettings.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for SchemaSettings
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.SchemaSettings
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    SchemaSettings.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.SchemaSettings";
                    };
    
                    return SchemaSettings;
                })();
    
                v1.IngestionDataSourceSettings = (function() {
    
                    /**
                     * Properties of an IngestionDataSourceSettings.
                     * @memberof google.pubsub.v1
                     * @interface IIngestionDataSourceSettings
                     * @property {google.pubsub.v1.IngestionDataSourceSettings.IAwsKinesis|null} [awsKinesis] IngestionDataSourceSettings awsKinesis
                     * @property {google.pubsub.v1.IngestionDataSourceSettings.ICloudStorage|null} [cloudStorage] IngestionDataSourceSettings cloudStorage
                     * @property {google.pubsub.v1.IngestionDataSourceSettings.IAzureEventHubs|null} [azureEventHubs] IngestionDataSourceSettings azureEventHubs
                     * @property {google.pubsub.v1.IngestionDataSourceSettings.IAwsMsk|null} [awsMsk] IngestionDataSourceSettings awsMsk
                     * @property {google.pubsub.v1.IngestionDataSourceSettings.IConfluentCloud|null} [confluentCloud] IngestionDataSourceSettings confluentCloud
                     * @property {google.pubsub.v1.IPlatformLogsSettings|null} [platformLogsSettings] IngestionDataSourceSettings platformLogsSettings
                     */
    
                    /**
                     * Constructs a new IngestionDataSourceSettings.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents an IngestionDataSourceSettings.
                     * @implements IIngestionDataSourceSettings
                     * @constructor
                     * @param {google.pubsub.v1.IIngestionDataSourceSettings=} [properties] Properties to set
                     */
                    function IngestionDataSourceSettings(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * IngestionDataSourceSettings awsKinesis.
                     * @member {google.pubsub.v1.IngestionDataSourceSettings.IAwsKinesis|null|undefined} awsKinesis
                     * @memberof google.pubsub.v1.IngestionDataSourceSettings
                     * @instance
                     */
                    IngestionDataSourceSettings.prototype.awsKinesis = null;
    
                    /**
                     * IngestionDataSourceSettings cloudStorage.
                     * @member {google.pubsub.v1.IngestionDataSourceSettings.ICloudStorage|null|undefined} cloudStorage
                     * @memberof google.pubsub.v1.IngestionDataSourceSettings
                     * @instance
                     */
                    IngestionDataSourceSettings.prototype.cloudStorage = null;
    
                    /**
                     * IngestionDataSourceSettings azureEventHubs.
                     * @member {google.pubsub.v1.IngestionDataSourceSettings.IAzureEventHubs|null|undefined} azureEventHubs
                     * @memberof google.pubsub.v1.IngestionDataSourceSettings
                     * @instance
                     */
                    IngestionDataSourceSettings.prototype.azureEventHubs = null;
    
                    /**
                     * IngestionDataSourceSettings awsMsk.
                     * @member {google.pubsub.v1.IngestionDataSourceSettings.IAwsMsk|null|undefined} awsMsk
                     * @memberof google.pubsub.v1.IngestionDataSourceSettings
                     * @instance
                     */
                    IngestionDataSourceSettings.prototype.awsMsk = null;
    
                    /**
                     * IngestionDataSourceSettings confluentCloud.
                     * @member {google.pubsub.v1.IngestionDataSourceSettings.IConfluentCloud|null|undefined} confluentCloud
                     * @memberof google.pubsub.v1.IngestionDataSourceSettings
                     * @instance
                     */
                    IngestionDataSourceSettings.prototype.confluentCloud = null;
    
                    /**
                     * IngestionDataSourceSettings platformLogsSettings.
                     * @member {google.pubsub.v1.IPlatformLogsSettings|null|undefined} platformLogsSettings
                     * @memberof google.pubsub.v1.IngestionDataSourceSettings
                     * @instance
                     */
                    IngestionDataSourceSettings.prototype.platformLogsSettings = null;
    
                    // OneOf field names bound to virtual getters and setters
                    var $oneOfFields;
    
                    /**
                     * IngestionDataSourceSettings source.
                     * @member {"awsKinesis"|"cloudStorage"|"azureEventHubs"|"awsMsk"|"confluentCloud"|undefined} source
                     * @memberof google.pubsub.v1.IngestionDataSourceSettings
                     * @instance
                     */
                    Object.defineProperty(IngestionDataSourceSettings.prototype, "source", {
                        get: $util.oneOfGetter($oneOfFields = ["awsKinesis", "cloudStorage", "azureEventHubs", "awsMsk", "confluentCloud"]),
                        set: $util.oneOfSetter($oneOfFields)
                    });
    
                    /**
                     * Creates a new IngestionDataSourceSettings instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.IngestionDataSourceSettings
                     * @static
                     * @param {google.pubsub.v1.IIngestionDataSourceSettings=} [properties] Properties to set
                     * @returns {google.pubsub.v1.IngestionDataSourceSettings} IngestionDataSourceSettings instance
                     */
                    IngestionDataSourceSettings.create = function create(properties) {
                        return new IngestionDataSourceSettings(properties);
                    };
    
                    /**
                     * Encodes the specified IngestionDataSourceSettings message. Does not implicitly {@link google.pubsub.v1.IngestionDataSourceSettings.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.IngestionDataSourceSettings
                     * @static
                     * @param {google.pubsub.v1.IIngestionDataSourceSettings} message IngestionDataSourceSettings message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    IngestionDataSourceSettings.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.awsKinesis != null && Object.hasOwnProperty.call(message, "awsKinesis"))
                            $root.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.encode(message.awsKinesis, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                        if (message.cloudStorage != null && Object.hasOwnProperty.call(message, "cloudStorage"))
                            $root.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.encode(message.cloudStorage, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                        if (message.azureEventHubs != null && Object.hasOwnProperty.call(message, "azureEventHubs"))
                            $root.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.encode(message.azureEventHubs, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                        if (message.platformLogsSettings != null && Object.hasOwnProperty.call(message, "platformLogsSettings"))
                            $root.google.pubsub.v1.PlatformLogsSettings.encode(message.platformLogsSettings, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                        if (message.awsMsk != null && Object.hasOwnProperty.call(message, "awsMsk"))
                            $root.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.encode(message.awsMsk, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                        if (message.confluentCloud != null && Object.hasOwnProperty.call(message, "confluentCloud"))
                            $root.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.encode(message.confluentCloud, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified IngestionDataSourceSettings message, length delimited. Does not implicitly {@link google.pubsub.v1.IngestionDataSourceSettings.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.IngestionDataSourceSettings
                     * @static
                     * @param {google.pubsub.v1.IIngestionDataSourceSettings} message IngestionDataSourceSettings message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    IngestionDataSourceSettings.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes an IngestionDataSourceSettings message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.IngestionDataSourceSettings
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.IngestionDataSourceSettings} IngestionDataSourceSettings
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    IngestionDataSourceSettings.decode = function decode(reader, length, error) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.IngestionDataSourceSettings();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            if (tag === error)
                                break;
                            switch (tag >>> 3) {
                            case 1: {
                                    message.awsKinesis = $root.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.decode(reader, reader.uint32());
                                    break;
                                }
                            case 2: {
                                    message.cloudStorage = $root.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.decode(reader, reader.uint32());
                                    break;
                                }
                            case 3: {
                                    message.azureEventHubs = $root.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.decode(reader, reader.uint32());
                                    break;
                                }
                            case 5: {
                                    message.awsMsk = $root.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.decode(reader, reader.uint32());
                                    break;
                                }
                            case 6: {
                                    message.confluentCloud = $root.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.decode(reader, reader.uint32());
                                    break;
                                }
                            case 4: {
                                    message.platformLogsSettings = $root.google.pubsub.v1.PlatformLogsSettings.decode(reader, reader.uint32());
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes an IngestionDataSourceSettings message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.IngestionDataSourceSettings
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.IngestionDataSourceSettings} IngestionDataSourceSettings
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    IngestionDataSourceSettings.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies an IngestionDataSourceSettings message.
                     * @function verify
                     * @memberof google.pubsub.v1.IngestionDataSourceSettings
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    IngestionDataSourceSettings.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        var properties = {};
                        if (message.awsKinesis != null && message.hasOwnProperty("awsKinesis")) {
                            properties.source = 1;
                            {
                                var error = $root.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.verify(message.awsKinesis);
                                if (error)
                                    return "awsKinesis." + error;
                            }
                        }
                        if (message.cloudStorage != null && message.hasOwnProperty("cloudStorage")) {
                            if (properties.source === 1)
                                return "source: multiple values";
                            properties.source = 1;
                            {
                                var error = $root.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.verify(message.cloudStorage);
                                if (error)
                                    return "cloudStorage." + error;
                            }
                        }
                        if (message.azureEventHubs != null && message.hasOwnProperty("azureEventHubs")) {
                            if (properties.source === 1)
                                return "source: multiple values";
                            properties.source = 1;
                            {
                                var error = $root.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.verify(message.azureEventHubs);
                                if (error)
                                    return "azureEventHubs." + error;
                            }
                        }
                        if (message.awsMsk != null && message.hasOwnProperty("awsMsk")) {
                            if (properties.source === 1)
                                return "source: multiple values";
                            properties.source = 1;
                            {
                                var error = $root.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.verify(message.awsMsk);
                                if (error)
                                    return "awsMsk." + error;
                            }
                        }
                        if (message.confluentCloud != null && message.hasOwnProperty("confluentCloud")) {
                            if (properties.source === 1)
                                return "source: multiple values";
                            properties.source = 1;
                            {
                                var error = $root.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.verify(message.confluentCloud);
                                if (error)
                                    return "confluentCloud." + error;
                            }
                        }
                        if (message.platformLogsSettings != null && message.hasOwnProperty("platformLogsSettings")) {
                            var error = $root.google.pubsub.v1.PlatformLogsSettings.verify(message.platformLogsSettings);
                            if (error)
                                return "platformLogsSettings." + error;
                        }
                        return null;
                    };
    
                    /**
                     * Creates an IngestionDataSourceSettings message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.IngestionDataSourceSettings
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.IngestionDataSourceSettings} IngestionDataSourceSettings
                     */
                    IngestionDataSourceSettings.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.IngestionDataSourceSettings)
                            return object;
                        var message = new $root.google.pubsub.v1.IngestionDataSourceSettings();
                        if (object.awsKinesis != null) {
                            if (typeof object.awsKinesis !== "object")
                                throw TypeError(".google.pubsub.v1.IngestionDataSourceSettings.awsKinesis: object expected");
                            message.awsKinesis = $root.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.fromObject(object.awsKinesis);
                        }
                        if (object.cloudStorage != null) {
                            if (typeof object.cloudStorage !== "object")
                                throw TypeError(".google.pubsub.v1.IngestionDataSourceSettings.cloudStorage: object expected");
                            message.cloudStorage = $root.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.fromObject(object.cloudStorage);
                        }
                        if (object.azureEventHubs != null) {
                            if (typeof object.azureEventHubs !== "object")
                                throw TypeError(".google.pubsub.v1.IngestionDataSourceSettings.azureEventHubs: object expected");
                            message.azureEventHubs = $root.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.fromObject(object.azureEventHubs);
                        }
                        if (object.awsMsk != null) {
                            if (typeof object.awsMsk !== "object")
                                throw TypeError(".google.pubsub.v1.IngestionDataSourceSettings.awsMsk: object expected");
                            message.awsMsk = $root.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.fromObject(object.awsMsk);
                        }
                        if (object.confluentCloud != null) {
                            if (typeof object.confluentCloud !== "object")
                                throw TypeError(".google.pubsub.v1.IngestionDataSourceSettings.confluentCloud: object expected");
                            message.confluentCloud = $root.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.fromObject(object.confluentCloud);
                        }
                        if (object.platformLogsSettings != null) {
                            if (typeof object.platformLogsSettings !== "object")
                                throw TypeError(".google.pubsub.v1.IngestionDataSourceSettings.platformLogsSettings: object expected");
                            message.platformLogsSettings = $root.google.pubsub.v1.PlatformLogsSettings.fromObject(object.platformLogsSettings);
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from an IngestionDataSourceSettings message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.IngestionDataSourceSettings
                     * @static
                     * @param {google.pubsub.v1.IngestionDataSourceSettings} message IngestionDataSourceSettings
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    IngestionDataSourceSettings.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults)
                            object.platformLogsSettings = null;
                        if (message.awsKinesis != null && message.hasOwnProperty("awsKinesis")) {
                            object.awsKinesis = $root.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.toObject(message.awsKinesis, options);
                            if (options.oneofs)
                                object.source = "awsKinesis";
                        }
                        if (message.cloudStorage != null && message.hasOwnProperty("cloudStorage")) {
                            object.cloudStorage = $root.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.toObject(message.cloudStorage, options);
                            if (options.oneofs)
                                object.source = "cloudStorage";
                        }
                        if (message.azureEventHubs != null && message.hasOwnProperty("azureEventHubs")) {
                            object.azureEventHubs = $root.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.toObject(message.azureEventHubs, options);
                            if (options.oneofs)
                                object.source = "azureEventHubs";
                        }
                        if (message.platformLogsSettings != null && message.hasOwnProperty("platformLogsSettings"))
                            object.platformLogsSettings = $root.google.pubsub.v1.PlatformLogsSettings.toObject(message.platformLogsSettings, options);
                        if (message.awsMsk != null && message.hasOwnProperty("awsMsk")) {
                            object.awsMsk = $root.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.toObject(message.awsMsk, options);
                            if (options.oneofs)
                                object.source = "awsMsk";
                        }
                        if (message.confluentCloud != null && message.hasOwnProperty("confluentCloud")) {
                            object.confluentCloud = $root.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.toObject(message.confluentCloud, options);
                            if (options.oneofs)
                                object.source = "confluentCloud";
                        }
                        return object;
                    };
    
                    /**
                     * Converts this IngestionDataSourceSettings to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.IngestionDataSourceSettings
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    IngestionDataSourceSettings.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for IngestionDataSourceSettings
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.IngestionDataSourceSettings
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    IngestionDataSourceSettings.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.IngestionDataSourceSettings";
                    };
    
                    IngestionDataSourceSettings.AwsKinesis = (function() {
    
                        /**
                         * Properties of an AwsKinesis.
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings
                         * @interface IAwsKinesis
                         * @property {google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State|null} [state] AwsKinesis state
                         * @property {string|null} [streamArn] AwsKinesis streamArn
                         * @property {string|null} [consumerArn] AwsKinesis consumerArn
                         * @property {string|null} [awsRoleArn] AwsKinesis awsRoleArn
                         * @property {string|null} [gcpServiceAccount] AwsKinesis gcpServiceAccount
                         */
    
                        /**
                         * Constructs a new AwsKinesis.
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings
                         * @classdesc Represents an AwsKinesis.
                         * @implements IAwsKinesis
                         * @constructor
                         * @param {google.pubsub.v1.IngestionDataSourceSettings.IAwsKinesis=} [properties] Properties to set
                         */
                        function AwsKinesis(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * AwsKinesis state.
                         * @member {google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State} state
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis
                         * @instance
                         */
                        AwsKinesis.prototype.state = 0;
    
                        /**
                         * AwsKinesis streamArn.
                         * @member {string} streamArn
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis
                         * @instance
                         */
                        AwsKinesis.prototype.streamArn = "";
    
                        /**
                         * AwsKinesis consumerArn.
                         * @member {string} consumerArn
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis
                         * @instance
                         */
                        AwsKinesis.prototype.consumerArn = "";
    
                        /**
                         * AwsKinesis awsRoleArn.
                         * @member {string} awsRoleArn
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis
                         * @instance
                         */
                        AwsKinesis.prototype.awsRoleArn = "";
    
                        /**
                         * AwsKinesis gcpServiceAccount.
                         * @member {string} gcpServiceAccount
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis
                         * @instance
                         */
                        AwsKinesis.prototype.gcpServiceAccount = "";
    
                        /**
                         * Creates a new AwsKinesis instance using the specified properties.
                         * @function create
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis
                         * @static
                         * @param {google.pubsub.v1.IngestionDataSourceSettings.IAwsKinesis=} [properties] Properties to set
                         * @returns {google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis} AwsKinesis instance
                         */
                        AwsKinesis.create = function create(properties) {
                            return new AwsKinesis(properties);
                        };
    
                        /**
                         * Encodes the specified AwsKinesis message. Does not implicitly {@link google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.verify|verify} messages.
                         * @function encode
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis
                         * @static
                         * @param {google.pubsub.v1.IngestionDataSourceSettings.IAwsKinesis} message AwsKinesis message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AwsKinesis.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.state != null && Object.hasOwnProperty.call(message, "state"))
                                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.state);
                            if (message.streamArn != null && Object.hasOwnProperty.call(message, "streamArn"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.streamArn);
                            if (message.consumerArn != null && Object.hasOwnProperty.call(message, "consumerArn"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.consumerArn);
                            if (message.awsRoleArn != null && Object.hasOwnProperty.call(message, "awsRoleArn"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.awsRoleArn);
                            if (message.gcpServiceAccount != null && Object.hasOwnProperty.call(message, "gcpServiceAccount"))
                                writer.uint32(/* id 5, wireType 2 =*/42).string(message.gcpServiceAccount);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified AwsKinesis message, length delimited. Does not implicitly {@link google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis
                         * @static
                         * @param {google.pubsub.v1.IngestionDataSourceSettings.IAwsKinesis} message AwsKinesis message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AwsKinesis.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an AwsKinesis message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis} AwsKinesis
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AwsKinesis.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.state = reader.int32();
                                        break;
                                    }
                                case 2: {
                                        message.streamArn = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.consumerArn = reader.string();
                                        break;
                                    }
                                case 4: {
                                        message.awsRoleArn = reader.string();
                                        break;
                                    }
                                case 5: {
                                        message.gcpServiceAccount = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an AwsKinesis message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis} AwsKinesis
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AwsKinesis.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an AwsKinesis message.
                         * @function verify
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AwsKinesis.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.state != null && message.hasOwnProperty("state"))
                                switch (message.state) {
                                default:
                                    return "state: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                case 4:
                                case 5:
                                    break;
                                }
                            if (message.streamArn != null && message.hasOwnProperty("streamArn"))
                                if (!$util.isString(message.streamArn))
                                    return "streamArn: string expected";
                            if (message.consumerArn != null && message.hasOwnProperty("consumerArn"))
                                if (!$util.isString(message.consumerArn))
                                    return "consumerArn: string expected";
                            if (message.awsRoleArn != null && message.hasOwnProperty("awsRoleArn"))
                                if (!$util.isString(message.awsRoleArn))
                                    return "awsRoleArn: string expected";
                            if (message.gcpServiceAccount != null && message.hasOwnProperty("gcpServiceAccount"))
                                if (!$util.isString(message.gcpServiceAccount))
                                    return "gcpServiceAccount: string expected";
                            return null;
                        };
    
                        /**
                         * Creates an AwsKinesis message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis} AwsKinesis
                         */
                        AwsKinesis.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis)
                                return object;
                            var message = new $root.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis();
                            switch (object.state) {
                            default:
                                if (typeof object.state === "number") {
                                    message.state = object.state;
                                    break;
                                }
                                break;
                            case "STATE_UNSPECIFIED":
                            case 0:
                                message.state = 0;
                                break;
                            case "ACTIVE":
                            case 1:
                                message.state = 1;
                                break;
                            case "KINESIS_PERMISSION_DENIED":
                            case 2:
                                message.state = 2;
                                break;
                            case "PUBLISH_PERMISSION_DENIED":
                            case 3:
                                message.state = 3;
                                break;
                            case "STREAM_NOT_FOUND":
                            case 4:
                                message.state = 4;
                                break;
                            case "CONSUMER_NOT_FOUND":
                            case 5:
                                message.state = 5;
                                break;
                            }
                            if (object.streamArn != null)
                                message.streamArn = String(object.streamArn);
                            if (object.consumerArn != null)
                                message.consumerArn = String(object.consumerArn);
                            if (object.awsRoleArn != null)
                                message.awsRoleArn = String(object.awsRoleArn);
                            if (object.gcpServiceAccount != null)
                                message.gcpServiceAccount = String(object.gcpServiceAccount);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an AwsKinesis message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis
                         * @static
                         * @param {google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis} message AwsKinesis
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AwsKinesis.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.state = options.enums === String ? "STATE_UNSPECIFIED" : 0;
                                object.streamArn = "";
                                object.consumerArn = "";
                                object.awsRoleArn = "";
                                object.gcpServiceAccount = "";
                            }
                            if (message.state != null && message.hasOwnProperty("state"))
                                object.state = options.enums === String ? $root.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State[message.state] === undefined ? message.state : $root.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State[message.state] : message.state;
                            if (message.streamArn != null && message.hasOwnProperty("streamArn"))
                                object.streamArn = message.streamArn;
                            if (message.consumerArn != null && message.hasOwnProperty("consumerArn"))
                                object.consumerArn = message.consumerArn;
                            if (message.awsRoleArn != null && message.hasOwnProperty("awsRoleArn"))
                                object.awsRoleArn = message.awsRoleArn;
                            if (message.gcpServiceAccount != null && message.hasOwnProperty("gcpServiceAccount"))
                                object.gcpServiceAccount = message.gcpServiceAccount;
                            return object;
                        };
    
                        /**
                         * Converts this AwsKinesis to JSON.
                         * @function toJSON
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AwsKinesis.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for AwsKinesis
                         * @function getTypeUrl
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        AwsKinesis.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis";
                        };
    
                        /**
                         * State enum.
                         * @name google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State
                         * @enum {number}
                         * @property {number} STATE_UNSPECIFIED=0 STATE_UNSPECIFIED value
                         * @property {number} ACTIVE=1 ACTIVE value
                         * @property {number} KINESIS_PERMISSION_DENIED=2 KINESIS_PERMISSION_DENIED value
                         * @property {number} PUBLISH_PERMISSION_DENIED=3 PUBLISH_PERMISSION_DENIED value
                         * @property {number} STREAM_NOT_FOUND=4 STREAM_NOT_FOUND value
                         * @property {number} CONSUMER_NOT_FOUND=5 CONSUMER_NOT_FOUND value
                         */
                        AwsKinesis.State = (function() {
                            var valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[0] = "STATE_UNSPECIFIED"] = 0;
                            values[valuesById[1] = "ACTIVE"] = 1;
                            values[valuesById[2] = "KINESIS_PERMISSION_DENIED"] = 2;
                            values[valuesById[3] = "PUBLISH_PERMISSION_DENIED"] = 3;
                            values[valuesById[4] = "STREAM_NOT_FOUND"] = 4;
                            values[valuesById[5] = "CONSUMER_NOT_FOUND"] = 5;
                            return values;
                        })();
    
                        return AwsKinesis;
                    })();
    
                    IngestionDataSourceSettings.CloudStorage = (function() {
    
                        /**
                         * Properties of a CloudStorage.
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings
                         * @interface ICloudStorage
                         * @property {google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State|null} [state] CloudStorage state
                         * @property {string|null} [bucket] CloudStorage bucket
                         * @property {google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.ITextFormat|null} [textFormat] CloudStorage textFormat
                         * @property {google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.IAvroFormat|null} [avroFormat] CloudStorage avroFormat
                         * @property {google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.IPubSubAvroFormat|null} [pubsubAvroFormat] CloudStorage pubsubAvroFormat
                         * @property {google.protobuf.ITimestamp|null} [minimumObjectCreateTime] CloudStorage minimumObjectCreateTime
                         * @property {string|null} [matchGlob] CloudStorage matchGlob
                         */
    
                        /**
                         * Constructs a new CloudStorage.
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings
                         * @classdesc Represents a CloudStorage.
                         * @implements ICloudStorage
                         * @constructor
                         * @param {google.pubsub.v1.IngestionDataSourceSettings.ICloudStorage=} [properties] Properties to set
                         */
                        function CloudStorage(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * CloudStorage state.
                         * @member {google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State} state
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
                         * @instance
                         */
                        CloudStorage.prototype.state = 0;
    
                        /**
                         * CloudStorage bucket.
                         * @member {string} bucket
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
                         * @instance
                         */
                        CloudStorage.prototype.bucket = "";
    
                        /**
                         * CloudStorage textFormat.
                         * @member {google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.ITextFormat|null|undefined} textFormat
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
                         * @instance
                         */
                        CloudStorage.prototype.textFormat = null;
    
                        /**
                         * CloudStorage avroFormat.
                         * @member {google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.IAvroFormat|null|undefined} avroFormat
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
                         * @instance
                         */
                        CloudStorage.prototype.avroFormat = null;
    
                        /**
                         * CloudStorage pubsubAvroFormat.
                         * @member {google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.IPubSubAvroFormat|null|undefined} pubsubAvroFormat
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
                         * @instance
                         */
                        CloudStorage.prototype.pubsubAvroFormat = null;
    
                        /**
                         * CloudStorage minimumObjectCreateTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} minimumObjectCreateTime
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
                         * @instance
                         */
                        CloudStorage.prototype.minimumObjectCreateTime = null;
    
                        /**
                         * CloudStorage matchGlob.
                         * @member {string} matchGlob
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
                         * @instance
                         */
                        CloudStorage.prototype.matchGlob = "";
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * CloudStorage inputFormat.
                         * @member {"textFormat"|"avroFormat"|"pubsubAvroFormat"|undefined} inputFormat
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
                         * @instance
                         */
                        Object.defineProperty(CloudStorage.prototype, "inputFormat", {
                            get: $util.oneOfGetter($oneOfFields = ["textFormat", "avroFormat", "pubsubAvroFormat"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new CloudStorage instance using the specified properties.
                         * @function create
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
                         * @static
                         * @param {google.pubsub.v1.IngestionDataSourceSettings.ICloudStorage=} [properties] Properties to set
                         * @returns {google.pubsub.v1.IngestionDataSourceSettings.CloudStorage} CloudStorage instance
                         */
                        CloudStorage.create = function create(properties) {
                            return new CloudStorage(properties);
                        };
    
                        /**
                         * Encodes the specified CloudStorage message. Does not implicitly {@link google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.verify|verify} messages.
                         * @function encode
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
                         * @static
                         * @param {google.pubsub.v1.IngestionDataSourceSettings.ICloudStorage} message CloudStorage message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CloudStorage.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.state != null && Object.hasOwnProperty.call(message, "state"))
                                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.state);
                            if (message.bucket != null && Object.hasOwnProperty.call(message, "bucket"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.bucket);
                            if (message.textFormat != null && Object.hasOwnProperty.call(message, "textFormat"))
                                $root.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat.encode(message.textFormat, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            if (message.avroFormat != null && Object.hasOwnProperty.call(message, "avroFormat"))
                                $root.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat.encode(message.avroFormat, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                            if (message.pubsubAvroFormat != null && Object.hasOwnProperty.call(message, "pubsubAvroFormat"))
                                $root.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat.encode(message.pubsubAvroFormat, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                            if (message.minimumObjectCreateTime != null && Object.hasOwnProperty.call(message, "minimumObjectCreateTime"))
                                $root.google.protobuf.Timestamp.encode(message.minimumObjectCreateTime, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                            if (message.matchGlob != null && Object.hasOwnProperty.call(message, "matchGlob"))
                                writer.uint32(/* id 9, wireType 2 =*/74).string(message.matchGlob);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified CloudStorage message, length delimited. Does not implicitly {@link google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
                         * @static
                         * @param {google.pubsub.v1.IngestionDataSourceSettings.ICloudStorage} message CloudStorage message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CloudStorage.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a CloudStorage message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.pubsub.v1.IngestionDataSourceSettings.CloudStorage} CloudStorage
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CloudStorage.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.state = reader.int32();
                                        break;
                                    }
                                case 2: {
                                        message.bucket = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.textFormat = $root.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 4: {
                                        message.avroFormat = $root.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 5: {
                                        message.pubsubAvroFormat = $root.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 6: {
                                        message.minimumObjectCreateTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 9: {
                                        message.matchGlob = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a CloudStorage message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.pubsub.v1.IngestionDataSourceSettings.CloudStorage} CloudStorage
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CloudStorage.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a CloudStorage message.
                         * @function verify
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CloudStorage.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.state != null && message.hasOwnProperty("state"))
                                switch (message.state) {
                                default:
                                    return "state: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                case 4:
                                case 5:
                                    break;
                                }
                            if (message.bucket != null && message.hasOwnProperty("bucket"))
                                if (!$util.isString(message.bucket))
                                    return "bucket: string expected";
                            if (message.textFormat != null && message.hasOwnProperty("textFormat")) {
                                properties.inputFormat = 1;
                                {
                                    var error = $root.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat.verify(message.textFormat);
                                    if (error)
                                        return "textFormat." + error;
                                }
                            }
                            if (message.avroFormat != null && message.hasOwnProperty("avroFormat")) {
                                if (properties.inputFormat === 1)
                                    return "inputFormat: multiple values";
                                properties.inputFormat = 1;
                                {
                                    var error = $root.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat.verify(message.avroFormat);
                                    if (error)
                                        return "avroFormat." + error;
                                }
                            }
                            if (message.pubsubAvroFormat != null && message.hasOwnProperty("pubsubAvroFormat")) {
                                if (properties.inputFormat === 1)
                                    return "inputFormat: multiple values";
                                properties.inputFormat = 1;
                                {
                                    var error = $root.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat.verify(message.pubsubAvroFormat);
                                    if (error)
                                        return "pubsubAvroFormat." + error;
                                }
                            }
                            if (message.minimumObjectCreateTime != null && message.hasOwnProperty("minimumObjectCreateTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.minimumObjectCreateTime);
                                if (error)
                                    return "minimumObjectCreateTime." + error;
                            }
                            if (message.matchGlob != null && message.hasOwnProperty("matchGlob"))
                                if (!$util.isString(message.matchGlob))
                                    return "matchGlob: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a CloudStorage message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.pubsub.v1.IngestionDataSourceSettings.CloudStorage} CloudStorage
                         */
                        CloudStorage.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage)
                                return object;
                            var message = new $root.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage();
                            switch (object.state) {
                            default:
                                if (typeof object.state === "number") {
                                    message.state = object.state;
                                    break;
                                }
                                break;
                            case "STATE_UNSPECIFIED":
                            case 0:
                                message.state = 0;
                                break;
                            case "ACTIVE":
                            case 1:
                                message.state = 1;
                                break;
                            case "CLOUD_STORAGE_PERMISSION_DENIED":
                            case 2:
                                message.state = 2;
                                break;
                            case "PUBLISH_PERMISSION_DENIED":
                            case 3:
                                message.state = 3;
                                break;
                            case "BUCKET_NOT_FOUND":
                            case 4:
                                message.state = 4;
                                break;
                            case "TOO_MANY_OBJECTS":
                            case 5:
                                message.state = 5;
                                break;
                            }
                            if (object.bucket != null)
                                message.bucket = String(object.bucket);
                            if (object.textFormat != null) {
                                if (typeof object.textFormat !== "object")
                                    throw TypeError(".google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.textFormat: object expected");
                                message.textFormat = $root.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat.fromObject(object.textFormat);
                            }
                            if (object.avroFormat != null) {
                                if (typeof object.avroFormat !== "object")
                                    throw TypeError(".google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.avroFormat: object expected");
                                message.avroFormat = $root.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat.fromObject(object.avroFormat);
                            }
                            if (object.pubsubAvroFormat != null) {
                                if (typeof object.pubsubAvroFormat !== "object")
                                    throw TypeError(".google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.pubsubAvroFormat: object expected");
                                message.pubsubAvroFormat = $root.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat.fromObject(object.pubsubAvroFormat);
                            }
                            if (object.minimumObjectCreateTime != null) {
                                if (typeof object.minimumObjectCreateTime !== "object")
                                    throw TypeError(".google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.minimumObjectCreateTime: object expected");
                                message.minimumObjectCreateTime = $root.google.protobuf.Timestamp.fromObject(object.minimumObjectCreateTime);
                            }
                            if (object.matchGlob != null)
                                message.matchGlob = String(object.matchGlob);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a CloudStorage message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
                         * @static
                         * @param {google.pubsub.v1.IngestionDataSourceSettings.CloudStorage} message CloudStorage
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CloudStorage.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.state = options.enums === String ? "STATE_UNSPECIFIED" : 0;
                                object.bucket = "";
                                object.minimumObjectCreateTime = null;
                                object.matchGlob = "";
                            }
                            if (message.state != null && message.hasOwnProperty("state"))
                                object.state = options.enums === String ? $root.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State[message.state] === undefined ? message.state : $root.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State[message.state] : message.state;
                            if (message.bucket != null && message.hasOwnProperty("bucket"))
                                object.bucket = message.bucket;
                            if (message.textFormat != null && message.hasOwnProperty("textFormat")) {
                                object.textFormat = $root.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat.toObject(message.textFormat, options);
                                if (options.oneofs)
                                    object.inputFormat = "textFormat";
                            }
                            if (message.avroFormat != null && message.hasOwnProperty("avroFormat")) {
                                object.avroFormat = $root.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat.toObject(message.avroFormat, options);
                                if (options.oneofs)
                                    object.inputFormat = "avroFormat";
                            }
                            if (message.pubsubAvroFormat != null && message.hasOwnProperty("pubsubAvroFormat")) {
                                object.pubsubAvroFormat = $root.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat.toObject(message.pubsubAvroFormat, options);
                                if (options.oneofs)
                                    object.inputFormat = "pubsubAvroFormat";
                            }
                            if (message.minimumObjectCreateTime != null && message.hasOwnProperty("minimumObjectCreateTime"))
                                object.minimumObjectCreateTime = $root.google.protobuf.Timestamp.toObject(message.minimumObjectCreateTime, options);
                            if (message.matchGlob != null && message.hasOwnProperty("matchGlob"))
                                object.matchGlob = message.matchGlob;
                            return object;
                        };
    
                        /**
                         * Converts this CloudStorage to JSON.
                         * @function toJSON
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CloudStorage.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for CloudStorage
                         * @function getTypeUrl
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        CloudStorage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.pubsub.v1.IngestionDataSourceSettings.CloudStorage";
                        };
    
                        /**
                         * State enum.
                         * @name google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State
                         * @enum {number}
                         * @property {number} STATE_UNSPECIFIED=0 STATE_UNSPECIFIED value
                         * @property {number} ACTIVE=1 ACTIVE value
                         * @property {number} CLOUD_STORAGE_PERMISSION_DENIED=2 CLOUD_STORAGE_PERMISSION_DENIED value
                         * @property {number} PUBLISH_PERMISSION_DENIED=3 PUBLISH_PERMISSION_DENIED value
                         * @property {number} BUCKET_NOT_FOUND=4 BUCKET_NOT_FOUND value
                         * @property {number} TOO_MANY_OBJECTS=5 TOO_MANY_OBJECTS value
                         */
                        CloudStorage.State = (function() {
                            var valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[0] = "STATE_UNSPECIFIED"] = 0;
                            values[valuesById[1] = "ACTIVE"] = 1;
                            values[valuesById[2] = "CLOUD_STORAGE_PERMISSION_DENIED"] = 2;
                            values[valuesById[3] = "PUBLISH_PERMISSION_DENIED"] = 3;
                            values[valuesById[4] = "BUCKET_NOT_FOUND"] = 4;
                            values[valuesById[5] = "TOO_MANY_OBJECTS"] = 5;
                            return values;
                        })();
    
                        CloudStorage.TextFormat = (function() {
    
                            /**
                             * Properties of a TextFormat.
                             * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
                             * @interface ITextFormat
                             * @property {string|null} [delimiter] TextFormat delimiter
                             */
    
                            /**
                             * Constructs a new TextFormat.
                             * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
                             * @classdesc Represents a TextFormat.
                             * @implements ITextFormat
                             * @constructor
                             * @param {google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.ITextFormat=} [properties] Properties to set
                             */
                            function TextFormat(properties) {
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }
    
                            /**
                             * TextFormat delimiter.
                             * @member {string|null|undefined} delimiter
                             * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
                             * @instance
                             */
                            TextFormat.prototype.delimiter = null;
    
                            // OneOf field names bound to virtual getters and setters
                            var $oneOfFields;
    
                            // Virtual OneOf for proto3 optional field
                            Object.defineProperty(TextFormat.prototype, "_delimiter", {
                                get: $util.oneOfGetter($oneOfFields = ["delimiter"]),
                                set: $util.oneOfSetter($oneOfFields)
                            });
    
                            /**
                             * Creates a new TextFormat instance using the specified properties.
                             * @function create
                             * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
                             * @static
                             * @param {google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.ITextFormat=} [properties] Properties to set
                             * @returns {google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat} TextFormat instance
                             */
                            TextFormat.create = function create(properties) {
                                return new TextFormat(properties);
                            };
    
                            /**
                             * Encodes the specified TextFormat message. Does not implicitly {@link google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat.verify|verify} messages.
                             * @function encode
                             * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
                             * @static
                             * @param {google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.ITextFormat} message TextFormat message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            TextFormat.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                if (message.delimiter != null && Object.hasOwnProperty.call(message, "delimiter"))
                                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.delimiter);
                                return writer;
                            };
    
                            /**
                             * Encodes the specified TextFormat message, length delimited. Does not implicitly {@link google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
                             * @static
                             * @param {google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.ITextFormat} message TextFormat message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            TextFormat.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };
    
                            /**
                             * Decodes a TextFormat message from the specified reader or buffer.
                             * @function decode
                             * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat} TextFormat
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            TextFormat.decode = function decode(reader, length, error) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    if (tag === error)
                                        break;
                                    switch (tag >>> 3) {
                                    case 1: {
                                            message.delimiter = reader.string();
                                            break;
                                        }
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Decodes a TextFormat message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat} TextFormat
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            TextFormat.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };
    
                            /**
                             * Verifies a TextFormat message.
                             * @function verify
                             * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            TextFormat.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                var properties = {};
                                if (message.delimiter != null && message.hasOwnProperty("delimiter")) {
                                    properties._delimiter = 1;
                                    if (!$util.isString(message.delimiter))
                                        return "delimiter: string expected";
                                }
                                return null;
                            };
    
                            /**
                             * Creates a TextFormat message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat} TextFormat
                             */
                            TextFormat.fromObject = function fromObject(object) {
                                if (object instanceof $root.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat)
                                    return object;
                                var message = new $root.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat();
                                if (object.delimiter != null)
                                    message.delimiter = String(object.delimiter);
                                return message;
                            };
    
                            /**
                             * Creates a plain object from a TextFormat message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
                             * @static
                             * @param {google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat} message TextFormat
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            TextFormat.toObject = function toObject(message, options) {
                                if (!options)
                                    options = {};
                                var object = {};
                                if (message.delimiter != null && message.hasOwnProperty("delimiter")) {
                                    object.delimiter = message.delimiter;
                                    if (options.oneofs)
                                        object._delimiter = "delimiter";
                                }
                                return object;
                            };
    
                            /**
                             * Converts this TextFormat to JSON.
                             * @function toJSON
                             * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            TextFormat.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };
    
                            /**
                             * Gets the default type url for TextFormat
                             * @function getTypeUrl
                             * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
                             * @static
                             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns {string} The default type url
                             */
                            TextFormat.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                if (typeUrlPrefix === undefined) {
                                    typeUrlPrefix = "type.googleapis.com";
                                }
                                return typeUrlPrefix + "/google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat";
                            };
    
                            return TextFormat;
                        })();
    
                        CloudStorage.AvroFormat = (function() {
    
                            /**
                             * Properties of an AvroFormat.
                             * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
                             * @interface IAvroFormat
                             */
    
                            /**
                             * Constructs a new AvroFormat.
                             * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
                             * @classdesc Represents an AvroFormat.
                             * @implements IAvroFormat
                             * @constructor
                             * @param {google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.IAvroFormat=} [properties] Properties to set
                             */
                            function AvroFormat(properties) {
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }
    
                            /**
                             * Creates a new AvroFormat instance using the specified properties.
                             * @function create
                             * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
                             * @static
                             * @param {google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.IAvroFormat=} [properties] Properties to set
                             * @returns {google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat} AvroFormat instance
                             */
                            AvroFormat.create = function create(properties) {
                                return new AvroFormat(properties);
                            };
    
                            /**
                             * Encodes the specified AvroFormat message. Does not implicitly {@link google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat.verify|verify} messages.
                             * @function encode
                             * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
                             * @static
                             * @param {google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.IAvroFormat} message AvroFormat message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            AvroFormat.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                return writer;
                            };
    
                            /**
                             * Encodes the specified AvroFormat message, length delimited. Does not implicitly {@link google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
                             * @static
                             * @param {google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.IAvroFormat} message AvroFormat message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            AvroFormat.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };
    
                            /**
                             * Decodes an AvroFormat message from the specified reader or buffer.
                             * @function decode
                             * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat} AvroFormat
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            AvroFormat.decode = function decode(reader, length, error) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    if (tag === error)
                                        break;
                                    switch (tag >>> 3) {
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Decodes an AvroFormat message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat} AvroFormat
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            AvroFormat.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };
    
                            /**
                             * Verifies an AvroFormat message.
                             * @function verify
                             * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            AvroFormat.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                return null;
                            };
    
                            /**
                             * Creates an AvroFormat message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat} AvroFormat
                             */
                            AvroFormat.fromObject = function fromObject(object) {
                                if (object instanceof $root.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat)
                                    return object;
                                return new $root.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat();
                            };
    
                            /**
                             * Creates a plain object from an AvroFormat message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
                             * @static
                             * @param {google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat} message AvroFormat
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            AvroFormat.toObject = function toObject() {
                                return {};
                            };
    
                            /**
                             * Converts this AvroFormat to JSON.
                             * @function toJSON
                             * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            AvroFormat.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };
    
                            /**
                             * Gets the default type url for AvroFormat
                             * @function getTypeUrl
                             * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
                             * @static
                             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns {string} The default type url
                             */
                            AvroFormat.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                if (typeUrlPrefix === undefined) {
                                    typeUrlPrefix = "type.googleapis.com";
                                }
                                return typeUrlPrefix + "/google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat";
                            };
    
                            return AvroFormat;
                        })();
    
                        CloudStorage.PubSubAvroFormat = (function() {
    
                            /**
                             * Properties of a PubSubAvroFormat.
                             * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
                             * @interface IPubSubAvroFormat
                             */
    
                            /**
                             * Constructs a new PubSubAvroFormat.
                             * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
                             * @classdesc Represents a PubSubAvroFormat.
                             * @implements IPubSubAvroFormat
                             * @constructor
                             * @param {google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.IPubSubAvroFormat=} [properties] Properties to set
                             */
                            function PubSubAvroFormat(properties) {
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }
    
                            /**
                             * Creates a new PubSubAvroFormat instance using the specified properties.
                             * @function create
                             * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
                             * @static
                             * @param {google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.IPubSubAvroFormat=} [properties] Properties to set
                             * @returns {google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat} PubSubAvroFormat instance
                             */
                            PubSubAvroFormat.create = function create(properties) {
                                return new PubSubAvroFormat(properties);
                            };
    
                            /**
                             * Encodes the specified PubSubAvroFormat message. Does not implicitly {@link google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat.verify|verify} messages.
                             * @function encode
                             * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
                             * @static
                             * @param {google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.IPubSubAvroFormat} message PubSubAvroFormat message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            PubSubAvroFormat.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                return writer;
                            };
    
                            /**
                             * Encodes the specified PubSubAvroFormat message, length delimited. Does not implicitly {@link google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
                             * @static
                             * @param {google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.IPubSubAvroFormat} message PubSubAvroFormat message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            PubSubAvroFormat.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };
    
                            /**
                             * Decodes a PubSubAvroFormat message from the specified reader or buffer.
                             * @function decode
                             * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat} PubSubAvroFormat
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            PubSubAvroFormat.decode = function decode(reader, length, error) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    if (tag === error)
                                        break;
                                    switch (tag >>> 3) {
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Decodes a PubSubAvroFormat message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat} PubSubAvroFormat
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            PubSubAvroFormat.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };
    
                            /**
                             * Verifies a PubSubAvroFormat message.
                             * @function verify
                             * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            PubSubAvroFormat.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                return null;
                            };
    
                            /**
                             * Creates a PubSubAvroFormat message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat} PubSubAvroFormat
                             */
                            PubSubAvroFormat.fromObject = function fromObject(object) {
                                if (object instanceof $root.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat)
                                    return object;
                                return new $root.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat();
                            };
    
                            /**
                             * Creates a plain object from a PubSubAvroFormat message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
                             * @static
                             * @param {google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat} message PubSubAvroFormat
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            PubSubAvroFormat.toObject = function toObject() {
                                return {};
                            };
    
                            /**
                             * Converts this PubSubAvroFormat to JSON.
                             * @function toJSON
                             * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            PubSubAvroFormat.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };
    
                            /**
                             * Gets the default type url for PubSubAvroFormat
                             * @function getTypeUrl
                             * @memberof google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
                             * @static
                             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns {string} The default type url
                             */
                            PubSubAvroFormat.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                if (typeUrlPrefix === undefined) {
                                    typeUrlPrefix = "type.googleapis.com";
                                }
                                return typeUrlPrefix + "/google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat";
                            };
    
                            return PubSubAvroFormat;
                        })();
    
                        return CloudStorage;
                    })();
    
                    IngestionDataSourceSettings.AzureEventHubs = (function() {
    
                        /**
                         * Properties of an AzureEventHubs.
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings
                         * @interface IAzureEventHubs
                         * @property {google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.State|null} [state] AzureEventHubs state
                         * @property {string|null} [resourceGroup] AzureEventHubs resourceGroup
                         * @property {string|null} [namespace] AzureEventHubs namespace
                         * @property {string|null} [eventHub] AzureEventHubs eventHub
                         * @property {string|null} [clientId] AzureEventHubs clientId
                         * @property {string|null} [tenantId] AzureEventHubs tenantId
                         * @property {string|null} [subscriptionId] AzureEventHubs subscriptionId
                         * @property {string|null} [gcpServiceAccount] AzureEventHubs gcpServiceAccount
                         */
    
                        /**
                         * Constructs a new AzureEventHubs.
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings
                         * @classdesc Represents an AzureEventHubs.
                         * @implements IAzureEventHubs
                         * @constructor
                         * @param {google.pubsub.v1.IngestionDataSourceSettings.IAzureEventHubs=} [properties] Properties to set
                         */
                        function AzureEventHubs(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * AzureEventHubs state.
                         * @member {google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.State} state
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs
                         * @instance
                         */
                        AzureEventHubs.prototype.state = 0;
    
                        /**
                         * AzureEventHubs resourceGroup.
                         * @member {string} resourceGroup
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs
                         * @instance
                         */
                        AzureEventHubs.prototype.resourceGroup = "";
    
                        /**
                         * AzureEventHubs namespace.
                         * @member {string} namespace
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs
                         * @instance
                         */
                        AzureEventHubs.prototype.namespace = "";
    
                        /**
                         * AzureEventHubs eventHub.
                         * @member {string} eventHub
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs
                         * @instance
                         */
                        AzureEventHubs.prototype.eventHub = "";
    
                        /**
                         * AzureEventHubs clientId.
                         * @member {string} clientId
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs
                         * @instance
                         */
                        AzureEventHubs.prototype.clientId = "";
    
                        /**
                         * AzureEventHubs tenantId.
                         * @member {string} tenantId
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs
                         * @instance
                         */
                        AzureEventHubs.prototype.tenantId = "";
    
                        /**
                         * AzureEventHubs subscriptionId.
                         * @member {string} subscriptionId
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs
                         * @instance
                         */
                        AzureEventHubs.prototype.subscriptionId = "";
    
                        /**
                         * AzureEventHubs gcpServiceAccount.
                         * @member {string} gcpServiceAccount
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs
                         * @instance
                         */
                        AzureEventHubs.prototype.gcpServiceAccount = "";
    
                        /**
                         * Creates a new AzureEventHubs instance using the specified properties.
                         * @function create
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs
                         * @static
                         * @param {google.pubsub.v1.IngestionDataSourceSettings.IAzureEventHubs=} [properties] Properties to set
                         * @returns {google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs} AzureEventHubs instance
                         */
                        AzureEventHubs.create = function create(properties) {
                            return new AzureEventHubs(properties);
                        };
    
                        /**
                         * Encodes the specified AzureEventHubs message. Does not implicitly {@link google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.verify|verify} messages.
                         * @function encode
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs
                         * @static
                         * @param {google.pubsub.v1.IngestionDataSourceSettings.IAzureEventHubs} message AzureEventHubs message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AzureEventHubs.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.state != null && Object.hasOwnProperty.call(message, "state"))
                                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.state);
                            if (message.resourceGroup != null && Object.hasOwnProperty.call(message, "resourceGroup"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.resourceGroup);
                            if (message.namespace != null && Object.hasOwnProperty.call(message, "namespace"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.namespace);
                            if (message.eventHub != null && Object.hasOwnProperty.call(message, "eventHub"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.eventHub);
                            if (message.clientId != null && Object.hasOwnProperty.call(message, "clientId"))
                                writer.uint32(/* id 5, wireType 2 =*/42).string(message.clientId);
                            if (message.tenantId != null && Object.hasOwnProperty.call(message, "tenantId"))
                                writer.uint32(/* id 6, wireType 2 =*/50).string(message.tenantId);
                            if (message.subscriptionId != null && Object.hasOwnProperty.call(message, "subscriptionId"))
                                writer.uint32(/* id 7, wireType 2 =*/58).string(message.subscriptionId);
                            if (message.gcpServiceAccount != null && Object.hasOwnProperty.call(message, "gcpServiceAccount"))
                                writer.uint32(/* id 8, wireType 2 =*/66).string(message.gcpServiceAccount);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified AzureEventHubs message, length delimited. Does not implicitly {@link google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs
                         * @static
                         * @param {google.pubsub.v1.IngestionDataSourceSettings.IAzureEventHubs} message AzureEventHubs message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AzureEventHubs.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an AzureEventHubs message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs} AzureEventHubs
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AzureEventHubs.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.state = reader.int32();
                                        break;
                                    }
                                case 2: {
                                        message.resourceGroup = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.namespace = reader.string();
                                        break;
                                    }
                                case 4: {
                                        message.eventHub = reader.string();
                                        break;
                                    }
                                case 5: {
                                        message.clientId = reader.string();
                                        break;
                                    }
                                case 6: {
                                        message.tenantId = reader.string();
                                        break;
                                    }
                                case 7: {
                                        message.subscriptionId = reader.string();
                                        break;
                                    }
                                case 8: {
                                        message.gcpServiceAccount = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an AzureEventHubs message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs} AzureEventHubs
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AzureEventHubs.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an AzureEventHubs message.
                         * @function verify
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AzureEventHubs.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.state != null && message.hasOwnProperty("state"))
                                switch (message.state) {
                                default:
                                    return "state: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                case 4:
                                case 5:
                                case 6:
                                case 7:
                                    break;
                                }
                            if (message.resourceGroup != null && message.hasOwnProperty("resourceGroup"))
                                if (!$util.isString(message.resourceGroup))
                                    return "resourceGroup: string expected";
                            if (message.namespace != null && message.hasOwnProperty("namespace"))
                                if (!$util.isString(message.namespace))
                                    return "namespace: string expected";
                            if (message.eventHub != null && message.hasOwnProperty("eventHub"))
                                if (!$util.isString(message.eventHub))
                                    return "eventHub: string expected";
                            if (message.clientId != null && message.hasOwnProperty("clientId"))
                                if (!$util.isString(message.clientId))
                                    return "clientId: string expected";
                            if (message.tenantId != null && message.hasOwnProperty("tenantId"))
                                if (!$util.isString(message.tenantId))
                                    return "tenantId: string expected";
                            if (message.subscriptionId != null && message.hasOwnProperty("subscriptionId"))
                                if (!$util.isString(message.subscriptionId))
                                    return "subscriptionId: string expected";
                            if (message.gcpServiceAccount != null && message.hasOwnProperty("gcpServiceAccount"))
                                if (!$util.isString(message.gcpServiceAccount))
                                    return "gcpServiceAccount: string expected";
                            return null;
                        };
    
                        /**
                         * Creates an AzureEventHubs message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs} AzureEventHubs
                         */
                        AzureEventHubs.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs)
                                return object;
                            var message = new $root.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs();
                            switch (object.state) {
                            default:
                                if (typeof object.state === "number") {
                                    message.state = object.state;
                                    break;
                                }
                                break;
                            case "STATE_UNSPECIFIED":
                            case 0:
                                message.state = 0;
                                break;
                            case "ACTIVE":
                            case 1:
                                message.state = 1;
                                break;
                            case "EVENT_HUBS_PERMISSION_DENIED":
                            case 2:
                                message.state = 2;
                                break;
                            case "PUBLISH_PERMISSION_DENIED":
                            case 3:
                                message.state = 3;
                                break;
                            case "NAMESPACE_NOT_FOUND":
                            case 4:
                                message.state = 4;
                                break;
                            case "EVENT_HUB_NOT_FOUND":
                            case 5:
                                message.state = 5;
                                break;
                            case "SUBSCRIPTION_NOT_FOUND":
                            case 6:
                                message.state = 6;
                                break;
                            case "RESOURCE_GROUP_NOT_FOUND":
                            case 7:
                                message.state = 7;
                                break;
                            }
                            if (object.resourceGroup != null)
                                message.resourceGroup = String(object.resourceGroup);
                            if (object.namespace != null)
                                message.namespace = String(object.namespace);
                            if (object.eventHub != null)
                                message.eventHub = String(object.eventHub);
                            if (object.clientId != null)
                                message.clientId = String(object.clientId);
                            if (object.tenantId != null)
                                message.tenantId = String(object.tenantId);
                            if (object.subscriptionId != null)
                                message.subscriptionId = String(object.subscriptionId);
                            if (object.gcpServiceAccount != null)
                                message.gcpServiceAccount = String(object.gcpServiceAccount);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an AzureEventHubs message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs
                         * @static
                         * @param {google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs} message AzureEventHubs
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AzureEventHubs.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.state = options.enums === String ? "STATE_UNSPECIFIED" : 0;
                                object.resourceGroup = "";
                                object.namespace = "";
                                object.eventHub = "";
                                object.clientId = "";
                                object.tenantId = "";
                                object.subscriptionId = "";
                                object.gcpServiceAccount = "";
                            }
                            if (message.state != null && message.hasOwnProperty("state"))
                                object.state = options.enums === String ? $root.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.State[message.state] === undefined ? message.state : $root.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.State[message.state] : message.state;
                            if (message.resourceGroup != null && message.hasOwnProperty("resourceGroup"))
                                object.resourceGroup = message.resourceGroup;
                            if (message.namespace != null && message.hasOwnProperty("namespace"))
                                object.namespace = message.namespace;
                            if (message.eventHub != null && message.hasOwnProperty("eventHub"))
                                object.eventHub = message.eventHub;
                            if (message.clientId != null && message.hasOwnProperty("clientId"))
                                object.clientId = message.clientId;
                            if (message.tenantId != null && message.hasOwnProperty("tenantId"))
                                object.tenantId = message.tenantId;
                            if (message.subscriptionId != null && message.hasOwnProperty("subscriptionId"))
                                object.subscriptionId = message.subscriptionId;
                            if (message.gcpServiceAccount != null && message.hasOwnProperty("gcpServiceAccount"))
                                object.gcpServiceAccount = message.gcpServiceAccount;
                            return object;
                        };
    
                        /**
                         * Converts this AzureEventHubs to JSON.
                         * @function toJSON
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AzureEventHubs.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for AzureEventHubs
                         * @function getTypeUrl
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        AzureEventHubs.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs";
                        };
    
                        /**
                         * State enum.
                         * @name google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.State
                         * @enum {number}
                         * @property {number} STATE_UNSPECIFIED=0 STATE_UNSPECIFIED value
                         * @property {number} ACTIVE=1 ACTIVE value
                         * @property {number} EVENT_HUBS_PERMISSION_DENIED=2 EVENT_HUBS_PERMISSION_DENIED value
                         * @property {number} PUBLISH_PERMISSION_DENIED=3 PUBLISH_PERMISSION_DENIED value
                         * @property {number} NAMESPACE_NOT_FOUND=4 NAMESPACE_NOT_FOUND value
                         * @property {number} EVENT_HUB_NOT_FOUND=5 EVENT_HUB_NOT_FOUND value
                         * @property {number} SUBSCRIPTION_NOT_FOUND=6 SUBSCRIPTION_NOT_FOUND value
                         * @property {number} RESOURCE_GROUP_NOT_FOUND=7 RESOURCE_GROUP_NOT_FOUND value
                         */
                        AzureEventHubs.State = (function() {
                            var valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[0] = "STATE_UNSPECIFIED"] = 0;
                            values[valuesById[1] = "ACTIVE"] = 1;
                            values[valuesById[2] = "EVENT_HUBS_PERMISSION_DENIED"] = 2;
                            values[valuesById[3] = "PUBLISH_PERMISSION_DENIED"] = 3;
                            values[valuesById[4] = "NAMESPACE_NOT_FOUND"] = 4;
                            values[valuesById[5] = "EVENT_HUB_NOT_FOUND"] = 5;
                            values[valuesById[6] = "SUBSCRIPTION_NOT_FOUND"] = 6;
                            values[valuesById[7] = "RESOURCE_GROUP_NOT_FOUND"] = 7;
                            return values;
                        })();
    
                        return AzureEventHubs;
                    })();
    
                    IngestionDataSourceSettings.AwsMsk = (function() {
    
                        /**
                         * Properties of an AwsMsk.
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings
                         * @interface IAwsMsk
                         * @property {google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.State|null} [state] AwsMsk state
                         * @property {string|null} [clusterArn] AwsMsk clusterArn
                         * @property {string|null} [topic] AwsMsk topic
                         * @property {string|null} [awsRoleArn] AwsMsk awsRoleArn
                         * @property {string|null} [gcpServiceAccount] AwsMsk gcpServiceAccount
                         */
    
                        /**
                         * Constructs a new AwsMsk.
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings
                         * @classdesc Represents an AwsMsk.
                         * @implements IAwsMsk
                         * @constructor
                         * @param {google.pubsub.v1.IngestionDataSourceSettings.IAwsMsk=} [properties] Properties to set
                         */
                        function AwsMsk(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * AwsMsk state.
                         * @member {google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.State} state
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AwsMsk
                         * @instance
                         */
                        AwsMsk.prototype.state = 0;
    
                        /**
                         * AwsMsk clusterArn.
                         * @member {string} clusterArn
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AwsMsk
                         * @instance
                         */
                        AwsMsk.prototype.clusterArn = "";
    
                        /**
                         * AwsMsk topic.
                         * @member {string} topic
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AwsMsk
                         * @instance
                         */
                        AwsMsk.prototype.topic = "";
    
                        /**
                         * AwsMsk awsRoleArn.
                         * @member {string} awsRoleArn
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AwsMsk
                         * @instance
                         */
                        AwsMsk.prototype.awsRoleArn = "";
    
                        /**
                         * AwsMsk gcpServiceAccount.
                         * @member {string} gcpServiceAccount
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AwsMsk
                         * @instance
                         */
                        AwsMsk.prototype.gcpServiceAccount = "";
    
                        /**
                         * Creates a new AwsMsk instance using the specified properties.
                         * @function create
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AwsMsk
                         * @static
                         * @param {google.pubsub.v1.IngestionDataSourceSettings.IAwsMsk=} [properties] Properties to set
                         * @returns {google.pubsub.v1.IngestionDataSourceSettings.AwsMsk} AwsMsk instance
                         */
                        AwsMsk.create = function create(properties) {
                            return new AwsMsk(properties);
                        };
    
                        /**
                         * Encodes the specified AwsMsk message. Does not implicitly {@link google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.verify|verify} messages.
                         * @function encode
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AwsMsk
                         * @static
                         * @param {google.pubsub.v1.IngestionDataSourceSettings.IAwsMsk} message AwsMsk message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AwsMsk.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.state != null && Object.hasOwnProperty.call(message, "state"))
                                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.state);
                            if (message.clusterArn != null && Object.hasOwnProperty.call(message, "clusterArn"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.clusterArn);
                            if (message.topic != null && Object.hasOwnProperty.call(message, "topic"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.topic);
                            if (message.awsRoleArn != null && Object.hasOwnProperty.call(message, "awsRoleArn"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.awsRoleArn);
                            if (message.gcpServiceAccount != null && Object.hasOwnProperty.call(message, "gcpServiceAccount"))
                                writer.uint32(/* id 5, wireType 2 =*/42).string(message.gcpServiceAccount);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified AwsMsk message, length delimited. Does not implicitly {@link google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AwsMsk
                         * @static
                         * @param {google.pubsub.v1.IngestionDataSourceSettings.IAwsMsk} message AwsMsk message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AwsMsk.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an AwsMsk message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AwsMsk
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.pubsub.v1.IngestionDataSourceSettings.AwsMsk} AwsMsk
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AwsMsk.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.state = reader.int32();
                                        break;
                                    }
                                case 2: {
                                        message.clusterArn = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.topic = reader.string();
                                        break;
                                    }
                                case 4: {
                                        message.awsRoleArn = reader.string();
                                        break;
                                    }
                                case 5: {
                                        message.gcpServiceAccount = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an AwsMsk message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AwsMsk
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.pubsub.v1.IngestionDataSourceSettings.AwsMsk} AwsMsk
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AwsMsk.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an AwsMsk message.
                         * @function verify
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AwsMsk
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AwsMsk.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.state != null && message.hasOwnProperty("state"))
                                switch (message.state) {
                                default:
                                    return "state: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                case 4:
                                case 5:
                                    break;
                                }
                            if (message.clusterArn != null && message.hasOwnProperty("clusterArn"))
                                if (!$util.isString(message.clusterArn))
                                    return "clusterArn: string expected";
                            if (message.topic != null && message.hasOwnProperty("topic"))
                                if (!$util.isString(message.topic))
                                    return "topic: string expected";
                            if (message.awsRoleArn != null && message.hasOwnProperty("awsRoleArn"))
                                if (!$util.isString(message.awsRoleArn))
                                    return "awsRoleArn: string expected";
                            if (message.gcpServiceAccount != null && message.hasOwnProperty("gcpServiceAccount"))
                                if (!$util.isString(message.gcpServiceAccount))
                                    return "gcpServiceAccount: string expected";
                            return null;
                        };
    
                        /**
                         * Creates an AwsMsk message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AwsMsk
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.pubsub.v1.IngestionDataSourceSettings.AwsMsk} AwsMsk
                         */
                        AwsMsk.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk)
                                return object;
                            var message = new $root.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk();
                            switch (object.state) {
                            default:
                                if (typeof object.state === "number") {
                                    message.state = object.state;
                                    break;
                                }
                                break;
                            case "STATE_UNSPECIFIED":
                            case 0:
                                message.state = 0;
                                break;
                            case "ACTIVE":
                            case 1:
                                message.state = 1;
                                break;
                            case "MSK_PERMISSION_DENIED":
                            case 2:
                                message.state = 2;
                                break;
                            case "PUBLISH_PERMISSION_DENIED":
                            case 3:
                                message.state = 3;
                                break;
                            case "CLUSTER_NOT_FOUND":
                            case 4:
                                message.state = 4;
                                break;
                            case "TOPIC_NOT_FOUND":
                            case 5:
                                message.state = 5;
                                break;
                            }
                            if (object.clusterArn != null)
                                message.clusterArn = String(object.clusterArn);
                            if (object.topic != null)
                                message.topic = String(object.topic);
                            if (object.awsRoleArn != null)
                                message.awsRoleArn = String(object.awsRoleArn);
                            if (object.gcpServiceAccount != null)
                                message.gcpServiceAccount = String(object.gcpServiceAccount);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an AwsMsk message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AwsMsk
                         * @static
                         * @param {google.pubsub.v1.IngestionDataSourceSettings.AwsMsk} message AwsMsk
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AwsMsk.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.state = options.enums === String ? "STATE_UNSPECIFIED" : 0;
                                object.clusterArn = "";
                                object.topic = "";
                                object.awsRoleArn = "";
                                object.gcpServiceAccount = "";
                            }
                            if (message.state != null && message.hasOwnProperty("state"))
                                object.state = options.enums === String ? $root.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.State[message.state] === undefined ? message.state : $root.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.State[message.state] : message.state;
                            if (message.clusterArn != null && message.hasOwnProperty("clusterArn"))
                                object.clusterArn = message.clusterArn;
                            if (message.topic != null && message.hasOwnProperty("topic"))
                                object.topic = message.topic;
                            if (message.awsRoleArn != null && message.hasOwnProperty("awsRoleArn"))
                                object.awsRoleArn = message.awsRoleArn;
                            if (message.gcpServiceAccount != null && message.hasOwnProperty("gcpServiceAccount"))
                                object.gcpServiceAccount = message.gcpServiceAccount;
                            return object;
                        };
    
                        /**
                         * Converts this AwsMsk to JSON.
                         * @function toJSON
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AwsMsk
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AwsMsk.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for AwsMsk
                         * @function getTypeUrl
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.AwsMsk
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        AwsMsk.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.pubsub.v1.IngestionDataSourceSettings.AwsMsk";
                        };
    
                        /**
                         * State enum.
                         * @name google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.State
                         * @enum {number}
                         * @property {number} STATE_UNSPECIFIED=0 STATE_UNSPECIFIED value
                         * @property {number} ACTIVE=1 ACTIVE value
                         * @property {number} MSK_PERMISSION_DENIED=2 MSK_PERMISSION_DENIED value
                         * @property {number} PUBLISH_PERMISSION_DENIED=3 PUBLISH_PERMISSION_DENIED value
                         * @property {number} CLUSTER_NOT_FOUND=4 CLUSTER_NOT_FOUND value
                         * @property {number} TOPIC_NOT_FOUND=5 TOPIC_NOT_FOUND value
                         */
                        AwsMsk.State = (function() {
                            var valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[0] = "STATE_UNSPECIFIED"] = 0;
                            values[valuesById[1] = "ACTIVE"] = 1;
                            values[valuesById[2] = "MSK_PERMISSION_DENIED"] = 2;
                            values[valuesById[3] = "PUBLISH_PERMISSION_DENIED"] = 3;
                            values[valuesById[4] = "CLUSTER_NOT_FOUND"] = 4;
                            values[valuesById[5] = "TOPIC_NOT_FOUND"] = 5;
                            return values;
                        })();
    
                        return AwsMsk;
                    })();
    
                    IngestionDataSourceSettings.ConfluentCloud = (function() {
    
                        /**
                         * Properties of a ConfluentCloud.
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings
                         * @interface IConfluentCloud
                         * @property {google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.State|null} [state] ConfluentCloud state
                         * @property {string|null} [bootstrapServer] ConfluentCloud bootstrapServer
                         * @property {string|null} [clusterId] ConfluentCloud clusterId
                         * @property {string|null} [topic] ConfluentCloud topic
                         * @property {string|null} [identityPoolId] ConfluentCloud identityPoolId
                         * @property {string|null} [gcpServiceAccount] ConfluentCloud gcpServiceAccount
                         */
    
                        /**
                         * Constructs a new ConfluentCloud.
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings
                         * @classdesc Represents a ConfluentCloud.
                         * @implements IConfluentCloud
                         * @constructor
                         * @param {google.pubsub.v1.IngestionDataSourceSettings.IConfluentCloud=} [properties] Properties to set
                         */
                        function ConfluentCloud(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ConfluentCloud state.
                         * @member {google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.State} state
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud
                         * @instance
                         */
                        ConfluentCloud.prototype.state = 0;
    
                        /**
                         * ConfluentCloud bootstrapServer.
                         * @member {string} bootstrapServer
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud
                         * @instance
                         */
                        ConfluentCloud.prototype.bootstrapServer = "";
    
                        /**
                         * ConfluentCloud clusterId.
                         * @member {string} clusterId
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud
                         * @instance
                         */
                        ConfluentCloud.prototype.clusterId = "";
    
                        /**
                         * ConfluentCloud topic.
                         * @member {string} topic
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud
                         * @instance
                         */
                        ConfluentCloud.prototype.topic = "";
    
                        /**
                         * ConfluentCloud identityPoolId.
                         * @member {string} identityPoolId
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud
                         * @instance
                         */
                        ConfluentCloud.prototype.identityPoolId = "";
    
                        /**
                         * ConfluentCloud gcpServiceAccount.
                         * @member {string} gcpServiceAccount
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud
                         * @instance
                         */
                        ConfluentCloud.prototype.gcpServiceAccount = "";
    
                        /**
                         * Creates a new ConfluentCloud instance using the specified properties.
                         * @function create
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud
                         * @static
                         * @param {google.pubsub.v1.IngestionDataSourceSettings.IConfluentCloud=} [properties] Properties to set
                         * @returns {google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud} ConfluentCloud instance
                         */
                        ConfluentCloud.create = function create(properties) {
                            return new ConfluentCloud(properties);
                        };
    
                        /**
                         * Encodes the specified ConfluentCloud message. Does not implicitly {@link google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.verify|verify} messages.
                         * @function encode
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud
                         * @static
                         * @param {google.pubsub.v1.IngestionDataSourceSettings.IConfluentCloud} message ConfluentCloud message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ConfluentCloud.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.state != null && Object.hasOwnProperty.call(message, "state"))
                                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.state);
                            if (message.bootstrapServer != null && Object.hasOwnProperty.call(message, "bootstrapServer"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.bootstrapServer);
                            if (message.clusterId != null && Object.hasOwnProperty.call(message, "clusterId"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.clusterId);
                            if (message.topic != null && Object.hasOwnProperty.call(message, "topic"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.topic);
                            if (message.identityPoolId != null && Object.hasOwnProperty.call(message, "identityPoolId"))
                                writer.uint32(/* id 5, wireType 2 =*/42).string(message.identityPoolId);
                            if (message.gcpServiceAccount != null && Object.hasOwnProperty.call(message, "gcpServiceAccount"))
                                writer.uint32(/* id 6, wireType 2 =*/50).string(message.gcpServiceAccount);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ConfluentCloud message, length delimited. Does not implicitly {@link google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud
                         * @static
                         * @param {google.pubsub.v1.IngestionDataSourceSettings.IConfluentCloud} message ConfluentCloud message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ConfluentCloud.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ConfluentCloud message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud} ConfluentCloud
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ConfluentCloud.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.state = reader.int32();
                                        break;
                                    }
                                case 2: {
                                        message.bootstrapServer = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.clusterId = reader.string();
                                        break;
                                    }
                                case 4: {
                                        message.topic = reader.string();
                                        break;
                                    }
                                case 5: {
                                        message.identityPoolId = reader.string();
                                        break;
                                    }
                                case 6: {
                                        message.gcpServiceAccount = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ConfluentCloud message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud} ConfluentCloud
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ConfluentCloud.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ConfluentCloud message.
                         * @function verify
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ConfluentCloud.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.state != null && message.hasOwnProperty("state"))
                                switch (message.state) {
                                default:
                                    return "state: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                case 4:
                                case 5:
                                case 6:
                                    break;
                                }
                            if (message.bootstrapServer != null && message.hasOwnProperty("bootstrapServer"))
                                if (!$util.isString(message.bootstrapServer))
                                    return "bootstrapServer: string expected";
                            if (message.clusterId != null && message.hasOwnProperty("clusterId"))
                                if (!$util.isString(message.clusterId))
                                    return "clusterId: string expected";
                            if (message.topic != null && message.hasOwnProperty("topic"))
                                if (!$util.isString(message.topic))
                                    return "topic: string expected";
                            if (message.identityPoolId != null && message.hasOwnProperty("identityPoolId"))
                                if (!$util.isString(message.identityPoolId))
                                    return "identityPoolId: string expected";
                            if (message.gcpServiceAccount != null && message.hasOwnProperty("gcpServiceAccount"))
                                if (!$util.isString(message.gcpServiceAccount))
                                    return "gcpServiceAccount: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ConfluentCloud message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud} ConfluentCloud
                         */
                        ConfluentCloud.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud)
                                return object;
                            var message = new $root.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud();
                            switch (object.state) {
                            default:
                                if (typeof object.state === "number") {
                                    message.state = object.state;
                                    break;
                                }
                                break;
                            case "STATE_UNSPECIFIED":
                            case 0:
                                message.state = 0;
                                break;
                            case "ACTIVE":
                            case 1:
                                message.state = 1;
                                break;
                            case "CONFLUENT_CLOUD_PERMISSION_DENIED":
                            case 2:
                                message.state = 2;
                                break;
                            case "PUBLISH_PERMISSION_DENIED":
                            case 3:
                                message.state = 3;
                                break;
                            case "UNREACHABLE_BOOTSTRAP_SERVER":
                            case 4:
                                message.state = 4;
                                break;
                            case "CLUSTER_NOT_FOUND":
                            case 5:
                                message.state = 5;
                                break;
                            case "TOPIC_NOT_FOUND":
                            case 6:
                                message.state = 6;
                                break;
                            }
                            if (object.bootstrapServer != null)
                                message.bootstrapServer = String(object.bootstrapServer);
                            if (object.clusterId != null)
                                message.clusterId = String(object.clusterId);
                            if (object.topic != null)
                                message.topic = String(object.topic);
                            if (object.identityPoolId != null)
                                message.identityPoolId = String(object.identityPoolId);
                            if (object.gcpServiceAccount != null)
                                message.gcpServiceAccount = String(object.gcpServiceAccount);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ConfluentCloud message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud
                         * @static
                         * @param {google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud} message ConfluentCloud
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ConfluentCloud.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.state = options.enums === String ? "STATE_UNSPECIFIED" : 0;
                                object.bootstrapServer = "";
                                object.clusterId = "";
                                object.topic = "";
                                object.identityPoolId = "";
                                object.gcpServiceAccount = "";
                            }
                            if (message.state != null && message.hasOwnProperty("state"))
                                object.state = options.enums === String ? $root.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.State[message.state] === undefined ? message.state : $root.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.State[message.state] : message.state;
                            if (message.bootstrapServer != null && message.hasOwnProperty("bootstrapServer"))
                                object.bootstrapServer = message.bootstrapServer;
                            if (message.clusterId != null && message.hasOwnProperty("clusterId"))
                                object.clusterId = message.clusterId;
                            if (message.topic != null && message.hasOwnProperty("topic"))
                                object.topic = message.topic;
                            if (message.identityPoolId != null && message.hasOwnProperty("identityPoolId"))
                                object.identityPoolId = message.identityPoolId;
                            if (message.gcpServiceAccount != null && message.hasOwnProperty("gcpServiceAccount"))
                                object.gcpServiceAccount = message.gcpServiceAccount;
                            return object;
                        };
    
                        /**
                         * Converts this ConfluentCloud to JSON.
                         * @function toJSON
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ConfluentCloud.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ConfluentCloud
                         * @function getTypeUrl
                         * @memberof google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ConfluentCloud.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud";
                        };
    
                        /**
                         * State enum.
                         * @name google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.State
                         * @enum {number}
                         * @property {number} STATE_UNSPECIFIED=0 STATE_UNSPECIFIED value
                         * @property {number} ACTIVE=1 ACTIVE value
                         * @property {number} CONFLUENT_CLOUD_PERMISSION_DENIED=2 CONFLUENT_CLOUD_PERMISSION_DENIED value
                         * @property {number} PUBLISH_PERMISSION_DENIED=3 PUBLISH_PERMISSION_DENIED value
                         * @property {number} UNREACHABLE_BOOTSTRAP_SERVER=4 UNREACHABLE_BOOTSTRAP_SERVER value
                         * @property {number} CLUSTER_NOT_FOUND=5 CLUSTER_NOT_FOUND value
                         * @property {number} TOPIC_NOT_FOUND=6 TOPIC_NOT_FOUND value
                         */
                        ConfluentCloud.State = (function() {
                            var valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[0] = "STATE_UNSPECIFIED"] = 0;
                            values[valuesById[1] = "ACTIVE"] = 1;
                            values[valuesById[2] = "CONFLUENT_CLOUD_PERMISSION_DENIED"] = 2;
                            values[valuesById[3] = "PUBLISH_PERMISSION_DENIED"] = 3;
                            values[valuesById[4] = "UNREACHABLE_BOOTSTRAP_SERVER"] = 4;
                            values[valuesById[5] = "CLUSTER_NOT_FOUND"] = 5;
                            values[valuesById[6] = "TOPIC_NOT_FOUND"] = 6;
                            return values;
                        })();
    
                        return ConfluentCloud;
                    })();
    
                    return IngestionDataSourceSettings;
                })();
    
                v1.PlatformLogsSettings = (function() {
    
                    /**
                     * Properties of a PlatformLogsSettings.
                     * @memberof google.pubsub.v1
                     * @interface IPlatformLogsSettings
                     * @property {google.pubsub.v1.PlatformLogsSettings.Severity|null} [severity] PlatformLogsSettings severity
                     */
    
                    /**
                     * Constructs a new PlatformLogsSettings.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a PlatformLogsSettings.
                     * @implements IPlatformLogsSettings
                     * @constructor
                     * @param {google.pubsub.v1.IPlatformLogsSettings=} [properties] Properties to set
                     */
                    function PlatformLogsSettings(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * PlatformLogsSettings severity.
                     * @member {google.pubsub.v1.PlatformLogsSettings.Severity} severity
                     * @memberof google.pubsub.v1.PlatformLogsSettings
                     * @instance
                     */
                    PlatformLogsSettings.prototype.severity = 0;
    
                    /**
                     * Creates a new PlatformLogsSettings instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.PlatformLogsSettings
                     * @static
                     * @param {google.pubsub.v1.IPlatformLogsSettings=} [properties] Properties to set
                     * @returns {google.pubsub.v1.PlatformLogsSettings} PlatformLogsSettings instance
                     */
                    PlatformLogsSettings.create = function create(properties) {
                        return new PlatformLogsSettings(properties);
                    };
    
                    /**
                     * Encodes the specified PlatformLogsSettings message. Does not implicitly {@link google.pubsub.v1.PlatformLogsSettings.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.PlatformLogsSettings
                     * @static
                     * @param {google.pubsub.v1.IPlatformLogsSettings} message PlatformLogsSettings message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    PlatformLogsSettings.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.severity != null && Object.hasOwnProperty.call(message, "severity"))
                            writer.uint32(/* id 1, wireType 0 =*/8).int32(message.severity);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified PlatformLogsSettings message, length delimited. Does not implicitly {@link google.pubsub.v1.PlatformLogsSettings.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.PlatformLogsSettings
                     * @static
                     * @param {google.pubsub.v1.IPlatformLogsSettings} message PlatformLogsSettings message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    PlatformLogsSettings.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a PlatformLogsSettings message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.PlatformLogsSettings
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.PlatformLogsSettings} PlatformLogsSettings
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    PlatformLogsSettings.decode = function decode(reader, length, error) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.PlatformLogsSettings();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            if (tag === error)
                                break;
                            switch (tag >>> 3) {
                            case 1: {
                                    message.severity = reader.int32();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a PlatformLogsSettings message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.PlatformLogsSettings
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.PlatformLogsSettings} PlatformLogsSettings
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    PlatformLogsSettings.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a PlatformLogsSettings message.
                     * @function verify
                     * @memberof google.pubsub.v1.PlatformLogsSettings
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    PlatformLogsSettings.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.severity != null && message.hasOwnProperty("severity"))
                            switch (message.severity) {
                            default:
                                return "severity: enum value expected";
                            case 0:
                            case 1:
                            case 2:
                            case 3:
                            case 4:
                            case 5:
                                break;
                            }
                        return null;
                    };
    
                    /**
                     * Creates a PlatformLogsSettings message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.PlatformLogsSettings
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.PlatformLogsSettings} PlatformLogsSettings
                     */
                    PlatformLogsSettings.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.PlatformLogsSettings)
                            return object;
                        var message = new $root.google.pubsub.v1.PlatformLogsSettings();
                        switch (object.severity) {
                        default:
                            if (typeof object.severity === "number") {
                                message.severity = object.severity;
                                break;
                            }
                            break;
                        case "SEVERITY_UNSPECIFIED":
                        case 0:
                            message.severity = 0;
                            break;
                        case "DISABLED":
                        case 1:
                            message.severity = 1;
                            break;
                        case "DEBUG":
                        case 2:
                            message.severity = 2;
                            break;
                        case "INFO":
                        case 3:
                            message.severity = 3;
                            break;
                        case "WARNING":
                        case 4:
                            message.severity = 4;
                            break;
                        case "ERROR":
                        case 5:
                            message.severity = 5;
                            break;
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a PlatformLogsSettings message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.PlatformLogsSettings
                     * @static
                     * @param {google.pubsub.v1.PlatformLogsSettings} message PlatformLogsSettings
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    PlatformLogsSettings.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults)
                            object.severity = options.enums === String ? "SEVERITY_UNSPECIFIED" : 0;
                        if (message.severity != null && message.hasOwnProperty("severity"))
                            object.severity = options.enums === String ? $root.google.pubsub.v1.PlatformLogsSettings.Severity[message.severity] === undefined ? message.severity : $root.google.pubsub.v1.PlatformLogsSettings.Severity[message.severity] : message.severity;
                        return object;
                    };
    
                    /**
                     * Converts this PlatformLogsSettings to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.PlatformLogsSettings
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    PlatformLogsSettings.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for PlatformLogsSettings
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.PlatformLogsSettings
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    PlatformLogsSettings.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.PlatformLogsSettings";
                    };
    
                    /**
                     * Severity enum.
                     * @name google.pubsub.v1.PlatformLogsSettings.Severity
                     * @enum {number}
                     * @property {number} SEVERITY_UNSPECIFIED=0 SEVERITY_UNSPECIFIED value
                     * @property {number} DISABLED=1 DISABLED value
                     * @property {number} DEBUG=2 DEBUG value
                     * @property {number} INFO=3 INFO value
                     * @property {number} WARNING=4 WARNING value
                     * @property {number} ERROR=5 ERROR value
                     */
                    PlatformLogsSettings.Severity = (function() {
                        var valuesById = {}, values = Object.create(valuesById);
                        values[valuesById[0] = "SEVERITY_UNSPECIFIED"] = 0;
                        values[valuesById[1] = "DISABLED"] = 1;
                        values[valuesById[2] = "DEBUG"] = 2;
                        values[valuesById[3] = "INFO"] = 3;
                        values[valuesById[4] = "WARNING"] = 4;
                        values[valuesById[5] = "ERROR"] = 5;
                        return values;
                    })();
    
                    return PlatformLogsSettings;
                })();
    
                v1.IngestionFailureEvent = (function() {
    
                    /**
                     * Properties of an IngestionFailureEvent.
                     * @memberof google.pubsub.v1
                     * @interface IIngestionFailureEvent
                     * @property {string|null} [topic] IngestionFailureEvent topic
                     * @property {string|null} [errorMessage] IngestionFailureEvent errorMessage
                     * @property {google.pubsub.v1.IngestionFailureEvent.ICloudStorageFailure|null} [cloudStorageFailure] IngestionFailureEvent cloudStorageFailure
                     * @property {google.pubsub.v1.IngestionFailureEvent.IAwsMskFailureReason|null} [awsMskFailure] IngestionFailureEvent awsMskFailure
                     * @property {google.pubsub.v1.IngestionFailureEvent.IAzureEventHubsFailureReason|null} [azureEventHubsFailure] IngestionFailureEvent azureEventHubsFailure
                     * @property {google.pubsub.v1.IngestionFailureEvent.IConfluentCloudFailureReason|null} [confluentCloudFailure] IngestionFailureEvent confluentCloudFailure
                     * @property {google.pubsub.v1.IngestionFailureEvent.IAwsKinesisFailureReason|null} [awsKinesisFailure] IngestionFailureEvent awsKinesisFailure
                     */
    
                    /**
                     * Constructs a new IngestionFailureEvent.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents an IngestionFailureEvent.
                     * @implements IIngestionFailureEvent
                     * @constructor
                     * @param {google.pubsub.v1.IIngestionFailureEvent=} [properties] Properties to set
                     */
                    function IngestionFailureEvent(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * IngestionFailureEvent topic.
                     * @member {string} topic
                     * @memberof google.pubsub.v1.IngestionFailureEvent
                     * @instance
                     */
                    IngestionFailureEvent.prototype.topic = "";
    
                    /**
                     * IngestionFailureEvent errorMessage.
                     * @member {string} errorMessage
                     * @memberof google.pubsub.v1.IngestionFailureEvent
                     * @instance
                     */
                    IngestionFailureEvent.prototype.errorMessage = "";
    
                    /**
                     * IngestionFailureEvent cloudStorageFailure.
                     * @member {google.pubsub.v1.IngestionFailureEvent.ICloudStorageFailure|null|undefined} cloudStorageFailure
                     * @memberof google.pubsub.v1.IngestionFailureEvent
                     * @instance
                     */
                    IngestionFailureEvent.prototype.cloudStorageFailure = null;
    
                    /**
                     * IngestionFailureEvent awsMskFailure.
                     * @member {google.pubsub.v1.IngestionFailureEvent.IAwsMskFailureReason|null|undefined} awsMskFailure
                     * @memberof google.pubsub.v1.IngestionFailureEvent
                     * @instance
                     */
                    IngestionFailureEvent.prototype.awsMskFailure = null;
    
                    /**
                     * IngestionFailureEvent azureEventHubsFailure.
                     * @member {google.pubsub.v1.IngestionFailureEvent.IAzureEventHubsFailureReason|null|undefined} azureEventHubsFailure
                     * @memberof google.pubsub.v1.IngestionFailureEvent
                     * @instance
                     */
                    IngestionFailureEvent.prototype.azureEventHubsFailure = null;
    
                    /**
                     * IngestionFailureEvent confluentCloudFailure.
                     * @member {google.pubsub.v1.IngestionFailureEvent.IConfluentCloudFailureReason|null|undefined} confluentCloudFailure
                     * @memberof google.pubsub.v1.IngestionFailureEvent
                     * @instance
                     */
                    IngestionFailureEvent.prototype.confluentCloudFailure = null;
    
                    /**
                     * IngestionFailureEvent awsKinesisFailure.
                     * @member {google.pubsub.v1.IngestionFailureEvent.IAwsKinesisFailureReason|null|undefined} awsKinesisFailure
                     * @memberof google.pubsub.v1.IngestionFailureEvent
                     * @instance
                     */
                    IngestionFailureEvent.prototype.awsKinesisFailure = null;
    
                    // OneOf field names bound to virtual getters and setters
                    var $oneOfFields;
    
                    /**
                     * IngestionFailureEvent failure.
                     * @member {"cloudStorageFailure"|"awsMskFailure"|"azureEventHubsFailure"|"confluentCloudFailure"|"awsKinesisFailure"|undefined} failure
                     * @memberof google.pubsub.v1.IngestionFailureEvent
                     * @instance
                     */
                    Object.defineProperty(IngestionFailureEvent.prototype, "failure", {
                        get: $util.oneOfGetter($oneOfFields = ["cloudStorageFailure", "awsMskFailure", "azureEventHubsFailure", "confluentCloudFailure", "awsKinesisFailure"]),
                        set: $util.oneOfSetter($oneOfFields)
                    });
    
                    /**
                     * Creates a new IngestionFailureEvent instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.IngestionFailureEvent
                     * @static
                     * @param {google.pubsub.v1.IIngestionFailureEvent=} [properties] Properties to set
                     * @returns {google.pubsub.v1.IngestionFailureEvent} IngestionFailureEvent instance
                     */
                    IngestionFailureEvent.create = function create(properties) {
                        return new IngestionFailureEvent(properties);
                    };
    
                    /**
                     * Encodes the specified IngestionFailureEvent message. Does not implicitly {@link google.pubsub.v1.IngestionFailureEvent.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.IngestionFailureEvent
                     * @static
                     * @param {google.pubsub.v1.IIngestionFailureEvent} message IngestionFailureEvent message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    IngestionFailureEvent.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.topic != null && Object.hasOwnProperty.call(message, "topic"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.topic);
                        if (message.errorMessage != null && Object.hasOwnProperty.call(message, "errorMessage"))
                            writer.uint32(/* id 2, wireType 2 =*/18).string(message.errorMessage);
                        if (message.cloudStorageFailure != null && Object.hasOwnProperty.call(message, "cloudStorageFailure"))
                            $root.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure.encode(message.cloudStorageFailure, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                        if (message.awsMskFailure != null && Object.hasOwnProperty.call(message, "awsMskFailure"))
                            $root.google.pubsub.v1.IngestionFailureEvent.AwsMskFailureReason.encode(message.awsMskFailure, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                        if (message.azureEventHubsFailure != null && Object.hasOwnProperty.call(message, "azureEventHubsFailure"))
                            $root.google.pubsub.v1.IngestionFailureEvent.AzureEventHubsFailureReason.encode(message.azureEventHubsFailure, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                        if (message.confluentCloudFailure != null && Object.hasOwnProperty.call(message, "confluentCloudFailure"))
                            $root.google.pubsub.v1.IngestionFailureEvent.ConfluentCloudFailureReason.encode(message.confluentCloudFailure, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                        if (message.awsKinesisFailure != null && Object.hasOwnProperty.call(message, "awsKinesisFailure"))
                            $root.google.pubsub.v1.IngestionFailureEvent.AwsKinesisFailureReason.encode(message.awsKinesisFailure, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified IngestionFailureEvent message, length delimited. Does not implicitly {@link google.pubsub.v1.IngestionFailureEvent.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.IngestionFailureEvent
                     * @static
                     * @param {google.pubsub.v1.IIngestionFailureEvent} message IngestionFailureEvent message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    IngestionFailureEvent.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes an IngestionFailureEvent message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.IngestionFailureEvent
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.IngestionFailureEvent} IngestionFailureEvent
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    IngestionFailureEvent.decode = function decode(reader, length, error) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.IngestionFailureEvent();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            if (tag === error)
                                break;
                            switch (tag >>> 3) {
                            case 1: {
                                    message.topic = reader.string();
                                    break;
                                }
                            case 2: {
                                    message.errorMessage = reader.string();
                                    break;
                                }
                            case 3: {
                                    message.cloudStorageFailure = $root.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure.decode(reader, reader.uint32());
                                    break;
                                }
                            case 4: {
                                    message.awsMskFailure = $root.google.pubsub.v1.IngestionFailureEvent.AwsMskFailureReason.decode(reader, reader.uint32());
                                    break;
                                }
                            case 5: {
                                    message.azureEventHubsFailure = $root.google.pubsub.v1.IngestionFailureEvent.AzureEventHubsFailureReason.decode(reader, reader.uint32());
                                    break;
                                }
                            case 6: {
                                    message.confluentCloudFailure = $root.google.pubsub.v1.IngestionFailureEvent.ConfluentCloudFailureReason.decode(reader, reader.uint32());
                                    break;
                                }
                            case 7: {
                                    message.awsKinesisFailure = $root.google.pubsub.v1.IngestionFailureEvent.AwsKinesisFailureReason.decode(reader, reader.uint32());
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes an IngestionFailureEvent message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.IngestionFailureEvent
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.IngestionFailureEvent} IngestionFailureEvent
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    IngestionFailureEvent.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies an IngestionFailureEvent message.
                     * @function verify
                     * @memberof google.pubsub.v1.IngestionFailureEvent
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    IngestionFailureEvent.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        var properties = {};
                        if (message.topic != null && message.hasOwnProperty("topic"))
                            if (!$util.isString(message.topic))
                                return "topic: string expected";
                        if (message.errorMessage != null && message.hasOwnProperty("errorMessage"))
                            if (!$util.isString(message.errorMessage))
                                return "errorMessage: string expected";
                        if (message.cloudStorageFailure != null && message.hasOwnProperty("cloudStorageFailure")) {
                            properties.failure = 1;
                            {
                                var error = $root.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure.verify(message.cloudStorageFailure);
                                if (error)
                                    return "cloudStorageFailure." + error;
                            }
                        }
                        if (message.awsMskFailure != null && message.hasOwnProperty("awsMskFailure")) {
                            if (properties.failure === 1)
                                return "failure: multiple values";
                            properties.failure = 1;
                            {
                                var error = $root.google.pubsub.v1.IngestionFailureEvent.AwsMskFailureReason.verify(message.awsMskFailure);
                                if (error)
                                    return "awsMskFailure." + error;
                            }
                        }
                        if (message.azureEventHubsFailure != null && message.hasOwnProperty("azureEventHubsFailure")) {
                            if (properties.failure === 1)
                                return "failure: multiple values";
                            properties.failure = 1;
                            {
                                var error = $root.google.pubsub.v1.IngestionFailureEvent.AzureEventHubsFailureReason.verify(message.azureEventHubsFailure);
                                if (error)
                                    return "azureEventHubsFailure." + error;
                            }
                        }
                        if (message.confluentCloudFailure != null && message.hasOwnProperty("confluentCloudFailure")) {
                            if (properties.failure === 1)
                                return "failure: multiple values";
                            properties.failure = 1;
                            {
                                var error = $root.google.pubsub.v1.IngestionFailureEvent.ConfluentCloudFailureReason.verify(message.confluentCloudFailure);
                                if (error)
                                    return "confluentCloudFailure." + error;
                            }
                        }
                        if (message.awsKinesisFailure != null && message.hasOwnProperty("awsKinesisFailure")) {
                            if (properties.failure === 1)
                                return "failure: multiple values";
                            properties.failure = 1;
                            {
                                var error = $root.google.pubsub.v1.IngestionFailureEvent.AwsKinesisFailureReason.verify(message.awsKinesisFailure);
                                if (error)
                                    return "awsKinesisFailure." + error;
                            }
                        }
                        return null;
                    };
    
                    /**
                     * Creates an IngestionFailureEvent message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.IngestionFailureEvent
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.IngestionFailureEvent} IngestionFailureEvent
                     */
                    IngestionFailureEvent.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.IngestionFailureEvent)
                            return object;
                        var message = new $root.google.pubsub.v1.IngestionFailureEvent();
                        if (object.topic != null)
                            message.topic = String(object.topic);
                        if (object.errorMessage != null)
                            message.errorMessage = String(object.errorMessage);
                        if (object.cloudStorageFailure != null) {
                            if (typeof object.cloudStorageFailure !== "object")
                                throw TypeError(".google.pubsub.v1.IngestionFailureEvent.cloudStorageFailure: object expected");
                            message.cloudStorageFailure = $root.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure.fromObject(object.cloudStorageFailure);
                        }
                        if (object.awsMskFailure != null) {
                            if (typeof object.awsMskFailure !== "object")
                                throw TypeError(".google.pubsub.v1.IngestionFailureEvent.awsMskFailure: object expected");
                            message.awsMskFailure = $root.google.pubsub.v1.IngestionFailureEvent.AwsMskFailureReason.fromObject(object.awsMskFailure);
                        }
                        if (object.azureEventHubsFailure != null) {
                            if (typeof object.azureEventHubsFailure !== "object")
                                throw TypeError(".google.pubsub.v1.IngestionFailureEvent.azureEventHubsFailure: object expected");
                            message.azureEventHubsFailure = $root.google.pubsub.v1.IngestionFailureEvent.AzureEventHubsFailureReason.fromObject(object.azureEventHubsFailure);
                        }
                        if (object.confluentCloudFailure != null) {
                            if (typeof object.confluentCloudFailure !== "object")
                                throw TypeError(".google.pubsub.v1.IngestionFailureEvent.confluentCloudFailure: object expected");
                            message.confluentCloudFailure = $root.google.pubsub.v1.IngestionFailureEvent.ConfluentCloudFailureReason.fromObject(object.confluentCloudFailure);
                        }
                        if (object.awsKinesisFailure != null) {
                            if (typeof object.awsKinesisFailure !== "object")
                                throw TypeError(".google.pubsub.v1.IngestionFailureEvent.awsKinesisFailure: object expected");
                            message.awsKinesisFailure = $root.google.pubsub.v1.IngestionFailureEvent.AwsKinesisFailureReason.fromObject(object.awsKinesisFailure);
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from an IngestionFailureEvent message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.IngestionFailureEvent
                     * @static
                     * @param {google.pubsub.v1.IngestionFailureEvent} message IngestionFailureEvent
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    IngestionFailureEvent.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.topic = "";
                            object.errorMessage = "";
                        }
                        if (message.topic != null && message.hasOwnProperty("topic"))
                            object.topic = message.topic;
                        if (message.errorMessage != null && message.hasOwnProperty("errorMessage"))
                            object.errorMessage = message.errorMessage;
                        if (message.cloudStorageFailure != null && message.hasOwnProperty("cloudStorageFailure")) {
                            object.cloudStorageFailure = $root.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure.toObject(message.cloudStorageFailure, options);
                            if (options.oneofs)
                                object.failure = "cloudStorageFailure";
                        }
                        if (message.awsMskFailure != null && message.hasOwnProperty("awsMskFailure")) {
                            object.awsMskFailure = $root.google.pubsub.v1.IngestionFailureEvent.AwsMskFailureReason.toObject(message.awsMskFailure, options);
                            if (options.oneofs)
                                object.failure = "awsMskFailure";
                        }
                        if (message.azureEventHubsFailure != null && message.hasOwnProperty("azureEventHubsFailure")) {
                            object.azureEventHubsFailure = $root.google.pubsub.v1.IngestionFailureEvent.AzureEventHubsFailureReason.toObject(message.azureEventHubsFailure, options);
                            if (options.oneofs)
                                object.failure = "azureEventHubsFailure";
                        }
                        if (message.confluentCloudFailure != null && message.hasOwnProperty("confluentCloudFailure")) {
                            object.confluentCloudFailure = $root.google.pubsub.v1.IngestionFailureEvent.ConfluentCloudFailureReason.toObject(message.confluentCloudFailure, options);
                            if (options.oneofs)
                                object.failure = "confluentCloudFailure";
                        }
                        if (message.awsKinesisFailure != null && message.hasOwnProperty("awsKinesisFailure")) {
                            object.awsKinesisFailure = $root.google.pubsub.v1.IngestionFailureEvent.AwsKinesisFailureReason.toObject(message.awsKinesisFailure, options);
                            if (options.oneofs)
                                object.failure = "awsKinesisFailure";
                        }
                        return object;
                    };
    
                    /**
                     * Converts this IngestionFailureEvent to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.IngestionFailureEvent
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    IngestionFailureEvent.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for IngestionFailureEvent
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.IngestionFailureEvent
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    IngestionFailureEvent.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.IngestionFailureEvent";
                    };
    
                    IngestionFailureEvent.ApiViolationReason = (function() {
    
                        /**
                         * Properties of an ApiViolationReason.
                         * @memberof google.pubsub.v1.IngestionFailureEvent
                         * @interface IApiViolationReason
                         */
    
                        /**
                         * Constructs a new ApiViolationReason.
                         * @memberof google.pubsub.v1.IngestionFailureEvent
                         * @classdesc Represents an ApiViolationReason.
                         * @implements IApiViolationReason
                         * @constructor
                         * @param {google.pubsub.v1.IngestionFailureEvent.IApiViolationReason=} [properties] Properties to set
                         */
                        function ApiViolationReason(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Creates a new ApiViolationReason instance using the specified properties.
                         * @function create
                         * @memberof google.pubsub.v1.IngestionFailureEvent.ApiViolationReason
                         * @static
                         * @param {google.pubsub.v1.IngestionFailureEvent.IApiViolationReason=} [properties] Properties to set
                         * @returns {google.pubsub.v1.IngestionFailureEvent.ApiViolationReason} ApiViolationReason instance
                         */
                        ApiViolationReason.create = function create(properties) {
                            return new ApiViolationReason(properties);
                        };
    
                        /**
                         * Encodes the specified ApiViolationReason message. Does not implicitly {@link google.pubsub.v1.IngestionFailureEvent.ApiViolationReason.verify|verify} messages.
                         * @function encode
                         * @memberof google.pubsub.v1.IngestionFailureEvent.ApiViolationReason
                         * @static
                         * @param {google.pubsub.v1.IngestionFailureEvent.IApiViolationReason} message ApiViolationReason message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ApiViolationReason.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ApiViolationReason message, length delimited. Does not implicitly {@link google.pubsub.v1.IngestionFailureEvent.ApiViolationReason.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.pubsub.v1.IngestionFailureEvent.ApiViolationReason
                         * @static
                         * @param {google.pubsub.v1.IngestionFailureEvent.IApiViolationReason} message ApiViolationReason message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ApiViolationReason.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an ApiViolationReason message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.pubsub.v1.IngestionFailureEvent.ApiViolationReason
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.pubsub.v1.IngestionFailureEvent.ApiViolationReason} ApiViolationReason
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ApiViolationReason.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an ApiViolationReason message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.pubsub.v1.IngestionFailureEvent.ApiViolationReason
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.pubsub.v1.IngestionFailureEvent.ApiViolationReason} ApiViolationReason
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ApiViolationReason.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an ApiViolationReason message.
                         * @function verify
                         * @memberof google.pubsub.v1.IngestionFailureEvent.ApiViolationReason
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ApiViolationReason.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            return null;
                        };
    
                        /**
                         * Creates an ApiViolationReason message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.pubsub.v1.IngestionFailureEvent.ApiViolationReason
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.pubsub.v1.IngestionFailureEvent.ApiViolationReason} ApiViolationReason
                         */
                        ApiViolationReason.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason)
                                return object;
                            return new $root.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason();
                        };
    
                        /**
                         * Creates a plain object from an ApiViolationReason message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.pubsub.v1.IngestionFailureEvent.ApiViolationReason
                         * @static
                         * @param {google.pubsub.v1.IngestionFailureEvent.ApiViolationReason} message ApiViolationReason
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ApiViolationReason.toObject = function toObject() {
                            return {};
                        };
    
                        /**
                         * Converts this ApiViolationReason to JSON.
                         * @function toJSON
                         * @memberof google.pubsub.v1.IngestionFailureEvent.ApiViolationReason
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ApiViolationReason.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ApiViolationReason
                         * @function getTypeUrl
                         * @memberof google.pubsub.v1.IngestionFailureEvent.ApiViolationReason
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ApiViolationReason.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.pubsub.v1.IngestionFailureEvent.ApiViolationReason";
                        };
    
                        return ApiViolationReason;
                    })();
    
                    IngestionFailureEvent.AvroFailureReason = (function() {
    
                        /**
                         * Properties of an AvroFailureReason.
                         * @memberof google.pubsub.v1.IngestionFailureEvent
                         * @interface IAvroFailureReason
                         */
    
                        /**
                         * Constructs a new AvroFailureReason.
                         * @memberof google.pubsub.v1.IngestionFailureEvent
                         * @classdesc Represents an AvroFailureReason.
                         * @implements IAvroFailureReason
                         * @constructor
                         * @param {google.pubsub.v1.IngestionFailureEvent.IAvroFailureReason=} [properties] Properties to set
                         */
                        function AvroFailureReason(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Creates a new AvroFailureReason instance using the specified properties.
                         * @function create
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AvroFailureReason
                         * @static
                         * @param {google.pubsub.v1.IngestionFailureEvent.IAvroFailureReason=} [properties] Properties to set
                         * @returns {google.pubsub.v1.IngestionFailureEvent.AvroFailureReason} AvroFailureReason instance
                         */
                        AvroFailureReason.create = function create(properties) {
                            return new AvroFailureReason(properties);
                        };
    
                        /**
                         * Encodes the specified AvroFailureReason message. Does not implicitly {@link google.pubsub.v1.IngestionFailureEvent.AvroFailureReason.verify|verify} messages.
                         * @function encode
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AvroFailureReason
                         * @static
                         * @param {google.pubsub.v1.IngestionFailureEvent.IAvroFailureReason} message AvroFailureReason message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AvroFailureReason.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified AvroFailureReason message, length delimited. Does not implicitly {@link google.pubsub.v1.IngestionFailureEvent.AvroFailureReason.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AvroFailureReason
                         * @static
                         * @param {google.pubsub.v1.IngestionFailureEvent.IAvroFailureReason} message AvroFailureReason message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AvroFailureReason.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an AvroFailureReason message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AvroFailureReason
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.pubsub.v1.IngestionFailureEvent.AvroFailureReason} AvroFailureReason
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AvroFailureReason.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an AvroFailureReason message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AvroFailureReason
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.pubsub.v1.IngestionFailureEvent.AvroFailureReason} AvroFailureReason
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AvroFailureReason.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an AvroFailureReason message.
                         * @function verify
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AvroFailureReason
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AvroFailureReason.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            return null;
                        };
    
                        /**
                         * Creates an AvroFailureReason message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AvroFailureReason
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.pubsub.v1.IngestionFailureEvent.AvroFailureReason} AvroFailureReason
                         */
                        AvroFailureReason.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason)
                                return object;
                            return new $root.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason();
                        };
    
                        /**
                         * Creates a plain object from an AvroFailureReason message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AvroFailureReason
                         * @static
                         * @param {google.pubsub.v1.IngestionFailureEvent.AvroFailureReason} message AvroFailureReason
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AvroFailureReason.toObject = function toObject() {
                            return {};
                        };
    
                        /**
                         * Converts this AvroFailureReason to JSON.
                         * @function toJSON
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AvroFailureReason
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AvroFailureReason.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for AvroFailureReason
                         * @function getTypeUrl
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AvroFailureReason
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        AvroFailureReason.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.pubsub.v1.IngestionFailureEvent.AvroFailureReason";
                        };
    
                        return AvroFailureReason;
                    })();
    
                    IngestionFailureEvent.SchemaViolationReason = (function() {
    
                        /**
                         * Properties of a SchemaViolationReason.
                         * @memberof google.pubsub.v1.IngestionFailureEvent
                         * @interface ISchemaViolationReason
                         */
    
                        /**
                         * Constructs a new SchemaViolationReason.
                         * @memberof google.pubsub.v1.IngestionFailureEvent
                         * @classdesc Represents a SchemaViolationReason.
                         * @implements ISchemaViolationReason
                         * @constructor
                         * @param {google.pubsub.v1.IngestionFailureEvent.ISchemaViolationReason=} [properties] Properties to set
                         */
                        function SchemaViolationReason(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Creates a new SchemaViolationReason instance using the specified properties.
                         * @function create
                         * @memberof google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason
                         * @static
                         * @param {google.pubsub.v1.IngestionFailureEvent.ISchemaViolationReason=} [properties] Properties to set
                         * @returns {google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason} SchemaViolationReason instance
                         */
                        SchemaViolationReason.create = function create(properties) {
                            return new SchemaViolationReason(properties);
                        };
    
                        /**
                         * Encodes the specified SchemaViolationReason message. Does not implicitly {@link google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason.verify|verify} messages.
                         * @function encode
                         * @memberof google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason
                         * @static
                         * @param {google.pubsub.v1.IngestionFailureEvent.ISchemaViolationReason} message SchemaViolationReason message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SchemaViolationReason.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified SchemaViolationReason message, length delimited. Does not implicitly {@link google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason
                         * @static
                         * @param {google.pubsub.v1.IngestionFailureEvent.ISchemaViolationReason} message SchemaViolationReason message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SchemaViolationReason.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a SchemaViolationReason message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason} SchemaViolationReason
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SchemaViolationReason.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a SchemaViolationReason message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason} SchemaViolationReason
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SchemaViolationReason.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a SchemaViolationReason message.
                         * @function verify
                         * @memberof google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        SchemaViolationReason.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            return null;
                        };
    
                        /**
                         * Creates a SchemaViolationReason message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason} SchemaViolationReason
                         */
                        SchemaViolationReason.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason)
                                return object;
                            return new $root.google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason();
                        };
    
                        /**
                         * Creates a plain object from a SchemaViolationReason message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason
                         * @static
                         * @param {google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason} message SchemaViolationReason
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        SchemaViolationReason.toObject = function toObject() {
                            return {};
                        };
    
                        /**
                         * Converts this SchemaViolationReason to JSON.
                         * @function toJSON
                         * @memberof google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        SchemaViolationReason.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for SchemaViolationReason
                         * @function getTypeUrl
                         * @memberof google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        SchemaViolationReason.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason";
                        };
    
                        return SchemaViolationReason;
                    })();
    
                    IngestionFailureEvent.CloudStorageFailure = (function() {
    
                        /**
                         * Properties of a CloudStorageFailure.
                         * @memberof google.pubsub.v1.IngestionFailureEvent
                         * @interface ICloudStorageFailure
                         * @property {string|null} [bucket] CloudStorageFailure bucket
                         * @property {string|null} [objectName] CloudStorageFailure objectName
                         * @property {number|Long|null} [objectGeneration] CloudStorageFailure objectGeneration
                         * @property {google.pubsub.v1.IngestionFailureEvent.IAvroFailureReason|null} [avroFailureReason] CloudStorageFailure avroFailureReason
                         * @property {google.pubsub.v1.IngestionFailureEvent.IApiViolationReason|null} [apiViolationReason] CloudStorageFailure apiViolationReason
                         * @property {google.pubsub.v1.IngestionFailureEvent.ISchemaViolationReason|null} [schemaViolationReason] CloudStorageFailure schemaViolationReason
                         */
    
                        /**
                         * Constructs a new CloudStorageFailure.
                         * @memberof google.pubsub.v1.IngestionFailureEvent
                         * @classdesc Represents a CloudStorageFailure.
                         * @implements ICloudStorageFailure
                         * @constructor
                         * @param {google.pubsub.v1.IngestionFailureEvent.ICloudStorageFailure=} [properties] Properties to set
                         */
                        function CloudStorageFailure(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * CloudStorageFailure bucket.
                         * @member {string} bucket
                         * @memberof google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure
                         * @instance
                         */
                        CloudStorageFailure.prototype.bucket = "";
    
                        /**
                         * CloudStorageFailure objectName.
                         * @member {string} objectName
                         * @memberof google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure
                         * @instance
                         */
                        CloudStorageFailure.prototype.objectName = "";
    
                        /**
                         * CloudStorageFailure objectGeneration.
                         * @member {number|Long} objectGeneration
                         * @memberof google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure
                         * @instance
                         */
                        CloudStorageFailure.prototype.objectGeneration = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
    
                        /**
                         * CloudStorageFailure avroFailureReason.
                         * @member {google.pubsub.v1.IngestionFailureEvent.IAvroFailureReason|null|undefined} avroFailureReason
                         * @memberof google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure
                         * @instance
                         */
                        CloudStorageFailure.prototype.avroFailureReason = null;
    
                        /**
                         * CloudStorageFailure apiViolationReason.
                         * @member {google.pubsub.v1.IngestionFailureEvent.IApiViolationReason|null|undefined} apiViolationReason
                         * @memberof google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure
                         * @instance
                         */
                        CloudStorageFailure.prototype.apiViolationReason = null;
    
                        /**
                         * CloudStorageFailure schemaViolationReason.
                         * @member {google.pubsub.v1.IngestionFailureEvent.ISchemaViolationReason|null|undefined} schemaViolationReason
                         * @memberof google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure
                         * @instance
                         */
                        CloudStorageFailure.prototype.schemaViolationReason = null;
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * CloudStorageFailure reason.
                         * @member {"avroFailureReason"|"apiViolationReason"|"schemaViolationReason"|undefined} reason
                         * @memberof google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure
                         * @instance
                         */
                        Object.defineProperty(CloudStorageFailure.prototype, "reason", {
                            get: $util.oneOfGetter($oneOfFields = ["avroFailureReason", "apiViolationReason", "schemaViolationReason"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new CloudStorageFailure instance using the specified properties.
                         * @function create
                         * @memberof google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure
                         * @static
                         * @param {google.pubsub.v1.IngestionFailureEvent.ICloudStorageFailure=} [properties] Properties to set
                         * @returns {google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure} CloudStorageFailure instance
                         */
                        CloudStorageFailure.create = function create(properties) {
                            return new CloudStorageFailure(properties);
                        };
    
                        /**
                         * Encodes the specified CloudStorageFailure message. Does not implicitly {@link google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure.verify|verify} messages.
                         * @function encode
                         * @memberof google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure
                         * @static
                         * @param {google.pubsub.v1.IngestionFailureEvent.ICloudStorageFailure} message CloudStorageFailure message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CloudStorageFailure.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.bucket != null && Object.hasOwnProperty.call(message, "bucket"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.bucket);
                            if (message.objectName != null && Object.hasOwnProperty.call(message, "objectName"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.objectName);
                            if (message.objectGeneration != null && Object.hasOwnProperty.call(message, "objectGeneration"))
                                writer.uint32(/* id 3, wireType 0 =*/24).int64(message.objectGeneration);
                            if (message.avroFailureReason != null && Object.hasOwnProperty.call(message, "avroFailureReason"))
                                $root.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason.encode(message.avroFailureReason, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                            if (message.apiViolationReason != null && Object.hasOwnProperty.call(message, "apiViolationReason"))
                                $root.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason.encode(message.apiViolationReason, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                            if (message.schemaViolationReason != null && Object.hasOwnProperty.call(message, "schemaViolationReason"))
                                $root.google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason.encode(message.schemaViolationReason, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified CloudStorageFailure message, length delimited. Does not implicitly {@link google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure
                         * @static
                         * @param {google.pubsub.v1.IngestionFailureEvent.ICloudStorageFailure} message CloudStorageFailure message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CloudStorageFailure.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a CloudStorageFailure message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure} CloudStorageFailure
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CloudStorageFailure.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.bucket = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.objectName = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.objectGeneration = reader.int64();
                                        break;
                                    }
                                case 5: {
                                        message.avroFailureReason = $root.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 6: {
                                        message.apiViolationReason = $root.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 7: {
                                        message.schemaViolationReason = $root.google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a CloudStorageFailure message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure} CloudStorageFailure
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CloudStorageFailure.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a CloudStorageFailure message.
                         * @function verify
                         * @memberof google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CloudStorageFailure.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.bucket != null && message.hasOwnProperty("bucket"))
                                if (!$util.isString(message.bucket))
                                    return "bucket: string expected";
                            if (message.objectName != null && message.hasOwnProperty("objectName"))
                                if (!$util.isString(message.objectName))
                                    return "objectName: string expected";
                            if (message.objectGeneration != null && message.hasOwnProperty("objectGeneration"))
                                if (!$util.isInteger(message.objectGeneration) && !(message.objectGeneration && $util.isInteger(message.objectGeneration.low) && $util.isInteger(message.objectGeneration.high)))
                                    return "objectGeneration: integer|Long expected";
                            if (message.avroFailureReason != null && message.hasOwnProperty("avroFailureReason")) {
                                properties.reason = 1;
                                {
                                    var error = $root.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason.verify(message.avroFailureReason);
                                    if (error)
                                        return "avroFailureReason." + error;
                                }
                            }
                            if (message.apiViolationReason != null && message.hasOwnProperty("apiViolationReason")) {
                                if (properties.reason === 1)
                                    return "reason: multiple values";
                                properties.reason = 1;
                                {
                                    var error = $root.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason.verify(message.apiViolationReason);
                                    if (error)
                                        return "apiViolationReason." + error;
                                }
                            }
                            if (message.schemaViolationReason != null && message.hasOwnProperty("schemaViolationReason")) {
                                if (properties.reason === 1)
                                    return "reason: multiple values";
                                properties.reason = 1;
                                {
                                    var error = $root.google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason.verify(message.schemaViolationReason);
                                    if (error)
                                        return "schemaViolationReason." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates a CloudStorageFailure message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure} CloudStorageFailure
                         */
                        CloudStorageFailure.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure)
                                return object;
                            var message = new $root.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure();
                            if (object.bucket != null)
                                message.bucket = String(object.bucket);
                            if (object.objectName != null)
                                message.objectName = String(object.objectName);
                            if (object.objectGeneration != null)
                                if ($util.Long)
                                    (message.objectGeneration = $util.Long.fromValue(object.objectGeneration)).unsigned = false;
                                else if (typeof object.objectGeneration === "string")
                                    message.objectGeneration = parseInt(object.objectGeneration, 10);
                                else if (typeof object.objectGeneration === "number")
                                    message.objectGeneration = object.objectGeneration;
                                else if (typeof object.objectGeneration === "object")
                                    message.objectGeneration = new $util.LongBits(object.objectGeneration.low >>> 0, object.objectGeneration.high >>> 0).toNumber();
                            if (object.avroFailureReason != null) {
                                if (typeof object.avroFailureReason !== "object")
                                    throw TypeError(".google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure.avroFailureReason: object expected");
                                message.avroFailureReason = $root.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason.fromObject(object.avroFailureReason);
                            }
                            if (object.apiViolationReason != null) {
                                if (typeof object.apiViolationReason !== "object")
                                    throw TypeError(".google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure.apiViolationReason: object expected");
                                message.apiViolationReason = $root.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason.fromObject(object.apiViolationReason);
                            }
                            if (object.schemaViolationReason != null) {
                                if (typeof object.schemaViolationReason !== "object")
                                    throw TypeError(".google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure.schemaViolationReason: object expected");
                                message.schemaViolationReason = $root.google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason.fromObject(object.schemaViolationReason);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a CloudStorageFailure message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure
                         * @static
                         * @param {google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure} message CloudStorageFailure
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CloudStorageFailure.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.bucket = "";
                                object.objectName = "";
                                if ($util.Long) {
                                    var long = new $util.Long(0, 0, false);
                                    object.objectGeneration = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                                } else
                                    object.objectGeneration = options.longs === String ? "0" : 0;
                            }
                            if (message.bucket != null && message.hasOwnProperty("bucket"))
                                object.bucket = message.bucket;
                            if (message.objectName != null && message.hasOwnProperty("objectName"))
                                object.objectName = message.objectName;
                            if (message.objectGeneration != null && message.hasOwnProperty("objectGeneration"))
                                if (typeof message.objectGeneration === "number")
                                    object.objectGeneration = options.longs === String ? String(message.objectGeneration) : message.objectGeneration;
                                else
                                    object.objectGeneration = options.longs === String ? $util.Long.prototype.toString.call(message.objectGeneration) : options.longs === Number ? new $util.LongBits(message.objectGeneration.low >>> 0, message.objectGeneration.high >>> 0).toNumber() : message.objectGeneration;
                            if (message.avroFailureReason != null && message.hasOwnProperty("avroFailureReason")) {
                                object.avroFailureReason = $root.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason.toObject(message.avroFailureReason, options);
                                if (options.oneofs)
                                    object.reason = "avroFailureReason";
                            }
                            if (message.apiViolationReason != null && message.hasOwnProperty("apiViolationReason")) {
                                object.apiViolationReason = $root.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason.toObject(message.apiViolationReason, options);
                                if (options.oneofs)
                                    object.reason = "apiViolationReason";
                            }
                            if (message.schemaViolationReason != null && message.hasOwnProperty("schemaViolationReason")) {
                                object.schemaViolationReason = $root.google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason.toObject(message.schemaViolationReason, options);
                                if (options.oneofs)
                                    object.reason = "schemaViolationReason";
                            }
                            return object;
                        };
    
                        /**
                         * Converts this CloudStorageFailure to JSON.
                         * @function toJSON
                         * @memberof google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CloudStorageFailure.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for CloudStorageFailure
                         * @function getTypeUrl
                         * @memberof google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        CloudStorageFailure.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure";
                        };
    
                        return CloudStorageFailure;
                    })();
    
                    IngestionFailureEvent.AwsMskFailureReason = (function() {
    
                        /**
                         * Properties of an AwsMskFailureReason.
                         * @memberof google.pubsub.v1.IngestionFailureEvent
                         * @interface IAwsMskFailureReason
                         * @property {string|null} [clusterArn] AwsMskFailureReason clusterArn
                         * @property {string|null} [kafkaTopic] AwsMskFailureReason kafkaTopic
                         * @property {number|Long|null} [partitionId] AwsMskFailureReason partitionId
                         * @property {number|Long|null} [offset] AwsMskFailureReason offset
                         * @property {google.pubsub.v1.IngestionFailureEvent.IApiViolationReason|null} [apiViolationReason] AwsMskFailureReason apiViolationReason
                         * @property {google.pubsub.v1.IngestionFailureEvent.ISchemaViolationReason|null} [schemaViolationReason] AwsMskFailureReason schemaViolationReason
                         */
    
                        /**
                         * Constructs a new AwsMskFailureReason.
                         * @memberof google.pubsub.v1.IngestionFailureEvent
                         * @classdesc Represents an AwsMskFailureReason.
                         * @implements IAwsMskFailureReason
                         * @constructor
                         * @param {google.pubsub.v1.IngestionFailureEvent.IAwsMskFailureReason=} [properties] Properties to set
                         */
                        function AwsMskFailureReason(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * AwsMskFailureReason clusterArn.
                         * @member {string} clusterArn
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AwsMskFailureReason
                         * @instance
                         */
                        AwsMskFailureReason.prototype.clusterArn = "";
    
                        /**
                         * AwsMskFailureReason kafkaTopic.
                         * @member {string} kafkaTopic
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AwsMskFailureReason
                         * @instance
                         */
                        AwsMskFailureReason.prototype.kafkaTopic = "";
    
                        /**
                         * AwsMskFailureReason partitionId.
                         * @member {number|Long} partitionId
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AwsMskFailureReason
                         * @instance
                         */
                        AwsMskFailureReason.prototype.partitionId = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
    
                        /**
                         * AwsMskFailureReason offset.
                         * @member {number|Long} offset
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AwsMskFailureReason
                         * @instance
                         */
                        AwsMskFailureReason.prototype.offset = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
    
                        /**
                         * AwsMskFailureReason apiViolationReason.
                         * @member {google.pubsub.v1.IngestionFailureEvent.IApiViolationReason|null|undefined} apiViolationReason
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AwsMskFailureReason
                         * @instance
                         */
                        AwsMskFailureReason.prototype.apiViolationReason = null;
    
                        /**
                         * AwsMskFailureReason schemaViolationReason.
                         * @member {google.pubsub.v1.IngestionFailureEvent.ISchemaViolationReason|null|undefined} schemaViolationReason
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AwsMskFailureReason
                         * @instance
                         */
                        AwsMskFailureReason.prototype.schemaViolationReason = null;
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * AwsMskFailureReason reason.
                         * @member {"apiViolationReason"|"schemaViolationReason"|undefined} reason
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AwsMskFailureReason
                         * @instance
                         */
                        Object.defineProperty(AwsMskFailureReason.prototype, "reason", {
                            get: $util.oneOfGetter($oneOfFields = ["apiViolationReason", "schemaViolationReason"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new AwsMskFailureReason instance using the specified properties.
                         * @function create
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AwsMskFailureReason
                         * @static
                         * @param {google.pubsub.v1.IngestionFailureEvent.IAwsMskFailureReason=} [properties] Properties to set
                         * @returns {google.pubsub.v1.IngestionFailureEvent.AwsMskFailureReason} AwsMskFailureReason instance
                         */
                        AwsMskFailureReason.create = function create(properties) {
                            return new AwsMskFailureReason(properties);
                        };
    
                        /**
                         * Encodes the specified AwsMskFailureReason message. Does not implicitly {@link google.pubsub.v1.IngestionFailureEvent.AwsMskFailureReason.verify|verify} messages.
                         * @function encode
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AwsMskFailureReason
                         * @static
                         * @param {google.pubsub.v1.IngestionFailureEvent.IAwsMskFailureReason} message AwsMskFailureReason message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AwsMskFailureReason.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.clusterArn != null && Object.hasOwnProperty.call(message, "clusterArn"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.clusterArn);
                            if (message.kafkaTopic != null && Object.hasOwnProperty.call(message, "kafkaTopic"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.kafkaTopic);
                            if (message.partitionId != null && Object.hasOwnProperty.call(message, "partitionId"))
                                writer.uint32(/* id 3, wireType 0 =*/24).int64(message.partitionId);
                            if (message.offset != null && Object.hasOwnProperty.call(message, "offset"))
                                writer.uint32(/* id 4, wireType 0 =*/32).int64(message.offset);
                            if (message.apiViolationReason != null && Object.hasOwnProperty.call(message, "apiViolationReason"))
                                $root.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason.encode(message.apiViolationReason, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                            if (message.schemaViolationReason != null && Object.hasOwnProperty.call(message, "schemaViolationReason"))
                                $root.google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason.encode(message.schemaViolationReason, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified AwsMskFailureReason message, length delimited. Does not implicitly {@link google.pubsub.v1.IngestionFailureEvent.AwsMskFailureReason.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AwsMskFailureReason
                         * @static
                         * @param {google.pubsub.v1.IngestionFailureEvent.IAwsMskFailureReason} message AwsMskFailureReason message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AwsMskFailureReason.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an AwsMskFailureReason message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AwsMskFailureReason
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.pubsub.v1.IngestionFailureEvent.AwsMskFailureReason} AwsMskFailureReason
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AwsMskFailureReason.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.IngestionFailureEvent.AwsMskFailureReason();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.clusterArn = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.kafkaTopic = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.partitionId = reader.int64();
                                        break;
                                    }
                                case 4: {
                                        message.offset = reader.int64();
                                        break;
                                    }
                                case 5: {
                                        message.apiViolationReason = $root.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 6: {
                                        message.schemaViolationReason = $root.google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an AwsMskFailureReason message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AwsMskFailureReason
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.pubsub.v1.IngestionFailureEvent.AwsMskFailureReason} AwsMskFailureReason
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AwsMskFailureReason.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an AwsMskFailureReason message.
                         * @function verify
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AwsMskFailureReason
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AwsMskFailureReason.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.clusterArn != null && message.hasOwnProperty("clusterArn"))
                                if (!$util.isString(message.clusterArn))
                                    return "clusterArn: string expected";
                            if (message.kafkaTopic != null && message.hasOwnProperty("kafkaTopic"))
                                if (!$util.isString(message.kafkaTopic))
                                    return "kafkaTopic: string expected";
                            if (message.partitionId != null && message.hasOwnProperty("partitionId"))
                                if (!$util.isInteger(message.partitionId) && !(message.partitionId && $util.isInteger(message.partitionId.low) && $util.isInteger(message.partitionId.high)))
                                    return "partitionId: integer|Long expected";
                            if (message.offset != null && message.hasOwnProperty("offset"))
                                if (!$util.isInteger(message.offset) && !(message.offset && $util.isInteger(message.offset.low) && $util.isInteger(message.offset.high)))
                                    return "offset: integer|Long expected";
                            if (message.apiViolationReason != null && message.hasOwnProperty("apiViolationReason")) {
                                properties.reason = 1;
                                {
                                    var error = $root.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason.verify(message.apiViolationReason);
                                    if (error)
                                        return "apiViolationReason." + error;
                                }
                            }
                            if (message.schemaViolationReason != null && message.hasOwnProperty("schemaViolationReason")) {
                                if (properties.reason === 1)
                                    return "reason: multiple values";
                                properties.reason = 1;
                                {
                                    var error = $root.google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason.verify(message.schemaViolationReason);
                                    if (error)
                                        return "schemaViolationReason." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates an AwsMskFailureReason message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AwsMskFailureReason
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.pubsub.v1.IngestionFailureEvent.AwsMskFailureReason} AwsMskFailureReason
                         */
                        AwsMskFailureReason.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.pubsub.v1.IngestionFailureEvent.AwsMskFailureReason)
                                return object;
                            var message = new $root.google.pubsub.v1.IngestionFailureEvent.AwsMskFailureReason();
                            if (object.clusterArn != null)
                                message.clusterArn = String(object.clusterArn);
                            if (object.kafkaTopic != null)
                                message.kafkaTopic = String(object.kafkaTopic);
                            if (object.partitionId != null)
                                if ($util.Long)
                                    (message.partitionId = $util.Long.fromValue(object.partitionId)).unsigned = false;
                                else if (typeof object.partitionId === "string")
                                    message.partitionId = parseInt(object.partitionId, 10);
                                else if (typeof object.partitionId === "number")
                                    message.partitionId = object.partitionId;
                                else if (typeof object.partitionId === "object")
                                    message.partitionId = new $util.LongBits(object.partitionId.low >>> 0, object.partitionId.high >>> 0).toNumber();
                            if (object.offset != null)
                                if ($util.Long)
                                    (message.offset = $util.Long.fromValue(object.offset)).unsigned = false;
                                else if (typeof object.offset === "string")
                                    message.offset = parseInt(object.offset, 10);
                                else if (typeof object.offset === "number")
                                    message.offset = object.offset;
                                else if (typeof object.offset === "object")
                                    message.offset = new $util.LongBits(object.offset.low >>> 0, object.offset.high >>> 0).toNumber();
                            if (object.apiViolationReason != null) {
                                if (typeof object.apiViolationReason !== "object")
                                    throw TypeError(".google.pubsub.v1.IngestionFailureEvent.AwsMskFailureReason.apiViolationReason: object expected");
                                message.apiViolationReason = $root.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason.fromObject(object.apiViolationReason);
                            }
                            if (object.schemaViolationReason != null) {
                                if (typeof object.schemaViolationReason !== "object")
                                    throw TypeError(".google.pubsub.v1.IngestionFailureEvent.AwsMskFailureReason.schemaViolationReason: object expected");
                                message.schemaViolationReason = $root.google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason.fromObject(object.schemaViolationReason);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an AwsMskFailureReason message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AwsMskFailureReason
                         * @static
                         * @param {google.pubsub.v1.IngestionFailureEvent.AwsMskFailureReason} message AwsMskFailureReason
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AwsMskFailureReason.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.clusterArn = "";
                                object.kafkaTopic = "";
                                if ($util.Long) {
                                    var long = new $util.Long(0, 0, false);
                                    object.partitionId = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                                } else
                                    object.partitionId = options.longs === String ? "0" : 0;
                                if ($util.Long) {
                                    var long = new $util.Long(0, 0, false);
                                    object.offset = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                                } else
                                    object.offset = options.longs === String ? "0" : 0;
                            }
                            if (message.clusterArn != null && message.hasOwnProperty("clusterArn"))
                                object.clusterArn = message.clusterArn;
                            if (message.kafkaTopic != null && message.hasOwnProperty("kafkaTopic"))
                                object.kafkaTopic = message.kafkaTopic;
                            if (message.partitionId != null && message.hasOwnProperty("partitionId"))
                                if (typeof message.partitionId === "number")
                                    object.partitionId = options.longs === String ? String(message.partitionId) : message.partitionId;
                                else
                                    object.partitionId = options.longs === String ? $util.Long.prototype.toString.call(message.partitionId) : options.longs === Number ? new $util.LongBits(message.partitionId.low >>> 0, message.partitionId.high >>> 0).toNumber() : message.partitionId;
                            if (message.offset != null && message.hasOwnProperty("offset"))
                                if (typeof message.offset === "number")
                                    object.offset = options.longs === String ? String(message.offset) : message.offset;
                                else
                                    object.offset = options.longs === String ? $util.Long.prototype.toString.call(message.offset) : options.longs === Number ? new $util.LongBits(message.offset.low >>> 0, message.offset.high >>> 0).toNumber() : message.offset;
                            if (message.apiViolationReason != null && message.hasOwnProperty("apiViolationReason")) {
                                object.apiViolationReason = $root.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason.toObject(message.apiViolationReason, options);
                                if (options.oneofs)
                                    object.reason = "apiViolationReason";
                            }
                            if (message.schemaViolationReason != null && message.hasOwnProperty("schemaViolationReason")) {
                                object.schemaViolationReason = $root.google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason.toObject(message.schemaViolationReason, options);
                                if (options.oneofs)
                                    object.reason = "schemaViolationReason";
                            }
                            return object;
                        };
    
                        /**
                         * Converts this AwsMskFailureReason to JSON.
                         * @function toJSON
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AwsMskFailureReason
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AwsMskFailureReason.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for AwsMskFailureReason
                         * @function getTypeUrl
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AwsMskFailureReason
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        AwsMskFailureReason.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.pubsub.v1.IngestionFailureEvent.AwsMskFailureReason";
                        };
    
                        return AwsMskFailureReason;
                    })();
    
                    IngestionFailureEvent.AzureEventHubsFailureReason = (function() {
    
                        /**
                         * Properties of an AzureEventHubsFailureReason.
                         * @memberof google.pubsub.v1.IngestionFailureEvent
                         * @interface IAzureEventHubsFailureReason
                         * @property {string|null} [namespace] AzureEventHubsFailureReason namespace
                         * @property {string|null} [eventHub] AzureEventHubsFailureReason eventHub
                         * @property {number|Long|null} [partitionId] AzureEventHubsFailureReason partitionId
                         * @property {number|Long|null} [offset] AzureEventHubsFailureReason offset
                         * @property {google.pubsub.v1.IngestionFailureEvent.IApiViolationReason|null} [apiViolationReason] AzureEventHubsFailureReason apiViolationReason
                         * @property {google.pubsub.v1.IngestionFailureEvent.ISchemaViolationReason|null} [schemaViolationReason] AzureEventHubsFailureReason schemaViolationReason
                         */
    
                        /**
                         * Constructs a new AzureEventHubsFailureReason.
                         * @memberof google.pubsub.v1.IngestionFailureEvent
                         * @classdesc Represents an AzureEventHubsFailureReason.
                         * @implements IAzureEventHubsFailureReason
                         * @constructor
                         * @param {google.pubsub.v1.IngestionFailureEvent.IAzureEventHubsFailureReason=} [properties] Properties to set
                         */
                        function AzureEventHubsFailureReason(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * AzureEventHubsFailureReason namespace.
                         * @member {string} namespace
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AzureEventHubsFailureReason
                         * @instance
                         */
                        AzureEventHubsFailureReason.prototype.namespace = "";
    
                        /**
                         * AzureEventHubsFailureReason eventHub.
                         * @member {string} eventHub
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AzureEventHubsFailureReason
                         * @instance
                         */
                        AzureEventHubsFailureReason.prototype.eventHub = "";
    
                        /**
                         * AzureEventHubsFailureReason partitionId.
                         * @member {number|Long} partitionId
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AzureEventHubsFailureReason
                         * @instance
                         */
                        AzureEventHubsFailureReason.prototype.partitionId = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
    
                        /**
                         * AzureEventHubsFailureReason offset.
                         * @member {number|Long} offset
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AzureEventHubsFailureReason
                         * @instance
                         */
                        AzureEventHubsFailureReason.prototype.offset = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
    
                        /**
                         * AzureEventHubsFailureReason apiViolationReason.
                         * @member {google.pubsub.v1.IngestionFailureEvent.IApiViolationReason|null|undefined} apiViolationReason
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AzureEventHubsFailureReason
                         * @instance
                         */
                        AzureEventHubsFailureReason.prototype.apiViolationReason = null;
    
                        /**
                         * AzureEventHubsFailureReason schemaViolationReason.
                         * @member {google.pubsub.v1.IngestionFailureEvent.ISchemaViolationReason|null|undefined} schemaViolationReason
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AzureEventHubsFailureReason
                         * @instance
                         */
                        AzureEventHubsFailureReason.prototype.schemaViolationReason = null;
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * AzureEventHubsFailureReason reason.
                         * @member {"apiViolationReason"|"schemaViolationReason"|undefined} reason
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AzureEventHubsFailureReason
                         * @instance
                         */
                        Object.defineProperty(AzureEventHubsFailureReason.prototype, "reason", {
                            get: $util.oneOfGetter($oneOfFields = ["apiViolationReason", "schemaViolationReason"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new AzureEventHubsFailureReason instance using the specified properties.
                         * @function create
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AzureEventHubsFailureReason
                         * @static
                         * @param {google.pubsub.v1.IngestionFailureEvent.IAzureEventHubsFailureReason=} [properties] Properties to set
                         * @returns {google.pubsub.v1.IngestionFailureEvent.AzureEventHubsFailureReason} AzureEventHubsFailureReason instance
                         */
                        AzureEventHubsFailureReason.create = function create(properties) {
                            return new AzureEventHubsFailureReason(properties);
                        };
    
                        /**
                         * Encodes the specified AzureEventHubsFailureReason message. Does not implicitly {@link google.pubsub.v1.IngestionFailureEvent.AzureEventHubsFailureReason.verify|verify} messages.
                         * @function encode
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AzureEventHubsFailureReason
                         * @static
                         * @param {google.pubsub.v1.IngestionFailureEvent.IAzureEventHubsFailureReason} message AzureEventHubsFailureReason message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AzureEventHubsFailureReason.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.namespace != null && Object.hasOwnProperty.call(message, "namespace"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.namespace);
                            if (message.eventHub != null && Object.hasOwnProperty.call(message, "eventHub"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.eventHub);
                            if (message.partitionId != null && Object.hasOwnProperty.call(message, "partitionId"))
                                writer.uint32(/* id 3, wireType 0 =*/24).int64(message.partitionId);
                            if (message.offset != null && Object.hasOwnProperty.call(message, "offset"))
                                writer.uint32(/* id 4, wireType 0 =*/32).int64(message.offset);
                            if (message.apiViolationReason != null && Object.hasOwnProperty.call(message, "apiViolationReason"))
                                $root.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason.encode(message.apiViolationReason, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                            if (message.schemaViolationReason != null && Object.hasOwnProperty.call(message, "schemaViolationReason"))
                                $root.google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason.encode(message.schemaViolationReason, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified AzureEventHubsFailureReason message, length delimited. Does not implicitly {@link google.pubsub.v1.IngestionFailureEvent.AzureEventHubsFailureReason.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AzureEventHubsFailureReason
                         * @static
                         * @param {google.pubsub.v1.IngestionFailureEvent.IAzureEventHubsFailureReason} message AzureEventHubsFailureReason message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AzureEventHubsFailureReason.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an AzureEventHubsFailureReason message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AzureEventHubsFailureReason
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.pubsub.v1.IngestionFailureEvent.AzureEventHubsFailureReason} AzureEventHubsFailureReason
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AzureEventHubsFailureReason.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.IngestionFailureEvent.AzureEventHubsFailureReason();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.namespace = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.eventHub = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.partitionId = reader.int64();
                                        break;
                                    }
                                case 4: {
                                        message.offset = reader.int64();
                                        break;
                                    }
                                case 5: {
                                        message.apiViolationReason = $root.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 6: {
                                        message.schemaViolationReason = $root.google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an AzureEventHubsFailureReason message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AzureEventHubsFailureReason
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.pubsub.v1.IngestionFailureEvent.AzureEventHubsFailureReason} AzureEventHubsFailureReason
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AzureEventHubsFailureReason.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an AzureEventHubsFailureReason message.
                         * @function verify
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AzureEventHubsFailureReason
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AzureEventHubsFailureReason.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.namespace != null && message.hasOwnProperty("namespace"))
                                if (!$util.isString(message.namespace))
                                    return "namespace: string expected";
                            if (message.eventHub != null && message.hasOwnProperty("eventHub"))
                                if (!$util.isString(message.eventHub))
                                    return "eventHub: string expected";
                            if (message.partitionId != null && message.hasOwnProperty("partitionId"))
                                if (!$util.isInteger(message.partitionId) && !(message.partitionId && $util.isInteger(message.partitionId.low) && $util.isInteger(message.partitionId.high)))
                                    return "partitionId: integer|Long expected";
                            if (message.offset != null && message.hasOwnProperty("offset"))
                                if (!$util.isInteger(message.offset) && !(message.offset && $util.isInteger(message.offset.low) && $util.isInteger(message.offset.high)))
                                    return "offset: integer|Long expected";
                            if (message.apiViolationReason != null && message.hasOwnProperty("apiViolationReason")) {
                                properties.reason = 1;
                                {
                                    var error = $root.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason.verify(message.apiViolationReason);
                                    if (error)
                                        return "apiViolationReason." + error;
                                }
                            }
                            if (message.schemaViolationReason != null && message.hasOwnProperty("schemaViolationReason")) {
                                if (properties.reason === 1)
                                    return "reason: multiple values";
                                properties.reason = 1;
                                {
                                    var error = $root.google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason.verify(message.schemaViolationReason);
                                    if (error)
                                        return "schemaViolationReason." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates an AzureEventHubsFailureReason message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AzureEventHubsFailureReason
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.pubsub.v1.IngestionFailureEvent.AzureEventHubsFailureReason} AzureEventHubsFailureReason
                         */
                        AzureEventHubsFailureReason.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.pubsub.v1.IngestionFailureEvent.AzureEventHubsFailureReason)
                                return object;
                            var message = new $root.google.pubsub.v1.IngestionFailureEvent.AzureEventHubsFailureReason();
                            if (object.namespace != null)
                                message.namespace = String(object.namespace);
                            if (object.eventHub != null)
                                message.eventHub = String(object.eventHub);
                            if (object.partitionId != null)
                                if ($util.Long)
                                    (message.partitionId = $util.Long.fromValue(object.partitionId)).unsigned = false;
                                else if (typeof object.partitionId === "string")
                                    message.partitionId = parseInt(object.partitionId, 10);
                                else if (typeof object.partitionId === "number")
                                    message.partitionId = object.partitionId;
                                else if (typeof object.partitionId === "object")
                                    message.partitionId = new $util.LongBits(object.partitionId.low >>> 0, object.partitionId.high >>> 0).toNumber();
                            if (object.offset != null)
                                if ($util.Long)
                                    (message.offset = $util.Long.fromValue(object.offset)).unsigned = false;
                                else if (typeof object.offset === "string")
                                    message.offset = parseInt(object.offset, 10);
                                else if (typeof object.offset === "number")
                                    message.offset = object.offset;
                                else if (typeof object.offset === "object")
                                    message.offset = new $util.LongBits(object.offset.low >>> 0, object.offset.high >>> 0).toNumber();
                            if (object.apiViolationReason != null) {
                                if (typeof object.apiViolationReason !== "object")
                                    throw TypeError(".google.pubsub.v1.IngestionFailureEvent.AzureEventHubsFailureReason.apiViolationReason: object expected");
                                message.apiViolationReason = $root.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason.fromObject(object.apiViolationReason);
                            }
                            if (object.schemaViolationReason != null) {
                                if (typeof object.schemaViolationReason !== "object")
                                    throw TypeError(".google.pubsub.v1.IngestionFailureEvent.AzureEventHubsFailureReason.schemaViolationReason: object expected");
                                message.schemaViolationReason = $root.google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason.fromObject(object.schemaViolationReason);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an AzureEventHubsFailureReason message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AzureEventHubsFailureReason
                         * @static
                         * @param {google.pubsub.v1.IngestionFailureEvent.AzureEventHubsFailureReason} message AzureEventHubsFailureReason
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AzureEventHubsFailureReason.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.namespace = "";
                                object.eventHub = "";
                                if ($util.Long) {
                                    var long = new $util.Long(0, 0, false);
                                    object.partitionId = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                                } else
                                    object.partitionId = options.longs === String ? "0" : 0;
                                if ($util.Long) {
                                    var long = new $util.Long(0, 0, false);
                                    object.offset = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                                } else
                                    object.offset = options.longs === String ? "0" : 0;
                            }
                            if (message.namespace != null && message.hasOwnProperty("namespace"))
                                object.namespace = message.namespace;
                            if (message.eventHub != null && message.hasOwnProperty("eventHub"))
                                object.eventHub = message.eventHub;
                            if (message.partitionId != null && message.hasOwnProperty("partitionId"))
                                if (typeof message.partitionId === "number")
                                    object.partitionId = options.longs === String ? String(message.partitionId) : message.partitionId;
                                else
                                    object.partitionId = options.longs === String ? $util.Long.prototype.toString.call(message.partitionId) : options.longs === Number ? new $util.LongBits(message.partitionId.low >>> 0, message.partitionId.high >>> 0).toNumber() : message.partitionId;
                            if (message.offset != null && message.hasOwnProperty("offset"))
                                if (typeof message.offset === "number")
                                    object.offset = options.longs === String ? String(message.offset) : message.offset;
                                else
                                    object.offset = options.longs === String ? $util.Long.prototype.toString.call(message.offset) : options.longs === Number ? new $util.LongBits(message.offset.low >>> 0, message.offset.high >>> 0).toNumber() : message.offset;
                            if (message.apiViolationReason != null && message.hasOwnProperty("apiViolationReason")) {
                                object.apiViolationReason = $root.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason.toObject(message.apiViolationReason, options);
                                if (options.oneofs)
                                    object.reason = "apiViolationReason";
                            }
                            if (message.schemaViolationReason != null && message.hasOwnProperty("schemaViolationReason")) {
                                object.schemaViolationReason = $root.google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason.toObject(message.schemaViolationReason, options);
                                if (options.oneofs)
                                    object.reason = "schemaViolationReason";
                            }
                            return object;
                        };
    
                        /**
                         * Converts this AzureEventHubsFailureReason to JSON.
                         * @function toJSON
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AzureEventHubsFailureReason
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AzureEventHubsFailureReason.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for AzureEventHubsFailureReason
                         * @function getTypeUrl
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AzureEventHubsFailureReason
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        AzureEventHubsFailureReason.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.pubsub.v1.IngestionFailureEvent.AzureEventHubsFailureReason";
                        };
    
                        return AzureEventHubsFailureReason;
                    })();
    
                    IngestionFailureEvent.ConfluentCloudFailureReason = (function() {
    
                        /**
                         * Properties of a ConfluentCloudFailureReason.
                         * @memberof google.pubsub.v1.IngestionFailureEvent
                         * @interface IConfluentCloudFailureReason
                         * @property {string|null} [clusterId] ConfluentCloudFailureReason clusterId
                         * @property {string|null} [kafkaTopic] ConfluentCloudFailureReason kafkaTopic
                         * @property {number|Long|null} [partitionId] ConfluentCloudFailureReason partitionId
                         * @property {number|Long|null} [offset] ConfluentCloudFailureReason offset
                         * @property {google.pubsub.v1.IngestionFailureEvent.IApiViolationReason|null} [apiViolationReason] ConfluentCloudFailureReason apiViolationReason
                         * @property {google.pubsub.v1.IngestionFailureEvent.ISchemaViolationReason|null} [schemaViolationReason] ConfluentCloudFailureReason schemaViolationReason
                         */
    
                        /**
                         * Constructs a new ConfluentCloudFailureReason.
                         * @memberof google.pubsub.v1.IngestionFailureEvent
                         * @classdesc Represents a ConfluentCloudFailureReason.
                         * @implements IConfluentCloudFailureReason
                         * @constructor
                         * @param {google.pubsub.v1.IngestionFailureEvent.IConfluentCloudFailureReason=} [properties] Properties to set
                         */
                        function ConfluentCloudFailureReason(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ConfluentCloudFailureReason clusterId.
                         * @member {string} clusterId
                         * @memberof google.pubsub.v1.IngestionFailureEvent.ConfluentCloudFailureReason
                         * @instance
                         */
                        ConfluentCloudFailureReason.prototype.clusterId = "";
    
                        /**
                         * ConfluentCloudFailureReason kafkaTopic.
                         * @member {string} kafkaTopic
                         * @memberof google.pubsub.v1.IngestionFailureEvent.ConfluentCloudFailureReason
                         * @instance
                         */
                        ConfluentCloudFailureReason.prototype.kafkaTopic = "";
    
                        /**
                         * ConfluentCloudFailureReason partitionId.
                         * @member {number|Long} partitionId
                         * @memberof google.pubsub.v1.IngestionFailureEvent.ConfluentCloudFailureReason
                         * @instance
                         */
                        ConfluentCloudFailureReason.prototype.partitionId = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
    
                        /**
                         * ConfluentCloudFailureReason offset.
                         * @member {number|Long} offset
                         * @memberof google.pubsub.v1.IngestionFailureEvent.ConfluentCloudFailureReason
                         * @instance
                         */
                        ConfluentCloudFailureReason.prototype.offset = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
    
                        /**
                         * ConfluentCloudFailureReason apiViolationReason.
                         * @member {google.pubsub.v1.IngestionFailureEvent.IApiViolationReason|null|undefined} apiViolationReason
                         * @memberof google.pubsub.v1.IngestionFailureEvent.ConfluentCloudFailureReason
                         * @instance
                         */
                        ConfluentCloudFailureReason.prototype.apiViolationReason = null;
    
                        /**
                         * ConfluentCloudFailureReason schemaViolationReason.
                         * @member {google.pubsub.v1.IngestionFailureEvent.ISchemaViolationReason|null|undefined} schemaViolationReason
                         * @memberof google.pubsub.v1.IngestionFailureEvent.ConfluentCloudFailureReason
                         * @instance
                         */
                        ConfluentCloudFailureReason.prototype.schemaViolationReason = null;
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * ConfluentCloudFailureReason reason.
                         * @member {"apiViolationReason"|"schemaViolationReason"|undefined} reason
                         * @memberof google.pubsub.v1.IngestionFailureEvent.ConfluentCloudFailureReason
                         * @instance
                         */
                        Object.defineProperty(ConfluentCloudFailureReason.prototype, "reason", {
                            get: $util.oneOfGetter($oneOfFields = ["apiViolationReason", "schemaViolationReason"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new ConfluentCloudFailureReason instance using the specified properties.
                         * @function create
                         * @memberof google.pubsub.v1.IngestionFailureEvent.ConfluentCloudFailureReason
                         * @static
                         * @param {google.pubsub.v1.IngestionFailureEvent.IConfluentCloudFailureReason=} [properties] Properties to set
                         * @returns {google.pubsub.v1.IngestionFailureEvent.ConfluentCloudFailureReason} ConfluentCloudFailureReason instance
                         */
                        ConfluentCloudFailureReason.create = function create(properties) {
                            return new ConfluentCloudFailureReason(properties);
                        };
    
                        /**
                         * Encodes the specified ConfluentCloudFailureReason message. Does not implicitly {@link google.pubsub.v1.IngestionFailureEvent.ConfluentCloudFailureReason.verify|verify} messages.
                         * @function encode
                         * @memberof google.pubsub.v1.IngestionFailureEvent.ConfluentCloudFailureReason
                         * @static
                         * @param {google.pubsub.v1.IngestionFailureEvent.IConfluentCloudFailureReason} message ConfluentCloudFailureReason message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ConfluentCloudFailureReason.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.clusterId != null && Object.hasOwnProperty.call(message, "clusterId"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.clusterId);
                            if (message.kafkaTopic != null && Object.hasOwnProperty.call(message, "kafkaTopic"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.kafkaTopic);
                            if (message.partitionId != null && Object.hasOwnProperty.call(message, "partitionId"))
                                writer.uint32(/* id 3, wireType 0 =*/24).int64(message.partitionId);
                            if (message.offset != null && Object.hasOwnProperty.call(message, "offset"))
                                writer.uint32(/* id 4, wireType 0 =*/32).int64(message.offset);
                            if (message.apiViolationReason != null && Object.hasOwnProperty.call(message, "apiViolationReason"))
                                $root.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason.encode(message.apiViolationReason, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                            if (message.schemaViolationReason != null && Object.hasOwnProperty.call(message, "schemaViolationReason"))
                                $root.google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason.encode(message.schemaViolationReason, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ConfluentCloudFailureReason message, length delimited. Does not implicitly {@link google.pubsub.v1.IngestionFailureEvent.ConfluentCloudFailureReason.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.pubsub.v1.IngestionFailureEvent.ConfluentCloudFailureReason
                         * @static
                         * @param {google.pubsub.v1.IngestionFailureEvent.IConfluentCloudFailureReason} message ConfluentCloudFailureReason message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ConfluentCloudFailureReason.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ConfluentCloudFailureReason message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.pubsub.v1.IngestionFailureEvent.ConfluentCloudFailureReason
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.pubsub.v1.IngestionFailureEvent.ConfluentCloudFailureReason} ConfluentCloudFailureReason
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ConfluentCloudFailureReason.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.IngestionFailureEvent.ConfluentCloudFailureReason();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.clusterId = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.kafkaTopic = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.partitionId = reader.int64();
                                        break;
                                    }
                                case 4: {
                                        message.offset = reader.int64();
                                        break;
                                    }
                                case 5: {
                                        message.apiViolationReason = $root.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 6: {
                                        message.schemaViolationReason = $root.google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ConfluentCloudFailureReason message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.pubsub.v1.IngestionFailureEvent.ConfluentCloudFailureReason
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.pubsub.v1.IngestionFailureEvent.ConfluentCloudFailureReason} ConfluentCloudFailureReason
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ConfluentCloudFailureReason.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ConfluentCloudFailureReason message.
                         * @function verify
                         * @memberof google.pubsub.v1.IngestionFailureEvent.ConfluentCloudFailureReason
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ConfluentCloudFailureReason.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.clusterId != null && message.hasOwnProperty("clusterId"))
                                if (!$util.isString(message.clusterId))
                                    return "clusterId: string expected";
                            if (message.kafkaTopic != null && message.hasOwnProperty("kafkaTopic"))
                                if (!$util.isString(message.kafkaTopic))
                                    return "kafkaTopic: string expected";
                            if (message.partitionId != null && message.hasOwnProperty("partitionId"))
                                if (!$util.isInteger(message.partitionId) && !(message.partitionId && $util.isInteger(message.partitionId.low) && $util.isInteger(message.partitionId.high)))
                                    return "partitionId: integer|Long expected";
                            if (message.offset != null && message.hasOwnProperty("offset"))
                                if (!$util.isInteger(message.offset) && !(message.offset && $util.isInteger(message.offset.low) && $util.isInteger(message.offset.high)))
                                    return "offset: integer|Long expected";
                            if (message.apiViolationReason != null && message.hasOwnProperty("apiViolationReason")) {
                                properties.reason = 1;
                                {
                                    var error = $root.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason.verify(message.apiViolationReason);
                                    if (error)
                                        return "apiViolationReason." + error;
                                }
                            }
                            if (message.schemaViolationReason != null && message.hasOwnProperty("schemaViolationReason")) {
                                if (properties.reason === 1)
                                    return "reason: multiple values";
                                properties.reason = 1;
                                {
                                    var error = $root.google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason.verify(message.schemaViolationReason);
                                    if (error)
                                        return "schemaViolationReason." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates a ConfluentCloudFailureReason message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.pubsub.v1.IngestionFailureEvent.ConfluentCloudFailureReason
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.pubsub.v1.IngestionFailureEvent.ConfluentCloudFailureReason} ConfluentCloudFailureReason
                         */
                        ConfluentCloudFailureReason.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.pubsub.v1.IngestionFailureEvent.ConfluentCloudFailureReason)
                                return object;
                            var message = new $root.google.pubsub.v1.IngestionFailureEvent.ConfluentCloudFailureReason();
                            if (object.clusterId != null)
                                message.clusterId = String(object.clusterId);
                            if (object.kafkaTopic != null)
                                message.kafkaTopic = String(object.kafkaTopic);
                            if (object.partitionId != null)
                                if ($util.Long)
                                    (message.partitionId = $util.Long.fromValue(object.partitionId)).unsigned = false;
                                else if (typeof object.partitionId === "string")
                                    message.partitionId = parseInt(object.partitionId, 10);
                                else if (typeof object.partitionId === "number")
                                    message.partitionId = object.partitionId;
                                else if (typeof object.partitionId === "object")
                                    message.partitionId = new $util.LongBits(object.partitionId.low >>> 0, object.partitionId.high >>> 0).toNumber();
                            if (object.offset != null)
                                if ($util.Long)
                                    (message.offset = $util.Long.fromValue(object.offset)).unsigned = false;
                                else if (typeof object.offset === "string")
                                    message.offset = parseInt(object.offset, 10);
                                else if (typeof object.offset === "number")
                                    message.offset = object.offset;
                                else if (typeof object.offset === "object")
                                    message.offset = new $util.LongBits(object.offset.low >>> 0, object.offset.high >>> 0).toNumber();
                            if (object.apiViolationReason != null) {
                                if (typeof object.apiViolationReason !== "object")
                                    throw TypeError(".google.pubsub.v1.IngestionFailureEvent.ConfluentCloudFailureReason.apiViolationReason: object expected");
                                message.apiViolationReason = $root.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason.fromObject(object.apiViolationReason);
                            }
                            if (object.schemaViolationReason != null) {
                                if (typeof object.schemaViolationReason !== "object")
                                    throw TypeError(".google.pubsub.v1.IngestionFailureEvent.ConfluentCloudFailureReason.schemaViolationReason: object expected");
                                message.schemaViolationReason = $root.google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason.fromObject(object.schemaViolationReason);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ConfluentCloudFailureReason message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.pubsub.v1.IngestionFailureEvent.ConfluentCloudFailureReason
                         * @static
                         * @param {google.pubsub.v1.IngestionFailureEvent.ConfluentCloudFailureReason} message ConfluentCloudFailureReason
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ConfluentCloudFailureReason.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.clusterId = "";
                                object.kafkaTopic = "";
                                if ($util.Long) {
                                    var long = new $util.Long(0, 0, false);
                                    object.partitionId = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                                } else
                                    object.partitionId = options.longs === String ? "0" : 0;
                                if ($util.Long) {
                                    var long = new $util.Long(0, 0, false);
                                    object.offset = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                                } else
                                    object.offset = options.longs === String ? "0" : 0;
                            }
                            if (message.clusterId != null && message.hasOwnProperty("clusterId"))
                                object.clusterId = message.clusterId;
                            if (message.kafkaTopic != null && message.hasOwnProperty("kafkaTopic"))
                                object.kafkaTopic = message.kafkaTopic;
                            if (message.partitionId != null && message.hasOwnProperty("partitionId"))
                                if (typeof message.partitionId === "number")
                                    object.partitionId = options.longs === String ? String(message.partitionId) : message.partitionId;
                                else
                                    object.partitionId = options.longs === String ? $util.Long.prototype.toString.call(message.partitionId) : options.longs === Number ? new $util.LongBits(message.partitionId.low >>> 0, message.partitionId.high >>> 0).toNumber() : message.partitionId;
                            if (message.offset != null && message.hasOwnProperty("offset"))
                                if (typeof message.offset === "number")
                                    object.offset = options.longs === String ? String(message.offset) : message.offset;
                                else
                                    object.offset = options.longs === String ? $util.Long.prototype.toString.call(message.offset) : options.longs === Number ? new $util.LongBits(message.offset.low >>> 0, message.offset.high >>> 0).toNumber() : message.offset;
                            if (message.apiViolationReason != null && message.hasOwnProperty("apiViolationReason")) {
                                object.apiViolationReason = $root.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason.toObject(message.apiViolationReason, options);
                                if (options.oneofs)
                                    object.reason = "apiViolationReason";
                            }
                            if (message.schemaViolationReason != null && message.hasOwnProperty("schemaViolationReason")) {
                                object.schemaViolationReason = $root.google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason.toObject(message.schemaViolationReason, options);
                                if (options.oneofs)
                                    object.reason = "schemaViolationReason";
                            }
                            return object;
                        };
    
                        /**
                         * Converts this ConfluentCloudFailureReason to JSON.
                         * @function toJSON
                         * @memberof google.pubsub.v1.IngestionFailureEvent.ConfluentCloudFailureReason
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ConfluentCloudFailureReason.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ConfluentCloudFailureReason
                         * @function getTypeUrl
                         * @memberof google.pubsub.v1.IngestionFailureEvent.ConfluentCloudFailureReason
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ConfluentCloudFailureReason.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.pubsub.v1.IngestionFailureEvent.ConfluentCloudFailureReason";
                        };
    
                        return ConfluentCloudFailureReason;
                    })();
    
                    IngestionFailureEvent.AwsKinesisFailureReason = (function() {
    
                        /**
                         * Properties of an AwsKinesisFailureReason.
                         * @memberof google.pubsub.v1.IngestionFailureEvent
                         * @interface IAwsKinesisFailureReason
                         * @property {string|null} [streamArn] AwsKinesisFailureReason streamArn
                         * @property {string|null} [partitionKey] AwsKinesisFailureReason partitionKey
                         * @property {string|null} [sequenceNumber] AwsKinesisFailureReason sequenceNumber
                         * @property {google.pubsub.v1.IngestionFailureEvent.ISchemaViolationReason|null} [schemaViolationReason] AwsKinesisFailureReason schemaViolationReason
                         */
    
                        /**
                         * Constructs a new AwsKinesisFailureReason.
                         * @memberof google.pubsub.v1.IngestionFailureEvent
                         * @classdesc Represents an AwsKinesisFailureReason.
                         * @implements IAwsKinesisFailureReason
                         * @constructor
                         * @param {google.pubsub.v1.IngestionFailureEvent.IAwsKinesisFailureReason=} [properties] Properties to set
                         */
                        function AwsKinesisFailureReason(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * AwsKinesisFailureReason streamArn.
                         * @member {string} streamArn
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AwsKinesisFailureReason
                         * @instance
                         */
                        AwsKinesisFailureReason.prototype.streamArn = "";
    
                        /**
                         * AwsKinesisFailureReason partitionKey.
                         * @member {string} partitionKey
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AwsKinesisFailureReason
                         * @instance
                         */
                        AwsKinesisFailureReason.prototype.partitionKey = "";
    
                        /**
                         * AwsKinesisFailureReason sequenceNumber.
                         * @member {string} sequenceNumber
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AwsKinesisFailureReason
                         * @instance
                         */
                        AwsKinesisFailureReason.prototype.sequenceNumber = "";
    
                        /**
                         * AwsKinesisFailureReason schemaViolationReason.
                         * @member {google.pubsub.v1.IngestionFailureEvent.ISchemaViolationReason|null|undefined} schemaViolationReason
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AwsKinesisFailureReason
                         * @instance
                         */
                        AwsKinesisFailureReason.prototype.schemaViolationReason = null;
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * AwsKinesisFailureReason reason.
                         * @member {"schemaViolationReason"|undefined} reason
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AwsKinesisFailureReason
                         * @instance
                         */
                        Object.defineProperty(AwsKinesisFailureReason.prototype, "reason", {
                            get: $util.oneOfGetter($oneOfFields = ["schemaViolationReason"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new AwsKinesisFailureReason instance using the specified properties.
                         * @function create
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AwsKinesisFailureReason
                         * @static
                         * @param {google.pubsub.v1.IngestionFailureEvent.IAwsKinesisFailureReason=} [properties] Properties to set
                         * @returns {google.pubsub.v1.IngestionFailureEvent.AwsKinesisFailureReason} AwsKinesisFailureReason instance
                         */
                        AwsKinesisFailureReason.create = function create(properties) {
                            return new AwsKinesisFailureReason(properties);
                        };
    
                        /**
                         * Encodes the specified AwsKinesisFailureReason message. Does not implicitly {@link google.pubsub.v1.IngestionFailureEvent.AwsKinesisFailureReason.verify|verify} messages.
                         * @function encode
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AwsKinesisFailureReason
                         * @static
                         * @param {google.pubsub.v1.IngestionFailureEvent.IAwsKinesisFailureReason} message AwsKinesisFailureReason message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AwsKinesisFailureReason.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.streamArn != null && Object.hasOwnProperty.call(message, "streamArn"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.streamArn);
                            if (message.partitionKey != null && Object.hasOwnProperty.call(message, "partitionKey"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.partitionKey);
                            if (message.sequenceNumber != null && Object.hasOwnProperty.call(message, "sequenceNumber"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.sequenceNumber);
                            if (message.schemaViolationReason != null && Object.hasOwnProperty.call(message, "schemaViolationReason"))
                                $root.google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason.encode(message.schemaViolationReason, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified AwsKinesisFailureReason message, length delimited. Does not implicitly {@link google.pubsub.v1.IngestionFailureEvent.AwsKinesisFailureReason.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AwsKinesisFailureReason
                         * @static
                         * @param {google.pubsub.v1.IngestionFailureEvent.IAwsKinesisFailureReason} message AwsKinesisFailureReason message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AwsKinesisFailureReason.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an AwsKinesisFailureReason message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AwsKinesisFailureReason
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.pubsub.v1.IngestionFailureEvent.AwsKinesisFailureReason} AwsKinesisFailureReason
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AwsKinesisFailureReason.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.IngestionFailureEvent.AwsKinesisFailureReason();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.streamArn = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.partitionKey = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.sequenceNumber = reader.string();
                                        break;
                                    }
                                case 4: {
                                        message.schemaViolationReason = $root.google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an AwsKinesisFailureReason message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AwsKinesisFailureReason
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.pubsub.v1.IngestionFailureEvent.AwsKinesisFailureReason} AwsKinesisFailureReason
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AwsKinesisFailureReason.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an AwsKinesisFailureReason message.
                         * @function verify
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AwsKinesisFailureReason
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AwsKinesisFailureReason.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.streamArn != null && message.hasOwnProperty("streamArn"))
                                if (!$util.isString(message.streamArn))
                                    return "streamArn: string expected";
                            if (message.partitionKey != null && message.hasOwnProperty("partitionKey"))
                                if (!$util.isString(message.partitionKey))
                                    return "partitionKey: string expected";
                            if (message.sequenceNumber != null && message.hasOwnProperty("sequenceNumber"))
                                if (!$util.isString(message.sequenceNumber))
                                    return "sequenceNumber: string expected";
                            if (message.schemaViolationReason != null && message.hasOwnProperty("schemaViolationReason")) {
                                properties.reason = 1;
                                {
                                    var error = $root.google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason.verify(message.schemaViolationReason);
                                    if (error)
                                        return "schemaViolationReason." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates an AwsKinesisFailureReason message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AwsKinesisFailureReason
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.pubsub.v1.IngestionFailureEvent.AwsKinesisFailureReason} AwsKinesisFailureReason
                         */
                        AwsKinesisFailureReason.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.pubsub.v1.IngestionFailureEvent.AwsKinesisFailureReason)
                                return object;
                            var message = new $root.google.pubsub.v1.IngestionFailureEvent.AwsKinesisFailureReason();
                            if (object.streamArn != null)
                                message.streamArn = String(object.streamArn);
                            if (object.partitionKey != null)
                                message.partitionKey = String(object.partitionKey);
                            if (object.sequenceNumber != null)
                                message.sequenceNumber = String(object.sequenceNumber);
                            if (object.schemaViolationReason != null) {
                                if (typeof object.schemaViolationReason !== "object")
                                    throw TypeError(".google.pubsub.v1.IngestionFailureEvent.AwsKinesisFailureReason.schemaViolationReason: object expected");
                                message.schemaViolationReason = $root.google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason.fromObject(object.schemaViolationReason);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an AwsKinesisFailureReason message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AwsKinesisFailureReason
                         * @static
                         * @param {google.pubsub.v1.IngestionFailureEvent.AwsKinesisFailureReason} message AwsKinesisFailureReason
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AwsKinesisFailureReason.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.streamArn = "";
                                object.partitionKey = "";
                                object.sequenceNumber = "";
                            }
                            if (message.streamArn != null && message.hasOwnProperty("streamArn"))
                                object.streamArn = message.streamArn;
                            if (message.partitionKey != null && message.hasOwnProperty("partitionKey"))
                                object.partitionKey = message.partitionKey;
                            if (message.sequenceNumber != null && message.hasOwnProperty("sequenceNumber"))
                                object.sequenceNumber = message.sequenceNumber;
                            if (message.schemaViolationReason != null && message.hasOwnProperty("schemaViolationReason")) {
                                object.schemaViolationReason = $root.google.pubsub.v1.IngestionFailureEvent.SchemaViolationReason.toObject(message.schemaViolationReason, options);
                                if (options.oneofs)
                                    object.reason = "schemaViolationReason";
                            }
                            return object;
                        };
    
                        /**
                         * Converts this AwsKinesisFailureReason to JSON.
                         * @function toJSON
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AwsKinesisFailureReason
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AwsKinesisFailureReason.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for AwsKinesisFailureReason
                         * @function getTypeUrl
                         * @memberof google.pubsub.v1.IngestionFailureEvent.AwsKinesisFailureReason
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        AwsKinesisFailureReason.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.pubsub.v1.IngestionFailureEvent.AwsKinesisFailureReason";
                        };
    
                        return AwsKinesisFailureReason;
                    })();
    
                    return IngestionFailureEvent;
                })();
    
                v1.JavaScriptUDF = (function() {
    
                    /**
                     * Properties of a JavaScriptUDF.
                     * @memberof google.pubsub.v1
                     * @interface IJavaScriptUDF
                     * @property {string|null} [functionName] JavaScriptUDF functionName
                     * @property {string|null} [code] JavaScriptUDF code
                     */
    
                    /**
                     * Constructs a new JavaScriptUDF.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a JavaScriptUDF.
                     * @implements IJavaScriptUDF
                     * @constructor
                     * @param {google.pubsub.v1.IJavaScriptUDF=} [properties] Properties to set
                     */
                    function JavaScriptUDF(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * JavaScriptUDF functionName.
                     * @member {string} functionName
                     * @memberof google.pubsub.v1.JavaScriptUDF
                     * @instance
                     */
                    JavaScriptUDF.prototype.functionName = "";
    
                    /**
                     * JavaScriptUDF code.
                     * @member {string} code
                     * @memberof google.pubsub.v1.JavaScriptUDF
                     * @instance
                     */
                    JavaScriptUDF.prototype.code = "";
    
                    /**
                     * Creates a new JavaScriptUDF instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.JavaScriptUDF
                     * @static
                     * @param {google.pubsub.v1.IJavaScriptUDF=} [properties] Properties to set
                     * @returns {google.pubsub.v1.JavaScriptUDF} JavaScriptUDF instance
                     */
                    JavaScriptUDF.create = function create(properties) {
                        return new JavaScriptUDF(properties);
                    };
    
                    /**
                     * Encodes the specified JavaScriptUDF message. Does not implicitly {@link google.pubsub.v1.JavaScriptUDF.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.JavaScriptUDF
                     * @static
                     * @param {google.pubsub.v1.IJavaScriptUDF} message JavaScriptUDF message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    JavaScriptUDF.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.functionName != null && Object.hasOwnProperty.call(message, "functionName"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.functionName);
                        if (message.code != null && Object.hasOwnProperty.call(message, "code"))
                            writer.uint32(/* id 2, wireType 2 =*/18).string(message.code);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified JavaScriptUDF message, length delimited. Does not implicitly {@link google.pubsub.v1.JavaScriptUDF.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.JavaScriptUDF
                     * @static
                     * @param {google.pubsub.v1.IJavaScriptUDF} message JavaScriptUDF message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    JavaScriptUDF.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a JavaScriptUDF message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.JavaScriptUDF
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.JavaScriptUDF} JavaScriptUDF
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    JavaScriptUDF.decode = function decode(reader, length, error) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.JavaScriptUDF();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            if (tag === error)
                                break;
                            switch (tag >>> 3) {
                            case 1: {
                                    message.functionName = reader.string();
                                    break;
                                }
                            case 2: {
                                    message.code = reader.string();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a JavaScriptUDF message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.JavaScriptUDF
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.JavaScriptUDF} JavaScriptUDF
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    JavaScriptUDF.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a JavaScriptUDF message.
                     * @function verify
                     * @memberof google.pubsub.v1.JavaScriptUDF
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    JavaScriptUDF.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.functionName != null && message.hasOwnProperty("functionName"))
                            if (!$util.isString(message.functionName))
                                return "functionName: string expected";
                        if (message.code != null && message.hasOwnProperty("code"))
                            if (!$util.isString(message.code))
                                return "code: string expected";
                        return null;
                    };
    
                    /**
                     * Creates a JavaScriptUDF message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.JavaScriptUDF
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.JavaScriptUDF} JavaScriptUDF
                     */
                    JavaScriptUDF.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.JavaScriptUDF)
                            return object;
                        var message = new $root.google.pubsub.v1.JavaScriptUDF();
                        if (object.functionName != null)
                            message.functionName = String(object.functionName);
                        if (object.code != null)
                            message.code = String(object.code);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a JavaScriptUDF message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.JavaScriptUDF
                     * @static
                     * @param {google.pubsub.v1.JavaScriptUDF} message JavaScriptUDF
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    JavaScriptUDF.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.functionName = "";
                            object.code = "";
                        }
                        if (message.functionName != null && message.hasOwnProperty("functionName"))
                            object.functionName = message.functionName;
                        if (message.code != null && message.hasOwnProperty("code"))
                            object.code = message.code;
                        return object;
                    };
    
                    /**
                     * Converts this JavaScriptUDF to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.JavaScriptUDF
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    JavaScriptUDF.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for JavaScriptUDF
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.JavaScriptUDF
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    JavaScriptUDF.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.JavaScriptUDF";
                    };
    
                    return JavaScriptUDF;
                })();
    
                v1.MessageTransform = (function() {
    
                    /**
                     * Properties of a MessageTransform.
                     * @memberof google.pubsub.v1
                     * @interface IMessageTransform
                     * @property {google.pubsub.v1.IJavaScriptUDF|null} [javascriptUdf] MessageTransform javascriptUdf
                     * @property {boolean|null} [enabled] MessageTransform enabled
                     * @property {boolean|null} [disabled] MessageTransform disabled
                     */
    
                    /**
                     * Constructs a new MessageTransform.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a MessageTransform.
                     * @implements IMessageTransform
                     * @constructor
                     * @param {google.pubsub.v1.IMessageTransform=} [properties] Properties to set
                     */
                    function MessageTransform(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * MessageTransform javascriptUdf.
                     * @member {google.pubsub.v1.IJavaScriptUDF|null|undefined} javascriptUdf
                     * @memberof google.pubsub.v1.MessageTransform
                     * @instance
                     */
                    MessageTransform.prototype.javascriptUdf = null;
    
                    /**
                     * MessageTransform enabled.
                     * @member {boolean} enabled
                     * @memberof google.pubsub.v1.MessageTransform
                     * @instance
                     */
                    MessageTransform.prototype.enabled = false;
    
                    /**
                     * MessageTransform disabled.
                     * @member {boolean} disabled
                     * @memberof google.pubsub.v1.MessageTransform
                     * @instance
                     */
                    MessageTransform.prototype.disabled = false;
    
                    // OneOf field names bound to virtual getters and setters
                    var $oneOfFields;
    
                    /**
                     * MessageTransform transform.
                     * @member {"javascriptUdf"|undefined} transform
                     * @memberof google.pubsub.v1.MessageTransform
                     * @instance
                     */
                    Object.defineProperty(MessageTransform.prototype, "transform", {
                        get: $util.oneOfGetter($oneOfFields = ["javascriptUdf"]),
                        set: $util.oneOfSetter($oneOfFields)
                    });
    
                    /**
                     * Creates a new MessageTransform instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.MessageTransform
                     * @static
                     * @param {google.pubsub.v1.IMessageTransform=} [properties] Properties to set
                     * @returns {google.pubsub.v1.MessageTransform} MessageTransform instance
                     */
                    MessageTransform.create = function create(properties) {
                        return new MessageTransform(properties);
                    };
    
                    /**
                     * Encodes the specified MessageTransform message. Does not implicitly {@link google.pubsub.v1.MessageTransform.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.MessageTransform
                     * @static
                     * @param {google.pubsub.v1.IMessageTransform} message MessageTransform message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    MessageTransform.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.javascriptUdf != null && Object.hasOwnProperty.call(message, "javascriptUdf"))
                            $root.google.pubsub.v1.JavaScriptUDF.encode(message.javascriptUdf, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                        if (message.enabled != null && Object.hasOwnProperty.call(message, "enabled"))
                            writer.uint32(/* id 3, wireType 0 =*/24).bool(message.enabled);
                        if (message.disabled != null && Object.hasOwnProperty.call(message, "disabled"))
                            writer.uint32(/* id 4, wireType 0 =*/32).bool(message.disabled);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified MessageTransform message, length delimited. Does not implicitly {@link google.pubsub.v1.MessageTransform.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.MessageTransform
                     * @static
                     * @param {google.pubsub.v1.IMessageTransform} message MessageTransform message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    MessageTransform.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a MessageTransform message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.MessageTransform
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.MessageTransform} MessageTransform
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    MessageTransform.decode = function decode(reader, length, error) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.MessageTransform();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            if (tag === error)
                                break;
                            switch (tag >>> 3) {
                            case 2: {
                                    message.javascriptUdf = $root.google.pubsub.v1.JavaScriptUDF.decode(reader, reader.uint32());
                                    break;
                                }
                            case 3: {
                                    message.enabled = reader.bool();
                                    break;
                                }
                            case 4: {
                                    message.disabled = reader.bool();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a MessageTransform message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.MessageTransform
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.MessageTransform} MessageTransform
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    MessageTransform.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a MessageTransform message.
                     * @function verify
                     * @memberof google.pubsub.v1.MessageTransform
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    MessageTransform.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        var properties = {};
                        if (message.javascriptUdf != null && message.hasOwnProperty("javascriptUdf")) {
                            properties.transform = 1;
                            {
                                var error = $root.google.pubsub.v1.JavaScriptUDF.verify(message.javascriptUdf);
                                if (error)
                                    return "javascriptUdf." + error;
                            }
                        }
                        if (message.enabled != null && message.hasOwnProperty("enabled"))
                            if (typeof message.enabled !== "boolean")
                                return "enabled: boolean expected";
                        if (message.disabled != null && message.hasOwnProperty("disabled"))
                            if (typeof message.disabled !== "boolean")
                                return "disabled: boolean expected";
                        return null;
                    };
    
                    /**
                     * Creates a MessageTransform message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.MessageTransform
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.MessageTransform} MessageTransform
                     */
                    MessageTransform.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.MessageTransform)
                            return object;
                        var message = new $root.google.pubsub.v1.MessageTransform();
                        if (object.javascriptUdf != null) {
                            if (typeof object.javascriptUdf !== "object")
                                throw TypeError(".google.pubsub.v1.MessageTransform.javascriptUdf: object expected");
                            message.javascriptUdf = $root.google.pubsub.v1.JavaScriptUDF.fromObject(object.javascriptUdf);
                        }
                        if (object.enabled != null)
                            message.enabled = Boolean(object.enabled);
                        if (object.disabled != null)
                            message.disabled = Boolean(object.disabled);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a MessageTransform message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.MessageTransform
                     * @static
                     * @param {google.pubsub.v1.MessageTransform} message MessageTransform
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    MessageTransform.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.enabled = false;
                            object.disabled = false;
                        }
                        if (message.javascriptUdf != null && message.hasOwnProperty("javascriptUdf")) {
                            object.javascriptUdf = $root.google.pubsub.v1.JavaScriptUDF.toObject(message.javascriptUdf, options);
                            if (options.oneofs)
                                object.transform = "javascriptUdf";
                        }
                        if (message.enabled != null && message.hasOwnProperty("enabled"))
                            object.enabled = message.enabled;
                        if (message.disabled != null && message.hasOwnProperty("disabled"))
                            object.disabled = message.disabled;
                        return object;
                    };
    
                    /**
                     * Converts this MessageTransform to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.MessageTransform
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    MessageTransform.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for MessageTransform
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.MessageTransform
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    MessageTransform.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.MessageTransform";
                    };
    
                    return MessageTransform;
                })();
    
                v1.Topic = (function() {
    
                    /**
                     * Properties of a Topic.
                     * @memberof google.pubsub.v1
                     * @interface ITopic
                     * @property {string|null} [name] Topic name
                     * @property {Object.<string,string>|null} [labels] Topic labels
                     * @property {google.pubsub.v1.IMessageStoragePolicy|null} [messageStoragePolicy] Topic messageStoragePolicy
                     * @property {string|null} [kmsKeyName] Topic kmsKeyName
                     * @property {google.pubsub.v1.ISchemaSettings|null} [schemaSettings] Topic schemaSettings
                     * @property {boolean|null} [satisfiesPzs] Topic satisfiesPzs
                     * @property {google.protobuf.IDuration|null} [messageRetentionDuration] Topic messageRetentionDuration
                     * @property {google.pubsub.v1.Topic.State|null} [state] Topic state
                     * @property {google.pubsub.v1.IIngestionDataSourceSettings|null} [ingestionDataSourceSettings] Topic ingestionDataSourceSettings
                     * @property {Array.<google.pubsub.v1.IMessageTransform>|null} [messageTransforms] Topic messageTransforms
                     */
    
                    /**
                     * Constructs a new Topic.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a Topic.
                     * @implements ITopic
                     * @constructor
                     * @param {google.pubsub.v1.ITopic=} [properties] Properties to set
                     */
                    function Topic(properties) {
                        this.labels = {};
                        this.messageTransforms = [];
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * Topic name.
                     * @member {string} name
                     * @memberof google.pubsub.v1.Topic
                     * @instance
                     */
                    Topic.prototype.name = "";
    
                    /**
                     * Topic labels.
                     * @member {Object.<string,string>} labels
                     * @memberof google.pubsub.v1.Topic
                     * @instance
                     */
                    Topic.prototype.labels = $util.emptyObject;
    
                    /**
                     * Topic messageStoragePolicy.
                     * @member {google.pubsub.v1.IMessageStoragePolicy|null|undefined} messageStoragePolicy
                     * @memberof google.pubsub.v1.Topic
                     * @instance
                     */
                    Topic.prototype.messageStoragePolicy = null;
    
                    /**
                     * Topic kmsKeyName.
                     * @member {string} kmsKeyName
                     * @memberof google.pubsub.v1.Topic
                     * @instance
                     */
                    Topic.prototype.kmsKeyName = "";
    
                    /**
                     * Topic schemaSettings.
                     * @member {google.pubsub.v1.ISchemaSettings|null|undefined} schemaSettings
                     * @memberof google.pubsub.v1.Topic
                     * @instance
                     */
                    Topic.prototype.schemaSettings = null;
    
                    /**
                     * Topic satisfiesPzs.
                     * @member {boolean} satisfiesPzs
                     * @memberof google.pubsub.v1.Topic
                     * @instance
                     */
                    Topic.prototype.satisfiesPzs = false;
    
                    /**
                     * Topic messageRetentionDuration.
                     * @member {google.protobuf.IDuration|null|undefined} messageRetentionDuration
                     * @memberof google.pubsub.v1.Topic
                     * @instance
                     */
                    Topic.prototype.messageRetentionDuration = null;
    
                    /**
                     * Topic state.
                     * @member {google.pubsub.v1.Topic.State} state
                     * @memberof google.pubsub.v1.Topic
                     * @instance
                     */
                    Topic.prototype.state = 0;
    
                    /**
                     * Topic ingestionDataSourceSettings.
                     * @member {google.pubsub.v1.IIngestionDataSourceSettings|null|undefined} ingestionDataSourceSettings
                     * @memberof google.pubsub.v1.Topic
                     * @instance
                     */
                    Topic.prototype.ingestionDataSourceSettings = null;
    
                    /**
                     * Topic messageTransforms.
                     * @member {Array.<google.pubsub.v1.IMessageTransform>} messageTransforms
                     * @memberof google.pubsub.v1.Topic
                     * @instance
                     */
                    Topic.prototype.messageTransforms = $util.emptyArray;
    
                    /**
                     * Creates a new Topic instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.Topic
                     * @static
                     * @param {google.pubsub.v1.ITopic=} [properties] Properties to set
                     * @returns {google.pubsub.v1.Topic} Topic instance
                     */
                    Topic.create = function create(properties) {
                        return new Topic(properties);
                    };
    
                    /**
                     * Encodes the specified Topic message. Does not implicitly {@link google.pubsub.v1.Topic.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.Topic
                     * @static
                     * @param {google.pubsub.v1.ITopic} message Topic message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    Topic.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                        if (message.labels != null && Object.hasOwnProperty.call(message, "labels"))
                            for (var keys = Object.keys(message.labels), i = 0; i < keys.length; ++i)
                                writer.uint32(/* id 2, wireType 2 =*/18).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]).uint32(/* id 2, wireType 2 =*/18).string(message.labels[keys[i]]).ldelim();
                        if (message.messageStoragePolicy != null && Object.hasOwnProperty.call(message, "messageStoragePolicy"))
                            $root.google.pubsub.v1.MessageStoragePolicy.encode(message.messageStoragePolicy, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                        if (message.kmsKeyName != null && Object.hasOwnProperty.call(message, "kmsKeyName"))
                            writer.uint32(/* id 5, wireType 2 =*/42).string(message.kmsKeyName);
                        if (message.schemaSettings != null && Object.hasOwnProperty.call(message, "schemaSettings"))
                            $root.google.pubsub.v1.SchemaSettings.encode(message.schemaSettings, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                        if (message.satisfiesPzs != null && Object.hasOwnProperty.call(message, "satisfiesPzs"))
                            writer.uint32(/* id 7, wireType 0 =*/56).bool(message.satisfiesPzs);
                        if (message.messageRetentionDuration != null && Object.hasOwnProperty.call(message, "messageRetentionDuration"))
                            $root.google.protobuf.Duration.encode(message.messageRetentionDuration, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
                        if (message.state != null && Object.hasOwnProperty.call(message, "state"))
                            writer.uint32(/* id 9, wireType 0 =*/72).int32(message.state);
                        if (message.ingestionDataSourceSettings != null && Object.hasOwnProperty.call(message, "ingestionDataSourceSettings"))
                            $root.google.pubsub.v1.IngestionDataSourceSettings.encode(message.ingestionDataSourceSettings, writer.uint32(/* id 10, wireType 2 =*/82).fork()).ldelim();
                        if (message.messageTransforms != null && message.messageTransforms.length)
                            for (var i = 0; i < message.messageTransforms.length; ++i)
                                $root.google.pubsub.v1.MessageTransform.encode(message.messageTransforms[i], writer.uint32(/* id 13, wireType 2 =*/106).fork()).ldelim();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified Topic message, length delimited. Does not implicitly {@link google.pubsub.v1.Topic.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.Topic
                     * @static
                     * @param {google.pubsub.v1.ITopic} message Topic message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    Topic.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a Topic message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.Topic
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.Topic} Topic
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    Topic.decode = function decode(reader, length, error) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.Topic(), key, value;
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            if (tag === error)
                                break;
                            switch (tag >>> 3) {
                            case 1: {
                                    message.name = reader.string();
                                    break;
                                }
                            case 2: {
                                    if (message.labels === $util.emptyObject)
                                        message.labels = {};
                                    var end2 = reader.uint32() + reader.pos;
                                    key = "";
                                    value = "";
                                    while (reader.pos < end2) {
                                        var tag2 = reader.uint32();
                                        switch (tag2 >>> 3) {
                                        case 1:
                                            key = reader.string();
                                            break;
                                        case 2:
                                            value = reader.string();
                                            break;
                                        default:
                                            reader.skipType(tag2 & 7);
                                            break;
                                        }
                                    }
                                    message.labels[key] = value;
                                    break;
                                }
                            case 3: {
                                    message.messageStoragePolicy = $root.google.pubsub.v1.MessageStoragePolicy.decode(reader, reader.uint32());
                                    break;
                                }
                            case 5: {
                                    message.kmsKeyName = reader.string();
                                    break;
                                }
                            case 6: {
                                    message.schemaSettings = $root.google.pubsub.v1.SchemaSettings.decode(reader, reader.uint32());
                                    break;
                                }
                            case 7: {
                                    message.satisfiesPzs = reader.bool();
                                    break;
                                }
                            case 8: {
                                    message.messageRetentionDuration = $root.google.protobuf.Duration.decode(reader, reader.uint32());
                                    break;
                                }
                            case 9: {
                                    message.state = reader.int32();
                                    break;
                                }
                            case 10: {
                                    message.ingestionDataSourceSettings = $root.google.pubsub.v1.IngestionDataSourceSettings.decode(reader, reader.uint32());
                                    break;
                                }
                            case 13: {
                                    if (!(message.messageTransforms && message.messageTransforms.length))
                                        message.messageTransforms = [];
                                    message.messageTransforms.push($root.google.pubsub.v1.MessageTransform.decode(reader, reader.uint32()));
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a Topic message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.Topic
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.Topic} Topic
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    Topic.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a Topic message.
                     * @function verify
                     * @memberof google.pubsub.v1.Topic
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    Topic.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.name != null && message.hasOwnProperty("name"))
                            if (!$util.isString(message.name))
                                return "name: string expected";
                        if (message.labels != null && message.hasOwnProperty("labels")) {
                            if (!$util.isObject(message.labels))
                                return "labels: object expected";
                            var key = Object.keys(message.labels);
                            for (var i = 0; i < key.length; ++i)
                                if (!$util.isString(message.labels[key[i]]))
                                    return "labels: string{k:string} expected";
                        }
                        if (message.messageStoragePolicy != null && message.hasOwnProperty("messageStoragePolicy")) {
                            var error = $root.google.pubsub.v1.MessageStoragePolicy.verify(message.messageStoragePolicy);
                            if (error)
                                return "messageStoragePolicy." + error;
                        }
                        if (message.kmsKeyName != null && message.hasOwnProperty("kmsKeyName"))
                            if (!$util.isString(message.kmsKeyName))
                                return "kmsKeyName: string expected";
                        if (message.schemaSettings != null && message.hasOwnProperty("schemaSettings")) {
                            var error = $root.google.pubsub.v1.SchemaSettings.verify(message.schemaSettings);
                            if (error)
                                return "schemaSettings." + error;
                        }
                        if (message.satisfiesPzs != null && message.hasOwnProperty("satisfiesPzs"))
                            if (typeof message.satisfiesPzs !== "boolean")
                                return "satisfiesPzs: boolean expected";
                        if (message.messageRetentionDuration != null && message.hasOwnProperty("messageRetentionDuration")) {
                            var error = $root.google.protobuf.Duration.verify(message.messageRetentionDuration);
                            if (error)
                                return "messageRetentionDuration." + error;
                        }
                        if (message.state != null && message.hasOwnProperty("state"))
                            switch (message.state) {
                            default:
                                return "state: enum value expected";
                            case 0:
                            case 1:
                            case 2:
                                break;
                            }
                        if (message.ingestionDataSourceSettings != null && message.hasOwnProperty("ingestionDataSourceSettings")) {
                            var error = $root.google.pubsub.v1.IngestionDataSourceSettings.verify(message.ingestionDataSourceSettings);
                            if (error)
                                return "ingestionDataSourceSettings." + error;
                        }
                        if (message.messageTransforms != null && message.hasOwnProperty("messageTransforms")) {
                            if (!Array.isArray(message.messageTransforms))
                                return "messageTransforms: array expected";
                            for (var i = 0; i < message.messageTransforms.length; ++i) {
                                var error = $root.google.pubsub.v1.MessageTransform.verify(message.messageTransforms[i]);
                                if (error)
                                    return "messageTransforms." + error;
                            }
                        }
                        return null;
                    };
    
                    /**
                     * Creates a Topic message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.Topic
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.Topic} Topic
                     */
                    Topic.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.Topic)
                            return object;
                        var message = new $root.google.pubsub.v1.Topic();
                        if (object.name != null)
                            message.name = String(object.name);
                        if (object.labels) {
                            if (typeof object.labels !== "object")
                                throw TypeError(".google.pubsub.v1.Topic.labels: object expected");
                            message.labels = {};
                            for (var keys = Object.keys(object.labels), i = 0; i < keys.length; ++i)
                                message.labels[keys[i]] = String(object.labels[keys[i]]);
                        }
                        if (object.messageStoragePolicy != null) {
                            if (typeof object.messageStoragePolicy !== "object")
                                throw TypeError(".google.pubsub.v1.Topic.messageStoragePolicy: object expected");
                            message.messageStoragePolicy = $root.google.pubsub.v1.MessageStoragePolicy.fromObject(object.messageStoragePolicy);
                        }
                        if (object.kmsKeyName != null)
                            message.kmsKeyName = String(object.kmsKeyName);
                        if (object.schemaSettings != null) {
                            if (typeof object.schemaSettings !== "object")
                                throw TypeError(".google.pubsub.v1.Topic.schemaSettings: object expected");
                            message.schemaSettings = $root.google.pubsub.v1.SchemaSettings.fromObject(object.schemaSettings);
                        }
                        if (object.satisfiesPzs != null)
                            message.satisfiesPzs = Boolean(object.satisfiesPzs);
                        if (object.messageRetentionDuration != null) {
                            if (typeof object.messageRetentionDuration !== "object")
                                throw TypeError(".google.pubsub.v1.Topic.messageRetentionDuration: object expected");
                            message.messageRetentionDuration = $root.google.protobuf.Duration.fromObject(object.messageRetentionDuration);
                        }
                        switch (object.state) {
                        default:
                            if (typeof object.state === "number") {
                                message.state = object.state;
                                break;
                            }
                            break;
                        case "STATE_UNSPECIFIED":
                        case 0:
                            message.state = 0;
                            break;
                        case "ACTIVE":
                        case 1:
                            message.state = 1;
                            break;
                        case "INGESTION_RESOURCE_ERROR":
                        case 2:
                            message.state = 2;
                            break;
                        }
                        if (object.ingestionDataSourceSettings != null) {
                            if (typeof object.ingestionDataSourceSettings !== "object")
                                throw TypeError(".google.pubsub.v1.Topic.ingestionDataSourceSettings: object expected");
                            message.ingestionDataSourceSettings = $root.google.pubsub.v1.IngestionDataSourceSettings.fromObject(object.ingestionDataSourceSettings);
                        }
                        if (object.messageTransforms) {
                            if (!Array.isArray(object.messageTransforms))
                                throw TypeError(".google.pubsub.v1.Topic.messageTransforms: array expected");
                            message.messageTransforms = [];
                            for (var i = 0; i < object.messageTransforms.length; ++i) {
                                if (typeof object.messageTransforms[i] !== "object")
                                    throw TypeError(".google.pubsub.v1.Topic.messageTransforms: object expected");
                                message.messageTransforms[i] = $root.google.pubsub.v1.MessageTransform.fromObject(object.messageTransforms[i]);
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a Topic message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.Topic
                     * @static
                     * @param {google.pubsub.v1.Topic} message Topic
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    Topic.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.arrays || options.defaults)
                            object.messageTransforms = [];
                        if (options.objects || options.defaults)
                            object.labels = {};
                        if (options.defaults) {
                            object.name = "";
                            object.messageStoragePolicy = null;
                            object.kmsKeyName = "";
                            object.schemaSettings = null;
                            object.satisfiesPzs = false;
                            object.messageRetentionDuration = null;
                            object.state = options.enums === String ? "STATE_UNSPECIFIED" : 0;
                            object.ingestionDataSourceSettings = null;
                        }
                        if (message.name != null && message.hasOwnProperty("name"))
                            object.name = message.name;
                        var keys2;
                        if (message.labels && (keys2 = Object.keys(message.labels)).length) {
                            object.labels = {};
                            for (var j = 0; j < keys2.length; ++j)
                                object.labels[keys2[j]] = message.labels[keys2[j]];
                        }
                        if (message.messageStoragePolicy != null && message.hasOwnProperty("messageStoragePolicy"))
                            object.messageStoragePolicy = $root.google.pubsub.v1.MessageStoragePolicy.toObject(message.messageStoragePolicy, options);
                        if (message.kmsKeyName != null && message.hasOwnProperty("kmsKeyName"))
                            object.kmsKeyName = message.kmsKeyName;
                        if (message.schemaSettings != null && message.hasOwnProperty("schemaSettings"))
                            object.schemaSettings = $root.google.pubsub.v1.SchemaSettings.toObject(message.schemaSettings, options);
                        if (message.satisfiesPzs != null && message.hasOwnProperty("satisfiesPzs"))
                            object.satisfiesPzs = message.satisfiesPzs;
                        if (message.messageRetentionDuration != null && message.hasOwnProperty("messageRetentionDuration"))
                            object.messageRetentionDuration = $root.google.protobuf.Duration.toObject(message.messageRetentionDuration, options);
                        if (message.state != null && message.hasOwnProperty("state"))
                            object.state = options.enums === String ? $root.google.pubsub.v1.Topic.State[message.state] === undefined ? message.state : $root.google.pubsub.v1.Topic.State[message.state] : message.state;
                        if (message.ingestionDataSourceSettings != null && message.hasOwnProperty("ingestionDataSourceSettings"))
                            object.ingestionDataSourceSettings = $root.google.pubsub.v1.IngestionDataSourceSettings.toObject(message.ingestionDataSourceSettings, options);
                        if (message.messageTransforms && message.messageTransforms.length) {
                            object.messageTransforms = [];
                            for (var j = 0; j < message.messageTransforms.length; ++j)
                                object.messageTransforms[j] = $root.google.pubsub.v1.MessageTransform.toObject(message.messageTransforms[j], options);
                        }
                        return object;
                    };
    
                    /**
                     * Converts this Topic to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.Topic
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    Topic.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for Topic
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.Topic
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    Topic.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.Topic";
                    };
    
                    /**
                     * State enum.
                     * @name google.pubsub.v1.Topic.State
                     * @enum {number}
                     * @property {number} STATE_UNSPECIFIED=0 STATE_UNSPECIFIED value
                     * @property {number} ACTIVE=1 ACTIVE value
                     * @property {number} INGESTION_RESOURCE_ERROR=2 INGESTION_RESOURCE_ERROR value
                     */
                    Topic.State = (function() {
                        var valuesById = {}, values = Object.create(valuesById);
                        values[valuesById[0] = "STATE_UNSPECIFIED"] = 0;
                        values[valuesById[1] = "ACTIVE"] = 1;
                        values[valuesById[2] = "INGESTION_RESOURCE_ERROR"] = 2;
                        return values;
                    })();
    
                    return Topic;
                })();
    
                v1.PubsubMessage = (function() {
    
                    /**
                     * Properties of a PubsubMessage.
                     * @memberof google.pubsub.v1
                     * @interface IPubsubMessage
                     * @property {Uint8Array|null} [data] PubsubMessage data
                     * @property {Object.<string,string>|null} [attributes] PubsubMessage attributes
                     * @property {string|null} [messageId] PubsubMessage messageId
                     * @property {google.protobuf.ITimestamp|null} [publishTime] PubsubMessage publishTime
                     * @property {string|null} [orderingKey] PubsubMessage orderingKey
                     */
    
                    /**
                     * Constructs a new PubsubMessage.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a PubsubMessage.
                     * @implements IPubsubMessage
                     * @constructor
                     * @param {google.pubsub.v1.IPubsubMessage=} [properties] Properties to set
                     */
                    function PubsubMessage(properties) {
                        this.attributes = {};
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * PubsubMessage data.
                     * @member {Uint8Array} data
                     * @memberof google.pubsub.v1.PubsubMessage
                     * @instance
                     */
                    PubsubMessage.prototype.data = $util.newBuffer([]);
    
                    /**
                     * PubsubMessage attributes.
                     * @member {Object.<string,string>} attributes
                     * @memberof google.pubsub.v1.PubsubMessage
                     * @instance
                     */
                    PubsubMessage.prototype.attributes = $util.emptyObject;
    
                    /**
                     * PubsubMessage messageId.
                     * @member {string} messageId
                     * @memberof google.pubsub.v1.PubsubMessage
                     * @instance
                     */
                    PubsubMessage.prototype.messageId = "";
    
                    /**
                     * PubsubMessage publishTime.
                     * @member {google.protobuf.ITimestamp|null|undefined} publishTime
                     * @memberof google.pubsub.v1.PubsubMessage
                     * @instance
                     */
                    PubsubMessage.prototype.publishTime = null;
    
                    /**
                     * PubsubMessage orderingKey.
                     * @member {string} orderingKey
                     * @memberof google.pubsub.v1.PubsubMessage
                     * @instance
                     */
                    PubsubMessage.prototype.orderingKey = "";
    
                    /**
                     * Creates a new PubsubMessage instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.PubsubMessage
                     * @static
                     * @param {google.pubsub.v1.IPubsubMessage=} [properties] Properties to set
                     * @returns {google.pubsub.v1.PubsubMessage} PubsubMessage instance
                     */
                    PubsubMessage.create = function create(properties) {
                        return new PubsubMessage(properties);
                    };
    
                    /**
                     * Encodes the specified PubsubMessage message. Does not implicitly {@link google.pubsub.v1.PubsubMessage.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.PubsubMessage
                     * @static
                     * @param {google.pubsub.v1.IPubsubMessage} message PubsubMessage message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    PubsubMessage.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.data != null && Object.hasOwnProperty.call(message, "data"))
                            writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.data);
                        if (message.attributes != null && Object.hasOwnProperty.call(message, "attributes"))
                            for (var keys = Object.keys(message.attributes), i = 0; i < keys.length; ++i)
                                writer.uint32(/* id 2, wireType 2 =*/18).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]).uint32(/* id 2, wireType 2 =*/18).string(message.attributes[keys[i]]).ldelim();
                        if (message.messageId != null && Object.hasOwnProperty.call(message, "messageId"))
                            writer.uint32(/* id 3, wireType 2 =*/26).string(message.messageId);
                        if (message.publishTime != null && Object.hasOwnProperty.call(message, "publishTime"))
                            $root.google.protobuf.Timestamp.encode(message.publishTime, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                        if (message.orderingKey != null && Object.hasOwnProperty.call(message, "orderingKey"))
                            writer.uint32(/* id 5, wireType 2 =*/42).string(message.orderingKey);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified PubsubMessage message, length delimited. Does not implicitly {@link google.pubsub.v1.PubsubMessage.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.PubsubMessage
                     * @static
                     * @param {google.pubsub.v1.IPubsubMessage} message PubsubMessage message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    PubsubMessage.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a PubsubMessage message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.PubsubMessage
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.PubsubMessage} PubsubMessage
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    PubsubMessage.decode = function decode(reader, length, error) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.PubsubMessage(), key, value;
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            if (tag === error)
                                break;
                            switch (tag >>> 3) {
                            case 1: {
                                    message.data = reader.bytes();
                                    break;
                                }
                            case 2: {
                                    if (message.attributes === $util.emptyObject)
                                        message.attributes = {};
                                    var end2 = reader.uint32() + reader.pos;
                                    key = "";
                                    value = "";
                                    while (reader.pos < end2) {
                                        var tag2 = reader.uint32();
                                        switch (tag2 >>> 3) {
                                        case 1:
                                            key = reader.string();
                                            break;
                                        case 2:
                                            value = reader.string();
                                            break;
                                        default:
                                            reader.skipType(tag2 & 7);
                                            break;
                                        }
                                    }
                                    message.attributes[key] = value;
                                    break;
                                }
                            case 3: {
                                    message.messageId = reader.string();
                                    break;
                                }
                            case 4: {
                                    message.publishTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                    break;
                                }
                            case 5: {
                                    message.orderingKey = reader.string();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a PubsubMessage message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.PubsubMessage
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.PubsubMessage} PubsubMessage
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    PubsubMessage.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a PubsubMessage message.
                     * @function verify
                     * @memberof google.pubsub.v1.PubsubMessage
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    PubsubMessage.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.data != null && message.hasOwnProperty("data"))
                            if (!(message.data && typeof message.data.length === "number" || $util.isString(message.data)))
                                return "data: buffer expected";
                        if (message.attributes != null && message.hasOwnProperty("attributes")) {
                            if (!$util.isObject(message.attributes))
                                return "attributes: object expected";
                            var key = Object.keys(message.attributes);
                            for (var i = 0; i < key.length; ++i)
                                if (!$util.isString(message.attributes[key[i]]))
                                    return "attributes: string{k:string} expected";
                        }
                        if (message.messageId != null && message.hasOwnProperty("messageId"))
                            if (!$util.isString(message.messageId))
                                return "messageId: string expected";
                        if (message.publishTime != null && message.hasOwnProperty("publishTime")) {
                            var error = $root.google.protobuf.Timestamp.verify(message.publishTime);
                            if (error)
                                return "publishTime." + error;
                        }
                        if (message.orderingKey != null && message.hasOwnProperty("orderingKey"))
                            if (!$util.isString(message.orderingKey))
                                return "orderingKey: string expected";
                        return null;
                    };
    
                    /**
                     * Creates a PubsubMessage message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.PubsubMessage
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.PubsubMessage} PubsubMessage
                     */
                    PubsubMessage.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.PubsubMessage)
                            return object;
                        var message = new $root.google.pubsub.v1.PubsubMessage();
                        if (object.data != null)
                            if (typeof object.data === "string")
                                $util.base64.decode(object.data, message.data = $util.newBuffer($util.base64.length(object.data)), 0);
                            else if (object.data.length >= 0)
                                message.data = object.data;
                        if (object.attributes) {
                            if (typeof object.attributes !== "object")
                                throw TypeError(".google.pubsub.v1.PubsubMessage.attributes: object expected");
                            message.attributes = {};
                            for (var keys = Object.keys(object.attributes), i = 0; i < keys.length; ++i)
                                message.attributes[keys[i]] = String(object.attributes[keys[i]]);
                        }
                        if (object.messageId != null)
                            message.messageId = String(object.messageId);
                        if (object.publishTime != null) {
                            if (typeof object.publishTime !== "object")
                                throw TypeError(".google.pubsub.v1.PubsubMessage.publishTime: object expected");
                            message.publishTime = $root.google.protobuf.Timestamp.fromObject(object.publishTime);
                        }
                        if (object.orderingKey != null)
                            message.orderingKey = String(object.orderingKey);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a PubsubMessage message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.PubsubMessage
                     * @static
                     * @param {google.pubsub.v1.PubsubMessage} message PubsubMessage
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    PubsubMessage.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.objects || options.defaults)
                            object.attributes = {};
                        if (options.defaults) {
                            if (options.bytes === String)
                                object.data = "";
                            else {
                                object.data = [];
                                if (options.bytes !== Array)
                                    object.data = $util.newBuffer(object.data);
                            }
                            object.messageId = "";
                            object.publishTime = null;
                            object.orderingKey = "";
                        }
                        if (message.data != null && message.hasOwnProperty("data"))
                            object.data = options.bytes === String ? $util.base64.encode(message.data, 0, message.data.length) : options.bytes === Array ? Array.prototype.slice.call(message.data) : message.data;
                        var keys2;
                        if (message.attributes && (keys2 = Object.keys(message.attributes)).length) {
                            object.attributes = {};
                            for (var j = 0; j < keys2.length; ++j)
                                object.attributes[keys2[j]] = message.attributes[keys2[j]];
                        }
                        if (message.messageId != null && message.hasOwnProperty("messageId"))
                            object.messageId = message.messageId;
                        if (message.publishTime != null && message.hasOwnProperty("publishTime"))
                            object.publishTime = $root.google.protobuf.Timestamp.toObject(message.publishTime, options);
                        if (message.orderingKey != null && message.hasOwnProperty("orderingKey"))
                            object.orderingKey = message.orderingKey;
                        return object;
                    };
    
                    /**
                     * Converts this PubsubMessage to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.PubsubMessage
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    PubsubMessage.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for PubsubMessage
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.PubsubMessage
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    PubsubMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.PubsubMessage";
                    };
    
                    return PubsubMessage;
                })();
    
                v1.GetTopicRequest = (function() {
    
                    /**
                     * Properties of a GetTopicRequest.
                     * @memberof google.pubsub.v1
                     * @interface IGetTopicRequest
                     * @property {string|null} [topic] GetTopicRequest topic
                     */
    
                    /**
                     * Constructs a new GetTopicRequest.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a GetTopicRequest.
                     * @implements IGetTopicRequest
                     * @constructor
                     * @param {google.pubsub.v1.IGetTopicRequest=} [properties] Properties to set
                     */
                    function GetTopicRequest(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * GetTopicRequest topic.
                     * @member {string} topic
                     * @memberof google.pubsub.v1.GetTopicRequest
                     * @instance
                     */
                    GetTopicRequest.prototype.topic = "";
    
                    /**
                     * Creates a new GetTopicRequest instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.GetTopicRequest
                     * @static
                     * @param {google.pubsub.v1.IGetTopicRequest=} [properties] Properties to set
                     * @returns {google.pubsub.v1.GetTopicRequest} GetTopicRequest instance
                     */
                    GetTopicRequest.create = function create(properties) {
                        return new GetTopicRequest(properties);
                    };
    
                    /**
                     * Encodes the specified GetTopicRequest message. Does not implicitly {@link google.pubsub.v1.GetTopicRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.GetTopicRequest
                     * @static
                     * @param {google.pubsub.v1.IGetTopicRequest} message GetTopicRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    GetTopicRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.topic != null && Object.hasOwnProperty.call(message, "topic"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.topic);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified GetTopicRequest message, length delimited. Does not implicitly {@link google.pubsub.v1.GetTopicRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.GetTopicRequest
                     * @static
                     * @param {google.pubsub.v1.IGetTopicRequest} message GetTopicRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    GetTopicRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a GetTopicRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.GetTopicRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.GetTopicRequest} GetTopicRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    GetTopicRequest.decode = function decode(reader, length, error) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.GetTopicRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            if (tag === error)
                                break;
                            switch (tag >>> 3) {
                            case 1: {
                                    message.topic = reader.string();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a GetTopicRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.GetTopicRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.GetTopicRequest} GetTopicRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    GetTopicRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a GetTopicRequest message.
                     * @function verify
                     * @memberof google.pubsub.v1.GetTopicRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    GetTopicRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.topic != null && message.hasOwnProperty("topic"))
                            if (!$util.isString(message.topic))
                                return "topic: string expected";
                        return null;
                    };
    
                    /**
                     * Creates a GetTopicRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.GetTopicRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.GetTopicRequest} GetTopicRequest
                     */
                    GetTopicRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.GetTopicRequest)
                            return object;
                        var message = new $root.google.pubsub.v1.GetTopicRequest();
                        if (object.topic != null)
                            message.topic = String(object.topic);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a GetTopicRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.GetTopicRequest
                     * @static
                     * @param {google.pubsub.v1.GetTopicRequest} message GetTopicRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    GetTopicRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults)
                            object.topic = "";
                        if (message.topic != null && message.hasOwnProperty("topic"))
                            object.topic = message.topic;
                        return object;
                    };
    
                    /**
                     * Converts this GetTopicRequest to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.GetTopicRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    GetTopicRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for GetTopicRequest
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.GetTopicRequest
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    GetTopicRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.GetTopicRequest";
                    };
    
                    return GetTopicRequest;
                })();
    
                v1.UpdateTopicRequest = (function() {
    
                    /**
                     * Properties of an UpdateTopicRequest.
                     * @memberof google.pubsub.v1
                     * @interface IUpdateTopicRequest
                     * @property {google.pubsub.v1.ITopic|null} [topic] UpdateTopicRequest topic
                     * @property {google.protobuf.IFieldMask|null} [updateMask] UpdateTopicRequest updateMask
                     */
    
                    /**
                     * Constructs a new UpdateTopicRequest.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents an UpdateTopicRequest.
                     * @implements IUpdateTopicRequest
                     * @constructor
                     * @param {google.pubsub.v1.IUpdateTopicRequest=} [properties] Properties to set
                     */
                    function UpdateTopicRequest(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * UpdateTopicRequest topic.
                     * @member {google.pubsub.v1.ITopic|null|undefined} topic
                     * @memberof google.pubsub.v1.UpdateTopicRequest
                     * @instance
                     */
                    UpdateTopicRequest.prototype.topic = null;
    
                    /**
                     * UpdateTopicRequest updateMask.
                     * @member {google.protobuf.IFieldMask|null|undefined} updateMask
                     * @memberof google.pubsub.v1.UpdateTopicRequest
                     * @instance
                     */
                    UpdateTopicRequest.prototype.updateMask = null;
    
                    /**
                     * Creates a new UpdateTopicRequest instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.UpdateTopicRequest
                     * @static
                     * @param {google.pubsub.v1.IUpdateTopicRequest=} [properties] Properties to set
                     * @returns {google.pubsub.v1.UpdateTopicRequest} UpdateTopicRequest instance
                     */
                    UpdateTopicRequest.create = function create(properties) {
                        return new UpdateTopicRequest(properties);
                    };
    
                    /**
                     * Encodes the specified UpdateTopicRequest message. Does not implicitly {@link google.pubsub.v1.UpdateTopicRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.UpdateTopicRequest
                     * @static
                     * @param {google.pubsub.v1.IUpdateTopicRequest} message UpdateTopicRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    UpdateTopicRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.topic != null && Object.hasOwnProperty.call(message, "topic"))
                            $root.google.pubsub.v1.Topic.encode(message.topic, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                        if (message.updateMask != null && Object.hasOwnProperty.call(message, "updateMask"))
                            $root.google.protobuf.FieldMask.encode(message.updateMask, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified UpdateTopicRequest message, length delimited. Does not implicitly {@link google.pubsub.v1.UpdateTopicRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.UpdateTopicRequest
                     * @static
                     * @param {google.pubsub.v1.IUpdateTopicRequest} message UpdateTopicRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    UpdateTopicRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes an UpdateTopicRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.UpdateTopicRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.UpdateTopicRequest} UpdateTopicRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    UpdateTopicRequest.decode = function decode(reader, length, error) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.UpdateTopicRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            if (tag === error)
                                break;
                            switch (tag >>> 3) {
                            case 1: {
                                    message.topic = $root.google.pubsub.v1.Topic.decode(reader, reader.uint32());
                                    break;
                                }
                            case 2: {
                                    message.updateMask = $root.google.protobuf.FieldMask.decode(reader, reader.uint32());
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes an UpdateTopicRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.UpdateTopicRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.UpdateTopicRequest} UpdateTopicRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    UpdateTopicRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies an UpdateTopicRequest message.
                     * @function verify
                     * @memberof google.pubsub.v1.UpdateTopicRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    UpdateTopicRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.topic != null && message.hasOwnProperty("topic")) {
                            var error = $root.google.pubsub.v1.Topic.verify(message.topic);
                            if (error)
                                return "topic." + error;
                        }
                        if (message.updateMask != null && message.hasOwnProperty("updateMask")) {
                            var error = $root.google.protobuf.FieldMask.verify(message.updateMask);
                            if (error)
                                return "updateMask." + error;
                        }
                        return null;
                    };
    
                    /**
                     * Creates an UpdateTopicRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.UpdateTopicRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.UpdateTopicRequest} UpdateTopicRequest
                     */
                    UpdateTopicRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.UpdateTopicRequest)
                            return object;
                        var message = new $root.google.pubsub.v1.UpdateTopicRequest();
                        if (object.topic != null) {
                            if (typeof object.topic !== "object")
                                throw TypeError(".google.pubsub.v1.UpdateTopicRequest.topic: object expected");
                            message.topic = $root.google.pubsub.v1.Topic.fromObject(object.topic);
                        }
                        if (object.updateMask != null) {
                            if (typeof object.updateMask !== "object")
                                throw TypeError(".google.pubsub.v1.UpdateTopicRequest.updateMask: object expected");
                            message.updateMask = $root.google.protobuf.FieldMask.fromObject(object.updateMask);
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from an UpdateTopicRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.UpdateTopicRequest
                     * @static
                     * @param {google.pubsub.v1.UpdateTopicRequest} message UpdateTopicRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    UpdateTopicRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.topic = null;
                            object.updateMask = null;
                        }
                        if (message.topic != null && message.hasOwnProperty("topic"))
                            object.topic = $root.google.pubsub.v1.Topic.toObject(message.topic, options);
                        if (message.updateMask != null && message.hasOwnProperty("updateMask"))
                            object.updateMask = $root.google.protobuf.FieldMask.toObject(message.updateMask, options);
                        return object;
                    };
    
                    /**
                     * Converts this UpdateTopicRequest to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.UpdateTopicRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    UpdateTopicRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for UpdateTopicRequest
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.UpdateTopicRequest
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    UpdateTopicRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.UpdateTopicRequest";
                    };
    
                    return UpdateTopicRequest;
                })();
    
                v1.PublishRequest = (function() {
    
                    /**
                     * Properties of a PublishRequest.
                     * @memberof google.pubsub.v1
                     * @interface IPublishRequest
                     * @property {string|null} [topic] PublishRequest topic
                     * @property {Array.<google.pubsub.v1.IPubsubMessage>|null} [messages] PublishRequest messages
                     */
    
                    /**
                     * Constructs a new PublishRequest.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a PublishRequest.
                     * @implements IPublishRequest
                     * @constructor
                     * @param {google.pubsub.v1.IPublishRequest=} [properties] Properties to set
                     */
                    function PublishRequest(properties) {
                        this.messages = [];
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * PublishRequest topic.
                     * @member {string} topic
                     * @memberof google.pubsub.v1.PublishRequest
                     * @instance
                     */
                    PublishRequest.prototype.topic = "";
    
                    /**
                     * PublishRequest messages.
                     * @member {Array.<google.pubsub.v1.IPubsubMessage>} messages
                     * @memberof google.pubsub.v1.PublishRequest
                     * @instance
                     */
                    PublishRequest.prototype.messages = $util.emptyArray;
    
                    /**
                     * Creates a new PublishRequest instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.PublishRequest
                     * @static
                     * @param {google.pubsub.v1.IPublishRequest=} [properties] Properties to set
                     * @returns {google.pubsub.v1.PublishRequest} PublishRequest instance
                     */
                    PublishRequest.create = function create(properties) {
                        return new PublishRequest(properties);
                    };
    
                    /**
                     * Encodes the specified PublishRequest message. Does not implicitly {@link google.pubsub.v1.PublishRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.PublishRequest
                     * @static
                     * @param {google.pubsub.v1.IPublishRequest} message PublishRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    PublishRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.topic != null && Object.hasOwnProperty.call(message, "topic"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.topic);
                        if (message.messages != null && message.messages.length)
                            for (var i = 0; i < message.messages.length; ++i)
                                $root.google.pubsub.v1.PubsubMessage.encode(message.messages[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified PublishRequest message, length delimited. Does not implicitly {@link google.pubsub.v1.PublishRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.PublishRequest
                     * @static
                     * @param {google.pubsub.v1.IPublishRequest} message PublishRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    PublishRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a PublishRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.PublishRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.PublishRequest} PublishRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    PublishRequest.decode = function decode(reader, length, error) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.PublishRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            if (tag === error)
                                break;
                            switch (tag >>> 3) {
                            case 1: {
                                    message.topic = reader.string();
                                    break;
                                }
                            case 2: {
                                    if (!(message.messages && message.messages.length))
                                        message.messages = [];
                                    message.messages.push($root.google.pubsub.v1.PubsubMessage.decode(reader, reader.uint32()));
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a PublishRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.PublishRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.PublishRequest} PublishRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    PublishRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a PublishRequest message.
                     * @function verify
                     * @memberof google.pubsub.v1.PublishRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    PublishRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.topic != null && message.hasOwnProperty("topic"))
                            if (!$util.isString(message.topic))
                                return "topic: string expected";
                        if (message.messages != null && message.hasOwnProperty("messages")) {
                            if (!Array.isArray(message.messages))
                                return "messages: array expected";
                            for (var i = 0; i < message.messages.length; ++i) {
                                var error = $root.google.pubsub.v1.PubsubMessage.verify(message.messages[i]);
                                if (error)
                                    return "messages." + error;
                            }
                        }
                        return null;
                    };
    
                    /**
                     * Creates a PublishRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.PublishRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.PublishRequest} PublishRequest
                     */
                    PublishRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.PublishRequest)
                            return object;
                        var message = new $root.google.pubsub.v1.PublishRequest();
                        if (object.topic != null)
                            message.topic = String(object.topic);
                        if (object.messages) {
                            if (!Array.isArray(object.messages))
                                throw TypeError(".google.pubsub.v1.PublishRequest.messages: array expected");
                            message.messages = [];
                            for (var i = 0; i < object.messages.length; ++i) {
                                if (typeof object.messages[i] !== "object")
                                    throw TypeError(".google.pubsub.v1.PublishRequest.messages: object expected");
                                message.messages[i] = $root.google.pubsub.v1.PubsubMessage.fromObject(object.messages[i]);
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a PublishRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.PublishRequest
                     * @static
                     * @param {google.pubsub.v1.PublishRequest} message PublishRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    PublishRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.arrays || options.defaults)
                            object.messages = [];
                        if (options.defaults)
                            object.topic = "";
                        if (message.topic != null && message.hasOwnProperty("topic"))
                            object.topic = message.topic;
                        if (message.messages && message.messages.length) {
                            object.messages = [];
                            for (var j = 0; j < message.messages.length; ++j)
                                object.messages[j] = $root.google.pubsub.v1.PubsubMessage.toObject(message.messages[j], options);
                        }
                        return object;
                    };
    
                    /**
                     * Converts this PublishRequest to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.PublishRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    PublishRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for PublishRequest
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.PublishRequest
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    PublishRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.PublishRequest";
                    };
    
                    return PublishRequest;
                })();
    
                v1.PublishResponse = (function() {
    
                    /**
                     * Properties of a PublishResponse.
                     * @memberof google.pubsub.v1
                     * @interface IPublishResponse
                     * @property {Array.<string>|null} [messageIds] PublishResponse messageIds
                     */
    
                    /**
                     * Constructs a new PublishResponse.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a PublishResponse.
                     * @implements IPublishResponse
                     * @constructor
                     * @param {google.pubsub.v1.IPublishResponse=} [properties] Properties to set
                     */
                    function PublishResponse(properties) {
                        this.messageIds = [];
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * PublishResponse messageIds.
                     * @member {Array.<string>} messageIds
                     * @memberof google.pubsub.v1.PublishResponse
                     * @instance
                     */
                    PublishResponse.prototype.messageIds = $util.emptyArray;
    
                    /**
                     * Creates a new PublishResponse instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.PublishResponse
                     * @static
                     * @param {google.pubsub.v1.IPublishResponse=} [properties] Properties to set
                     * @returns {google.pubsub.v1.PublishResponse} PublishResponse instance
                     */
                    PublishResponse.create = function create(properties) {
                        return new PublishResponse(properties);
                    };
    
                    /**
                     * Encodes the specified PublishResponse message. Does not implicitly {@link google.pubsub.v1.PublishResponse.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.PublishResponse
                     * @static
                     * @param {google.pubsub.v1.IPublishResponse} message PublishResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    PublishResponse.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.messageIds != null && message.messageIds.length)
                            for (var i = 0; i < message.messageIds.length; ++i)
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.messageIds[i]);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified PublishResponse message, length delimited. Does not implicitly {@link google.pubsub.v1.PublishResponse.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.PublishResponse
                     * @static
                     * @param {google.pubsub.v1.IPublishResponse} message PublishResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    PublishResponse.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a PublishResponse message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.PublishResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.PublishResponse} PublishResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    PublishResponse.decode = function decode(reader, length, error) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.PublishResponse();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            if (tag === error)
                                break;
                            switch (tag >>> 3) {
                            case 1: {
                                    if (!(message.messageIds && message.messageIds.length))
                                        message.messageIds = [];
                                    message.messageIds.push(reader.string());
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a PublishResponse message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.PublishResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.PublishResponse} PublishResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    PublishResponse.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a PublishResponse message.
                     * @function verify
                     * @memberof google.pubsub.v1.PublishResponse
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    PublishResponse.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.messageIds != null && message.hasOwnProperty("messageIds")) {
                            if (!Array.isArray(message.messageIds))
                                return "messageIds: array expected";
                            for (var i = 0; i < message.messageIds.length; ++i)
                                if (!$util.isString(message.messageIds[i]))
                                    return "messageIds: string[] expected";
                        }
                        return null;
                    };
    
                    /**
                     * Creates a PublishResponse message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.PublishResponse
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.PublishResponse} PublishResponse
                     */
                    PublishResponse.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.PublishResponse)
                            return object;
                        var message = new $root.google.pubsub.v1.PublishResponse();
                        if (object.messageIds) {
                            if (!Array.isArray(object.messageIds))
                                throw TypeError(".google.pubsub.v1.PublishResponse.messageIds: array expected");
                            message.messageIds = [];
                            for (var i = 0; i < object.messageIds.length; ++i)
                                message.messageIds[i] = String(object.messageIds[i]);
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a PublishResponse message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.PublishResponse
                     * @static
                     * @param {google.pubsub.v1.PublishResponse} message PublishResponse
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    PublishResponse.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.arrays || options.defaults)
                            object.messageIds = [];
                        if (message.messageIds && message.messageIds.length) {
                            object.messageIds = [];
                            for (var j = 0; j < message.messageIds.length; ++j)
                                object.messageIds[j] = message.messageIds[j];
                        }
                        return object;
                    };
    
                    /**
                     * Converts this PublishResponse to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.PublishResponse
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    PublishResponse.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for PublishResponse
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.PublishResponse
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    PublishResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.PublishResponse";
                    };
    
                    return PublishResponse;
                })();
    
                v1.ListTopicsRequest = (function() {
    
                    /**
                     * Properties of a ListTopicsRequest.
                     * @memberof google.pubsub.v1
                     * @interface IListTopicsRequest
                     * @property {string|null} [project] ListTopicsRequest project
                     * @property {number|null} [pageSize] ListTopicsRequest pageSize
                     * @property {string|null} [pageToken] ListTopicsRequest pageToken
                     */
    
                    /**
                     * Constructs a new ListTopicsRequest.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a ListTopicsRequest.
                     * @implements IListTopicsRequest
                     * @constructor
                     * @param {google.pubsub.v1.IListTopicsRequest=} [properties] Properties to set
                     */
                    function ListTopicsRequest(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * ListTopicsRequest project.
                     * @member {string} project
                     * @memberof google.pubsub.v1.ListTopicsRequest
                     * @instance
                     */
                    ListTopicsRequest.prototype.project = "";
    
                    /**
                     * ListTopicsRequest pageSize.
                     * @member {number} pageSize
                     * @memberof google.pubsub.v1.ListTopicsRequest
                     * @instance
                     */
                    ListTopicsRequest.prototype.pageSize = 0;
    
                    /**
                     * ListTopicsRequest pageToken.
                     * @member {string} pageToken
                     * @memberof google.pubsub.v1.ListTopicsRequest
                     * @instance
                     */
                    ListTopicsRequest.prototype.pageToken = "";
    
                    /**
                     * Creates a new ListTopicsRequest instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.ListTopicsRequest
                     * @static
                     * @param {google.pubsub.v1.IListTopicsRequest=} [properties] Properties to set
                     * @returns {google.pubsub.v1.ListTopicsRequest} ListTopicsRequest instance
                     */
                    ListTopicsRequest.create = function create(properties) {
                        return new ListTopicsRequest(properties);
                    };
    
                    /**
                     * Encodes the specified ListTopicsRequest message. Does not implicitly {@link google.pubsub.v1.ListTopicsRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.ListTopicsRequest
                     * @static
                     * @param {google.pubsub.v1.IListTopicsRequest} message ListTopicsRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ListTopicsRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.project != null && Object.hasOwnProperty.call(message, "project"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.project);
                        if (message.pageSize != null && Object.hasOwnProperty.call(message, "pageSize"))
                            writer.uint32(/* id 2, wireType 0 =*/16).int32(message.pageSize);
                        if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                            writer.uint32(/* id 3, wireType 2 =*/26).string(message.pageToken);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified ListTopicsRequest message, length delimited. Does not implicitly {@link google.pubsub.v1.ListTopicsRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.ListTopicsRequest
                     * @static
                     * @param {google.pubsub.v1.IListTopicsRequest} message ListTopicsRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ListTopicsRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a ListTopicsRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.ListTopicsRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.ListTopicsRequest} ListTopicsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ListTopicsRequest.decode = function decode(reader, length, error) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.ListTopicsRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            if (tag === error)
                                break;
                            switch (tag >>> 3) {
                            case 1: {
                                    message.project = reader.string();
                                    break;
                                }
                            case 2: {
                                    message.pageSize = reader.int32();
                                    break;
                                }
                            case 3: {
                                    message.pageToken = reader.string();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a ListTopicsRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.ListTopicsRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.ListTopicsRequest} ListTopicsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ListTopicsRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a ListTopicsRequest message.
                     * @function verify
                     * @memberof google.pubsub.v1.ListTopicsRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    ListTopicsRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.project != null && message.hasOwnProperty("project"))
                            if (!$util.isString(message.project))
                                return "project: string expected";
                        if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                            if (!$util.isInteger(message.pageSize))
                                return "pageSize: integer expected";
                        if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                            if (!$util.isString(message.pageToken))
                                return "pageToken: string expected";
                        return null;
                    };
    
                    /**
                     * Creates a ListTopicsRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.ListTopicsRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.ListTopicsRequest} ListTopicsRequest
                     */
                    ListTopicsRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.ListTopicsRequest)
                            return object;
                        var message = new $root.google.pubsub.v1.ListTopicsRequest();
                        if (object.project != null)
                            message.project = String(object.project);
                        if (object.pageSize != null)
                            message.pageSize = object.pageSize | 0;
                        if (object.pageToken != null)
                            message.pageToken = String(object.pageToken);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a ListTopicsRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.ListTopicsRequest
                     * @static
                     * @param {google.pubsub.v1.ListTopicsRequest} message ListTopicsRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    ListTopicsRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.project = "";
                            object.pageSize = 0;
                            object.pageToken = "";
                        }
                        if (message.project != null && message.hasOwnProperty("project"))
                            object.project = message.project;
                        if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                            object.pageSize = message.pageSize;
                        if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                            object.pageToken = message.pageToken;
                        return object;
                    };
    
                    /**
                     * Converts this ListTopicsRequest to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.ListTopicsRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    ListTopicsRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for ListTopicsRequest
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.ListTopicsRequest
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    ListTopicsRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.ListTopicsRequest";
                    };
    
                    return ListTopicsRequest;
                })();
    
                v1.ListTopicsResponse = (function() {
    
                    /**
                     * Properties of a ListTopicsResponse.
                     * @memberof google.pubsub.v1
                     * @interface IListTopicsResponse
                     * @property {Array.<google.pubsub.v1.ITopic>|null} [topics] ListTopicsResponse topics
                     * @property {string|null} [nextPageToken] ListTopicsResponse nextPageToken
                     */
    
                    /**
                     * Constructs a new ListTopicsResponse.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a ListTopicsResponse.
                     * @implements IListTopicsResponse
                     * @constructor
                     * @param {google.pubsub.v1.IListTopicsResponse=} [properties] Properties to set
                     */
                    function ListTopicsResponse(properties) {
                        this.topics = [];
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * ListTopicsResponse topics.
                     * @member {Array.<google.pubsub.v1.ITopic>} topics
                     * @memberof google.pubsub.v1.ListTopicsResponse
                     * @instance
                     */
                    ListTopicsResponse.prototype.topics = $util.emptyArray;
    
                    /**
                     * ListTopicsResponse nextPageToken.
                     * @member {string} nextPageToken
                     * @memberof google.pubsub.v1.ListTopicsResponse
                     * @instance
                     */
                    ListTopicsResponse.prototype.nextPageToken = "";
    
                    /**
                     * Creates a new ListTopicsResponse instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.ListTopicsResponse
                     * @static
                     * @param {google.pubsub.v1.IListTopicsResponse=} [properties] Properties to set
                     * @returns {google.pubsub.v1.ListTopicsResponse} ListTopicsResponse instance
                     */
                    ListTopicsResponse.create = function create(properties) {
                        return new ListTopicsResponse(properties);
                    };
    
                    /**
                     * Encodes the specified ListTopicsResponse message. Does not implicitly {@link google.pubsub.v1.ListTopicsResponse.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.ListTopicsResponse
                     * @static
                     * @param {google.pubsub.v1.IListTopicsResponse} message ListTopicsResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ListTopicsResponse.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.topics != null && message.topics.length)
                            for (var i = 0; i < message.topics.length; ++i)
                                $root.google.pubsub.v1.Topic.encode(message.topics[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                        if (message.nextPageToken != null && Object.hasOwnProperty.call(message, "nextPageToken"))
                            writer.uint32(/* id 2, wireType 2 =*/18).string(message.nextPageToken);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified ListTopicsResponse message, length delimited. Does not implicitly {@link google.pubsub.v1.ListTopicsResponse.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.ListTopicsResponse
                     * @static
                     * @param {google.pubsub.v1.IListTopicsResponse} message ListTopicsResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ListTopicsResponse.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a ListTopicsResponse message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.ListTopicsResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.ListTopicsResponse} ListTopicsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ListTopicsResponse.decode = function decode(reader, length, error) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.ListTopicsResponse();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            if (tag === error)
                                break;
                            switch (tag >>> 3) {
                            case 1: {
                                    if (!(message.topics && message.topics.length))
                                        message.topics = [];
                                    message.topics.push($root.google.pubsub.v1.Topic.decode(reader, reader.uint32()));
                                    break;
                                }
                            case 2: {
                                    message.nextPageToken = reader.string();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a ListTopicsResponse message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.ListTopicsResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.ListTopicsResponse} ListTopicsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ListTopicsResponse.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a ListTopicsResponse message.
                     * @function verify
                     * @memberof google.pubsub.v1.ListTopicsResponse
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    ListTopicsResponse.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.topics != null && message.hasOwnProperty("topics")) {
                            if (!Array.isArray(message.topics))
                                return "topics: array expected";
                            for (var i = 0; i < message.topics.length; ++i) {
                                var error = $root.google.pubsub.v1.Topic.verify(message.topics[i]);
                                if (error)
                                    return "topics." + error;
                            }
                        }
                        if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                            if (!$util.isString(message.nextPageToken))
                                return "nextPageToken: string expected";
                        return null;
                    };
    
                    /**
                     * Creates a ListTopicsResponse message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.ListTopicsResponse
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.ListTopicsResponse} ListTopicsResponse
                     */
                    ListTopicsResponse.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.ListTopicsResponse)
                            return object;
                        var message = new $root.google.pubsub.v1.ListTopicsResponse();
                        if (object.topics) {
                            if (!Array.isArray(object.topics))
                                throw TypeError(".google.pubsub.v1.ListTopicsResponse.topics: array expected");
                            message.topics = [];
                            for (var i = 0; i < object.topics.length; ++i) {
                                if (typeof object.topics[i] !== "object")
                                    throw TypeError(".google.pubsub.v1.ListTopicsResponse.topics: object expected");
                                message.topics[i] = $root.google.pubsub.v1.Topic.fromObject(object.topics[i]);
                            }
                        }
                        if (object.nextPageToken != null)
                            message.nextPageToken = String(object.nextPageToken);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a ListTopicsResponse message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.ListTopicsResponse
                     * @static
                     * @param {google.pubsub.v1.ListTopicsResponse} message ListTopicsResponse
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    ListTopicsResponse.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.arrays || options.defaults)
                            object.topics = [];
                        if (options.defaults)
                            object.nextPageToken = "";
                        if (message.topics && message.topics.length) {
                            object.topics = [];
                            for (var j = 0; j < message.topics.length; ++j)
                                object.topics[j] = $root.google.pubsub.v1.Topic.toObject(message.topics[j], options);
                        }
                        if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                            object.nextPageToken = message.nextPageToken;
                        return object;
                    };
    
                    /**
                     * Converts this ListTopicsResponse to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.ListTopicsResponse
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    ListTopicsResponse.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for ListTopicsResponse
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.ListTopicsResponse
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    ListTopicsResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.ListTopicsResponse";
                    };
    
                    return ListTopicsResponse;
                })();
    
                v1.ListTopicSubscriptionsRequest = (function() {
    
                    /**
                     * Properties of a ListTopicSubscriptionsRequest.
                     * @memberof google.pubsub.v1
                     * @interface IListTopicSubscriptionsRequest
                     * @property {string|null} [topic] ListTopicSubscriptionsRequest topic
                     * @property {number|null} [pageSize] ListTopicSubscriptionsRequest pageSize
                     * @property {string|null} [pageToken] ListTopicSubscriptionsRequest pageToken
                     */
    
                    /**
                     * Constructs a new ListTopicSubscriptionsRequest.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a ListTopicSubscriptionsRequest.
                     * @implements IListTopicSubscriptionsRequest
                     * @constructor
                     * @param {google.pubsub.v1.IListTopicSubscriptionsRequest=} [properties] Properties to set
                     */
                    function ListTopicSubscriptionsRequest(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * ListTopicSubscriptionsRequest topic.
                     * @member {string} topic
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsRequest
                     * @instance
                     */
                    ListTopicSubscriptionsRequest.prototype.topic = "";
    
                    /**
                     * ListTopicSubscriptionsRequest pageSize.
                     * @member {number} pageSize
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsRequest
                     * @instance
                     */
                    ListTopicSubscriptionsRequest.prototype.pageSize = 0;
    
                    /**
                     * ListTopicSubscriptionsRequest pageToken.
                     * @member {string} pageToken
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsRequest
                     * @instance
                     */
                    ListTopicSubscriptionsRequest.prototype.pageToken = "";
    
                    /**
                     * Creates a new ListTopicSubscriptionsRequest instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsRequest
                     * @static
                     * @param {google.pubsub.v1.IListTopicSubscriptionsRequest=} [properties] Properties to set
                     * @returns {google.pubsub.v1.ListTopicSubscriptionsRequest} ListTopicSubscriptionsRequest instance
                     */
                    ListTopicSubscriptionsRequest.create = function create(properties) {
                        return new ListTopicSubscriptionsRequest(properties);
                    };
    
                    /**
                     * Encodes the specified ListTopicSubscriptionsRequest message. Does not implicitly {@link google.pubsub.v1.ListTopicSubscriptionsRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsRequest
                     * @static
                     * @param {google.pubsub.v1.IListTopicSubscriptionsRequest} message ListTopicSubscriptionsRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ListTopicSubscriptionsRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.topic != null && Object.hasOwnProperty.call(message, "topic"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.topic);
                        if (message.pageSize != null && Object.hasOwnProperty.call(message, "pageSize"))
                            writer.uint32(/* id 2, wireType 0 =*/16).int32(message.pageSize);
                        if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                            writer.uint32(/* id 3, wireType 2 =*/26).string(message.pageToken);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified ListTopicSubscriptionsRequest message, length delimited. Does not implicitly {@link google.pubsub.v1.ListTopicSubscriptionsRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsRequest
                     * @static
                     * @param {google.pubsub.v1.IListTopicSubscriptionsRequest} message ListTopicSubscriptionsRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ListTopicSubscriptionsRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a ListTopicSubscriptionsRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.ListTopicSubscriptionsRequest} ListTopicSubscriptionsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ListTopicSubscriptionsRequest.decode = function decode(reader, length, error) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.ListTopicSubscriptionsRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            if (tag === error)
                                break;
                            switch (tag >>> 3) {
                            case 1: {
                                    message.topic = reader.string();
                                    break;
                                }
                            case 2: {
                                    message.pageSize = reader.int32();
                                    break;
                                }
                            case 3: {
                                    message.pageToken = reader.string();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a ListTopicSubscriptionsRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.ListTopicSubscriptionsRequest} ListTopicSubscriptionsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ListTopicSubscriptionsRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a ListTopicSubscriptionsRequest message.
                     * @function verify
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    ListTopicSubscriptionsRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.topic != null && message.hasOwnProperty("topic"))
                            if (!$util.isString(message.topic))
                                return "topic: string expected";
                        if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                            if (!$util.isInteger(message.pageSize))
                                return "pageSize: integer expected";
                        if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                            if (!$util.isString(message.pageToken))
                                return "pageToken: string expected";
                        return null;
                    };
    
                    /**
                     * Creates a ListTopicSubscriptionsRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.ListTopicSubscriptionsRequest} ListTopicSubscriptionsRequest
                     */
                    ListTopicSubscriptionsRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.ListTopicSubscriptionsRequest)
                            return object;
                        var message = new $root.google.pubsub.v1.ListTopicSubscriptionsRequest();
                        if (object.topic != null)
                            message.topic = String(object.topic);
                        if (object.pageSize != null)
                            message.pageSize = object.pageSize | 0;
                        if (object.pageToken != null)
                            message.pageToken = String(object.pageToken);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a ListTopicSubscriptionsRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsRequest
                     * @static
                     * @param {google.pubsub.v1.ListTopicSubscriptionsRequest} message ListTopicSubscriptionsRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    ListTopicSubscriptionsRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.topic = "";
                            object.pageSize = 0;
                            object.pageToken = "";
                        }
                        if (message.topic != null && message.hasOwnProperty("topic"))
                            object.topic = message.topic;
                        if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                            object.pageSize = message.pageSize;
                        if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                            object.pageToken = message.pageToken;
                        return object;
                    };
    
                    /**
                     * Converts this ListTopicSubscriptionsRequest to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    ListTopicSubscriptionsRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for ListTopicSubscriptionsRequest
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsRequest
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    ListTopicSubscriptionsRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.ListTopicSubscriptionsRequest";
                    };
    
                    return ListTopicSubscriptionsRequest;
                })();
    
                v1.ListTopicSubscriptionsResponse = (function() {
    
                    /**
                     * Properties of a ListTopicSubscriptionsResponse.
                     * @memberof google.pubsub.v1
                     * @interface IListTopicSubscriptionsResponse
                     * @property {Array.<string>|null} [subscriptions] ListTopicSubscriptionsResponse subscriptions
                     * @property {string|null} [nextPageToken] ListTopicSubscriptionsResponse nextPageToken
                     */
    
                    /**
                     * Constructs a new ListTopicSubscriptionsResponse.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a ListTopicSubscriptionsResponse.
                     * @implements IListTopicSubscriptionsResponse
                     * @constructor
                     * @param {google.pubsub.v1.IListTopicSubscriptionsResponse=} [properties] Properties to set
                     */
                    function ListTopicSubscriptionsResponse(properties) {
                        this.subscriptions = [];
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * ListTopicSubscriptionsResponse subscriptions.
                     * @member {Array.<string>} subscriptions
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsResponse
                     * @instance
                     */
                    ListTopicSubscriptionsResponse.prototype.subscriptions = $util.emptyArray;
    
                    /**
                     * ListTopicSubscriptionsResponse nextPageToken.
                     * @member {string} nextPageToken
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsResponse
                     * @instance
                     */
                    ListTopicSubscriptionsResponse.prototype.nextPageToken = "";
    
                    /**
                     * Creates a new ListTopicSubscriptionsResponse instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsResponse
                     * @static
                     * @param {google.pubsub.v1.IListTopicSubscriptionsResponse=} [properties] Properties to set
                     * @returns {google.pubsub.v1.ListTopicSubscriptionsResponse} ListTopicSubscriptionsResponse instance
                     */
                    ListTopicSubscriptionsResponse.create = function create(properties) {
                        return new ListTopicSubscriptionsResponse(properties);
                    };
    
                    /**
                     * Encodes the specified ListTopicSubscriptionsResponse message. Does not implicitly {@link google.pubsub.v1.ListTopicSubscriptionsResponse.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsResponse
                     * @static
                     * @param {google.pubsub.v1.IListTopicSubscriptionsResponse} message ListTopicSubscriptionsResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ListTopicSubscriptionsResponse.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.subscriptions != null && message.subscriptions.length)
                            for (var i = 0; i < message.subscriptions.length; ++i)
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.subscriptions[i]);
                        if (message.nextPageToken != null && Object.hasOwnProperty.call(message, "nextPageToken"))
                            writer.uint32(/* id 2, wireType 2 =*/18).string(message.nextPageToken);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified ListTopicSubscriptionsResponse message, length delimited. Does not implicitly {@link google.pubsub.v1.ListTopicSubscriptionsResponse.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsResponse
                     * @static
                     * @param {google.pubsub.v1.IListTopicSubscriptionsResponse} message ListTopicSubscriptionsResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ListTopicSubscriptionsResponse.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a ListTopicSubscriptionsResponse message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.ListTopicSubscriptionsResponse} ListTopicSubscriptionsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ListTopicSubscriptionsResponse.decode = function decode(reader, length, error) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.ListTopicSubscriptionsResponse();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            if (tag === error)
                                break;
                            switch (tag >>> 3) {
                            case 1: {
                                    if (!(message.subscriptions && message.subscriptions.length))
                                        message.subscriptions = [];
                                    message.subscriptions.push(reader.string());
                                    break;
                                }
                            case 2: {
                                    message.nextPageToken = reader.string();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a ListTopicSubscriptionsResponse message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.ListTopicSubscriptionsResponse} ListTopicSubscriptionsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ListTopicSubscriptionsResponse.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a ListTopicSubscriptionsResponse message.
                     * @function verify
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsResponse
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    ListTopicSubscriptionsResponse.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.subscriptions != null && message.hasOwnProperty("subscriptions")) {
                            if (!Array.isArray(message.subscriptions))
                                return "subscriptions: array expected";
                            for (var i = 0; i < message.subscriptions.length; ++i)
                                if (!$util.isString(message.subscriptions[i]))
                                    return "subscriptions: string[] expected";
                        }
                        if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                            if (!$util.isString(message.nextPageToken))
                                return "nextPageToken: string expected";
                        return null;
                    };
    
                    /**
                     * Creates a ListTopicSubscriptionsResponse message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsResponse
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.ListTopicSubscriptionsResponse} ListTopicSubscriptionsResponse
                     */
                    ListTopicSubscriptionsResponse.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.ListTopicSubscriptionsResponse)
                            return object;
                        var message = new $root.google.pubsub.v1.ListTopicSubscriptionsResponse();
                        if (object.subscriptions) {
                            if (!Array.isArray(object.subscriptions))
                                throw TypeError(".google.pubsub.v1.ListTopicSubscriptionsResponse.subscriptions: array expected");
                            message.subscriptions = [];
                            for (var i = 0; i < object.subscriptions.length; ++i)
                                message.subscriptions[i] = String(object.subscriptions[i]);
                        }
                        if (object.nextPageToken != null)
                            message.nextPageToken = String(object.nextPageToken);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a ListTopicSubscriptionsResponse message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsResponse
                     * @static
                     * @param {google.pubsub.v1.ListTopicSubscriptionsResponse} message ListTopicSubscriptionsResponse
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    ListTopicSubscriptionsResponse.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.arrays || options.defaults)
                            object.subscriptions = [];
                        if (options.defaults)
                            object.nextPageToken = "";
                        if (message.subscriptions && message.subscriptions.length) {
                            object.subscriptions = [];
                            for (var j = 0; j < message.subscriptions.length; ++j)
                                object.subscriptions[j] = message.subscriptions[j];
                        }
                        if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                            object.nextPageToken = message.nextPageToken;
                        return object;
                    };
    
                    /**
                     * Converts this ListTopicSubscriptionsResponse to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsResponse
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    ListTopicSubscriptionsResponse.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for ListTopicSubscriptionsResponse
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsResponse
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    ListTopicSubscriptionsResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.ListTopicSubscriptionsResponse";
                    };
    
                    return ListTopicSubscriptionsResponse;
                })();
    
                v1.ListTopicSnapshotsRequest = (function() {
    
                    /**
                     * Properties of a ListTopicSnapshotsRequest.
                     * @memberof google.pubsub.v1
                     * @interface IListTopicSnapshotsRequest
                     * @property {string|null} [topic] ListTopicSnapshotsRequest topic
                     * @property {number|null} [pageSize] ListTopicSnapshotsRequest pageSize
                     * @property {string|null} [pageToken] ListTopicSnapshotsRequest pageToken
                     */
    
                    /**
                     * Constructs a new ListTopicSnapshotsRequest.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a ListTopicSnapshotsRequest.
                     * @implements IListTopicSnapshotsRequest
                     * @constructor
                     * @param {google.pubsub.v1.IListTopicSnapshotsRequest=} [properties] Properties to set
                     */
                    function ListTopicSnapshotsRequest(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * ListTopicSnapshotsRequest topic.
                     * @member {string} topic
                     * @memberof google.pubsub.v1.ListTopicSnapshotsRequest
                     * @instance
                     */
                    ListTopicSnapshotsRequest.prototype.topic = "";
    
                    /**
                     * ListTopicSnapshotsRequest pageSize.
                     * @member {number} pageSize
                     * @memberof google.pubsub.v1.ListTopicSnapshotsRequest
                     * @instance
                     */
                    ListTopicSnapshotsRequest.prototype.pageSize = 0;
    
                    /**
                     * ListTopicSnapshotsRequest pageToken.
                     * @member {string} pageToken
                     * @memberof google.pubsub.v1.ListTopicSnapshotsRequest
                     * @instance
                     */
                    ListTopicSnapshotsRequest.prototype.pageToken = "";
    
                    /**
                     * Creates a new ListTopicSnapshotsRequest instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.ListTopicSnapshotsRequest
                     * @static
                     * @param {google.pubsub.v1.IListTopicSnapshotsRequest=} [properties] Properties to set
                     * @returns {google.pubsub.v1.ListTopicSnapshotsRequest} ListTopicSnapshotsRequest instance
                     */
                    ListTopicSnapshotsRequest.create = function create(properties) {
                        return new ListTopicSnapshotsRequest(properties);
                    };
    
                    /**
                     * Encodes the specified ListTopicSnapshotsRequest message. Does not implicitly {@link google.pubsub.v1.ListTopicSnapshotsRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.ListTopicSnapshotsRequest
                     * @static
                     * @param {google.pubsub.v1.IListTopicSnapshotsRequest} message ListTopicSnapshotsRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ListTopicSnapshotsRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.topic != null && Object.hasOwnProperty.call(message, "topic"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.topic);
                        if (message.pageSize != null && Object.hasOwnProperty.call(message, "pageSize"))
                            writer.uint32(/* id 2, wireType 0 =*/16).int32(message.pageSize);
                        if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                            writer.uint32(/* id 3, wireType 2 =*/26).string(message.pageToken);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified ListTopicSnapshotsRequest message, length delimited. Does not implicitly {@link google.pubsub.v1.ListTopicSnapshotsRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.ListTopicSnapshotsRequest
                     * @static
                     * @param {google.pubsub.v1.IListTopicSnapshotsRequest} message ListTopicSnapshotsRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ListTopicSnapshotsRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a ListTopicSnapshotsRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.ListTopicSnapshotsRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.ListTopicSnapshotsRequest} ListTopicSnapshotsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ListTopicSnapshotsRequest.decode = function decode(reader, length, error) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.ListTopicSnapshotsRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            if (tag === error)
                                break;
                            switch (tag >>> 3) {
                            case 1: {
                                    message.topic = reader.string();
                                    break;
                                }
                            case 2: {
                                    message.pageSize = reader.int32();
                                    break;
                                }
                            case 3: {
                                    message.pageToken = reader.string();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a ListTopicSnapshotsRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.ListTopicSnapshotsRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.ListTopicSnapshotsRequest} ListTopicSnapshotsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ListTopicSnapshotsRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a ListTopicSnapshotsRequest message.
                     * @function verify
                     * @memberof google.pubsub.v1.ListTopicSnapshotsRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    ListTopicSnapshotsRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.topic != null && message.hasOwnProperty("topic"))
                            if (!$util.isString(message.topic))
                                return "topic: string expected";
                        if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                            if (!$util.isInteger(message.pageSize))
                                return "pageSize: integer expected";
                        if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                            if (!$util.isString(message.pageToken))
                                return "pageToken: string expected";
                        return null;
                    };
    
                    /**
                     * Creates a ListTopicSnapshotsRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.ListTopicSnapshotsRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.ListTopicSnapshotsRequest} ListTopicSnapshotsRequest
                     */
                    ListTopicSnapshotsRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.ListTopicSnapshotsRequest)
                            return object;
                        var message = new $root.google.pubsub.v1.ListTopicSnapshotsRequest();
                        if (object.topic != null)
                            message.topic = String(object.topic);
                        if (object.pageSize != null)
                            message.pageSize = object.pageSize | 0;
                        if (object.pageToken != null)
                            message.pageToken = String(object.pageToken);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a ListTopicSnapshotsRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.ListTopicSnapshotsRequest
                     * @static
                     * @param {google.pubsub.v1.ListTopicSnapshotsRequest} message ListTopicSnapshotsRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    ListTopicSnapshotsRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.topic = "";
                            object.pageSize = 0;
                            object.pageToken = "";
                        }
                        if (message.topic != null && message.hasOwnProperty("topic"))
                            object.topic = message.topic;
                        if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                            object.pageSize = message.pageSize;
                        if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                            object.pageToken = message.pageToken;
                        return object;
                    };
    
                    /**
                     * Converts this ListTopicSnapshotsRequest to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.ListTopicSnapshotsRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    ListTopicSnapshotsRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for ListTopicSnapshotsRequest
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.ListTopicSnapshotsRequest
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    ListTopicSnapshotsRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.ListTopicSnapshotsRequest";
                    };
    
                    return ListTopicSnapshotsRequest;
                })();
    
                v1.ListTopicSnapshotsResponse = (function() {
    
                    /**
                     * Properties of a ListTopicSnapshotsResponse.
                     * @memberof google.pubsub.v1
                     * @interface IListTopicSnapshotsResponse
                     * @property {Array.<string>|null} [snapshots] ListTopicSnapshotsResponse snapshots
                     * @property {string|null} [nextPageToken] ListTopicSnapshotsResponse nextPageToken
                     */
    
                    /**
                     * Constructs a new ListTopicSnapshotsResponse.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a ListTopicSnapshotsResponse.
                     * @implements IListTopicSnapshotsResponse
                     * @constructor
                     * @param {google.pubsub.v1.IListTopicSnapshotsResponse=} [properties] Properties to set
                     */
                    function ListTopicSnapshotsResponse(properties) {
                        this.snapshots = [];
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * ListTopicSnapshotsResponse snapshots.
                     * @member {Array.<string>} snapshots
                     * @memberof google.pubsub.v1.ListTopicSnapshotsResponse
                     * @instance
                     */
                    ListTopicSnapshotsResponse.prototype.snapshots = $util.emptyArray;
    
                    /**
                     * ListTopicSnapshotsResponse nextPageToken.
                     * @member {string} nextPageToken
                     * @memberof google.pubsub.v1.ListTopicSnapshotsResponse
                     * @instance
                     */
                    ListTopicSnapshotsResponse.prototype.nextPageToken = "";
    
                    /**
                     * Creates a new ListTopicSnapshotsResponse instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.ListTopicSnapshotsResponse
                     * @static
                     * @param {google.pubsub.v1.IListTopicSnapshotsResponse=} [properties] Properties to set
                     * @returns {google.pubsub.v1.ListTopicSnapshotsResponse} ListTopicSnapshotsResponse instance
                     */
                    ListTopicSnapshotsResponse.create = function create(properties) {
                        return new ListTopicSnapshotsResponse(properties);
                    };
    
                    /**
                     * Encodes the specified ListTopicSnapshotsResponse message. Does not implicitly {@link google.pubsub.v1.ListTopicSnapshotsResponse.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.ListTopicSnapshotsResponse
                     * @static
                     * @param {google.pubsub.v1.IListTopicSnapshotsResponse} message ListTopicSnapshotsResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ListTopicSnapshotsResponse.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.snapshots != null && message.snapshots.length)
                            for (var i = 0; i < message.snapshots.length; ++i)
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.snapshots[i]);
                        if (message.nextPageToken != null && Object.hasOwnProperty.call(message, "nextPageToken"))
                            writer.uint32(/* id 2, wireType 2 =*/18).string(message.nextPageToken);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified ListTopicSnapshotsResponse message, length delimited. Does not implicitly {@link google.pubsub.v1.ListTopicSnapshotsResponse.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.ListTopicSnapshotsResponse
                     * @static
                     * @param {google.pubsub.v1.IListTopicSnapshotsResponse} message ListTopicSnapshotsResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ListTopicSnapshotsResponse.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a ListTopicSnapshotsResponse message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.ListTopicSnapshotsResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.ListTopicSnapshotsResponse} ListTopicSnapshotsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ListTopicSnapshotsResponse.decode = function decode(reader, length, error) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.ListTopicSnapshotsResponse();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            if (tag === error)
                                break;
                            switch (tag >>> 3) {
                            case 1: {
                                    if (!(message.snapshots && message.snapshots.length))
                                        message.snapshots = [];
                                    message.snapshots.push(reader.string());
                                    break;
                                }
                            case 2: {
                                    message.nextPageToken = reader.string();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a ListTopicSnapshotsResponse message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.ListTopicSnapshotsResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.ListTopicSnapshotsResponse} ListTopicSnapshotsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ListTopicSnapshotsResponse.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a ListTopicSnapshotsResponse message.
                     * @function verify
                     * @memberof google.pubsub.v1.ListTopicSnapshotsResponse
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    ListTopicSnapshotsResponse.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.snapshots != null && message.hasOwnProperty("snapshots")) {
                            if (!Array.isArray(message.snapshots))
                                return "snapshots: array expected";
                            for (var i = 0; i < message.snapshots.length; ++i)
                                if (!$util.isString(message.snapshots[i]))
                                    return "snapshots: string[] expected";
                        }
                        if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                            if (!$util.isString(message.nextPageToken))
                                return "nextPageToken: string expected";
                        return null;
                    };
    
                    /**
                     * Creates a ListTopicSnapshotsResponse message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.ListTopicSnapshotsResponse
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.ListTopicSnapshotsResponse} ListTopicSnapshotsResponse
                     */
                    ListTopicSnapshotsResponse.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.ListTopicSnapshotsResponse)
                            return object;
                        var message = new $root.google.pubsub.v1.ListTopicSnapshotsResponse();
                        if (object.snapshots) {
                            if (!Array.isArray(object.snapshots))
                                throw TypeError(".google.pubsub.v1.ListTopicSnapshotsResponse.snapshots: array expected");
                            message.snapshots = [];
                            for (var i = 0; i < object.snapshots.length; ++i)
                                message.snapshots[i] = String(object.snapshots[i]);
                        }
                        if (object.nextPageToken != null)
                            message.nextPageToken = String(object.nextPageToken);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a ListTopicSnapshotsResponse message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.ListTopicSnapshotsResponse
                     * @static
                     * @param {google.pubsub.v1.ListTopicSnapshotsResponse} message ListTopicSnapshotsResponse
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    ListTopicSnapshotsResponse.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.arrays || options.defaults)
                            object.snapshots = [];
                        if (options.defaults)
                            object.nextPageToken = "";
                        if (message.snapshots && message.snapshots.length) {
                            object.snapshots = [];
                            for (var j = 0; j < message.snapshots.length; ++j)
                                object.snapshots[j] = message.snapshots[j];
                        }
                        if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                            object.nextPageToken = message.nextPageToken;
                        return object;
                    };
    
                    /**
                     * Converts this ListTopicSnapshotsResponse to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.ListTopicSnapshotsResponse
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    ListTopicSnapshotsResponse.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for ListTopicSnapshotsResponse
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.ListTopicSnapshotsResponse
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    ListTopicSnapshotsResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.ListTopicSnapshotsResponse";
                    };
    
                    return ListTopicSnapshotsResponse;
                })();
    
                v1.DeleteTopicRequest = (function() {
    
                    /**
                     * Properties of a DeleteTopicRequest.
                     * @memberof google.pubsub.v1
                     * @interface IDeleteTopicRequest
                     * @property {string|null} [topic] DeleteTopicRequest topic
                     */
    
                    /**
                     * Constructs a new DeleteTopicRequest.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a DeleteTopicRequest.
                     * @implements IDeleteTopicRequest
                     * @constructor
                     * @param {google.pubsub.v1.IDeleteTopicRequest=} [properties] Properties to set
                     */
                    function DeleteTopicRequest(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * DeleteTopicRequest topic.
                     * @member {string} topic
                     * @memberof google.pubsub.v1.DeleteTopicRequest
                     * @instance
                     */
                    DeleteTopicRequest.prototype.topic = "";
    
                    /**
                     * Creates a new DeleteTopicRequest instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.DeleteTopicRequest
                     * @static
                     * @param {google.pubsub.v1.IDeleteTopicRequest=} [properties] Properties to set
                     * @returns {google.pubsub.v1.DeleteTopicRequest} DeleteTopicRequest instance
                     */
                    DeleteTopicRequest.create = function create(properties) {
                        return new DeleteTopicRequest(properties);
                    };
    
                    /**
                     * Encodes the specified DeleteTopicRequest message. Does not implicitly {@link google.pubsub.v1.DeleteTopicRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.DeleteTopicRequest
                     * @static
                     * @param {google.pubsub.v1.IDeleteTopicRequest} message DeleteTopicRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    DeleteTopicRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.topic != null && Object.hasOwnProperty.call(message, "topic"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.topic);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified DeleteTopicRequest message, length delimited. Does not implicitly {@link google.pubsub.v1.DeleteTopicRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.DeleteTopicRequest
                     * @static
                     * @param {google.pubsub.v1.IDeleteTopicRequest} message DeleteTopicRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    DeleteTopicRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a DeleteTopicRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.DeleteTopicRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.DeleteTopicRequest} DeleteTopicRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    DeleteTopicRequest.decode = function decode(reader, length, error) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.DeleteTopicRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            if (tag === error)
                                break;
                            switch (tag >>> 3) {
                            case 1: {
                                    message.topic = reader.string();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a DeleteTopicRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.DeleteTopicRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.DeleteTopicRequest} DeleteTopicRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    DeleteTopicRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a DeleteTopicRequest message.
                     * @function verify
                     * @memberof google.pubsub.v1.DeleteTopicRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    DeleteTopicRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.topic != null && message.hasOwnProperty("topic"))
                            if (!$util.isString(message.topic))
                                return "topic: string expected";
                        return null;
                    };
    
                    /**
                     * Creates a DeleteTopicRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.DeleteTopicRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.DeleteTopicRequest} DeleteTopicRequest
                     */
                    DeleteTopicRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.DeleteTopicRequest)
                            return object;
                        var message = new $root.google.pubsub.v1.DeleteTopicRequest();
                        if (object.topic != null)
                            message.topic = String(object.topic);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a DeleteTopicRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.DeleteTopicRequest
                     * @static
                     * @param {google.pubsub.v1.DeleteTopicRequest} message DeleteTopicRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    DeleteTopicRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults)
                            object.topic = "";
                        if (message.topic != null && message.hasOwnProperty("topic"))
                            object.topic = message.topic;
                        return object;
                    };
    
                    /**
                     * Converts this DeleteTopicRequest to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.DeleteTopicRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    DeleteTopicRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for DeleteTopicRequest
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.DeleteTopicRequest
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    DeleteTopicRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.DeleteTopicRequest";
                    };
    
                    return DeleteTopicRequest;
                })();
    
                v1.DetachSubscriptionRequest = (function() {
    
                    /**
                     * Properties of a DetachSubscriptionRequest.
                     * @memberof google.pubsub.v1
                     * @interface IDetachSubscriptionRequest
                     * @property {string|null} [subscription] DetachSubscriptionRequest subscription
                     */
    
                    /**
                     * Constructs a new DetachSubscriptionRequest.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a DetachSubscriptionRequest.
                     * @implements IDetachSubscriptionRequest
                     * @constructor
                     * @param {google.pubsub.v1.IDetachSubscriptionRequest=} [properties] Properties to set
                     */
                    function DetachSubscriptionRequest(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * DetachSubscriptionRequest subscription.
                     * @member {string} subscription
                     * @memberof google.pubsub.v1.DetachSubscriptionRequest
                     * @instance
                     */
                    DetachSubscriptionRequest.prototype.subscription = "";
    
                    /**
                     * Creates a new DetachSubscriptionRequest instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.DetachSubscriptionRequest
                     * @static
                     * @param {google.pubsub.v1.IDetachSubscriptionRequest=} [properties] Properties to set
                     * @returns {google.pubsub.v1.DetachSubscriptionRequest} DetachSubscriptionRequest instance
                     */
                    DetachSubscriptionRequest.create = function create(properties) {
                        return new DetachSubscriptionRequest(properties);
                    };
    
                    /**
                     * Encodes the specified DetachSubscriptionRequest message. Does not implicitly {@link google.pubsub.v1.DetachSubscriptionRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.DetachSubscriptionRequest
                     * @static
                     * @param {google.pubsub.v1.IDetachSubscriptionRequest} message DetachSubscriptionRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    DetachSubscriptionRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.subscription != null && Object.hasOwnProperty.call(message, "subscription"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.subscription);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified DetachSubscriptionRequest message, length delimited. Does not implicitly {@link google.pubsub.v1.DetachSubscriptionRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.DetachSubscriptionRequest
                     * @static
                     * @param {google.pubsub.v1.IDetachSubscriptionRequest} message DetachSubscriptionRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    DetachSubscriptionRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a DetachSubscriptionRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.DetachSubscriptionRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.DetachSubscriptionRequest} DetachSubscriptionRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    DetachSubscriptionRequest.decode = function decode(reader, length, error) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.DetachSubscriptionRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            if (tag === error)
                                break;
                            switch (tag >>> 3) {
                            case 1: {
                                    message.subscription = reader.string();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a DetachSubscriptionRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.DetachSubscriptionRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.DetachSubscriptionRequest} DetachSubscriptionRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    DetachSubscriptionRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a DetachSubscriptionRequest message.
                     * @function verify
                     * @memberof google.pubsub.v1.DetachSubscriptionRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    DetachSubscriptionRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.subscription != null && message.hasOwnProperty("subscription"))
                            if (!$util.isString(message.subscription))
                                return "subscription: string expected";
                        return null;
                    };
    
                    /**
                     * Creates a DetachSubscriptionRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.DetachSubscriptionRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.DetachSubscriptionRequest} DetachSubscriptionRequest
                     */
                    DetachSubscriptionRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.DetachSubscriptionRequest)
                            return object;
                        var message = new $root.google.pubsub.v1.DetachSubscriptionRequest();
                        if (object.subscription != null)
                            message.subscription = String(object.subscription);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a DetachSubscriptionRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.DetachSubscriptionRequest
                     * @static
                     * @param {google.pubsub.v1.DetachSubscriptionRequest} message DetachSubscriptionRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    DetachSubscriptionRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults)
                            object.subscription = "";
                        if (message.subscription != null && message.hasOwnProperty("subscription"))
                            object.subscription = message.subscription;
                        return object;
                    };
    
                    /**
                     * Converts this DetachSubscriptionRequest to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.DetachSubscriptionRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    DetachSubscriptionRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for DetachSubscriptionRequest
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.DetachSubscriptionRequest
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    DetachSubscriptionRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.DetachSubscriptionRequest";
                    };
    
                    return DetachSubscriptionRequest;
                })();
    
                v1.DetachSubscriptionResponse = (function() {
    
                    /**
                     * Properties of a DetachSubscriptionResponse.
                     * @memberof google.pubsub.v1
                     * @interface IDetachSubscriptionResponse
                     */
    
                    /**
                     * Constructs a new DetachSubscriptionResponse.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a DetachSubscriptionResponse.
                     * @implements IDetachSubscriptionResponse
                     * @constructor
                     * @param {google.pubsub.v1.IDetachSubscriptionResponse=} [properties] Properties to set
                     */
                    function DetachSubscriptionResponse(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * Creates a new DetachSubscriptionResponse instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.DetachSubscriptionResponse
                     * @static
                     * @param {google.pubsub.v1.IDetachSubscriptionResponse=} [properties] Properties to set
                     * @returns {google.pubsub.v1.DetachSubscriptionResponse} DetachSubscriptionResponse instance
                     */
                    DetachSubscriptionResponse.create = function create(properties) {
                        return new DetachSubscriptionResponse(properties);
                    };
    
                    /**
                     * Encodes the specified DetachSubscriptionResponse message. Does not implicitly {@link google.pubsub.v1.DetachSubscriptionResponse.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.DetachSubscriptionResponse
                     * @static
                     * @param {google.pubsub.v1.IDetachSubscriptionResponse} message DetachSubscriptionResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    DetachSubscriptionResponse.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified DetachSubscriptionResponse message, length delimited. Does not implicitly {@link google.pubsub.v1.DetachSubscriptionResponse.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.DetachSubscriptionResponse
                     * @static
                     * @param {google.pubsub.v1.IDetachSubscriptionResponse} message DetachSubscriptionResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    DetachSubscriptionResponse.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a DetachSubscriptionResponse message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.DetachSubscriptionResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.DetachSubscriptionResponse} DetachSubscriptionResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    DetachSubscriptionResponse.decode = function decode(reader, length, error) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.DetachSubscriptionResponse();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            if (tag === error)
                                break;
                            switch (tag >>> 3) {
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a DetachSubscriptionResponse message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.DetachSubscriptionResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.DetachSubscriptionResponse} DetachSubscriptionResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    DetachSubscriptionResponse.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a DetachSubscriptionResponse message.
                     * @function verify
                     * @memberof google.pubsub.v1.DetachSubscriptionResponse
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    DetachSubscriptionResponse.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        return null;
                    };
    
                    /**
                     * Creates a DetachSubscriptionResponse message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.DetachSubscriptionResponse
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.DetachSubscriptionResponse} DetachSubscriptionResponse
                     */
                    DetachSubscriptionResponse.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.DetachSubscriptionResponse)
                            return object;
                        return new $root.google.pubsub.v1.DetachSubscriptionResponse();
                    };
    
                    /**
                     * Creates a plain object from a DetachSubscriptionResponse message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.DetachSubscriptionResponse
                     * @static
                     * @param {google.pubsub.v1.DetachSubscriptionResponse} message DetachSubscriptionResponse
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    DetachSubscriptionResponse.toObject = function toObject() {
                        return {};
                    };
    
                    /**
                     * Converts this DetachSubscriptionResponse to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.DetachSubscriptionResponse
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    DetachSubscriptionResponse.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for DetachSubscriptionResponse
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.DetachSubscriptionResponse
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    DetachSubscriptionResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.DetachSubscriptionResponse";
                    };
    
                    return DetachSubscriptionResponse;
                })();
    
                v1.Subscriber = (function() {
    
                    /**
                     * Constructs a new Subscriber service.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a Subscriber
                     * @extends $protobuf.rpc.Service
                     * @constructor
                     * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                     * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                     * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                     */
                    function Subscriber(rpcImpl, requestDelimited, responseDelimited) {
                        $protobuf.rpc.Service.call(this, rpcImpl, requestDelimited, responseDelimited);
                    }
    
                    (Subscriber.prototype = Object.create($protobuf.rpc.Service.prototype)).constructor = Subscriber;
    
                    /**
                     * Creates new Subscriber service using the specified rpc implementation.
                     * @function create
                     * @memberof google.pubsub.v1.Subscriber
                     * @static
                     * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                     * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                     * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                     * @returns {Subscriber} RPC service. Useful where requests and/or responses are streamed.
                     */
                    Subscriber.create = function create(rpcImpl, requestDelimited, responseDelimited) {
                        return new this(rpcImpl, requestDelimited, responseDelimited);
                    };
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Subscriber|createSubscription}.
                     * @memberof google.pubsub.v1.Subscriber
                     * @typedef CreateSubscriptionCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.Subscription} [response] Subscription
                     */
    
                    /**
                     * Calls CreateSubscription.
                     * @function createSubscription
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.ISubscription} request Subscription message or plain object
                     * @param {google.pubsub.v1.Subscriber.CreateSubscriptionCallback} callback Node-style callback called with the error, if any, and Subscription
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Subscriber.prototype.createSubscription = function createSubscription(request, callback) {
                        return this.rpcCall(createSubscription, $root.google.pubsub.v1.Subscription, $root.google.pubsub.v1.Subscription, request, callback);
                    }, "name", { value: "CreateSubscription" });
    
                    /**
                     * Calls CreateSubscription.
                     * @function createSubscription
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.ISubscription} request Subscription message or plain object
                     * @returns {Promise<google.pubsub.v1.Subscription>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Subscriber|getSubscription}.
                     * @memberof google.pubsub.v1.Subscriber
                     * @typedef GetSubscriptionCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.Subscription} [response] Subscription
                     */
    
                    /**
                     * Calls GetSubscription.
                     * @function getSubscription
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IGetSubscriptionRequest} request GetSubscriptionRequest message or plain object
                     * @param {google.pubsub.v1.Subscriber.GetSubscriptionCallback} callback Node-style callback called with the error, if any, and Subscription
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Subscriber.prototype.getSubscription = function getSubscription(request, callback) {
                        return this.rpcCall(getSubscription, $root.google.pubsub.v1.GetSubscriptionRequest, $root.google.pubsub.v1.Subscription, request, callback);
                    }, "name", { value: "GetSubscription" });
    
                    /**
                     * Calls GetSubscription.
                     * @function getSubscription
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IGetSubscriptionRequest} request GetSubscriptionRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.Subscription>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Subscriber|updateSubscription}.
                     * @memberof google.pubsub.v1.Subscriber
                     * @typedef UpdateSubscriptionCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.Subscription} [response] Subscription
                     */
    
                    /**
                     * Calls UpdateSubscription.
                     * @function updateSubscription
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IUpdateSubscriptionRequest} request UpdateSubscriptionRequest message or plain object
                     * @param {google.pubsub.v1.Subscriber.UpdateSubscriptionCallback} callback Node-style callback called with the error, if any, and Subscription
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Subscriber.prototype.updateSubscription = function updateSubscription(request, callback) {
                        return this.rpcCall(updateSubscription, $root.google.pubsub.v1.UpdateSubscriptionRequest, $root.google.pubsub.v1.Subscription, request, callback);
                    }, "name", { value: "UpdateSubscription" });
    
                    /**
                     * Calls UpdateSubscription.
                     * @function updateSubscription
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IUpdateSubscriptionRequest} request UpdateSubscriptionRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.Subscription>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Subscriber|listSubscriptions}.
                     * @memberof google.pubsub.v1.Subscriber
                     * @typedef ListSubscriptionsCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.ListSubscriptionsResponse} [response] ListSubscriptionsResponse
                     */
    
                    /**
                     * Calls ListSubscriptions.
                     * @function listSubscriptions
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IListSubscriptionsRequest} request ListSubscriptionsRequest message or plain object
                     * @param {google.pubsub.v1.Subscriber.ListSubscriptionsCallback} callback Node-style callback called with the error, if any, and ListSubscriptionsResponse
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Subscriber.prototype.listSubscriptions = function listSubscriptions(request, callback) {
                        return this.rpcCall(listSubscriptions, $root.google.pubsub.v1.ListSubscriptionsRequest, $root.google.pubsub.v1.ListSubscriptionsResponse, request, callback);
                    }, "name", { value: "ListSubscriptions" });
    
                    /**
                     * Calls ListSubscriptions.
                     * @function listSubscriptions
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IListSubscriptionsRequest} request ListSubscriptionsRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.ListSubscriptionsResponse>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Subscriber|deleteSubscription}.
                     * @memberof google.pubsub.v1.Subscriber
                     * @typedef DeleteSubscriptionCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.protobuf.Empty} [response] Empty
                     */
    
                    /**
                     * Calls DeleteSubscription.
                     * @function deleteSubscription
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IDeleteSubscriptionRequest} request DeleteSubscriptionRequest message or plain object
                     * @param {google.pubsub.v1.Subscriber.DeleteSubscriptionCallback} callback Node-style callback called with the error, if any, and Empty
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Subscriber.prototype.deleteSubscription = function deleteSubscription(request, callback) {
                        return this.rpcCall(deleteSubscription, $root.google.pubsub.v1.DeleteSubscriptionRequest, $root.google.protobuf.Empty, request, callback);
                    }, "name", { value: "DeleteSubscription" });
    
                    /**
                     * Calls DeleteSubscription.
                     * @function deleteSubscription
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IDeleteSubscriptionRequest} request DeleteSubscriptionRequest message or plain object
                     * @returns {Promise<google.protobuf.Empty>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Subscriber|modifyAckDeadline}.
                     * @memberof google.pubsub.v1.Subscriber
                     * @typedef ModifyAckDeadlineCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.protobuf.Empty} [response] Empty
                     */
    
                    /**
                     * Calls ModifyAckDeadline.
                     * @function modifyAckDeadline
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IModifyAckDeadlineRequest} request ModifyAckDeadlineRequest message or plain object
                     * @param {google.pubsub.v1.Subscriber.ModifyAckDeadlineCallback} callback Node-style callback called with the error, if any, and Empty
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Subscriber.prototype.modifyAckDeadline = function modifyAckDeadline(request, callback) {
                        return this.rpcCall(modifyAckDeadline, $root.google.pubsub.v1.ModifyAckDeadlineRequest, $root.google.protobuf.Empty, request, callback);
                    }, "name", { value: "ModifyAckDeadline" });
    
                    /**
                     * Calls ModifyAckDeadline.
                     * @function modifyAckDeadline
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IModifyAckDeadlineRequest} request ModifyAckDeadlineRequest message or plain object
                     * @returns {Promise<google.protobuf.Empty>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Subscriber|acknowledge}.
                     * @memberof google.pubsub.v1.Subscriber
                     * @typedef AcknowledgeCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.protobuf.Empty} [response] Empty
                     */
    
                    /**
                     * Calls Acknowledge.
                     * @function acknowledge
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IAcknowledgeRequest} request AcknowledgeRequest message or plain object
                     * @param {google.pubsub.v1.Subscriber.AcknowledgeCallback} callback Node-style callback called with the error, if any, and Empty
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Subscriber.prototype.acknowledge = function acknowledge(request, callback) {
                        return this.rpcCall(acknowledge, $root.google.pubsub.v1.AcknowledgeRequest, $root.google.protobuf.Empty, request, callback);
                    }, "name", { value: "Acknowledge" });
    
                    /**
                     * Calls Acknowledge.
                     * @function acknowledge
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IAcknowledgeRequest} request AcknowledgeRequest message or plain object
                     * @returns {Promise<google.protobuf.Empty>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Subscriber|pull}.
                     * @memberof google.pubsub.v1.Subscriber
                     * @typedef PullCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.PullResponse} [response] PullResponse
                     */
    
                    /**
                     * Calls Pull.
                     * @function pull
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IPullRequest} request PullRequest message or plain object
                     * @param {google.pubsub.v1.Subscriber.PullCallback} callback Node-style callback called with the error, if any, and PullResponse
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Subscriber.prototype.pull = function pull(request, callback) {
                        return this.rpcCall(pull, $root.google.pubsub.v1.PullRequest, $root.google.pubsub.v1.PullResponse, request, callback);
                    }, "name", { value: "Pull" });
    
                    /**
                     * Calls Pull.
                     * @function pull
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IPullRequest} request PullRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.PullResponse>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Subscriber|streamingPull}.
                     * @memberof google.pubsub.v1.Subscriber
                     * @typedef StreamingPullCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.StreamingPullResponse} [response] StreamingPullResponse
                     */
    
                    /**
                     * Calls StreamingPull.
                     * @function streamingPull
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IStreamingPullRequest} request StreamingPullRequest message or plain object
                     * @param {google.pubsub.v1.Subscriber.StreamingPullCallback} callback Node-style callback called with the error, if any, and StreamingPullResponse
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Subscriber.prototype.streamingPull = function streamingPull(request, callback) {
                        return this.rpcCall(streamingPull, $root.google.pubsub.v1.StreamingPullRequest, $root.google.pubsub.v1.StreamingPullResponse, request, callback);
                    }, "name", { value: "StreamingPull" });
    
                    /**
                     * Calls StreamingPull.
                     * @function streamingPull
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IStreamingPullRequest} request StreamingPullRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.StreamingPullResponse>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Subscriber|modifyPushConfig}.
                     * @memberof google.pubsub.v1.Subscriber
                     * @typedef ModifyPushConfigCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.protobuf.Empty} [response] Empty
                     */
    
                    /**
                     * Calls ModifyPushConfig.
                     * @function modifyPushConfig
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IModifyPushConfigRequest} request ModifyPushConfigRequest message or plain object
                     * @param {google.pubsub.v1.Subscriber.ModifyPushConfigCallback} callback Node-style callback called with the error, if any, and Empty
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Subscriber.prototype.modifyPushConfig = function modifyPushConfig(request, callback) {
                        return this.rpcCall(modifyPushConfig, $root.google.pubsub.v1.ModifyPushConfigRequest, $root.google.protobuf.Empty, request, callback);
                    }, "name", { value: "ModifyPushConfig" });
    
                    /**
                     * Calls ModifyPushConfig.
                     * @function modifyPushConfig
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IModifyPushConfigRequest} request ModifyPushConfigRequest message or plain object
                     * @returns {Promise<google.protobuf.Empty>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Subscriber|getSnapshot}.
                     * @memberof google.pubsub.v1.Subscriber
                     * @typedef GetSnapshotCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.Snapshot} [response] Snapshot
                     */
    
                    /**
                     * Calls GetSnapshot.
                     * @function getSnapshot
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IGetSnapshotRequest} request GetSnapshotRequest message or plain object
                     * @param {google.pubsub.v1.Subscriber.GetSnapshotCallback} callback Node-style callback called with the error, if any, and Snapshot
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Subscriber.prototype.getSnapshot = function getSnapshot(request, callback) {
                        return this.rpcCall(getSnapshot, $root.google.pubsub.v1.GetSnapshotRequest, $root.google.pubsub.v1.Snapshot, request, callback);
                    }, "name", { value: "GetSnapshot" });
    
                    /**
                     * Calls GetSnapshot.
                     * @function getSnapshot
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IGetSnapshotRequest} request GetSnapshotRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.Snapshot>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Subscriber|listSnapshots}.
                     * @memberof google.pubsub.v1.Subscriber
                     * @typedef ListSnapshotsCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.ListSnapshotsResponse} [response] ListSnapshotsResponse
                     */
    
                    /**
                     * Calls ListSnapshots.
                     * @function listSnapshots
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IListSnapshotsRequest} request ListSnapshotsRequest message or plain object
                     * @param {google.pubsub.v1.Subscriber.ListSnapshotsCallback} callback Node-style callback called with the error, if any, and ListSnapshotsResponse
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Subscriber.prototype.listSnapshots = function listSnapshots(request, callback) {
                        return this.rpcCall(listSnapshots, $root.google.pubsub.v1.ListSnapshotsRequest, $root.google.pubsub.v1.ListSnapshotsResponse, request, callback);
                    }, "name", { value: "ListSnapshots" });
    
                    /**
                     * Calls ListSnapshots.
                     * @function listSnapshots
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IListSnapshotsRequest} request ListSnapshotsRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.ListSnapshotsResponse>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Subscriber|createSnapshot}.
                     * @memberof google.pubsub.v1.Subscriber
                     * @typedef CreateSnapshotCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.Snapshot} [response] Snapshot
                     */
    
                    /**
                     * Calls CreateSnapshot.
                     * @function createSnapshot
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.ICreateSnapshotRequest} request CreateSnapshotRequest message or plain object
                     * @param {google.pubsub.v1.Subscriber.CreateSnapshotCallback} callback Node-style callback called with the error, if any, and Snapshot
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Subscriber.prototype.createSnapshot = function createSnapshot(request, callback) {
                        return this.rpcCall(createSnapshot, $root.google.pubsub.v1.CreateSnapshotRequest, $root.google.pubsub.v1.Snapshot, request, callback);
                    }, "name", { value: "CreateSnapshot" });
    
                    /**
                     * Calls CreateSnapshot.
                     * @function createSnapshot
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.ICreateSnapshotRequest} request CreateSnapshotRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.Snapshot>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Subscriber|updateSnapshot}.
                     * @memberof google.pubsub.v1.Subscriber
                     * @typedef UpdateSnapshotCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.Snapshot} [response] Snapshot
                     */
    
                    /**
                     * Calls UpdateSnapshot.
                     * @function updateSnapshot
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IUpdateSnapshotRequest} request UpdateSnapshotRequest message or plain object
                     * @param {google.pubsub.v1.Subscriber.UpdateSnapshotCallback} callback Node-style callback called with the error, if any, and Snapshot
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Subscriber.prototype.updateSnapshot = function updateSnapshot(request, callback) {
                        return this.rpcCall(updateSnapshot, $root.google.pubsub.v1.UpdateSnapshotRequest, $root.google.pubsub.v1.Snapshot, request, callback);
                    }, "name", { value: "UpdateSnapshot" });
    
                    /**
                     * Calls UpdateSnapshot.
                     * @function updateSnapshot
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IUpdateSnapshotRequest} request UpdateSnapshotRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.Snapshot>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Subscriber|deleteSnapshot}.
                     * @memberof google.pubsub.v1.Subscriber
                     * @typedef DeleteSnapshotCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.protobuf.Empty} [response] Empty
                     */
    
                    /**
                     * Calls DeleteSnapshot.
                     * @function deleteSnapshot
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IDeleteSnapshotRequest} request DeleteSnapshotRequest message or plain object
                     * @param {google.pubsub.v1.Subscriber.DeleteSnapshotCallback} callback Node-style callback called with the error, if any, and Empty
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Subscriber.prototype.deleteSnapshot = function deleteSnapshot(request, callback) {
                        return this.rpcCall(deleteSnapshot, $root.google.pubsub.v1.DeleteSnapshotRequest, $root.google.protobuf.Empty, request, callback);
                    }, "name", { value: "DeleteSnapshot" });
    
                    /**
                     * Calls DeleteSnapshot.
                     * @function deleteSnapshot
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IDeleteSnapshotRequest} request DeleteSnapshotRequest message or plain object
                     * @returns {Promise<google.protobuf.Empty>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Subscriber|seek}.
                     * @memberof google.pubsub.v1.Subscriber
                     * @typedef SeekCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.SeekResponse} [response] SeekResponse
                     */
    
                    /**
                     * Calls Seek.
                     * @function seek
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.ISeekRequest} request SeekRequest message or plain object
                     * @param {google.pubsub.v1.Subscriber.SeekCallback} callback Node-style callback called with the error, if any, and SeekResponse
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Subscriber.prototype.seek = function seek(request, callback) {
                        return this.rpcCall(seek, $root.google.pubsub.v1.SeekRequest, $root.google.pubsub.v1.SeekResponse, request, callback);
                    }, "name", { value: "Seek" });
    
                    /**
                     * Calls Seek.
                     * @function seek
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.ISeekRequest} request SeekRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.SeekResponse>} Promise
                     * @variation 2
                     */
    
                    return Subscriber;
                })();
    
                v1.Subscription = (function() {
    
                    /**
                     * Properties of a Subscription.
                     * @memberof google.pubsub.v1
                     * @interface ISubscription
                     * @property {string|null} [name] Subscription name
                     * @property {string|null} [topic] Subscription topic
                     * @property {google.pubsub.v1.IPushConfig|null} [pushConfig] Subscription pushConfig
                     * @property {google.pubsub.v1.IBigQueryConfig|null} [bigqueryConfig] Subscription bigqueryConfig
                     * @property {google.pubsub.v1.ICloudStorageConfig|null} [cloudStorageConfig] Subscription cloudStorageConfig
                     * @property {number|null} [ackDeadlineSeconds] Subscription ackDeadlineSeconds
                     * @property {boolean|null} [retainAckedMessages] Subscription retainAckedMessages
                     * @property {google.protobuf.IDuration|null} [messageRetentionDuration] Subscription messageRetentionDuration
                     * @property {Object.<string,string>|null} [labels] Subscription labels
                     * @property {boolean|null} [enableMessageOrdering] Subscription enableMessageOrdering
                     * @property {google.pubsub.v1.IExpirationPolicy|null} [expirationPolicy] Subscription expirationPolicy
                     * @property {string|null} [filter] Subscription filter
                     * @property {google.pubsub.v1.IDeadLetterPolicy|null} [deadLetterPolicy] Subscription deadLetterPolicy
                     * @property {google.pubsub.v1.IRetryPolicy|null} [retryPolicy] Subscription retryPolicy
                     * @property {boolean|null} [detached] Subscription detached
                     * @property {boolean|null} [enableExactlyOnceDelivery] Subscription enableExactlyOnceDelivery
                     * @property {google.protobuf.IDuration|null} [topicMessageRetentionDuration] Subscription topicMessageRetentionDuration
                     * @property {google.pubsub.v1.Subscription.State|null} [state] Subscription state
                     * @property {google.pubsub.v1.Subscription.IAnalyticsHubSubscriptionInfo|null} [analyticsHubSubscriptionInfo] Subscription analyticsHubSubscriptionInfo
                     * @property {Array.<google.pubsub.v1.IMessageTransform>|null} [messageTransforms] Subscription messageTransforms
                     */
    
                    /**
                     * Constructs a new Subscription.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a Subscription.
                     * @implements ISubscription
                     * @constructor
                     * @param {google.pubsub.v1.ISubscription=} [properties] Properties to set
                     */
                    function Subscription(properties) {
                        this.labels = {};
                        this.messageTransforms = [];
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * Subscription name.
                     * @member {string} name
                     * @memberof google.pubsub.v1.Subscription
                     * @instance
                     */
                    Subscription.prototype.name = "";
    
                    /**
                     * Subscription topic.
                     * @member {string} topic
                     * @memberof google.pubsub.v1.Subscription
                     * @instance
                     */
                    Subscription.prototype.topic = "";
    
                    /**
                     * Subscription pushConfig.
                     * @member {google.pubsub.v1.IPushConfig|null|undefined} pushConfig
                     * @memberof google.pubsub.v1.Subscription
                     * @instance
                     */
                    Subscription.prototype.pushConfig = null;
    
                    /**
                     * Subscription bigqueryConfig.
                     * @member {google.pubsub.v1.IBigQueryConfig|null|undefined} bigqueryConfig
                     * @memberof google.pubsub.v1.Subscription
                     * @instance
                     */
                    Subscription.prototype.bigqueryConfig = null;
    
                    /**
                     * Subscription cloudStorageConfig.
                     * @member {google.pubsub.v1.ICloudStorageConfig|null|undefined} cloudStorageConfig
                     * @memberof google.pubsub.v1.Subscription
                     * @instance
                     */
                    Subscription.prototype.cloudStorageConfig = null;
    
                    /**
                     * Subscription ackDeadlineSeconds.
                     * @member {number} ackDeadlineSeconds
                     * @memberof google.pubsub.v1.Subscription
                     * @instance
                     */
                    Subscription.prototype.ackDeadlineSeconds = 0;
    
                    /**
                     * Subscription retainAckedMessages.
                     * @member {boolean} retainAckedMessages
                     * @memberof google.pubsub.v1.Subscription
                     * @instance
                     */
                    Subscription.prototype.retainAckedMessages = false;
    
                    /**
                     * Subscription messageRetentionDuration.
                     * @member {google.protobuf.IDuration|null|undefined} messageRetentionDuration
                     * @memberof google.pubsub.v1.Subscription
                     * @instance
                     */
                    Subscription.prototype.messageRetentionDuration = null;
    
                    /**
                     * Subscription labels.
                     * @member {Object.<string,string>} labels
                     * @memberof google.pubsub.v1.Subscription
                     * @instance
                     */
                    Subscription.prototype.labels = $util.emptyObject;
    
                    /**
                     * Subscription enableMessageOrdering.
                     * @member {boolean} enableMessageOrdering
                     * @memberof google.pubsub.v1.Subscription
                     * @instance
                     */
                    Subscription.prototype.enableMessageOrdering = false;
    
                    /**
                     * Subscription expirationPolicy.
                     * @member {google.pubsub.v1.IExpirationPolicy|null|undefined} expirationPolicy
                     * @memberof google.pubsub.v1.Subscription
                     * @instance
                     */
                    Subscription.prototype.expirationPolicy = null;
    
                    /**
                     * Subscription filter.
                     * @member {string} filter
                     * @memberof google.pubsub.v1.Subscription
                     * @instance
                     */
                    Subscription.prototype.filter = "";
    
                    /**
                     * Subscription deadLetterPolicy.
                     * @member {google.pubsub.v1.IDeadLetterPolicy|null|undefined} deadLetterPolicy
                     * @memberof google.pubsub.v1.Subscription
                     * @instance
                     */
                    Subscription.prototype.deadLetterPolicy = null;
    
                    /**
                     * Subscription retryPolicy.
                     * @member {google.pubsub.v1.IRetryPolicy|null|undefined} retryPolicy
                     * @memberof google.pubsub.v1.Subscription
                     * @instance
                     */
                    Subscription.prototype.retryPolicy = null;
    
                    /**
                     * Subscription detached.
                     * @member {boolean} detached
                     * @memberof google.pubsub.v1.Subscription
                     * @instance
                     */
                    Subscription.prototype.detached = false;
    
                    /**
                     * Subscription enableExactlyOnceDelivery.
                     * @member {boolean} enableExactlyOnceDelivery
                     * @memberof google.pubsub.v1.Subscription
                     * @instance
                     */
                    Subscription.prototype.enableExactlyOnceDelivery = false;
    
                    /**
                     * Subscription topicMessageRetentionDuration.
                     * @member {google.protobuf.IDuration|null|undefined} topicMessageRetentionDuration
                     * @memberof google.pubsub.v1.Subscription
                     * @instance
                     */
                    Subscription.prototype.topicMessageRetentionDuration = null;
    
                    /**
                     * Subscription state.
                     * @member {google.pubsub.v1.Subscription.State} state
                     * @memberof google.pubsub.v1.Subscription
                     * @instance
                     */
                    Subscription.prototype.state = 0;
    
                    /**
                     * Subscription analyticsHubSubscriptionInfo.
                     * @member {google.pubsub.v1.Subscription.IAnalyticsHubSubscriptionInfo|null|undefined} analyticsHubSubscriptionInfo
                     * @memberof google.pubsub.v1.Subscription
                     * @instance
                     */
                    Subscription.prototype.analyticsHubSubscriptionInfo = null;
    
                    /**
                     * Subscription messageTransforms.
                     * @member {Array.<google.pubsub.v1.IMessageTransform>} messageTransforms
                     * @memberof google.pubsub.v1.Subscription
                     * @instance
                     */
                    Subscription.prototype.messageTransforms = $util.emptyArray;
    
                    /**
                     * Creates a new Subscription instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.Subscription
                     * @static
                     * @param {google.pubsub.v1.ISubscription=} [properties] Properties to set
                     * @returns {google.pubsub.v1.Subscription} Subscription instance
                     */
                    Subscription.create = function create(properties) {
                        return new Subscription(properties);
                    };
    
                    /**
                     * Encodes the specified Subscription message. Does not implicitly {@link google.pubsub.v1.Subscription.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.Subscription
                     * @static
                     * @param {google.pubsub.v1.ISubscription} message Subscription message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    Subscription.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                        if (message.topic != null && Object.hasOwnProperty.call(message, "topic"))
                            writer.uint32(/* id 2, wireType 2 =*/18).string(message.topic);
                        if (message.pushConfig != null && Object.hasOwnProperty.call(message, "pushConfig"))
                            $root.google.pubsub.v1.PushConfig.encode(message.pushConfig, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                        if (message.ackDeadlineSeconds != null && Object.hasOwnProperty.call(message, "ackDeadlineSeconds"))
                            writer.uint32(/* id 5, wireType 0 =*/40).int32(message.ackDeadlineSeconds);
                        if (message.retainAckedMessages != null && Object.hasOwnProperty.call(message, "retainAckedMessages"))
                            writer.uint32(/* id 7, wireType 0 =*/56).bool(message.retainAckedMessages);
                        if (message.messageRetentionDuration != null && Object.hasOwnProperty.call(message, "messageRetentionDuration"))
                            $root.google.protobuf.Duration.encode(message.messageRetentionDuration, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
                        if (message.labels != null && Object.hasOwnProperty.call(message, "labels"))
                            for (var keys = Object.keys(message.labels), i = 0; i < keys.length; ++i)
                                writer.uint32(/* id 9, wireType 2 =*/74).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]).uint32(/* id 2, wireType 2 =*/18).string(message.labels[keys[i]]).ldelim();
                        if (message.enableMessageOrdering != null && Object.hasOwnProperty.call(message, "enableMessageOrdering"))
                            writer.uint32(/* id 10, wireType 0 =*/80).bool(message.enableMessageOrdering);
                        if (message.expirationPolicy != null && Object.hasOwnProperty.call(message, "expirationPolicy"))
                            $root.google.pubsub.v1.ExpirationPolicy.encode(message.expirationPolicy, writer.uint32(/* id 11, wireType 2 =*/90).fork()).ldelim();
                        if (message.filter != null && Object.hasOwnProperty.call(message, "filter"))
                            writer.uint32(/* id 12, wireType 2 =*/98).string(message.filter);
                        if (message.deadLetterPolicy != null && Object.hasOwnProperty.call(message, "deadLetterPolicy"))
                            $root.google.pubsub.v1.DeadLetterPolicy.encode(message.deadLetterPolicy, writer.uint32(/* id 13, wireType 2 =*/106).fork()).ldelim();
                        if (message.retryPolicy != null && Object.hasOwnProperty.call(message, "retryPolicy"))
                            $root.google.pubsub.v1.RetryPolicy.encode(message.retryPolicy, writer.uint32(/* id 14, wireType 2 =*/114).fork()).ldelim();
                        if (message.detached != null && Object.hasOwnProperty.call(message, "detached"))
                            writer.uint32(/* id 15, wireType 0 =*/120).bool(message.detached);
                        if (message.enableExactlyOnceDelivery != null && Object.hasOwnProperty.call(message, "enableExactlyOnceDelivery"))
                            writer.uint32(/* id 16, wireType 0 =*/128).bool(message.enableExactlyOnceDelivery);
                        if (message.topicMessageRetentionDuration != null && Object.hasOwnProperty.call(message, "topicMessageRetentionDuration"))
                            $root.google.protobuf.Duration.encode(message.topicMessageRetentionDuration, writer.uint32(/* id 17, wireType 2 =*/138).fork()).ldelim();
                        if (message.bigqueryConfig != null && Object.hasOwnProperty.call(message, "bigqueryConfig"))
                            $root.google.pubsub.v1.BigQueryConfig.encode(message.bigqueryConfig, writer.uint32(/* id 18, wireType 2 =*/146).fork()).ldelim();
                        if (message.state != null && Object.hasOwnProperty.call(message, "state"))
                            writer.uint32(/* id 19, wireType 0 =*/152).int32(message.state);
                        if (message.cloudStorageConfig != null && Object.hasOwnProperty.call(message, "cloudStorageConfig"))
                            $root.google.pubsub.v1.CloudStorageConfig.encode(message.cloudStorageConfig, writer.uint32(/* id 22, wireType 2 =*/178).fork()).ldelim();
                        if (message.analyticsHubSubscriptionInfo != null && Object.hasOwnProperty.call(message, "analyticsHubSubscriptionInfo"))
                            $root.google.pubsub.v1.Subscription.AnalyticsHubSubscriptionInfo.encode(message.analyticsHubSubscriptionInfo, writer.uint32(/* id 23, wireType 2 =*/186).fork()).ldelim();
                        if (message.messageTransforms != null && message.messageTransforms.length)
                            for (var i = 0; i < message.messageTransforms.length; ++i)
                                $root.google.pubsub.v1.MessageTransform.encode(message.messageTransforms[i], writer.uint32(/* id 25, wireType 2 =*/202).fork()).ldelim();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified Subscription message, length delimited. Does not implicitly {@link google.pubsub.v1.Subscription.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.Subscription
                     * @static
                     * @param {google.pubsub.v1.ISubscription} message Subscription message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    Subscription.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a Subscription message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.Subscription
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.Subscription} Subscription
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    Subscription.decode = function decode(reader, length, error) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.Subscription(), key, value;
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            if (tag === error)
                                break;
                            switch (tag >>> 3) {
                            case 1: {
                                    message.name = reader.string();
                                    break;
                                }
                            case 2: {
                                    message.topic = reader.string();
                                    break;
                                }
                            case 4: {
                                    message.pushConfig = $root.google.pubsub.v1.PushConfig.decode(reader, reader.uint32());
                                    break;
                                }
                            case 18: {
                                    message.bigqueryConfig = $root.google.pubsub.v1.BigQueryConfig.decode(reader, reader.uint32());
                                    break;
                                }
                            case 22: {
                                    message.cloudStorageConfig = $root.google.pubsub.v1.CloudStorageConfig.decode(reader, reader.uint32());
                                    break;
                                }
                            case 5: {
                                    message.ackDeadlineSeconds = reader.int32();
                                    break;
                                }
                            case 7: {
                                    message.retainAckedMessages = reader.bool();
                                    break;
                                }
                            case 8: {
                                    message.messageRetentionDuration = $root.google.protobuf.Duration.decode(reader, reader.uint32());
                                    break;
                                }
                            case 9: {
                                    if (message.labels === $util.emptyObject)
                                        message.labels = {};
                                    var end2 = reader.uint32() + reader.pos;
                                    key = "";
                                    value = "";
                                    while (reader.pos < end2) {
                                        var tag2 = reader.uint32();
                                        switch (tag2 >>> 3) {
                                        case 1:
                                            key = reader.string();
                                            break;
                                        case 2:
                                            value = reader.string();
                                            break;
                                        default:
                                            reader.skipType(tag2 & 7);
                                            break;
                                        }
                                    }
                                    message.labels[key] = value;
                                    break;
                                }
                            case 10: {
                                    message.enableMessageOrdering = reader.bool();
                                    break;
                                }
                            case 11: {
                                    message.expirationPolicy = $root.google.pubsub.v1.ExpirationPolicy.decode(reader, reader.uint32());
                                    break;
                                }
                            case 12: {
                                    message.filter = reader.string();
                                    break;
                                }
                            case 13: {
                                    message.deadLetterPolicy = $root.google.pubsub.v1.DeadLetterPolicy.decode(reader, reader.uint32());
                                    break;
                                }
                            case 14: {
                                    message.retryPolicy = $root.google.pubsub.v1.RetryPolicy.decode(reader, reader.uint32());
                                    break;
                                }
                            case 15: {
                                    message.detached = reader.bool();
                                    break;
                                }
                            case 16: {
                                    message.enableExactlyOnceDelivery = reader.bool();
                                    break;
                                }
                            case 17: {
                                    message.topicMessageRetentionDuration = $root.google.protobuf.Duration.decode(reader, reader.uint32());
                                    break;
                                }
                            case 19: {
                                    message.state = reader.int32();
                                    break;
                                }
                            case 23: {
                                    message.analyticsHubSubscriptionInfo = $root.google.pubsub.v1.Subscription.AnalyticsHubSubscriptionInfo.decode(reader, reader.uint32());
                                    break;
                                }
                            case 25: {
                                    if (!(message.messageTransforms && message.messageTransforms.length))
                                        message.messageTransforms = [];
                                    message.messageTransforms.push($root.google.pubsub.v1.MessageTransform.decode(reader, reader.uint32()));
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a Subscription message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.Subscription
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.Subscription} Subscription
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    Subscription.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a Subscription message.
                     * @function verify
                     * @memberof google.pubsub.v1.Subscription
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    Subscription.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.name != null && message.hasOwnProperty("name"))
                            if (!$util.isString(message.name))
                                return "name: string expected";
                        if (message.topic != null && message.hasOwnProperty("topic"))
                            if (!$util.isString(message.topic))
                                return "topic: string expected";
                        if (message.pushConfig != null && message.hasOwnProperty("pushConfig")) {
                            var error = $root.google.pubsub.v1.PushConfig.verify(message.pushConfig);
                            if (error)
                                return "pushConfig." + error;
                        }
                        if (message.bigqueryConfig != null && message.hasOwnProperty("bigqueryConfig")) {
                            var error = $root.google.pubsub.v1.BigQueryConfig.verify(message.bigqueryConfig);
                            if (error)
                                return "bigqueryConfig." + error;
                        }
                        if (message.cloudStorageConfig != null && message.hasOwnProperty("cloudStorageConfig")) {
                            var error = $root.google.pubsub.v1.CloudStorageConfig.verify(message.cloudStorageConfig);
                            if (error)
                                return "cloudStorageConfig." + error;
                        }
                        if (message.ackDeadlineSeconds != null && message.hasOwnProperty("ackDeadlineSeconds"))
                            if (!$util.isInteger(message.ackDeadlineSeconds))
                                return "ackDeadlineSeconds: integer expected";
                        if (message.retainAckedMessages != null && message.hasOwnProperty("retainAckedMessages"))
                            if (typeof message.retainAckedMessages !== "boolean")
                                return "retainAckedMessages: boolean expected";
                        if (message.messageRetentionDuration != null && message.hasOwnProperty("messageRetentionDuration")) {
                            var error = $root.google.protobuf.Duration.verify(message.messageRetentionDuration);
                            if (error)
                                return "messageRetentionDuration." + error;
                        }
                        if (message.labels != null && message.hasOwnProperty("labels")) {
                            if (!$util.isObject(message.labels))
                                return "labels: object expected";
                            var key = Object.keys(message.labels);
                            for (var i = 0; i < key.length; ++i)
                                if (!$util.isString(message.labels[key[i]]))
                                    return "labels: string{k:string} expected";
                        }
                        if (message.enableMessageOrdering != null && message.hasOwnProperty("enableMessageOrdering"))
                            if (typeof message.enableMessageOrdering !== "boolean")
                                return "enableMessageOrdering: boolean expected";
                        if (message.expirationPolicy != null && message.hasOwnProperty("expirationPolicy")) {
                            var error = $root.google.pubsub.v1.ExpirationPolicy.verify(message.expirationPolicy);
                            if (error)
                                return "expirationPolicy." + error;
                        }
                        if (message.filter != null && message.hasOwnProperty("filter"))
                            if (!$util.isString(message.filter))
                                return "filter: string expected";
                        if (message.deadLetterPolicy != null && message.hasOwnProperty("deadLetterPolicy")) {
                            var error = $root.google.pubsub.v1.DeadLetterPolicy.verify(message.deadLetterPolicy);
                            if (error)
                                return "deadLetterPolicy." + error;
                        }
                        if (message.retryPolicy != null && message.hasOwnProperty("retryPolicy")) {
                            var error = $root.google.pubsub.v1.RetryPolicy.verify(message.retryPolicy);
                            if (error)
                                return "retryPolicy." + error;
                        }
                        if (message.detached != null && message.hasOwnProperty("detached"))
                            if (typeof message.detached !== "boolean")
                                return "detached: boolean expected";
                        if (message.enableExactlyOnceDelivery != null && message.hasOwnProperty("enableExactlyOnceDelivery"))
                            if (typeof message.enableExactlyOnceDelivery !== "boolean")
                                return "enableExactlyOnceDelivery: boolean expected";
                        if (message.topicMessageRetentionDuration != null && message.hasOwnProperty("topicMessageRetentionDuration")) {
                            var error = $root.google.protobuf.Duration.verify(message.topicMessageRetentionDuration);
                            if (error)
                                return "topicMessageRetentionDuration." + error;
                        }
                        if (message.state != null && message.hasOwnProperty("state"))
                            switch (message.state) {
                            default:
                                return "state: enum value expected";
                            case 0:
                            case 1:
                            case 2:
                                break;
                            }
                        if (message.analyticsHubSubscriptionInfo != null && message.hasOwnProperty("analyticsHubSubscriptionInfo")) {
                            var error = $root.google.pubsub.v1.Subscription.AnalyticsHubSubscriptionInfo.verify(message.analyticsHubSubscriptionInfo);
                            if (error)
                                return "analyticsHubSubscriptionInfo." + error;
                        }
                        if (message.messageTransforms != null && message.hasOwnProperty("messageTransforms")) {
                            if (!Array.isArray(message.messageTransforms))
                                return "messageTransforms: array expected";
                            for (var i = 0; i < message.messageTransforms.length; ++i) {
                                var error = $root.google.pubsub.v1.MessageTransform.verify(message.messageTransforms[i]);
                                if (error)
                                    return "messageTransforms." + error;
                            }
                        }
                        return null;
                    };
    
                    /**
                     * Creates a Subscription message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.Subscription
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.Subscription} Subscription
                     */
                    Subscription.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.Subscription)
                            return object;
                        var message = new $root.google.pubsub.v1.Subscription();
                        if (object.name != null)
                            message.name = String(object.name);
                        if (object.topic != null)
                            message.topic = String(object.topic);
                        if (object.pushConfig != null) {
                            if (typeof object.pushConfig !== "object")
                                throw TypeError(".google.pubsub.v1.Subscription.pushConfig: object expected");
                            message.pushConfig = $root.google.pubsub.v1.PushConfig.fromObject(object.pushConfig);
                        }
                        if (object.bigqueryConfig != null) {
                            if (typeof object.bigqueryConfig !== "object")
                                throw TypeError(".google.pubsub.v1.Subscription.bigqueryConfig: object expected");
                            message.bigqueryConfig = $root.google.pubsub.v1.BigQueryConfig.fromObject(object.bigqueryConfig);
                        }
                        if (object.cloudStorageConfig != null) {
                            if (typeof object.cloudStorageConfig !== "object")
                                throw TypeError(".google.pubsub.v1.Subscription.cloudStorageConfig: object expected");
                            message.cloudStorageConfig = $root.google.pubsub.v1.CloudStorageConfig.fromObject(object.cloudStorageConfig);
                        }
                        if (object.ackDeadlineSeconds != null)
                            message.ackDeadlineSeconds = object.ackDeadlineSeconds | 0;
                        if (object.retainAckedMessages != null)
                            message.retainAckedMessages = Boolean(object.retainAckedMessages);
                        if (object.messageRetentionDuration != null) {
                            if (typeof object.messageRetentionDuration !== "object")
                                throw TypeError(".google.pubsub.v1.Subscription.messageRetentionDuration: object expected");
                            message.messageRetentionDuration = $root.google.protobuf.Duration.fromObject(object.messageRetentionDuration);
                        }
                        if (object.labels) {
                            if (typeof object.labels !== "object")
                                throw TypeError(".google.pubsub.v1.Subscription.labels: object expected");
                            message.labels = {};
                            for (var keys = Object.keys(object.labels), i = 0; i < keys.length; ++i)
                                message.labels[keys[i]] = String(object.labels[keys[i]]);
                        }
                        if (object.enableMessageOrdering != null)
                            message.enableMessageOrdering = Boolean(object.enableMessageOrdering);
                        if (object.expirationPolicy != null) {
                            if (typeof object.expirationPolicy !== "object")
                                throw TypeError(".google.pubsub.v1.Subscription.expirationPolicy: object expected");
                            message.expirationPolicy = $root.google.pubsub.v1.ExpirationPolicy.fromObject(object.expirationPolicy);
                        }
                        if (object.filter != null)
                            message.filter = String(object.filter);
                        if (object.deadLetterPolicy != null) {
                            if (typeof object.deadLetterPolicy !== "object")
                                throw TypeError(".google.pubsub.v1.Subscription.deadLetterPolicy: object expected");
                            message.deadLetterPolicy = $root.google.pubsub.v1.DeadLetterPolicy.fromObject(object.deadLetterPolicy);
                        }
                        if (object.retryPolicy != null) {
                            if (typeof object.retryPolicy !== "object")
                                throw TypeError(".google.pubsub.v1.Subscription.retryPolicy: object expected");
                            message.retryPolicy = $root.google.pubsub.v1.RetryPolicy.fromObject(object.retryPolicy);
                        }
                        if (object.detached != null)
                            message.detached = Boolean(object.detached);
                        if (object.enableExactlyOnceDelivery != null)
                            message.enableExactlyOnceDelivery = Boolean(object.enableExactlyOnceDelivery);
                        if (object.topicMessageRetentionDuration != null) {
                            if (typeof object.topicMessageRetentionDuration !== "object")
                                throw TypeError(".google.pubsub.v1.Subscription.topicMessageRetentionDuration: object expected");
                            message.topicMessageRetentionDuration = $root.google.protobuf.Duration.fromObject(object.topicMessageRetentionDuration);
                        }
                        switch (object.state) {
                        default:
                            if (typeof object.state === "number") {
                                message.state = object.state;
                                break;
                            }
                            break;
                        case "STATE_UNSPECIFIED":
                        case 0:
                            message.state = 0;
                            break;
                        case "ACTIVE":
                        case 1:
                            message.state = 1;
                            break;
                        case "RESOURCE_ERROR":
                        case 2:
                            message.state = 2;
                            break;
                        }
                        if (object.analyticsHubSubscriptionInfo != null) {
                            if (typeof object.analyticsHubSubscriptionInfo !== "object")
                                throw TypeError(".google.pubsub.v1.Subscription.analyticsHubSubscriptionInfo: object expected");
                            message.analyticsHubSubscriptionInfo = $root.google.pubsub.v1.Subscription.AnalyticsHubSubscriptionInfo.fromObject(object.analyticsHubSubscriptionInfo);
                        }
                        if (object.messageTransforms) {
                            if (!Array.isArray(object.messageTransforms))
                                throw TypeError(".google.pubsub.v1.Subscription.messageTransforms: array expected");
                            message.messageTransforms = [];
                            for (var i = 0; i < object.messageTransforms.length; ++i) {
                                if (typeof object.messageTransforms[i] !== "object")
                                    throw TypeError(".google.pubsub.v1.Subscription.messageTransforms: object expected");
                                message.messageTransforms[i] = $root.google.pubsub.v1.MessageTransform.fromObject(object.messageTransforms[i]);
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a Subscription message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.Subscription
                     * @static
                     * @param {google.pubsub.v1.Subscription} message Subscription
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    Subscription.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.arrays || options.defaults)
                            object.messageTransforms = [];
                        if (options.objects || options.defaults)
                            object.labels = {};
                        if (options.defaults) {
                            object.name = "";
                            object.topic = "";
                            object.pushConfig = null;
                            object.ackDeadlineSeconds = 0;
                            object.retainAckedMessages = false;
                            object.messageRetentionDuration = null;
                            object.enableMessageOrdering = false;
                            object.expirationPolicy = null;
                            object.filter = "";
                            object.deadLetterPolicy = null;
                            object.retryPolicy = null;
                            object.detached = false;
                            object.enableExactlyOnceDelivery = false;
                            object.topicMessageRetentionDuration = null;
                            object.bigqueryConfig = null;
                            object.state = options.enums === String ? "STATE_UNSPECIFIED" : 0;
                            object.cloudStorageConfig = null;
                            object.analyticsHubSubscriptionInfo = null;
                        }
                        if (message.name != null && message.hasOwnProperty("name"))
                            object.name = message.name;
                        if (message.topic != null && message.hasOwnProperty("topic"))
                            object.topic = message.topic;
                        if (message.pushConfig != null && message.hasOwnProperty("pushConfig"))
                            object.pushConfig = $root.google.pubsub.v1.PushConfig.toObject(message.pushConfig, options);
                        if (message.ackDeadlineSeconds != null && message.hasOwnProperty("ackDeadlineSeconds"))
                            object.ackDeadlineSeconds = message.ackDeadlineSeconds;
                        if (message.retainAckedMessages != null && message.hasOwnProperty("retainAckedMessages"))
                            object.retainAckedMessages = message.retainAckedMessages;
                        if (message.messageRetentionDuration != null && message.hasOwnProperty("messageRetentionDuration"))
                            object.messageRetentionDuration = $root.google.protobuf.Duration.toObject(message.messageRetentionDuration, options);
                        var keys2;
                        if (message.labels && (keys2 = Object.keys(message.labels)).length) {
                            object.labels = {};
                            for (var j = 0; j < keys2.length; ++j)
                                object.labels[keys2[j]] = message.labels[keys2[j]];
                        }
                        if (message.enableMessageOrdering != null && message.hasOwnProperty("enableMessageOrdering"))
                            object.enableMessageOrdering = message.enableMessageOrdering;
                        if (message.expirationPolicy != null && message.hasOwnProperty("expirationPolicy"))
                            object.expirationPolicy = $root.google.pubsub.v1.ExpirationPolicy.toObject(message.expirationPolicy, options);
                        if (message.filter != null && message.hasOwnProperty("filter"))
                            object.filter = message.filter;
                        if (message.deadLetterPolicy != null && message.hasOwnProperty("deadLetterPolicy"))
                            object.deadLetterPolicy = $root.google.pubsub.v1.DeadLetterPolicy.toObject(message.deadLetterPolicy, options);
                        if (message.retryPolicy != null && message.hasOwnProperty("retryPolicy"))
                            object.retryPolicy = $root.google.pubsub.v1.RetryPolicy.toObject(message.retryPolicy, options);
                        if (message.detached != null && message.hasOwnProperty("detached"))
                            object.detached = message.detached;
                        if (message.enableExactlyOnceDelivery != null && message.hasOwnProperty("enableExactlyOnceDelivery"))
                            object.enableExactlyOnceDelivery = message.enableExactlyOnceDelivery;
                        if (message.topicMessageRetentionDuration != null && message.hasOwnProperty("topicMessageRetentionDuration"))
                            object.topicMessageRetentionDuration = $root.google.protobuf.Duration.toObject(message.topicMessageRetentionDuration, options);
                        if (message.bigqueryConfig != null && message.hasOwnProperty("bigqueryConfig"))
                            object.bigqueryConfig = $root.google.pubsub.v1.BigQueryConfig.toObject(message.bigqueryConfig, options);
                        if (message.state != null && message.hasOwnProperty("state"))
                            object.state = options.enums === String ? $root.google.pubsub.v1.Subscription.State[message.state] === undefined ? message.state : $root.google.pubsub.v1.Subscription.State[message.state] : message.state;
                        if (message.cloudStorageConfig != null && message.hasOwnProperty("cloudStorageConfig"))
                            object.cloudStorageConfig = $root.google.pubsub.v1.CloudStorageConfig.toObject(message.cloudStorageConfig, options);
                        if (message.analyticsHubSubscriptionInfo != null && message.hasOwnProperty("analyticsHubSubscriptionInfo"))
                            object.analyticsHubSubscriptionInfo = $root.google.pubsub.v1.Subscription.AnalyticsHubSubscriptionInfo.toObject(message.analyticsHubSubscriptionInfo, options);
                        if (message.messageTransforms && message.messageTransforms.length) {
                            object.messageTransforms = [];
                            for (var j = 0; j < message.messageTransforms.length; ++j)
                                object.messageTransforms[j] = $root.google.pubsub.v1.MessageTransform.toObject(message.messageTransforms[j], options);
                        }
                        return object;
                    };
    
                    /**
                     * Converts this Subscription to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.Subscription
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    Subscription.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for Subscription
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.Subscription
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    Subscription.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.Subscription";
                    };
    
                    /**
                     * State enum.
                     * @name google.pubsub.v1.Subscription.State
                     * @enum {number}
                     * @property {number} STATE_UNSPECIFIED=0 STATE_UNSPECIFIED value
                     * @property {number} ACTIVE=1 ACTIVE value
                     * @property {number} RESOURCE_ERROR=2 RESOURCE_ERROR value
                     */
                    Subscription.State = (function() {
                        var valuesById = {}, values = Object.create(valuesById);
                        values[valuesById[0] = "STATE_UNSPECIFIED"] = 0;
                        values[valuesById[1] = "ACTIVE"] = 1;
                        values[valuesById[2] = "RESOURCE_ERROR"] = 2;
                        return values;
                    })();
    
                    Subscription.AnalyticsHubSubscriptionInfo = (function() {
    
                        /**
                         * Properties of an AnalyticsHubSubscriptionInfo.
                         * @memberof google.pubsub.v1.Subscription
                         * @interface IAnalyticsHubSubscriptionInfo
                         * @property {string|null} [listing] AnalyticsHubSubscriptionInfo listing
                         * @property {string|null} [subscription] AnalyticsHubSubscriptionInfo subscription
                         */
    
                        /**
                         * Constructs a new AnalyticsHubSubscriptionInfo.
                         * @memberof google.pubsub.v1.Subscription
                         * @classdesc Represents an AnalyticsHubSubscriptionInfo.
                         * @implements IAnalyticsHubSubscriptionInfo
                         * @constructor
                         * @param {google.pubsub.v1.Subscription.IAnalyticsHubSubscriptionInfo=} [properties] Properties to set
                         */
                        function AnalyticsHubSubscriptionInfo(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * AnalyticsHubSubscriptionInfo listing.
                         * @member {string} listing
                         * @memberof google.pubsub.v1.Subscription.AnalyticsHubSubscriptionInfo
                         * @instance
                         */
                        AnalyticsHubSubscriptionInfo.prototype.listing = "";
    
                        /**
                         * AnalyticsHubSubscriptionInfo subscription.
                         * @member {string} subscription
                         * @memberof google.pubsub.v1.Subscription.AnalyticsHubSubscriptionInfo
                         * @instance
                         */
                        AnalyticsHubSubscriptionInfo.prototype.subscription = "";
    
                        /**
                         * Creates a new AnalyticsHubSubscriptionInfo instance using the specified properties.
                         * @function create
                         * @memberof google.pubsub.v1.Subscription.AnalyticsHubSubscriptionInfo
                         * @static
                         * @param {google.pubsub.v1.Subscription.IAnalyticsHubSubscriptionInfo=} [properties] Properties to set
                         * @returns {google.pubsub.v1.Subscription.AnalyticsHubSubscriptionInfo} AnalyticsHubSubscriptionInfo instance
                         */
                        AnalyticsHubSubscriptionInfo.create = function create(properties) {
                            return new AnalyticsHubSubscriptionInfo(properties);
                        };
    
                        /**
                         * Encodes the specified AnalyticsHubSubscriptionInfo message. Does not implicitly {@link google.pubsub.v1.Subscription.AnalyticsHubSubscriptionInfo.verify|verify} messages.
                         * @function encode
                         * @memberof google.pubsub.v1.Subscription.AnalyticsHubSubscriptionInfo
                         * @static
                         * @param {google.pubsub.v1.Subscription.IAnalyticsHubSubscriptionInfo} message AnalyticsHubSubscriptionInfo message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AnalyticsHubSubscriptionInfo.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.listing != null && Object.hasOwnProperty.call(message, "listing"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.listing);
                            if (message.subscription != null && Object.hasOwnProperty.call(message, "subscription"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.subscription);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified AnalyticsHubSubscriptionInfo message, length delimited. Does not implicitly {@link google.pubsub.v1.Subscription.AnalyticsHubSubscriptionInfo.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.pubsub.v1.Subscription.AnalyticsHubSubscriptionInfo
                         * @static
                         * @param {google.pubsub.v1.Subscription.IAnalyticsHubSubscriptionInfo} message AnalyticsHubSubscriptionInfo message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AnalyticsHubSubscriptionInfo.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an AnalyticsHubSubscriptionInfo message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.pubsub.v1.Subscription.AnalyticsHubSubscriptionInfo
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.pubsub.v1.Subscription.AnalyticsHubSubscriptionInfo} AnalyticsHubSubscriptionInfo
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AnalyticsHubSubscriptionInfo.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.Subscription.AnalyticsHubSubscriptionInfo();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.listing = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.subscription = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an AnalyticsHubSubscriptionInfo message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.pubsub.v1.Subscription.AnalyticsHubSubscriptionInfo
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.pubsub.v1.Subscription.AnalyticsHubSubscriptionInfo} AnalyticsHubSubscriptionInfo
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AnalyticsHubSubscriptionInfo.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an AnalyticsHubSubscriptionInfo message.
                         * @function verify
                         * @memberof google.pubsub.v1.Subscription.AnalyticsHubSubscriptionInfo
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AnalyticsHubSubscriptionInfo.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.listing != null && message.hasOwnProperty("listing"))
                                if (!$util.isString(message.listing))
                                    return "listing: string expected";
                            if (message.subscription != null && message.hasOwnProperty("subscription"))
                                if (!$util.isString(message.subscription))
                                    return "subscription: string expected";
                            return null;
                        };
    
                        /**
                         * Creates an AnalyticsHubSubscriptionInfo message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.pubsub.v1.Subscription.AnalyticsHubSubscriptionInfo
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.pubsub.v1.Subscription.AnalyticsHubSubscriptionInfo} AnalyticsHubSubscriptionInfo
                         */
                        AnalyticsHubSubscriptionInfo.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.pubsub.v1.Subscription.AnalyticsHubSubscriptionInfo)
                                return object;
                            var message = new $root.google.pubsub.v1.Subscription.AnalyticsHubSubscriptionInfo();
                            if (object.listing != null)
                                message.listing = String(object.listing);
                            if (object.subscription != null)
                                message.subscription = String(object.subscription);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an AnalyticsHubSubscriptionInfo message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.pubsub.v1.Subscription.AnalyticsHubSubscriptionInfo
                         * @static
                         * @param {google.pubsub.v1.Subscription.AnalyticsHubSubscriptionInfo} message AnalyticsHubSubscriptionInfo
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AnalyticsHubSubscriptionInfo.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.listing = "";
                                object.subscription = "";
                            }
                            if (message.listing != null && message.hasOwnProperty("listing"))
                                object.listing = message.listing;
                            if (message.subscription != null && message.hasOwnProperty("subscription"))
                                object.subscription = message.subscription;
                            return object;
                        };
    
                        /**
                         * Converts this AnalyticsHubSubscriptionInfo to JSON.
                         * @function toJSON
                         * @memberof google.pubsub.v1.Subscription.AnalyticsHubSubscriptionInfo
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AnalyticsHubSubscriptionInfo.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for AnalyticsHubSubscriptionInfo
                         * @function getTypeUrl
                         * @memberof google.pubsub.v1.Subscription.AnalyticsHubSubscriptionInfo
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        AnalyticsHubSubscriptionInfo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.pubsub.v1.Subscription.AnalyticsHubSubscriptionInfo";
                        };
    
                        return AnalyticsHubSubscriptionInfo;
                    })();
    
                    return Subscription;
                })();
    
                v1.RetryPolicy = (function() {
    
                    /**
                     * Properties of a RetryPolicy.
                     * @memberof google.pubsub.v1
                     * @interface IRetryPolicy
                     * @property {google.protobuf.IDuration|null} [minimumBackoff] RetryPolicy minimumBackoff
                     * @property {google.protobuf.IDuration|null} [maximumBackoff] RetryPolicy maximumBackoff
                     */
    
                    /**
                     * Constructs a new RetryPolicy.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a RetryPolicy.
                     * @implements IRetryPolicy
                     * @constructor
                     * @param {google.pubsub.v1.IRetryPolicy=} [properties] Properties to set
                     */
                    function RetryPolicy(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * RetryPolicy minimumBackoff.
                     * @member {google.protobuf.IDuration|null|undefined} minimumBackoff
                     * @memberof google.pubsub.v1.RetryPolicy
                     * @instance
                     */
                    RetryPolicy.prototype.minimumBackoff = null;
    
                    /**
                     * RetryPolicy maximumBackoff.
                     * @member {google.protobuf.IDuration|null|undefined} maximumBackoff
                     * @memberof google.pubsub.v1.RetryPolicy
                     * @instance
                     */
                    RetryPolicy.prototype.maximumBackoff = null;
    
                    /**
                     * Creates a new RetryPolicy instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.RetryPolicy
                     * @static
                     * @param {google.pubsub.v1.IRetryPolicy=} [properties] Properties to set
                     * @returns {google.pubsub.v1.RetryPolicy} RetryPolicy instance
                     */
                    RetryPolicy.create = function create(properties) {
                        return new RetryPolicy(properties);
                    };
    
                    /**
                     * Encodes the specified RetryPolicy message. Does not implicitly {@link google.pubsub.v1.RetryPolicy.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.RetryPolicy
                     * @static
                     * @param {google.pubsub.v1.IRetryPolicy} message RetryPolicy message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    RetryPolicy.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.minimumBackoff != null && Object.hasOwnProperty.call(message, "minimumBackoff"))
                            $root.google.protobuf.Duration.encode(message.minimumBackoff, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                        if (message.maximumBackoff != null && Object.hasOwnProperty.call(message, "maximumBackoff"))
                            $root.google.protobuf.Duration.encode(message.maximumBackoff, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified RetryPolicy message, length delimited. Does not implicitly {@link google.pubsub.v1.RetryPolicy.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.RetryPolicy
                     * @static
                     * @param {google.pubsub.v1.IRetryPolicy} message RetryPolicy message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    RetryPolicy.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a RetryPolicy message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.RetryPolicy
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.RetryPolicy} RetryPolicy
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    RetryPolicy.decode = function decode(reader, length, error) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.RetryPolicy();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            if (tag === error)
                                break;
                            switch (tag >>> 3) {
                            case 1: {
                                    message.minimumBackoff = $root.google.protobuf.Duration.decode(reader, reader.uint32());
                                    break;
                                }
                            case 2: {
                                    message.maximumBackoff = $root.google.protobuf.Duration.decode(reader, reader.uint32());
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a RetryPolicy message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.RetryPolicy
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.RetryPolicy} RetryPolicy
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    RetryPolicy.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a RetryPolicy message.
                     * @function verify
                     * @memberof google.pubsub.v1.RetryPolicy
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    RetryPolicy.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.minimumBackoff != null && message.hasOwnProperty("minimumBackoff")) {
                            var error = $root.google.protobuf.Duration.verify(message.minimumBackoff);
                            if (error)
                                return "minimumBackoff." + error;
                        }
                        if (message.maximumBackoff != null && message.hasOwnProperty("maximumBackoff")) {
                            var error = $root.google.protobuf.Duration.verify(message.maximumBackoff);
                            if (error)
                                return "maximumBackoff." + error;
                        }
                        return null;
                    };
    
                    /**
                     * Creates a RetryPolicy message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.RetryPolicy
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.RetryPolicy} RetryPolicy
                     */
                    RetryPolicy.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.RetryPolicy)
                            return object;
                        var message = new $root.google.pubsub.v1.RetryPolicy();
                        if (object.minimumBackoff != null) {
                            if (typeof object.minimumBackoff !== "object")
                                throw TypeError(".google.pubsub.v1.RetryPolicy.minimumBackoff: object expected");
                            message.minimumBackoff = $root.google.protobuf.Duration.fromObject(object.minimumBackoff);
                        }
                        if (object.maximumBackoff != null) {
                            if (typeof object.maximumBackoff !== "object")
                                throw TypeError(".google.pubsub.v1.RetryPolicy.maximumBackoff: object expected");
                            message.maximumBackoff = $root.google.protobuf.Duration.fromObject(object.maximumBackoff);
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a RetryPolicy message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.RetryPolicy
                     * @static
                     * @param {google.pubsub.v1.RetryPolicy} message RetryPolicy
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    RetryPolicy.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.minimumBackoff = null;
                            object.maximumBackoff = null;
                        }
                        if (message.minimumBackoff != null && message.hasOwnProperty("minimumBackoff"))
                            object.minimumBackoff = $root.google.protobuf.Duration.toObject(message.minimumBackoff, options);
                        if (message.maximumBackoff != null && message.hasOwnProperty("maximumBackoff"))
                            object.maximumBackoff = $root.google.protobuf.Duration.toObject(message.maximumBackoff, options);
                        return object;
                    };
    
                    /**
                     * Converts this RetryPolicy to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.RetryPolicy
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    RetryPolicy.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for RetryPolicy
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.RetryPolicy
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    RetryPolicy.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.RetryPolicy";
                    };
    
                    return RetryPolicy;
                })();
    
                v1.DeadLetterPolicy = (function() {
    
                    /**
                     * Properties of a DeadLetterPolicy.
                     * @memberof google.pubsub.v1
                     * @interface IDeadLetterPolicy
                     * @property {string|null} [deadLetterTopic] DeadLetterPolicy deadLetterTopic
                     * @property {number|null} [maxDeliveryAttempts] DeadLetterPolicy maxDeliveryAttempts
                     */
    
                    /**
                     * Constructs a new DeadLetterPolicy.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a DeadLetterPolicy.
                     * @implements IDeadLetterPolicy
                     * @constructor
                     * @param {google.pubsub.v1.IDeadLetterPolicy=} [properties] Properties to set
                     */
                    function DeadLetterPolicy(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * DeadLetterPolicy deadLetterTopic.
                     * @member {string} deadLetterTopic
                     * @memberof google.pubsub.v1.DeadLetterPolicy
                     * @instance
                     */
                    DeadLetterPolicy.prototype.deadLetterTopic = "";
    
                    /**
                     * DeadLetterPolicy maxDeliveryAttempts.
                     * @member {number} maxDeliveryAttempts
                     * @memberof google.pubsub.v1.DeadLetterPolicy
                     * @instance
                     */
                    DeadLetterPolicy.prototype.maxDeliveryAttempts = 0;
    
                    /**
                     * Creates a new DeadLetterPolicy instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.DeadLetterPolicy
                     * @static
                     * @param {google.pubsub.v1.IDeadLetterPolicy=} [properties] Properties to set
                     * @returns {google.pubsub.v1.DeadLetterPolicy} DeadLetterPolicy instance
                     */
                    DeadLetterPolicy.create = function create(properties) {
                        return new DeadLetterPolicy(properties);
                    };
    
                    /**
                     * Encodes the specified DeadLetterPolicy message. Does not implicitly {@link google.pubsub.v1.DeadLetterPolicy.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.DeadLetterPolicy
                     * @static
                     * @param {google.pubsub.v1.IDeadLetterPolicy} message DeadLetterPolicy message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    DeadLetterPolicy.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.deadLetterTopic != null && Object.hasOwnProperty.call(message, "deadLetterTopic"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.deadLetterTopic);
                        if (message.maxDeliveryAttempts != null && Object.hasOwnProperty.call(message, "maxDeliveryAttempts"))
                            writer.uint32(/* id 2, wireType 0 =*/16).int32(message.maxDeliveryAttempts);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified DeadLetterPolicy message, length delimited. Does not implicitly {@link google.pubsub.v1.DeadLetterPolicy.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.DeadLetterPolicy
                     * @static
                     * @param {google.pubsub.v1.IDeadLetterPolicy} message DeadLetterPolicy message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    DeadLetterPolicy.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a DeadLetterPolicy message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.DeadLetterPolicy
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.DeadLetterPolicy} DeadLetterPolicy
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    DeadLetterPolicy.decode = function decode(reader, length, error) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.DeadLetterPolicy();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            if (tag === error)
                                break;
                            switch (tag >>> 3) {
                            case 1: {
                                    message.deadLetterTopic = reader.string();
                                    break;
                                }
                            case 2: {
                                    message.maxDeliveryAttempts = reader.int32();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a DeadLetterPolicy message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.DeadLetterPolicy
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.DeadLetterPolicy} DeadLetterPolicy
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    DeadLetterPolicy.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a DeadLetterPolicy message.
                     * @function verify
                     * @memberof google.pubsub.v1.DeadLetterPolicy
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    DeadLetterPolicy.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.deadLetterTopic != null && message.hasOwnProperty("deadLetterTopic"))
                            if (!$util.isString(message.deadLetterTopic))
                                return "deadLetterTopic: string expected";
                        if (message.maxDeliveryAttempts != null && message.hasOwnProperty("maxDeliveryAttempts"))
                            if (!$util.isInteger(message.maxDeliveryAttempts))
                                return "maxDeliveryAttempts: integer expected";
                        return null;
                    };
    
                    /**
                     * Creates a DeadLetterPolicy message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.DeadLetterPolicy
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.DeadLetterPolicy} DeadLetterPolicy
                     */
                    DeadLetterPolicy.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.DeadLetterPolicy)
                            return object;
                        var message = new $root.google.pubsub.v1.DeadLetterPolicy();
                        if (object.deadLetterTopic != null)
                            message.deadLetterTopic = String(object.deadLetterTopic);
                        if (object.maxDeliveryAttempts != null)
                            message.maxDeliveryAttempts = object.maxDeliveryAttempts | 0;
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a DeadLetterPolicy message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.DeadLetterPolicy
                     * @static
                     * @param {google.pubsub.v1.DeadLetterPolicy} message DeadLetterPolicy
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    DeadLetterPolicy.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.deadLetterTopic = "";
                            object.maxDeliveryAttempts = 0;
                        }
                        if (message.deadLetterTopic != null && message.hasOwnProperty("deadLetterTopic"))
                            object.deadLetterTopic = message.deadLetterTopic;
                        if (message.maxDeliveryAttempts != null && message.hasOwnProperty("maxDeliveryAttempts"))
                            object.maxDeliveryAttempts = message.maxDeliveryAttempts;
                        return object;
                    };
    
                    /**
                     * Converts this DeadLetterPolicy to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.DeadLetterPolicy
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    DeadLetterPolicy.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for DeadLetterPolicy
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.DeadLetterPolicy
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    DeadLetterPolicy.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.DeadLetterPolicy";
                    };
    
                    return DeadLetterPolicy;
                })();
    
                v1.ExpirationPolicy = (function() {
    
                    /**
                     * Properties of an ExpirationPolicy.
                     * @memberof google.pubsub.v1
                     * @interface IExpirationPolicy
                     * @property {google.protobuf.IDuration|null} [ttl] ExpirationPolicy ttl
                     */
    
                    /**
                     * Constructs a new ExpirationPolicy.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents an ExpirationPolicy.
                     * @implements IExpirationPolicy
                     * @constructor
                     * @param {google.pubsub.v1.IExpirationPolicy=} [properties] Properties to set
                     */
                    function ExpirationPolicy(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * ExpirationPolicy ttl.
                     * @member {google.protobuf.IDuration|null|undefined} ttl
                     * @memberof google.pubsub.v1.ExpirationPolicy
                     * @instance
                     */
                    ExpirationPolicy.prototype.ttl = null;
    
                    /**
                     * Creates a new ExpirationPolicy instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.ExpirationPolicy
                     * @static
                     * @param {google.pubsub.v1.IExpirationPolicy=} [properties] Properties to set
                     * @returns {google.pubsub.v1.ExpirationPolicy} ExpirationPolicy instance
                     */
                    ExpirationPolicy.create = function create(properties) {
                        return new ExpirationPolicy(properties);
                    };
    
                    /**
                     * Encodes the specified ExpirationPolicy message. Does not implicitly {@link google.pubsub.v1.ExpirationPolicy.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.ExpirationPolicy
                     * @static
                     * @param {google.pubsub.v1.IExpirationPolicy} message ExpirationPolicy message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ExpirationPolicy.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.ttl != null && Object.hasOwnProperty.call(message, "ttl"))
                            $root.google.protobuf.Duration.encode(message.ttl, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified ExpirationPolicy message, length delimited. Does not implicitly {@link google.pubsub.v1.ExpirationPolicy.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.ExpirationPolicy
                     * @static
                     * @param {google.pubsub.v1.IExpirationPolicy} message ExpirationPolicy message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ExpirationPolicy.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes an ExpirationPolicy message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.ExpirationPolicy
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.ExpirationPolicy} ExpirationPolicy
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ExpirationPolicy.decode = function decode(reader, length, error) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.ExpirationPolicy();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            if (tag === error)
                                break;
                            switch (tag >>> 3) {
                            case 1: {
                                    message.ttl = $root.google.protobuf.Duration.decode(reader, reader.uint32());
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes an ExpirationPolicy message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.ExpirationPolicy
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.ExpirationPolicy} ExpirationPolicy
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ExpirationPolicy.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies an ExpirationPolicy message.
                     * @function verify
                     * @memberof google.pubsub.v1.ExpirationPolicy
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    ExpirationPolicy.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.ttl != null && message.hasOwnProperty("ttl")) {
                            var error = $root.google.protobuf.Duration.verify(message.ttl);
                            if (error)
                                return "ttl." + error;
                        }
                        return null;
                    };
    
                    /**
                     * Creates an ExpirationPolicy message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.ExpirationPolicy
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.ExpirationPolicy} ExpirationPolicy
                     */
                    ExpirationPolicy.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.ExpirationPolicy)
                            return object;
                        var message = new $root.google.pubsub.v1.ExpirationPolicy();
                        if (object.ttl != null) {
                            if (typeof object.ttl !== "object")
                                throw TypeError(".google.pubsub.v1.ExpirationPolicy.ttl: object expected");
                            message.ttl = $root.google.protobuf.Duration.fromObject(object.ttl);
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from an ExpirationPolicy message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.ExpirationPolicy
                     * @static
                     * @param {google.pubsub.v1.ExpirationPolicy} message ExpirationPolicy
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    ExpirationPolicy.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults)
                            object.ttl = null;
                        if (message.ttl != null && message.hasOwnProperty("ttl"))
                            object.ttl = $root.google.protobuf.Duration.toObject(message.ttl, options);
                        return object;
                    };
    
                    /**
                     * Converts this ExpirationPolicy to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.ExpirationPolicy
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    ExpirationPolicy.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for ExpirationPolicy
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.ExpirationPolicy
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    ExpirationPolicy.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.ExpirationPolicy";
                    };
    
                    return ExpirationPolicy;
                })();
    
                v1.PushConfig = (function() {
    
                    /**
                     * Properties of a PushConfig.
                     * @memberof google.pubsub.v1
                     * @interface IPushConfig
                     * @property {string|null} [pushEndpoint] PushConfig pushEndpoint
                     * @property {Object.<string,string>|null} [attributes] PushConfig attributes
                     * @property {google.pubsub.v1.PushConfig.IOidcToken|null} [oidcToken] PushConfig oidcToken
                     * @property {google.pubsub.v1.PushConfig.IPubsubWrapper|null} [pubsubWrapper] PushConfig pubsubWrapper
                     * @property {google.pubsub.v1.PushConfig.INoWrapper|null} [noWrapper] PushConfig noWrapper
                     */
    
                    /**
                     * Constructs a new PushConfig.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a PushConfig.
                     * @implements IPushConfig
                     * @constructor
                     * @param {google.pubsub.v1.IPushConfig=} [properties] Properties to set
                     */
                    function PushConfig(properties) {
                        this.attributes = {};
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * PushConfig pushEndpoint.
                     * @member {string} pushEndpoint
                     * @memberof google.pubsub.v1.PushConfig
                     * @instance
                     */
                    PushConfig.prototype.pushEndpoint = "";
    
                    /**
                     * PushConfig attributes.
                     * @member {Object.<string,string>} attributes
                     * @memberof google.pubsub.v1.PushConfig
                     * @instance
                     */
                    PushConfig.prototype.attributes = $util.emptyObject;
    
                    /**
                     * PushConfig oidcToken.
                     * @member {google.pubsub.v1.PushConfig.IOidcToken|null|undefined} oidcToken
                     * @memberof google.pubsub.v1.PushConfig
                     * @instance
                     */
                    PushConfig.prototype.oidcToken = null;
    
                    /**
                     * PushConfig pubsubWrapper.
                     * @member {google.pubsub.v1.PushConfig.IPubsubWrapper|null|undefined} pubsubWrapper
                     * @memberof google.pubsub.v1.PushConfig
                     * @instance
                     */
                    PushConfig.prototype.pubsubWrapper = null;
    
                    /**
                     * PushConfig noWrapper.
                     * @member {google.pubsub.v1.PushConfig.INoWrapper|null|undefined} noWrapper
                     * @memberof google.pubsub.v1.PushConfig
                     * @instance
                     */
                    PushConfig.prototype.noWrapper = null;
    
                    // OneOf field names bound to virtual getters and setters
                    var $oneOfFields;
    
                    /**
                     * PushConfig authenticationMethod.
                     * @member {"oidcToken"|undefined} authenticationMethod
                     * @memberof google.pubsub.v1.PushConfig
                     * @instance
                     */
                    Object.defineProperty(PushConfig.prototype, "authenticationMethod", {
                        get: $util.oneOfGetter($oneOfFields = ["oidcToken"]),
                        set: $util.oneOfSetter($oneOfFields)
                    });
    
                    /**
                     * PushConfig wrapper.
                     * @member {"pubsubWrapper"|"noWrapper"|undefined} wrapper
                     * @memberof google.pubsub.v1.PushConfig
                     * @instance
                     */
                    Object.defineProperty(PushConfig.prototype, "wrapper", {
                        get: $util.oneOfGetter($oneOfFields = ["pubsubWrapper", "noWrapper"]),
                        set: $util.oneOfSetter($oneOfFields)
                    });
    
                    /**
                     * Creates a new PushConfig instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.PushConfig
                     * @static
                     * @param {google.pubsub.v1.IPushConfig=} [properties] Properties to set
                     * @returns {google.pubsub.v1.PushConfig} PushConfig instance
                     */
                    PushConfig.create = function create(properties) {
                        return new PushConfig(properties);
                    };
    
                    /**
                     * Encodes the specified PushConfig message. Does not implicitly {@link google.pubsub.v1.PushConfig.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.PushConfig
                     * @static
                     * @param {google.pubsub.v1.IPushConfig} message PushConfig message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    PushConfig.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.pushEndpoint != null && Object.hasOwnProperty.call(message, "pushEndpoint"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.pushEndpoint);
                        if (message.attributes != null && Object.hasOwnProperty.call(message, "attributes"))
                            for (var keys = Object.keys(message.attributes), i = 0; i < keys.length; ++i)
                                writer.uint32(/* id 2, wireType 2 =*/18).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]).uint32(/* id 2, wireType 2 =*/18).string(message.attributes[keys[i]]).ldelim();
                        if (message.oidcToken != null && Object.hasOwnProperty.call(message, "oidcToken"))
                            $root.google.pubsub.v1.PushConfig.OidcToken.encode(message.oidcToken, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                        if (message.pubsubWrapper != null && Object.hasOwnProperty.call(message, "pubsubWrapper"))
                            $root.google.pubsub.v1.PushConfig.PubsubWrapper.encode(message.pubsubWrapper, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                        if (message.noWrapper != null && Object.hasOwnProperty.call(message, "noWrapper"))
                            $root.google.pubsub.v1.PushConfig.NoWrapper.encode(message.noWrapper, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified PushConfig message, length delimited. Does not implicitly {@link google.pubsub.v1.PushConfig.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.PushConfig
                     * @static
                     * @param {google.pubsub.v1.IPushConfig} message PushConfig message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    PushConfig.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a PushConfig message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.PushConfig
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.PushConfig} PushConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    PushConfig.decode = function decode(reader, length, error) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.PushConfig(), key, value;
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            if (tag === error)
                                break;
                            switch (tag >>> 3) {
                            case 1: {
                                    message.pushEndpoint = reader.string();
                                    break;
                                }
                            case 2: {
                                    if (message.attributes === $util.emptyObject)
                                        message.attributes = {};
                                    var end2 = reader.uint32() + reader.pos;
                                    key = "";
                                    value = "";
                                    while (reader.pos < end2) {
                                        var tag2 = reader.uint32();
                                        switch (tag2 >>> 3) {
                                        case 1:
                                            key = reader.string();
                                            break;
                                        case 2:
                                            value = reader.string();
                                            break;
                                        default:
                                            reader.skipType(tag2 & 7);
                                            break;
                                        }
                                    }
                                    message.attributes[key] = value;
                                    break;
                                }
                            case 3: {
                                    message.oidcToken = $root.google.pubsub.v1.PushConfig.OidcToken.decode(reader, reader.uint32());
                                    break;
                                }
                            case 4: {
                                    message.pubsubWrapper = $root.google.pubsub.v1.PushConfig.PubsubWrapper.decode(reader, reader.uint32());
                                    break;
                                }
                            case 5: {
                                    message.noWrapper = $root.google.pubsub.v1.PushConfig.NoWrapper.decode(reader, reader.uint32());
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a PushConfig message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.PushConfig
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.PushConfig} PushConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    PushConfig.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a PushConfig message.
                     * @function verify
                     * @memberof google.pubsub.v1.PushConfig
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    PushConfig.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        var properties = {};
                        if (message.pushEndpoint != null && message.hasOwnProperty("pushEndpoint"))
                            if (!$util.isString(message.pushEndpoint))
                                return "pushEndpoint: string expected";
                        if (message.attributes != null && message.hasOwnProperty("attributes")) {
                            if (!$util.isObject(message.attributes))
                                return "attributes: object expected";
                            var key = Object.keys(message.attributes);
                            for (var i = 0; i < key.length; ++i)
                                if (!$util.isString(message.attributes[key[i]]))
                                    return "attributes: string{k:string} expected";
                        }
                        if (message.oidcToken != null && message.hasOwnProperty("oidcToken")) {
                            properties.authenticationMethod = 1;
                            {
                                var error = $root.google.pubsub.v1.PushConfig.OidcToken.verify(message.oidcToken);
                                if (error)
                                    return "oidcToken." + error;
                            }
                        }
                        if (message.pubsubWrapper != null && message.hasOwnProperty("pubsubWrapper")) {
                            properties.wrapper = 1;
                            {
                                var error = $root.google.pubsub.v1.PushConfig.PubsubWrapper.verify(message.pubsubWrapper);
                                if (error)
                                    return "pubsubWrapper." + error;
                            }
                        }
                        if (message.noWrapper != null && message.hasOwnProperty("noWrapper")) {
                            if (properties.wrapper === 1)
                                return "wrapper: multiple values";
                            properties.wrapper = 1;
                            {
                                var error = $root.google.pubsub.v1.PushConfig.NoWrapper.verify(message.noWrapper);
                                if (error)
                                    return "noWrapper." + error;
                            }
                        }
                        return null;
                    };
    
                    /**
                     * Creates a PushConfig message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.PushConfig
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.PushConfig} PushConfig
                     */
                    PushConfig.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.PushConfig)
                            return object;
                        var message = new $root.google.pubsub.v1.PushConfig();
                        if (object.pushEndpoint != null)
                            message.pushEndpoint = String(object.pushEndpoint);
                        if (object.attributes) {
                            if (typeof object.attributes !== "object")
                                throw TypeError(".google.pubsub.v1.PushConfig.attributes: object expected");
                            message.attributes = {};
                            for (var keys = Object.keys(object.attributes), i = 0; i < keys.length; ++i)
                                message.attributes[keys[i]] = String(object.attributes[keys[i]]);
                        }
                        if (object.oidcToken != null) {
                            if (typeof object.oidcToken !== "object")
                                throw TypeError(".google.pubsub.v1.PushConfig.oidcToken: object expected");
                            message.oidcToken = $root.google.pubsub.v1.PushConfig.OidcToken.fromObject(object.oidcToken);
                        }
                        if (object.pubsubWrapper != null) {
                            if (typeof object.pubsubWrapper !== "object")
                                throw TypeError(".google.pubsub.v1.PushConfig.pubsubWrapper: object expected");
                            message.pubsubWrapper = $root.google.pubsub.v1.PushConfig.PubsubWrapper.fromObject(object.pubsubWrapper);
                        }
                        if (object.noWrapper != null) {
                            if (typeof object.noWrapper !== "object")
                                throw TypeError(".google.pubsub.v1.PushConfig.noWrapper: object expected");
                            message.noWrapper = $root.google.pubsub.v1.PushConfig.NoWrapper.fromObject(object.noWrapper);
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a PushConfig message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.PushConfig
                     * @static
                     * @param {google.pubsub.v1.PushConfig} message PushConfig
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    PushConfig.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.objects || options.defaults)
                            object.attributes = {};
                        if (options.defaults)
                            object.pushEndpoint = "";
                        if (message.pushEndpoint != null && message.hasOwnProperty("pushEndpoint"))
                            object.pushEndpoint = message.pushEndpoint;
                        var keys2;
                        if (message.attributes && (keys2 = Object.keys(message.attributes)).length) {
                            object.attributes = {};
                            for (var j = 0; j < keys2.length; ++j)
                                object.attributes[keys2[j]] = message.attributes[keys2[j]];
                        }
                        if (message.oidcToken != null && message.hasOwnProperty("oidcToken")) {
                            object.oidcToken = $root.google.pubsub.v1.PushConfig.OidcToken.toObject(message.oidcToken, options);
                            if (options.oneofs)
                                object.authenticationMethod = "oidcToken";
                        }
                        if (message.pubsubWrapper != null && message.hasOwnProperty("pubsubWrapper")) {
                            object.pubsubWrapper = $root.google.pubsub.v1.PushConfig.PubsubWrapper.toObject(message.pubsubWrapper, options);
                            if (options.oneofs)
                                object.wrapper = "pubsubWrapper";
                        }
                        if (message.noWrapper != null && message.hasOwnProperty("noWrapper")) {
                            object.noWrapper = $root.google.pubsub.v1.PushConfig.NoWrapper.toObject(message.noWrapper, options);
                            if (options.oneofs)
                                object.wrapper = "noWrapper";
                        }
                        return object;
                    };
    
                    /**
                     * Converts this PushConfig to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.PushConfig
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    PushConfig.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for PushConfig
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.PushConfig
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    PushConfig.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.PushConfig";
                    };
    
                    PushConfig.OidcToken = (function() {
    
                        /**
                         * Properties of an OidcToken.
                         * @memberof google.pubsub.v1.PushConfig
                         * @interface IOidcToken
                         * @property {string|null} [serviceAccountEmail] OidcToken serviceAccountEmail
                         * @property {string|null} [audience] OidcToken audience
                         */
    
                        /**
                         * Constructs a new OidcToken.
                         * @memberof google.pubsub.v1.PushConfig
                         * @classdesc Represents an OidcToken.
                         * @implements IOidcToken
                         * @constructor
                         * @param {google.pubsub.v1.PushConfig.IOidcToken=} [properties] Properties to set
                         */
                        function OidcToken(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * OidcToken serviceAccountEmail.
                         * @member {string} serviceAccountEmail
                         * @memberof google.pubsub.v1.PushConfig.OidcToken
                         * @instance
                         */
                        OidcToken.prototype.serviceAccountEmail = "";
    
                        /**
                         * OidcToken audience.
                         * @member {string} audience
                         * @memberof google.pubsub.v1.PushConfig.OidcToken
                         * @instance
                         */
                        OidcToken.prototype.audience = "";
    
                        /**
                         * Creates a new OidcToken instance using the specified properties.
                         * @function create
                         * @memberof google.pubsub.v1.PushConfig.OidcToken
                         * @static
                         * @param {google.pubsub.v1.PushConfig.IOidcToken=} [properties] Properties to set
                         * @returns {google.pubsub.v1.PushConfig.OidcToken} OidcToken instance
                         */
                        OidcToken.create = function create(properties) {
                            return new OidcToken(properties);
                        };
    
                        /**
                         * Encodes the specified OidcToken message. Does not implicitly {@link google.pubsub.v1.PushConfig.OidcToken.verify|verify} messages.
                         * @function encode
                         * @memberof google.pubsub.v1.PushConfig.OidcToken
                         * @static
                         * @param {google.pubsub.v1.PushConfig.IOidcToken} message OidcToken message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        OidcToken.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.serviceAccountEmail != null && Object.hasOwnProperty.call(message, "serviceAccountEmail"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.serviceAccountEmail);
                            if (message.audience != null && Object.hasOwnProperty.call(message, "audience"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.audience);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified OidcToken message, length delimited. Does not implicitly {@link google.pubsub.v1.PushConfig.OidcToken.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.pubsub.v1.PushConfig.OidcToken
                         * @static
                         * @param {google.pubsub.v1.PushConfig.IOidcToken} message OidcToken message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        OidcToken.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an OidcToken message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.pubsub.v1.PushConfig.OidcToken
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.pubsub.v1.PushConfig.OidcToken} OidcToken
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        OidcToken.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.PushConfig.OidcToken();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.serviceAccountEmail = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.audience = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an OidcToken message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.pubsub.v1.PushConfig.OidcToken
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.pubsub.v1.PushConfig.OidcToken} OidcToken
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        OidcToken.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an OidcToken message.
                         * @function verify
                         * @memberof google.pubsub.v1.PushConfig.OidcToken
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        OidcToken.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.serviceAccountEmail != null && message.hasOwnProperty("serviceAccountEmail"))
                                if (!$util.isString(message.serviceAccountEmail))
                                    return "serviceAccountEmail: string expected";
                            if (message.audience != null && message.hasOwnProperty("audience"))
                                if (!$util.isString(message.audience))
                                    return "audience: string expected";
                            return null;
                        };
    
                        /**
                         * Creates an OidcToken message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.pubsub.v1.PushConfig.OidcToken
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.pubsub.v1.PushConfig.OidcToken} OidcToken
                         */
                        OidcToken.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.pubsub.v1.PushConfig.OidcToken)
                                return object;
                            var message = new $root.google.pubsub.v1.PushConfig.OidcToken();
                            if (object.serviceAccountEmail != null)
                                message.serviceAccountEmail = String(object.serviceAccountEmail);
                            if (object.audience != null)
                                message.audience = String(object.audience);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an OidcToken message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.pubsub.v1.PushConfig.OidcToken
                         * @static
                         * @param {google.pubsub.v1.PushConfig.OidcToken} message OidcToken
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        OidcToken.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.serviceAccountEmail = "";
                                object.audience = "";
                            }
                            if (message.serviceAccountEmail != null && message.hasOwnProperty("serviceAccountEmail"))
                                object.serviceAccountEmail = message.serviceAccountEmail;
                            if (message.audience != null && message.hasOwnProperty("audience"))
                                object.audience = message.audience;
                            return object;
                        };
    
                        /**
                         * Converts this OidcToken to JSON.
                         * @function toJSON
                         * @memberof google.pubsub.v1.PushConfig.OidcToken
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        OidcToken.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for OidcToken
                         * @function getTypeUrl
                         * @memberof google.pubsub.v1.PushConfig.OidcToken
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        OidcToken.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.pubsub.v1.PushConfig.OidcToken";
                        };
    
                        return OidcToken;
                    })();
    
                    PushConfig.PubsubWrapper = (function() {
    
                        /**
                         * Properties of a PubsubWrapper.
                         * @memberof google.pubsub.v1.PushConfig
                         * @interface IPubsubWrapper
                         */
    
                        /**
                         * Constructs a new PubsubWrapper.
                         * @memberof google.pubsub.v1.PushConfig
                         * @classdesc Represents a PubsubWrapper.
                         * @implements IPubsubWrapper
                         * @constructor
                         * @param {google.pubsub.v1.PushConfig.IPubsubWrapper=} [properties] Properties to set
                         */
                        function PubsubWrapper(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Creates a new PubsubWrapper instance using the specified properties.
                         * @function create
                         * @memberof google.pubsub.v1.PushConfig.PubsubWrapper
                         * @static
                         * @param {google.pubsub.v1.PushConfig.IPubsubWrapper=} [properties] Properties to set
                         * @returns {google.pubsub.v1.PushConfig.PubsubWrapper} PubsubWrapper instance
                         */
                        PubsubWrapper.create = function create(properties) {
                            return new PubsubWrapper(properties);
                        };
    
                        /**
                         * Encodes the specified PubsubWrapper message. Does not implicitly {@link google.pubsub.v1.PushConfig.PubsubWrapper.verify|verify} messages.
                         * @function encode
                         * @memberof google.pubsub.v1.PushConfig.PubsubWrapper
                         * @static
                         * @param {google.pubsub.v1.PushConfig.IPubsubWrapper} message PubsubWrapper message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        PubsubWrapper.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified PubsubWrapper message, length delimited. Does not implicitly {@link google.pubsub.v1.PushConfig.PubsubWrapper.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.pubsub.v1.PushConfig.PubsubWrapper
                         * @static
                         * @param {google.pubsub.v1.PushConfig.IPubsubWrapper} message PubsubWrapper message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        PubsubWrapper.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a PubsubWrapper message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.pubsub.v1.PushConfig.PubsubWrapper
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.pubsub.v1.PushConfig.PubsubWrapper} PubsubWrapper
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        PubsubWrapper.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.PushConfig.PubsubWrapper();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a PubsubWrapper message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.pubsub.v1.PushConfig.PubsubWrapper
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.pubsub.v1.PushConfig.PubsubWrapper} PubsubWrapper
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        PubsubWrapper.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a PubsubWrapper message.
                         * @function verify
                         * @memberof google.pubsub.v1.PushConfig.PubsubWrapper
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        PubsubWrapper.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            return null;
                        };
    
                        /**
                         * Creates a PubsubWrapper message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.pubsub.v1.PushConfig.PubsubWrapper
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.pubsub.v1.PushConfig.PubsubWrapper} PubsubWrapper
                         */
                        PubsubWrapper.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.pubsub.v1.PushConfig.PubsubWrapper)
                                return object;
                            return new $root.google.pubsub.v1.PushConfig.PubsubWrapper();
                        };
    
                        /**
                         * Creates a plain object from a PubsubWrapper message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.pubsub.v1.PushConfig.PubsubWrapper
                         * @static
                         * @param {google.pubsub.v1.PushConfig.PubsubWrapper} message PubsubWrapper
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        PubsubWrapper.toObject = function toObject() {
                            return {};
                        };
    
                        /**
                         * Converts this PubsubWrapper to JSON.
                         * @function toJSON
                         * @memberof google.pubsub.v1.PushConfig.PubsubWrapper
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        PubsubWrapper.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for PubsubWrapper
                         * @function getTypeUrl
                         * @memberof google.pubsub.v1.PushConfig.PubsubWrapper
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        PubsubWrapper.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.pubsub.v1.PushConfig.PubsubWrapper";
                        };
    
                        return PubsubWrapper;
                    })();
    
                    PushConfig.NoWrapper = (function() {
    
                        /**
                         * Properties of a NoWrapper.
                         * @memberof google.pubsub.v1.PushConfig
                         * @interface INoWrapper
                         * @property {boolean|null} [writeMetadata] NoWrapper writeMetadata
                         */
    
                        /**
                         * Constructs a new NoWrapper.
                         * @memberof google.pubsub.v1.PushConfig
                         * @classdesc Represents a NoWrapper.
                         * @implements INoWrapper
                         * @constructor
                         * @param {google.pubsub.v1.PushConfig.INoWrapper=} [properties] Properties to set
                         */
                        function NoWrapper(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * NoWrapper writeMetadata.
                         * @member {boolean} writeMetadata
                         * @memberof google.pubsub.v1.PushConfig.NoWrapper
                         * @instance
                         */
                        NoWrapper.prototype.writeMetadata = false;
    
                        /**
                         * Creates a new NoWrapper instance using the specified properties.
                         * @function create
                         * @memberof google.pubsub.v1.PushConfig.NoWrapper
                         * @static
                         * @param {google.pubsub.v1.PushConfig.INoWrapper=} [properties] Properties to set
                         * @returns {google.pubsub.v1.PushConfig.NoWrapper} NoWrapper instance
                         */
                        NoWrapper.create = function create(properties) {
                            return new NoWrapper(properties);
                        };
    
                        /**
                         * Encodes the specified NoWrapper message. Does not implicitly {@link google.pubsub.v1.PushConfig.NoWrapper.verify|verify} messages.
                         * @function encode
                         * @memberof google.pubsub.v1.PushConfig.NoWrapper
                         * @static
                         * @param {google.pubsub.v1.PushConfig.INoWrapper} message NoWrapper message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        NoWrapper.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.writeMetadata != null && Object.hasOwnProperty.call(message, "writeMetadata"))
                                writer.uint32(/* id 1, wireType 0 =*/8).bool(message.writeMetadata);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified NoWrapper message, length delimited. Does not implicitly {@link google.pubsub.v1.PushConfig.NoWrapper.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.pubsub.v1.PushConfig.NoWrapper
                         * @static
                         * @param {google.pubsub.v1.PushConfig.INoWrapper} message NoWrapper message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        NoWrapper.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a NoWrapper message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.pubsub.v1.PushConfig.NoWrapper
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.pubsub.v1.PushConfig.NoWrapper} NoWrapper
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        NoWrapper.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.PushConfig.NoWrapper();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.writeMetadata = reader.bool();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a NoWrapper message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.pubsub.v1.PushConfig.NoWrapper
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.pubsub.v1.PushConfig.NoWrapper} NoWrapper
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        NoWrapper.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a NoWrapper message.
                         * @function verify
                         * @memberof google.pubsub.v1.PushConfig.NoWrapper
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        NoWrapper.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.writeMetadata != null && message.hasOwnProperty("writeMetadata"))
                                if (typeof message.writeMetadata !== "boolean")
                                    return "writeMetadata: boolean expected";
                            return null;
                        };
    
                        /**
                         * Creates a NoWrapper message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.pubsub.v1.PushConfig.NoWrapper
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.pubsub.v1.PushConfig.NoWrapper} NoWrapper
                         */
                        NoWrapper.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.pubsub.v1.PushConfig.NoWrapper)
                                return object;
                            var message = new $root.google.pubsub.v1.PushConfig.NoWrapper();
                            if (object.writeMetadata != null)
                                message.writeMetadata = Boolean(object.writeMetadata);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a NoWrapper message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.pubsub.v1.PushConfig.NoWrapper
                         * @static
                         * @param {google.pubsub.v1.PushConfig.NoWrapper} message NoWrapper
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        NoWrapper.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.writeMetadata = false;
                            if (message.writeMetadata != null && message.hasOwnProperty("writeMetadata"))
                                object.writeMetadata = message.writeMetadata;
                            return object;
                        };
    
                        /**
                         * Converts this NoWrapper to JSON.
                         * @function toJSON
                         * @memberof google.pubsub.v1.PushConfig.NoWrapper
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        NoWrapper.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for NoWrapper
                         * @function getTypeUrl
                         * @memberof google.pubsub.v1.PushConfig.NoWrapper
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        NoWrapper.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.pubsub.v1.PushConfig.NoWrapper";
                        };
    
                        return NoWrapper;
                    })();
    
                    return PushConfig;
                })();
    
                v1.BigQueryConfig = (function() {
    
                    /**
                     * Properties of a BigQueryConfig.
                     * @memberof google.pubsub.v1
                     * @interface IBigQueryConfig
                     * @property {string|null} [table] BigQueryConfig table
                     * @property {boolean|null} [useTopicSchema] BigQueryConfig useTopicSchema
                     * @property {boolean|null} [writeMetadata] BigQueryConfig writeMetadata
                     * @property {boolean|null} [dropUnknownFields] BigQueryConfig dropUnknownFields
                     * @property {google.pubsub.v1.BigQueryConfig.State|null} [state] BigQueryConfig state
                     * @property {boolean|null} [useTableSchema] BigQueryConfig useTableSchema
                     * @property {string|null} [serviceAccountEmail] BigQueryConfig serviceAccountEmail
                     */
    
                    /**
                     * Constructs a new BigQueryConfig.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a BigQueryConfig.
                     * @implements IBigQueryConfig
                     * @constructor
                     * @param {google.pubsub.v1.IBigQueryConfig=} [properties] Properties to set
                     */
                    function BigQueryConfig(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * BigQueryConfig table.
                     * @member {string} table
                     * @memberof google.pubsub.v1.BigQueryConfig
                     * @instance
                     */
                    BigQueryConfig.prototype.table = "";
    
                    /**
                     * BigQueryConfig useTopicSchema.
                     * @member {boolean} useTopicSchema
                     * @memberof google.pubsub.v1.BigQueryConfig
                     * @instance
                     */
                    BigQueryConfig.prototype.useTopicSchema = false;
    
                    /**
                     * BigQueryConfig writeMetadata.
                     * @member {boolean} writeMetadata
                     * @memberof google.pubsub.v1.BigQueryConfig
                     * @instance
                     */
                    BigQueryConfig.prototype.writeMetadata = false;
    
                    /**
                     * BigQueryConfig dropUnknownFields.
                     * @member {boolean} dropUnknownFields
                     * @memberof google.pubsub.v1.BigQueryConfig
                     * @instance
                     */
                    BigQueryConfig.prototype.dropUnknownFields = false;
    
                    /**
                     * BigQueryConfig state.
                     * @member {google.pubsub.v1.BigQueryConfig.State} state
                     * @memberof google.pubsub.v1.BigQueryConfig
                     * @instance
                     */
                    BigQueryConfig.prototype.state = 0;
    
                    /**
                     * BigQueryConfig useTableSchema.
                     * @member {boolean} useTableSchema
                     * @memberof google.pubsub.v1.BigQueryConfig
                     * @instance
                     */
                    BigQueryConfig.prototype.useTableSchema = false;
    
                    /**
                     * BigQueryConfig serviceAccountEmail.
                     * @member {string} serviceAccountEmail
                     * @memberof google.pubsub.v1.BigQueryConfig
                     * @instance
                     */
                    BigQueryConfig.prototype.serviceAccountEmail = "";
    
                    /**
                     * Creates a new BigQueryConfig instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.BigQueryConfig
                     * @static
                     * @param {google.pubsub.v1.IBigQueryConfig=} [properties] Properties to set
                     * @returns {google.pubsub.v1.BigQueryConfig} BigQueryConfig instance
                     */
                    BigQueryConfig.create = function create(properties) {
                        return new BigQueryConfig(properties);
                    };
    
                    /**
                     * Encodes the specified BigQueryConfig message. Does not implicitly {@link google.pubsub.v1.BigQueryConfig.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.BigQueryConfig
                     * @static
                     * @param {google.pubsub.v1.IBigQueryConfig} message BigQueryConfig message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    BigQueryConfig.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.table != null && Object.hasOwnProperty.call(message, "table"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.table);
                        if (message.useTopicSchema != null && Object.hasOwnProperty.call(message, "useTopicSchema"))
                            writer.uint32(/* id 2, wireType 0 =*/16).bool(message.useTopicSchema);
                        if (message.writeMetadata != null && Object.hasOwnProperty.call(message, "writeMetadata"))
                            writer.uint32(/* id 3, wireType 0 =*/24).bool(message.writeMetadata);
                        if (message.dropUnknownFields != null && Object.hasOwnProperty.call(message, "dropUnknownFields"))
                            writer.uint32(/* id 4, wireType 0 =*/32).bool(message.dropUnknownFields);
                        if (message.state != null && Object.hasOwnProperty.call(message, "state"))
                            writer.uint32(/* id 5, wireType 0 =*/40).int32(message.state);
                        if (message.useTableSchema != null && Object.hasOwnProperty.call(message, "useTableSchema"))
                            writer.uint32(/* id 6, wireType 0 =*/48).bool(message.useTableSchema);
                        if (message.serviceAccountEmail != null && Object.hasOwnProperty.call(message, "serviceAccountEmail"))
                            writer.uint32(/* id 7, wireType 2 =*/58).string(message.serviceAccountEmail);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified BigQueryConfig message, length delimited. Does not implicitly {@link google.pubsub.v1.BigQueryConfig.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.BigQueryConfig
                     * @static
                     * @param {google.pubsub.v1.IBigQueryConfig} message BigQueryConfig message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    BigQueryConfig.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a BigQueryConfig message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.BigQueryConfig
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.BigQueryConfig} BigQueryConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    BigQueryConfig.decode = function decode(reader, length, error) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.BigQueryConfig();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            if (tag === error)
                                break;
                            switch (tag >>> 3) {
                            case 1: {
                                    message.table = reader.string();
                                    break;
                                }
                            case 2: {
                                    message.useTopicSchema = reader.bool();
                                    break;
                                }
                            case 3: {
                                    message.writeMetadata = reader.bool();
                                    break;
                                }
                            case 4: {
                                    message.dropUnknownFields = reader.bool();
                                    break;
                                }
                            case 5: {
                                    message.state = reader.int32();
                                    break;
                                }
                            case 6: {
                                    message.useTableSchema = reader.bool();
                                    break;
                                }
                            case 7: {
                                    message.serviceAccountEmail = reader.string();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a BigQueryConfig message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.BigQueryConfig
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.BigQueryConfig} BigQueryConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    BigQueryConfig.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a BigQueryConfig message.
                     * @function verify
                     * @memberof google.pubsub.v1.BigQueryConfig
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    BigQueryConfig.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.table != null && message.hasOwnProperty("table"))
                            if (!$util.isString(message.table))
                                return "table: string expected";
                        if (message.useTopicSchema != null && message.hasOwnProperty("useTopicSchema"))
                            if (typeof message.useTopicSchema !== "boolean")
                                return "useTopicSchema: boolean expected";
                        if (message.writeMetadata != null && message.hasOwnProperty("writeMetadata"))
                            if (typeof message.writeMetadata !== "boolean")
                                return "writeMetadata: boolean expected";
                        if (message.dropUnknownFields != null && message.hasOwnProperty("dropUnknownFields"))
                            if (typeof message.dropUnknownFields !== "boolean")
                                return "dropUnknownFields: boolean expected";
                        if (message.state != null && message.hasOwnProperty("state"))
                            switch (message.state) {
                            default:
                                return "state: enum value expected";
                            case 0:
                            case 1:
                            case 2:
                            case 3:
                            case 4:
                            case 5:
                                break;
                            }
                        if (message.useTableSchema != null && message.hasOwnProperty("useTableSchema"))
                            if (typeof message.useTableSchema !== "boolean")
                                return "useTableSchema: boolean expected";
                        if (message.serviceAccountEmail != null && message.hasOwnProperty("serviceAccountEmail"))
                            if (!$util.isString(message.serviceAccountEmail))
                                return "serviceAccountEmail: string expected";
                        return null;
                    };
    
                    /**
                     * Creates a BigQueryConfig message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.BigQueryConfig
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.BigQueryConfig} BigQueryConfig
                     */
                    BigQueryConfig.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.BigQueryConfig)
                            return object;
                        var message = new $root.google.pubsub.v1.BigQueryConfig();
                        if (object.table != null)
                            message.table = String(object.table);
                        if (object.useTopicSchema != null)
                            message.useTopicSchema = Boolean(object.useTopicSchema);
                        if (object.writeMetadata != null)
                            message.writeMetadata = Boolean(object.writeMetadata);
                        if (object.dropUnknownFields != null)
                            message.dropUnknownFields = Boolean(object.dropUnknownFields);
                        switch (object.state) {
                        default:
                            if (typeof object.state === "number") {
                                message.state = object.state;
                                break;
                            }
                            break;
                        case "STATE_UNSPECIFIED":
                        case 0:
                            message.state = 0;
                            break;
                        case "ACTIVE":
                        case 1:
                            message.state = 1;
                            break;
                        case "PERMISSION_DENIED":
                        case 2:
                            message.state = 2;
                            break;
                        case "NOT_FOUND":
                        case 3:
                            message.state = 3;
                            break;
                        case "SCHEMA_MISMATCH":
                        case 4:
                            message.state = 4;
                            break;
                        case "IN_TRANSIT_LOCATION_RESTRICTION":
                        case 5:
                            message.state = 5;
                            break;
                        }
                        if (object.useTableSchema != null)
                            message.useTableSchema = Boolean(object.useTableSchema);
                        if (object.serviceAccountEmail != null)
                            message.serviceAccountEmail = String(object.serviceAccountEmail);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a BigQueryConfig message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.BigQueryConfig
                     * @static
                     * @param {google.pubsub.v1.BigQueryConfig} message BigQueryConfig
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    BigQueryConfig.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.table = "";
                            object.useTopicSchema = false;
                            object.writeMetadata = false;
                            object.dropUnknownFields = false;
                            object.state = options.enums === String ? "STATE_UNSPECIFIED" : 0;
                            object.useTableSchema = false;
                            object.serviceAccountEmail = "";
                        }
                        if (message.table != null && message.hasOwnProperty("table"))
                            object.table = message.table;
                        if (message.useTopicSchema != null && message.hasOwnProperty("useTopicSchema"))
                            object.useTopicSchema = message.useTopicSchema;
                        if (message.writeMetadata != null && message.hasOwnProperty("writeMetadata"))
                            object.writeMetadata = message.writeMetadata;
                        if (message.dropUnknownFields != null && message.hasOwnProperty("dropUnknownFields"))
                            object.dropUnknownFields = message.dropUnknownFields;
                        if (message.state != null && message.hasOwnProperty("state"))
                            object.state = options.enums === String ? $root.google.pubsub.v1.BigQueryConfig.State[message.state] === undefined ? message.state : $root.google.pubsub.v1.BigQueryConfig.State[message.state] : message.state;
                        if (message.useTableSchema != null && message.hasOwnProperty("useTableSchema"))
                            object.useTableSchema = message.useTableSchema;
                        if (message.serviceAccountEmail != null && message.hasOwnProperty("serviceAccountEmail"))
                            object.serviceAccountEmail = message.serviceAccountEmail;
                        return object;
                    };
    
                    /**
                     * Converts this BigQueryConfig to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.BigQueryConfig
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    BigQueryConfig.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for BigQueryConfig
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.BigQueryConfig
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    BigQueryConfig.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.BigQueryConfig";
                    };
    
                    /**
                     * State enum.
                     * @name google.pubsub.v1.BigQueryConfig.State
                     * @enum {number}
                     * @property {number} STATE_UNSPECIFIED=0 STATE_UNSPECIFIED value
                     * @property {number} ACTIVE=1 ACTIVE value
                     * @property {number} PERMISSION_DENIED=2 PERMISSION_DENIED value
                     * @property {number} NOT_FOUND=3 NOT_FOUND value
                     * @property {number} SCHEMA_MISMATCH=4 SCHEMA_MISMATCH value
                     * @property {number} IN_TRANSIT_LOCATION_RESTRICTION=5 IN_TRANSIT_LOCATION_RESTRICTION value
                     */
                    BigQueryConfig.State = (function() {
                        var valuesById = {}, values = Object.create(valuesById);
                        values[valuesById[0] = "STATE_UNSPECIFIED"] = 0;
                        values[valuesById[1] = "ACTIVE"] = 1;
                        values[valuesById[2] = "PERMISSION_DENIED"] = 2;
                        values[valuesById[3] = "NOT_FOUND"] = 3;
                        values[valuesById[4] = "SCHEMA_MISMATCH"] = 4;
                        values[valuesById[5] = "IN_TRANSIT_LOCATION_RESTRICTION"] = 5;
                        return values;
                    })();
    
                    return BigQueryConfig;
                })();
    
                v1.CloudStorageConfig = (function() {
    
                    /**
                     * Properties of a CloudStorageConfig.
                     * @memberof google.pubsub.v1
                     * @interface ICloudStorageConfig
                     * @property {string|null} [bucket] CloudStorageConfig bucket
                     * @property {string|null} [filenamePrefix] CloudStorageConfig filenamePrefix
                     * @property {string|null} [filenameSuffix] CloudStorageConfig filenameSuffix
                     * @property {string|null} [filenameDatetimeFormat] CloudStorageConfig filenameDatetimeFormat
                     * @property {google.pubsub.v1.CloudStorageConfig.ITextConfig|null} [textConfig] CloudStorageConfig textConfig
                     * @property {google.pubsub.v1.CloudStorageConfig.IAvroConfig|null} [avroConfig] CloudStorageConfig avroConfig
                     * @property {google.protobuf.IDuration|null} [maxDuration] CloudStorageConfig maxDuration
                     * @property {number|Long|null} [maxBytes] CloudStorageConfig maxBytes
                     * @property {number|Long|null} [maxMessages] CloudStorageConfig maxMessages
                     * @property {google.pubsub.v1.CloudStorageConfig.State|null} [state] CloudStorageConfig state
                     * @property {string|null} [serviceAccountEmail] CloudStorageConfig serviceAccountEmail
                     */
    
                    /**
                     * Constructs a new CloudStorageConfig.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a CloudStorageConfig.
                     * @implements ICloudStorageConfig
                     * @constructor
                     * @param {google.pubsub.v1.ICloudStorageConfig=} [properties] Properties to set
                     */
                    function CloudStorageConfig(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * CloudStorageConfig bucket.
                     * @member {string} bucket
                     * @memberof google.pubsub.v1.CloudStorageConfig
                     * @instance
                     */
                    CloudStorageConfig.prototype.bucket = "";
    
                    /**
                     * CloudStorageConfig filenamePrefix.
                     * @member {string} filenamePrefix
                     * @memberof google.pubsub.v1.CloudStorageConfig
                     * @instance
                     */
                    CloudStorageConfig.prototype.filenamePrefix = "";
    
                    /**
                     * CloudStorageConfig filenameSuffix.
                     * @member {string} filenameSuffix
                     * @memberof google.pubsub.v1.CloudStorageConfig
                     * @instance
                     */
                    CloudStorageConfig.prototype.filenameSuffix = "";
    
                    /**
                     * CloudStorageConfig filenameDatetimeFormat.
                     * @member {string} filenameDatetimeFormat
                     * @memberof google.pubsub.v1.CloudStorageConfig
                     * @instance
                     */
                    CloudStorageConfig.prototype.filenameDatetimeFormat = "";
    
                    /**
                     * CloudStorageConfig textConfig.
                     * @member {google.pubsub.v1.CloudStorageConfig.ITextConfig|null|undefined} textConfig
                     * @memberof google.pubsub.v1.CloudStorageConfig
                     * @instance
                     */
                    CloudStorageConfig.prototype.textConfig = null;
    
                    /**
                     * CloudStorageConfig avroConfig.
                     * @member {google.pubsub.v1.CloudStorageConfig.IAvroConfig|null|undefined} avroConfig
                     * @memberof google.pubsub.v1.CloudStorageConfig
                     * @instance
                     */
                    CloudStorageConfig.prototype.avroConfig = null;
    
                    /**
                     * CloudStorageConfig maxDuration.
                     * @member {google.protobuf.IDuration|null|undefined} maxDuration
                     * @memberof google.pubsub.v1.CloudStorageConfig
                     * @instance
                     */
                    CloudStorageConfig.prototype.maxDuration = null;
    
                    /**
                     * CloudStorageConfig maxBytes.
                     * @member {number|Long} maxBytes
                     * @memberof google.pubsub.v1.CloudStorageConfig
                     * @instance
                     */
                    CloudStorageConfig.prototype.maxBytes = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
    
                    /**
                     * CloudStorageConfig maxMessages.
                     * @member {number|Long} maxMessages
                     * @memberof google.pubsub.v1.CloudStorageConfig
                     * @instance
                     */
                    CloudStorageConfig.prototype.maxMessages = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
    
                    /**
                     * CloudStorageConfig state.
                     * @member {google.pubsub.v1.CloudStorageConfig.State} state
                     * @memberof google.pubsub.v1.CloudStorageConfig
                     * @instance
                     */
                    CloudStorageConfig.prototype.state = 0;
    
                    /**
                     * CloudStorageConfig serviceAccountEmail.
                     * @member {string} serviceAccountEmail
                     * @memberof google.pubsub.v1.CloudStorageConfig
                     * @instance
                     */
                    CloudStorageConfig.prototype.serviceAccountEmail = "";
    
                    // OneOf field names bound to virtual getters and setters
                    var $oneOfFields;
    
                    /**
                     * CloudStorageConfig outputFormat.
                     * @member {"textConfig"|"avroConfig"|undefined} outputFormat
                     * @memberof google.pubsub.v1.CloudStorageConfig
                     * @instance
                     */
                    Object.defineProperty(CloudStorageConfig.prototype, "outputFormat", {
                        get: $util.oneOfGetter($oneOfFields = ["textConfig", "avroConfig"]),
                        set: $util.oneOfSetter($oneOfFields)
                    });
    
                    /**
                     * Creates a new CloudStorageConfig instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.CloudStorageConfig
                     * @static
                     * @param {google.pubsub.v1.ICloudStorageConfig=} [properties] Properties to set
                     * @returns {google.pubsub.v1.CloudStorageConfig} CloudStorageConfig instance
                     */
                    CloudStorageConfig.create = function create(properties) {
                        return new CloudStorageConfig(properties);
                    };
    
                    /**
                     * Encodes the specified CloudStorageConfig message. Does not implicitly {@link google.pubsub.v1.CloudStorageConfig.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.CloudStorageConfig
                     * @static
                     * @param {google.pubsub.v1.ICloudStorageConfig} message CloudStorageConfig message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    CloudStorageConfig.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.bucket != null && Object.hasOwnProperty.call(message, "bucket"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.bucket);
                        if (message.filenamePrefix != null && Object.hasOwnProperty.call(message, "filenamePrefix"))
                            writer.uint32(/* id 2, wireType 2 =*/18).string(message.filenamePrefix);
                        if (message.filenameSuffix != null && Object.hasOwnProperty.call(message, "filenameSuffix"))
                            writer.uint32(/* id 3, wireType 2 =*/26).string(message.filenameSuffix);
                        if (message.textConfig != null && Object.hasOwnProperty.call(message, "textConfig"))
                            $root.google.pubsub.v1.CloudStorageConfig.TextConfig.encode(message.textConfig, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                        if (message.avroConfig != null && Object.hasOwnProperty.call(message, "avroConfig"))
                            $root.google.pubsub.v1.CloudStorageConfig.AvroConfig.encode(message.avroConfig, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                        if (message.maxDuration != null && Object.hasOwnProperty.call(message, "maxDuration"))
                            $root.google.protobuf.Duration.encode(message.maxDuration, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                        if (message.maxBytes != null && Object.hasOwnProperty.call(message, "maxBytes"))
                            writer.uint32(/* id 7, wireType 0 =*/56).int64(message.maxBytes);
                        if (message.maxMessages != null && Object.hasOwnProperty.call(message, "maxMessages"))
                            writer.uint32(/* id 8, wireType 0 =*/64).int64(message.maxMessages);
                        if (message.state != null && Object.hasOwnProperty.call(message, "state"))
                            writer.uint32(/* id 9, wireType 0 =*/72).int32(message.state);
                        if (message.filenameDatetimeFormat != null && Object.hasOwnProperty.call(message, "filenameDatetimeFormat"))
                            writer.uint32(/* id 10, wireType 2 =*/82).string(message.filenameDatetimeFormat);
                        if (message.serviceAccountEmail != null && Object.hasOwnProperty.call(message, "serviceAccountEmail"))
                            writer.uint32(/* id 11, wireType 2 =*/90).string(message.serviceAccountEmail);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified CloudStorageConfig message, length delimited. Does not implicitly {@link google.pubsub.v1.CloudStorageConfig.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.CloudStorageConfig
                     * @static
                     * @param {google.pubsub.v1.ICloudStorageConfig} message CloudStorageConfig message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    CloudStorageConfig.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a CloudStorageConfig message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.CloudStorageConfig
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.CloudStorageConfig} CloudStorageConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    CloudStorageConfig.decode = function decode(reader, length, error) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.CloudStorageConfig();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            if (tag === error)
                                break;
                            switch (tag >>> 3) {
                            case 1: {
                                    message.bucket = reader.string();
                                    break;
                                }
                            case 2: {
                                    message.filenamePrefix = reader.string();
                                    break;
                                }
                            case 3: {
                                    message.filenameSuffix = reader.string();
                                    break;
                                }
                            case 10: {
                                    message.filenameDatetimeFormat = reader.string();
                                    break;
                                }
                            case 4: {
                                    message.textConfig = $root.google.pubsub.v1.CloudStorageConfig.TextConfig.decode(reader, reader.uint32());
                                    break;
                                }
                            case 5: {
                                    message.avroConfig = $root.google.pubsub.v1.CloudStorageConfig.AvroConfig.decode(reader, reader.uint32());
                                    break;
                                }
                            case 6: {
                                    message.maxDuration = $root.google.protobuf.Duration.decode(reader, reader.uint32());
                                    break;
                                }
                            case 7: {
                                    message.maxBytes = reader.int64();
                                    break;
                                }
                            case 8: {
                                    message.maxMessages = reader.int64();
                                    break;
                                }
                            case 9: {
                                    message.state = reader.int32();
                                    break;
                                }
                            case 11: {
                                    message.serviceAccountEmail = reader.string();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a CloudStorageConfig message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.CloudStorageConfig
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.CloudStorageConfig} CloudStorageConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    CloudStorageConfig.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a CloudStorageConfig message.
                     * @function verify
                     * @memberof google.pubsub.v1.CloudStorageConfig
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    CloudStorageConfig.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        var properties = {};
                        if (message.bucket != null && message.hasOwnProperty("bucket"))
                            if (!$util.isString(message.bucket))
                                return "bucket: string expected";
                        if (message.filenamePrefix != null && message.hasOwnProperty("filenamePrefix"))
                            if (!$util.isString(message.filenamePrefix))
                                return "filenamePrefix: string expected";
                        if (message.filenameSuffix != null && message.hasOwnProperty("filenameSuffix"))
                            if (!$util.isString(message.filenameSuffix))
                                return "filenameSuffix: string expected";
                        if (message.filenameDatetimeFormat != null && message.hasOwnProperty("filenameDatetimeFormat"))
                            if (!$util.isString(message.filenameDatetimeFormat))
                                return "filenameDatetimeFormat: string expected";
                        if (message.textConfig != null && message.hasOwnProperty("textConfig")) {
                            properties.outputFormat = 1;
                            {
                                var error = $root.google.pubsub.v1.CloudStorageConfig.TextConfig.verify(message.textConfig);
                                if (error)
                                    return "textConfig." + error;
                            }
                        }
                        if (message.avroConfig != null && message.hasOwnProperty("avroConfig")) {
                            if (properties.outputFormat === 1)
                                return "outputFormat: multiple values";
                            properties.outputFormat = 1;
                            {
                                var error = $root.google.pubsub.v1.CloudStorageConfig.AvroConfig.verify(message.avroConfig);
                                if (error)
                                    return "avroConfig." + error;
                            }
                        }
                        if (message.maxDuration != null && message.hasOwnProperty("maxDuration")) {
                            var error = $root.google.protobuf.Duration.verify(message.maxDuration);
                            if (error)
                                return "maxDuration." + error;
                        }
                        if (message.maxBytes != null && message.hasOwnProperty("maxBytes"))
                            if (!$util.isInteger(message.maxBytes) && !(message.maxBytes && $util.isInteger(message.maxBytes.low) && $util.isInteger(message.maxBytes.high)))
                                return "maxBytes: integer|Long expected";
                        if (message.maxMessages != null && message.hasOwnProperty("maxMessages"))
                            if (!$util.isInteger(message.maxMessages) && !(message.maxMessages && $util.isInteger(message.maxMessages.low) && $util.isInteger(message.maxMessages.high)))
                                return "maxMessages: integer|Long expected";
                        if (message.state != null && message.hasOwnProperty("state"))
                            switch (message.state) {
                            default:
                                return "state: enum value expected";
                            case 0:
                            case 1:
                            case 2:
                            case 3:
                            case 4:
                            case 5:
                                break;
                            }
                        if (message.serviceAccountEmail != null && message.hasOwnProperty("serviceAccountEmail"))
                            if (!$util.isString(message.serviceAccountEmail))
                                return "serviceAccountEmail: string expected";
                        return null;
                    };
    
                    /**
                     * Creates a CloudStorageConfig message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.CloudStorageConfig
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.CloudStorageConfig} CloudStorageConfig
                     */
                    CloudStorageConfig.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.CloudStorageConfig)
                            return object;
                        var message = new $root.google.pubsub.v1.CloudStorageConfig();
                        if (object.bucket != null)
                            message.bucket = String(object.bucket);
                        if (object.filenamePrefix != null)
                            message.filenamePrefix = String(object.filenamePrefix);
                        if (object.filenameSuffix != null)
                            message.filenameSuffix = String(object.filenameSuffix);
                        if (object.filenameDatetimeFormat != null)
                            message.filenameDatetimeFormat = String(object.filenameDatetimeFormat);
                        if (object.textConfig != null) {
                            if (typeof object.textConfig !== "object")
                                throw TypeError(".google.pubsub.v1.CloudStorageConfig.textConfig: object expected");
                            message.textConfig = $root.google.pubsub.v1.CloudStorageConfig.TextConfig.fromObject(object.textConfig);
                        }
                        if (object.avroConfig != null) {
                            if (typeof object.avroConfig !== "object")
                                throw TypeError(".google.pubsub.v1.CloudStorageConfig.avroConfig: object expected");
                            message.avroConfig = $root.google.pubsub.v1.CloudStorageConfig.AvroConfig.fromObject(object.avroConfig);
                        }
                        if (object.maxDuration != null) {
                            if (typeof object.maxDuration !== "object")
                                throw TypeError(".google.pubsub.v1.CloudStorageConfig.maxDuration: object expected");
                            message.maxDuration = $root.google.protobuf.Duration.fromObject(object.maxDuration);
                        }
                        if (object.maxBytes != null)
                            if ($util.Long)
                                (message.maxBytes = $util.Long.fromValue(object.maxBytes)).unsigned = false;
                            else if (typeof object.maxBytes === "string")
                                message.maxBytes = parseInt(object.maxBytes, 10);
                            else if (typeof object.maxBytes === "number")
                                message.maxBytes = object.maxBytes;
                            else if (typeof object.maxBytes === "object")
                                message.maxBytes = new $util.LongBits(object.maxBytes.low >>> 0, object.maxBytes.high >>> 0).toNumber();
                        if (object.maxMessages != null)
                            if ($util.Long)
                                (message.maxMessages = $util.Long.fromValue(object.maxMessages)).unsigned = false;
                            else if (typeof object.maxMessages === "string")
                                message.maxMessages = parseInt(object.maxMessages, 10);
                            else if (typeof object.maxMessages === "number")
                                message.maxMessages = object.maxMessages;
                            else if (typeof object.maxMessages === "object")
                                message.maxMessages = new $util.LongBits(object.maxMessages.low >>> 0, object.maxMessages.high >>> 0).toNumber();
                        switch (object.state) {
                        default:
                            if (typeof object.state === "number") {
                                message.state = object.state;
                                break;
                            }
                            break;
                        case "STATE_UNSPECIFIED":
                        case 0:
                            message.state = 0;
                            break;
                        case "ACTIVE":
                        case 1:
                            message.state = 1;
                            break;
                        case "PERMISSION_DENIED":
                        case 2:
                            message.state = 2;
                            break;
                        case "NOT_FOUND":
                        case 3:
                            message.state = 3;
                            break;
                        case "IN_TRANSIT_LOCATION_RESTRICTION":
                        case 4:
                            message.state = 4;
                            break;
                        case "SCHEMA_MISMATCH":
                        case 5:
                            message.state = 5;
                            break;
                        }
                        if (object.serviceAccountEmail != null)
                            message.serviceAccountEmail = String(object.serviceAccountEmail);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a CloudStorageConfig message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.CloudStorageConfig
                     * @static
                     * @param {google.pubsub.v1.CloudStorageConfig} message CloudStorageConfig
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    CloudStorageConfig.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.bucket = "";
                            object.filenamePrefix = "";
                            object.filenameSuffix = "";
                            object.maxDuration = null;
                            if ($util.Long) {
                                var long = new $util.Long(0, 0, false);
                                object.maxBytes = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                            } else
                                object.maxBytes = options.longs === String ? "0" : 0;
                            if ($util.Long) {
                                var long = new $util.Long(0, 0, false);
                                object.maxMessages = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                            } else
                                object.maxMessages = options.longs === String ? "0" : 0;
                            object.state = options.enums === String ? "STATE_UNSPECIFIED" : 0;
                            object.filenameDatetimeFormat = "";
                            object.serviceAccountEmail = "";
                        }
                        if (message.bucket != null && message.hasOwnProperty("bucket"))
                            object.bucket = message.bucket;
                        if (message.filenamePrefix != null && message.hasOwnProperty("filenamePrefix"))
                            object.filenamePrefix = message.filenamePrefix;
                        if (message.filenameSuffix != null && message.hasOwnProperty("filenameSuffix"))
                            object.filenameSuffix = message.filenameSuffix;
                        if (message.textConfig != null && message.hasOwnProperty("textConfig")) {
                            object.textConfig = $root.google.pubsub.v1.CloudStorageConfig.TextConfig.toObject(message.textConfig, options);
                            if (options.oneofs)
                                object.outputFormat = "textConfig";
                        }
                        if (message.avroConfig != null && message.hasOwnProperty("avroConfig")) {
                            object.avroConfig = $root.google.pubsub.v1.CloudStorageConfig.AvroConfig.toObject(message.avroConfig, options);
                            if (options.oneofs)
                                object.outputFormat = "avroConfig";
                        }
                        if (message.maxDuration != null && message.hasOwnProperty("maxDuration"))
                            object.maxDuration = $root.google.protobuf.Duration.toObject(message.maxDuration, options);
                        if (message.maxBytes != null && message.hasOwnProperty("maxBytes"))
                            if (typeof message.maxBytes === "number")
                                object.maxBytes = options.longs === String ? String(message.maxBytes) : message.maxBytes;
                            else
                                object.maxBytes = options.longs === String ? $util.Long.prototype.toString.call(message.maxBytes) : options.longs === Number ? new $util.LongBits(message.maxBytes.low >>> 0, message.maxBytes.high >>> 0).toNumber() : message.maxBytes;
                        if (message.maxMessages != null && message.hasOwnProperty("maxMessages"))
                            if (typeof message.maxMessages === "number")
                                object.maxMessages = options.longs === String ? String(message.maxMessages) : message.maxMessages;
                            else
                                object.maxMessages = options.longs === String ? $util.Long.prototype.toString.call(message.maxMessages) : options.longs === Number ? new $util.LongBits(message.maxMessages.low >>> 0, message.maxMessages.high >>> 0).toNumber() : message.maxMessages;
                        if (message.state != null && message.hasOwnProperty("state"))
                            object.state = options.enums === String ? $root.google.pubsub.v1.CloudStorageConfig.State[message.state] === undefined ? message.state : $root.google.pubsub.v1.CloudStorageConfig.State[message.state] : message.state;
                        if (message.filenameDatetimeFormat != null && message.hasOwnProperty("filenameDatetimeFormat"))
                            object.filenameDatetimeFormat = message.filenameDatetimeFormat;
                        if (message.serviceAccountEmail != null && message.hasOwnProperty("serviceAccountEmail"))
                            object.serviceAccountEmail = message.serviceAccountEmail;
                        return object;
                    };
    
                    /**
                     * Converts this CloudStorageConfig to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.CloudStorageConfig
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    CloudStorageConfig.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for CloudStorageConfig
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.CloudStorageConfig
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    CloudStorageConfig.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.CloudStorageConfig";
                    };
    
                    CloudStorageConfig.TextConfig = (function() {
    
                        /**
                         * Properties of a TextConfig.
                         * @memberof google.pubsub.v1.CloudStorageConfig
                         * @interface ITextConfig
                         */
    
                        /**
                         * Constructs a new TextConfig.
                         * @memberof google.pubsub.v1.CloudStorageConfig
                         * @classdesc Represents a TextConfig.
                         * @implements ITextConfig
                         * @constructor
                         * @param {google.pubsub.v1.CloudStorageConfig.ITextConfig=} [properties] Properties to set
                         */
                        function TextConfig(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Creates a new TextConfig instance using the specified properties.
                         * @function create
                         * @memberof google.pubsub.v1.CloudStorageConfig.TextConfig
                         * @static
                         * @param {google.pubsub.v1.CloudStorageConfig.ITextConfig=} [properties] Properties to set
                         * @returns {google.pubsub.v1.CloudStorageConfig.TextConfig} TextConfig instance
                         */
                        TextConfig.create = function create(properties) {
                            return new TextConfig(properties);
                        };
    
                        /**
                         * Encodes the specified TextConfig message. Does not implicitly {@link google.pubsub.v1.CloudStorageConfig.TextConfig.verify|verify} messages.
                         * @function encode
                         * @memberof google.pubsub.v1.CloudStorageConfig.TextConfig
                         * @static
                         * @param {google.pubsub.v1.CloudStorageConfig.ITextConfig} message TextConfig message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TextConfig.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified TextConfig message, length delimited. Does not implicitly {@link google.pubsub.v1.CloudStorageConfig.TextConfig.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.pubsub.v1.CloudStorageConfig.TextConfig
                         * @static
                         * @param {google.pubsub.v1.CloudStorageConfig.ITextConfig} message TextConfig message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TextConfig.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a TextConfig message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.pubsub.v1.CloudStorageConfig.TextConfig
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.pubsub.v1.CloudStorageConfig.TextConfig} TextConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TextConfig.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.CloudStorageConfig.TextConfig();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a TextConfig message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.pubsub.v1.CloudStorageConfig.TextConfig
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.pubsub.v1.CloudStorageConfig.TextConfig} TextConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TextConfig.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a TextConfig message.
                         * @function verify
                         * @memberof google.pubsub.v1.CloudStorageConfig.TextConfig
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        TextConfig.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            return null;
                        };
    
                        /**
                         * Creates a TextConfig message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.pubsub.v1.CloudStorageConfig.TextConfig
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.pubsub.v1.CloudStorageConfig.TextConfig} TextConfig
                         */
                        TextConfig.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.pubsub.v1.CloudStorageConfig.TextConfig)
                                return object;
                            return new $root.google.pubsub.v1.CloudStorageConfig.TextConfig();
                        };
    
                        /**
                         * Creates a plain object from a TextConfig message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.pubsub.v1.CloudStorageConfig.TextConfig
                         * @static
                         * @param {google.pubsub.v1.CloudStorageConfig.TextConfig} message TextConfig
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        TextConfig.toObject = function toObject() {
                            return {};
                        };
    
                        /**
                         * Converts this TextConfig to JSON.
                         * @function toJSON
                         * @memberof google.pubsub.v1.CloudStorageConfig.TextConfig
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        TextConfig.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for TextConfig
                         * @function getTypeUrl
                         * @memberof google.pubsub.v1.CloudStorageConfig.TextConfig
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        TextConfig.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.pubsub.v1.CloudStorageConfig.TextConfig";
                        };
    
                        return TextConfig;
                    })();
    
                    CloudStorageConfig.AvroConfig = (function() {
    
                        /**
                         * Properties of an AvroConfig.
                         * @memberof google.pubsub.v1.CloudStorageConfig
                         * @interface IAvroConfig
                         * @property {boolean|null} [writeMetadata] AvroConfig writeMetadata
                         * @property {boolean|null} [useTopicSchema] AvroConfig useTopicSchema
                         */
    
                        /**
                         * Constructs a new AvroConfig.
                         * @memberof google.pubsub.v1.CloudStorageConfig
                         * @classdesc Represents an AvroConfig.
                         * @implements IAvroConfig
                         * @constructor
                         * @param {google.pubsub.v1.CloudStorageConfig.IAvroConfig=} [properties] Properties to set
                         */
                        function AvroConfig(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * AvroConfig writeMetadata.
                         * @member {boolean} writeMetadata
                         * @memberof google.pubsub.v1.CloudStorageConfig.AvroConfig
                         * @instance
                         */
                        AvroConfig.prototype.writeMetadata = false;
    
                        /**
                         * AvroConfig useTopicSchema.
                         * @member {boolean} useTopicSchema
                         * @memberof google.pubsub.v1.CloudStorageConfig.AvroConfig
                         * @instance
                         */
                        AvroConfig.prototype.useTopicSchema = false;
    
                        /**
                         * Creates a new AvroConfig instance using the specified properties.
                         * @function create
                         * @memberof google.pubsub.v1.CloudStorageConfig.AvroConfig
                         * @static
                         * @param {google.pubsub.v1.CloudStorageConfig.IAvroConfig=} [properties] Properties to set
                         * @returns {google.pubsub.v1.CloudStorageConfig.AvroConfig} AvroConfig instance
                         */
                        AvroConfig.create = function create(properties) {
                            return new AvroConfig(properties);
                        };
    
                        /**
                         * Encodes the specified AvroConfig message. Does not implicitly {@link google.pubsub.v1.CloudStorageConfig.AvroConfig.verify|verify} messages.
                         * @function encode
                         * @memberof google.pubsub.v1.CloudStorageConfig.AvroConfig
                         * @static
                         * @param {google.pubsub.v1.CloudStorageConfig.IAvroConfig} message AvroConfig message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AvroConfig.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.writeMetadata != null && Object.hasOwnProperty.call(message, "writeMetadata"))
                                writer.uint32(/* id 1, wireType 0 =*/8).bool(message.writeMetadata);
                            if (message.useTopicSchema != null && Object.hasOwnProperty.call(message, "useTopicSchema"))
                                writer.uint32(/* id 2, wireType 0 =*/16).bool(message.useTopicSchema);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified AvroConfig message, length delimited. Does not implicitly {@link google.pubsub.v1.CloudStorageConfig.AvroConfig.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.pubsub.v1.CloudStorageConfig.AvroConfig
                         * @static
                         * @param {google.pubsub.v1.CloudStorageConfig.IAvroConfig} message AvroConfig message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AvroConfig.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an AvroConfig message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.pubsub.v1.CloudStorageConfig.AvroConfig
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.pubsub.v1.CloudStorageConfig.AvroConfig} AvroConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AvroConfig.decode = function decode(reader, length, error) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.CloudStorageConfig.AvroConfig();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                if (tag === error)
                                    break;
                                switch (tag >>> 3) {
                                case 1: {
                                        message.writeMetadata = reader.bool();
                                        break;
                                    }
                                case 2: {
                                        message.useTopicSchema = reader.bool();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an AvroConfig message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.pubsub.v1.CloudStorageConfig.AvroConfig
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.pubsub.v1.CloudStorageConfig.AvroConfig} AvroConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AvroConfig.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an AvroConfig message.
                         * @function verify
                         * @memberof google.pubsub.v1.CloudStorageConfig.AvroConfig
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AvroConfig.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.writeMetadata != null && message.hasOwnProperty("writeMetadata"))
                                if (typeof message.writeMetadata !== "boolean")
                                    return "writeMetadata: boolean expected";
                            if (message.useTopicSchema != null && message.hasOwnProperty("useTopicSchema"))
                                if (typeof message.useTopicSchema !== "boolean")
                                    return "useTopicSchema: boolean expected";
                            return null;
                        };
    
                        /**
                         * Creates an AvroConfig message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.pubsub.v1.CloudStorageConfig.AvroConfig
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.pubsub.v1.CloudStorageConfig.AvroConfig} AvroConfig
                         */
                        AvroConfig.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.pubsub.v1.CloudStorageConfig.AvroConfig)
                                return object;
                            var message = new $root.google.pubsub.v1.CloudStorageConfig.AvroConfig();
                            if (object.writeMetadata != null)
                                message.writeMetadata = Boolean(object.writeMetadata);
                            if (object.useTopicSchema != null)
                                message.useTopicSchema = Boolean(object.useTopicSchema);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an AvroConfig message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.pubsub.v1.CloudStorageConfig.AvroConfig
                         * @static
                         * @param {google.pubsub.v1.CloudStorageConfig.AvroConfig} message AvroConfig
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AvroConfig.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.writeMetadata = false;
                                object.useTopicSchema = false;
                            }
                            if (message.writeMetadata != null && message.hasOwnProperty("writeMetadata"))
                                object.writeMetadata = message.writeMetadata;
                            if (message.useTopicSchema != null && message.hasOwnProperty("useTopicSchema"))
                                object.useTopicSchema = message.useTopicSchema;
                            return object;
                        };
    
                        /**
                         * Converts this AvroConfig to JSON.
                         * @function toJSON
                         * @memberof google.pubsub.v1.CloudStorageConfig.AvroConfig
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AvroConfig.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for AvroConfig
                         * @function getTypeUrl
                         * @memberof google.pubsub.v1.CloudStorageConfig.AvroConfig
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        AvroConfig.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.pubsub.v1.CloudStorageConfig.AvroConfig";
                        };
    
                        return AvroConfig;
                    })();
    
                    /**
                     * State enum.
                     * @name google.pubsub.v1.CloudStorageConfig.State
                     * @enum {number}
                     * @property {number} STATE_UNSPECIFIED=0 STATE_UNSPECIFIED value
                     * @property {number} ACTIVE=1 ACTIVE value
                     * @property {number} PERMISSION_DENIED=2 PERMISSION_DENIED value
                     * @property {number} NOT_FOUND=3 NOT_FOUND value
                     * @property {number} IN_TRANSIT_LOCATION_RESTRICTION=4 IN_TRANSIT_LOCATION_RESTRICTION value
                     * @property {number} SCHEMA_MISMATCH=5 SCHEMA_MISMATCH value
                     */
                    CloudStorageConfig.State = (function() {
                        var valuesById = {}, values = Object.create(valuesById);
                        values[valuesById[0] = "STATE_UNSPECIFIED"] = 0;
                        values[valuesById[1] = "ACTIVE"] = 1;
                        values[valuesById[2] = "PERMISSION_DENIED"] = 2;
                        values[valuesById[3] = "NOT_FOUND"] = 3;
                        values[valuesById[4] = "IN_TRANSIT_LOCATION_RESTRICTION"] = 4;
                        values[valuesById[5] = "SCHEMA_MISMATCH"] = 5;
                        return values;
                    })();
    
                    return CloudStorageConfig;
                })();
    
                v1.ReceivedMessage = (function() {
    
                    /**
                     * Properties of a ReceivedMessage.
                     * @memberof google.pubsub.v1
                     * @interface IReceivedMessage
                     * @property {string|null} [ackId] ReceivedMessage ackId
                     * @property {google.pubsub.v1.IPubsubMessage|null} [message] ReceivedMessage message
                     * @property {number|null} [deliveryAttempt] ReceivedMessage deliveryAttempt
                     */
    
                    /**
                     * Constructs a new ReceivedMessage.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a ReceivedMessage.
                     * @implements IReceivedMessage
                     * @constructor
                     * @param {google.pubsub.v1.IReceivedMessage=} [properties] Properties to set
                     */
                    function ReceivedMessage(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * ReceivedMessage ackId.
                     * @member {string} ackId
                     * @memberof google.pubsub.v1.ReceivedMessage
                     * @instance
                     */
                    ReceivedMessage.prototype.ackId = "";
    
                    /**
                     * ReceivedMessage message.
                     * @member {google.pubsub.v1.IPubsubMessage|null|undefined} message
                     * @memberof google.pubsub.v1.ReceivedMessage
                     * @instance
                     */
                    ReceivedMessage.prototype.message = null;
    
                    /**
                     * ReceivedMessage deliveryAttempt.
                     * @member {number} deliveryAttempt
                     * @memberof google.pubsub.v1.ReceivedMessage
                     * @instance
                     */
                    ReceivedMessage.prototype.deliveryAttempt = 0;
    
                    /**
                     * Creates a new ReceivedMessage instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.ReceivedMessage
                     * @static
                     * @param {google.pubsub.v1.IReceivedMessage=} [properties] Properties to set
                     * @returns {google.pubsub.v1.ReceivedMessage} ReceivedMessage instance
                     */
                    ReceivedMessage.create = function create(properties) {
                        return new ReceivedMessage(properties);
                    };
    
                    /**
                     * Encodes the specified ReceivedMessage message. Does not implicitly {@link google.pubsub.v1.ReceivedMessage.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.ReceivedMessage
                     * @static
                     * @param {google.pubsub.v1.IReceivedMessage} message ReceivedMessage message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ReceivedMessage.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.ackId != null && Object.hasOwnProperty.call(message, "ackId"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.ackId);
                        if (message.message != null && Object.hasOwnProperty.call(message, "message"))
                            $root.google.pubsub.v1.PubsubMessage.encode(message.message, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                        if (message.deliveryAttempt != null && Object.hasOwnProperty.call(message, "deliveryAttempt"))
                            writer.uint32(/* id 3, wireType 0 =*/24).int32(message.deliveryAttempt);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified ReceivedMessage message, length delimited. Does not implicitly {@link google.pubsub.v1.ReceivedMessage.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.ReceivedMessage
                     * @static
                     * @param {google.pubsub.v1.IReceivedMessage} message ReceivedMessage message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ReceivedMessage.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a ReceivedMessage message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.ReceivedMessage
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.ReceivedMessage} ReceivedMessage
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ReceivedMessage.decode = function decode(reader, length, error) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.ReceivedMessage();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            if (tag === error)
                                break;
                            switch (tag >>> 3) {
                            case 1: {
                                    message.ackId = reader.string();
                                    break;
                                }
                            case 2: {
                                    message.message = $root.google.pubsub.v1.PubsubMessage.decode(reader, reader.uint32());
                                    break;
                                }
                            case 3: {
                                    message.deliveryAttempt = reader.int32();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a ReceivedMessage message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.ReceivedMessage
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.ReceivedMessage} ReceivedMessage
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ReceivedMessage.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a ReceivedMessage message.
                     * @function verify
                     * @memberof google.pubsub.v1.ReceivedMessage
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    ReceivedMessage.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.ackId != null && message.hasOwnProperty("ackId"))
                            if (!$util.isString(message.ackId))
                                return "ackId: string expected";
                        if (message.message != null && message.hasOwnProperty("message")) {
                            var error = $root.google.pubsub.v1.PubsubMessage.verify(message.message);
                            if (error)
                                return "message." + error;
                        }
                        if (message.deliveryAttempt != null && message.hasOwnProperty("deliveryAttempt"))
                            if (!$util.isInteger(message.deliveryAttempt))
                                return "deliveryAttempt: integer expected";
                        return null;
                    };
    
                    /**
                     * Creates a ReceivedMessage message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.ReceivedMessage
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.ReceivedMessage} ReceivedMessage
                     */
                    ReceivedMessage.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.ReceivedMessage)
                            return object;
                        var message = new $root.google.pubsub.v1.ReceivedMessage();
                        if (object.ackId != null)
                            message.ackId = String(object.ackId);
                        if (object.message != null) {
                            if (typeof object.message !== "object")
                                throw TypeError(".google.pubsub.v1.ReceivedMessage.message: object expected");
                            message.message = $root.google.pubsub.v1.PubsubMessage.fromObject(object.message);
                        }
                        if (object.deliveryAttempt != null)
                            message.deliveryAttempt = object.deliveryAttempt | 0;
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a ReceivedMessage message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.ReceivedMessage
                     * @static
                     * @param {google.pubsub.v1.ReceivedMessage} message ReceivedMessage
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    ReceivedMessage.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.ackId = "";
                            object.message = null;
                            object.deliveryAttempt = 0;
                        }
                        if (message.ackId != null && message.hasOwnProperty("ackId"))
                            object.ackId = message.ackId;
                        if (message.message != null && message.hasOwnProperty("message"))
                            object.message = $root.google.pubsub.v1.PubsubMessage.toObject(message.message, options);
                        if (message.deliveryAttempt != null && message.hasOwnProperty("deliveryAttempt"))
                            object.deliveryAttempt = message.deliveryAttempt;
                        return object;
                    };
    
                    /**
                     * Converts this ReceivedMessage to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.ReceivedMessage
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    ReceivedMessage.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for ReceivedMessage
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.ReceivedMessage
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    ReceivedMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.ReceivedMessage";
                    };
    
                    return ReceivedMessage;
                })();
    
                v1.GetSubscriptionRequest = (function() {
    
                    /**
                     * Properties of a GetSubscriptionRequest.
                     * @memberof google.pubsub.v1
                     * @interface IGetSubscriptionRequest
                     * @property {string|null} [subscription] GetSubscriptionRequest subscription
                     */
    
                    /**
                     * Constructs a new GetSubscriptionRequest.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a GetSubscriptionRequest.
                     * @implements IGetSubscriptionRequest
                     * @constructor
                     * @param {google.pubsub.v1.IGetSubscriptionRequest=} [properties] Properties to set
                     */
                    function GetSubscriptionRequest(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * GetSubscriptionRequest subscription.
                     * @member {string} subscription
                     * @memberof google.pubsub.v1.GetSubscriptionRequest
                     * @instance
                     */
                    GetSubscriptionRequest.prototype.subscription = "";
    
                    /**
                     * Creates a new GetSubscriptionRequest instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.GetSubscriptionRequest
                     * @static
                     * @param {google.pubsub.v1.IGetSubscriptionRequest=} [properties] Properties to set
                     * @returns {google.pubsub.v1.GetSubscriptionRequest} GetSubscriptionRequest instance
                     */
                    GetSubscriptionRequest.create = function create(properties) {
                        return new GetSubscriptionRequest(properties);
                    };
    
                    /**
                     * Encodes the specified GetSubscriptionRequest message. Does not implicitly {@link google.pubsub.v1.GetSubscriptionRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.GetSubscriptionRequest
                     * @static
                     * @param {google.pubsub.v1.IGetSubscriptionRequest} message GetSubscriptionRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    GetSubscriptionRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.subscription != null && Object.hasOwnProperty.call(message, "subscription"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.subscription);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified GetSubscriptionRequest message, length delimited. Does not implicitly {@link google.pubsub.v1.GetSubscriptionRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.GetSubscriptionRequest
                     * @static
                     * @param {google.pubsub.v1.IGetSubscriptionRequest} message GetSubscriptionRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    GetSubscriptionRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a GetSubscriptionRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.GetSubscriptionRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.GetSubscriptionRequest} GetSubscriptionRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    GetSubscriptionRequest.decode = function decode(reader, length, error) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.GetSubscriptionRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            if (tag === error)
                                break;
                            switch (tag >>> 3) {
                            case 1: {
                                    message.subscription = reader.string();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a GetSubscriptionRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.GetSubscriptionRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.GetSubscriptionRequest} GetSubscriptionRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    GetSubscriptionRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a GetSubscriptionRequest message.
                     * @function verify
                     * @memberof google.pubsub.v1.GetSubscriptionRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    GetSubscriptionRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.subscription != null && message.hasOwnProperty("subscription"))
                            if (!$util.isString(message.subscription))
                                return "subscription: string expected";
                        return null;
                    };
    
                    /**
                     * Creates a GetSubscriptionRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.GetSubscriptionRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.GetSubscriptionRequest} GetSubscriptionRequest
                     */
                    GetSubscriptionRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.GetSubscriptionRequest)
                            return object;
                        var message = new $root.google.pubsub.v1.GetSubscriptionRequest();
                        if (object.subscription != null)
                            message.subscription = String(object.subscription);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a GetSubscriptionRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.GetSubscriptionRequest
                     * @static
                     * @param {google.pubsub.v1.GetSubscriptionRequest} message GetSubscriptionRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    GetSubscriptionRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults)
                            object.subscription = "";
                        if (message.subscription != null && message.hasOwnProperty("subscription"))
                            object.subscription = message.subscription;
                        return object;
                    };
    
                    /**
                     * Converts this GetSubscriptionRequest to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.GetSubscriptionRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    GetSubscriptionRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for GetSubscriptionRequest
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.GetSubscriptionRequest
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    GetSubscriptionRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.GetSubscriptionRequest";
                    };
    
                    return GetSubscriptionRequest;
                })();
    
                v1.UpdateSubscriptionRequest = (function() {
    
                    /**
                     * Properties of an UpdateSubscriptionRequest.
                     * @memberof google.pubsub.v1
                     * @interface IUpdateSubscriptionRequest
                     * @property {google.pubsub.v1.ISubscription|null} [subscription] UpdateSubscriptionRequest subscription
                     * @property {google.protobuf.IFieldMask|null} [updateMask] UpdateSubscriptionRequest updateMask
                     */
    
                    /**
                     * Constructs a new UpdateSubscriptionRequest.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents an UpdateSubscriptionRequest.
                     * @implements IUpdateSubscriptionRequest
                     * @constructor
                     * @param {google.pubsub.v1.IUpdateSubscriptionRequest=} [properties] Properties to set
                     */
                    function UpdateSubscriptionRequest(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * UpdateSubscriptionRequest subscription.
                     * @member {google.pubsub.v1.ISubscription|null|undefined} subscription
                     * @memberof google.pubsub.v1.UpdateSubscriptionRequest
                     * @instance
                     */
                    UpdateSubscriptionRequest.prototype.subscription = null;
    
                    /**
                     * UpdateSubscriptionRequest updateMask.
                     * @member {google.protobuf.IFieldMask|null|undefined} updateMask
                     * @memberof google.pubsub.v1.UpdateSubscriptionRequest
                     * @instance
                     */
                    UpdateSubscriptionRequest.prototype.updateMask = null;
    
                    /**
                     * Creates a new UpdateSubscriptionRequest instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.UpdateSubscriptionRequest
                     * @static
                     * @param {google.pubsub.v1.IUpdateSubscriptionRequest=} [properties] Properties to set
                     * @returns {google.pubsub.v1.UpdateSubscriptionRequest} UpdateSubscriptionRequest instance
                     */
                    UpdateSubscriptionRequest.create = function create(properties) {
                        return new UpdateSubscriptionRequest(properties);
                    };
    
                    /**
                     * Encodes the specified UpdateSubscriptionRequest message. Does not implicitly {@link google.pubsub.v1.UpdateSubscriptionRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.UpdateSubscriptionRequest
                     * @static
                     * @param {google.pubsub.v1.IUpdateSubscriptionRequest} message UpdateSubscriptionRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    UpdateSubscriptionRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.subscription != null && Object.hasOwnProperty.call(message, "subscription"))
                            $root.google.pubsub.v1.Subscription.encode(message.subscription, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                        if (message.updateMask != null && Object.hasOwnProperty.call(message, "updateMask"))
                            $root.google.protobuf.FieldMask.encode(message.updateMask, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified UpdateSubscriptionRequest message, length delimited. Does not implicitly {@link google.pubsub.v1.UpdateSubscriptionRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.UpdateSubscriptionRequest
                     * @static
                     * @param {google.pubsub.v1.IUpdateSubscriptionRequest} message UpdateSubscriptionRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    UpdateSubscriptionRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes an UpdateSubscriptionRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.UpdateSubscriptionRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.UpdateSubscriptionRequest} UpdateSubscriptionRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    UpdateSubscriptionRequest.decode = function decode(reader, length, error) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.UpdateSubscriptionRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            if (tag === error)
                                break;
                            switch (tag >>> 3) {
                            case 1: {
                                    message.subscription = $root.google.pubsub.v1.Subscription.decode(reader, reader.uint32());
                                    break;
                                }
                            case 2: {
                                    message.updateMask = $root.google.protobuf.FieldMask.decode(reader, reader.uint32());
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
