# maas-log4js-stackdriver-appender
A log4js appender to use along with the Google Cloud logging Stackdriver

To allow access to Google Cloud Logging please follow [setup](https://cloud.google.com/logging/docs/setup/nodejs) and access permission on Google Cloud documentation.
You can use Application Default Credentials (ADC) or supply credential in config.

If your code is running on Google Cloud then make sure the proper scope is setup.
If you are running on you local dev server, use gcloud cli to authorize.

You can specify a resource which the log will be written to.

## quick usage 
```js
server-conf.js:
    "log": {
        "appenders": {
            "google": {
                "type":  'maas-log4js-stackdriver-appender',
                "credentials":{
                    "projectId": "<Project Id. Ex: 'oxs-develop-docker'>",
                    "keyFilename": '/app/logsecret/oxs-develop-docker-b8d9468810a6.json'
                },
                "resource": {
					"appLabels": {
						"k8s-pod/app": "<Server name. Ex: 'oxs-batch-import-server'>",
						"k8s-pod/io_kompose_service": "<Server name. Ex: 'oxs-batch-import-server'>",
					},
                    "type": "k8s_container",
                    "labels": {
						"container_name":	"<Container name. Ex: 'oxs-batch-import-server'>",
						"cluster_name": 	"<Cluster name. Ex: 'dev' | 'integration' | 'production'>" ,
						"pod_name": 		"<Hostname Ex: process.env["HOSTNAME"]>",
						"project_id":		"<Project Id. Ex: 'oxs-develop-docker'>",
						"namespace_name":	"<Namespace name Ex: 'development' | 'integration' |'production'>",
						"location":			"<location, ex.: europe-west3-b>"
                    }
                },
                "logFileName": 'stdout',
                "layout": {
                    "type":     "pattern",
                    "pattern":  "[%p] %c - %m",
                    /*
                    // Use following pattern to log ONLY the first parameter of the logger.error("some text", {"loglabel1": <value 1>>}) statement
                    // see https://log4js-node.github.io/log4js-node/layouts.html
                    "pattern": '[%p] %c - %x{data0}',
                    "tokens": {
                        "data0": function(loggingEvent){return loggingEvent.data[0]}
                    }
                    */
                }
            },
            "consoleappender": {
                "type": "console",
                "layout": {
                    "type": "pattern",
                    "pattern": "[%d] [%p] %c - %m"
                }
            }
        },
        "categories": {
            "default": {
                "appenders":["google", "consoleappender"],
                "level": process.env[process.env.OXSNPS_SERVER_PREFIX + "LOG_LEVEL"] || "INFO"
            }
        }
    }

var log4js = require('log4js');
log4js.configure(log);
var logger = log4js.getLogger('local');
logger.debug('something');
```
if you are running your server from your local system (not on GCP), you can supply your credentials in the config for connecting to your GCP
```js
server-conf.js:
    "log":{
        "appenders": {
            "type": 'maas-log4js-stackdriver-appender',
            "credentials":{
                "projectId": 'oxs-develop-docker',
                "keyFilename": '/app/logsecret/oxs-develop-docker-b8d9468810a6.json'
            },
            "..."
        }
    }
}
```
You can add labels to your log statement. To do so, in your plugin, build the logger call as shown below. The second paramter must be a json object. Every key of that object will be added as label (within the "labels" json object):
```js
    logger.<level>('<some text>', {'label1': '<value1>',...,'labeln': '<valuen>'})
```
where ```<level>``` can be any log4js available label (ie. info,error,debug,warn,...)

The output log entry will then look as shown below:
```js
    {
        "textPayload": "[<level>] <some text>",
        "insertId": "..........ByUzyN9et8B8lbAoU44Eo1",
        "resource": {
            "type": "k8s_container",
            "labels": {... }
        },
        ...
        "labels": {
            'label1': '<value1>',
            ...,
            'labeln': '<valuen>',
            "k8s-pod/app": "node-daniel",
            "k8s-pod/io_kompose_service": "node-daniel"
        },
        ...
    }    
```
Example:
```js
    logger.error('error!', {'tenant':'wackler', 'inputchannel': 'emailImport'})
```
Corresponding log entry:
```js
    {
        "textPayload": "[ERROR] error!",
        "insertId": "..........ByUzyN9et8B8lbAoU44Eo1",
        "resource": {
            "type": "k8s_container",
            "labels": {... }
        },
        ...
        "labels": {
            "tenant":"wackler",
            "inputchannel": "emailImport",
            "k8s-pod/app": "node-daniel",
            "k8s-pod/io_kompose_service": "node-daniel"
        },
        ...
    }    
```
To avoid that the second parameter (ie. ```{'label1': '<value1>',...,'labeln': '<valuen>'}```)  gets logged as part of the log message, use the following pattern layout :
```js
          "layout": {
            "type": "pattern",
            // see https://log4js-node.github.io/log4js-node/layouts.html
            "pattern": '[%p] %c - %x{data0}',
            "tokens": {
              "data0": function(loggingEvent) {
                return loggingEvent.data[0]
              }
            }            
          }
```

## install
```bash
npm install maas-log4js-stackdriver-appender --save
```