/**
 * @private
 * @module
 */

var Promise = require('es6-promise').Promise;

function ChatNoticeClient(socket) {
    this.socket = socket;
}

// ChatNoticeManager.prototype.sendMessage = function (text) {
//     console.log('Send message: ' + text);
// };

/**
 * @return Promise which resolve to the list of online users
 */
ChatNoticeClient.prototype.getOnlineUsers = function () {
    function getUsers(resolve, reject)  {
        this.socket.on("message", function (message) {
            try {
                message = JSON.parse(message);
                if (message.command == "onlineUsersMapping") {
                    resolve(message.data);
                }
            } catch (e) {
                console.error(e.stack || e);
                reject(e)
            }
        });
        this.socket.emit("message",{command:"getOnlineUsersByMapping"});
    }
    return new Promise(getUsers.bind(this));
};

/**
 * Register callback for new user connection. cb(user) will be called when new user is going online
 * @param cb
 */
ChatNoticeClient.prototype.onUserConnected = function (cb) {
    this.socket.on("message", function (message){
        try {
            message = JSON.parse(message);
            if (message.command == "userOnline")
                cb(message.data.sender);
        } catch (e) {
            console.error(e.stack || e);
        }
    });
};

/**
 * Register callback for new user connection. cb(user) will be called when user is going offline
 * @param cb
 */
ChatNoticeClient.prototype.onUserDisconnected = function (cb) {
    this.socket.on("message", function (message){
        try {
            message = JSON.parse(message);
            if (message.command == "userOffline")
                cb(message.data.sender);
        } catch (e) {
            console.error(e.stack || e);
        }
    })
};

module.exports = ChatNoticeClient;