var Promise = require('es6-promise').Promise;
var WssHttpClient = require('./WssHttpClient');

/**
 * @constructor
 */
function MessageExchangeManager(socket, mandant, token) {
    this.socket = socket;
    //Rajan 20240315 - Begin
    //this.wssHttpClient = new WssHttpClient(socket.io.uri + socket.io.engine.path.replace("/socket.io/",""), mandant, token);
    if (socket.io.engine && socket.io.engine.opts && socket.io.engine.opts.path){
        this.wssHttpClient = new WssHttpClient(socket.io.uri + socket.io.engine.opts.path.replace("/socket.io/",""), mandant, token);
    } else {
        this.wssHttpClient = new WssHttpClient(socket.io.uri + socket.io.engine.path.replace("/socket.io/",""), mandant, token);
    }
    //Rajan 20240315 - End
}

/**
 * Send message to a user via HTTP if he's online. Message will be lost if the user is offline (not connected to WSS).
 * @param data message to send
 * @param userId id of user to send message to
 * @param sessionId identifier of user session; see {@link WSSClient#getSessionId}
 */
MessageExchangeManager.prototype.sendMessage = function(data, userId, sessionId) {
    return this.wssHttpClient.sendMessage(data, userId, sessionId);
};

/**
 * Subscribe to messages for current session
 * @param cb function to call when message is received
 */
MessageExchangeManager.prototype.subscribe = function(cb) {
    this.socket.on('message', cb);
};

module.exports = MessageExchangeManager;