"use strict";
var Promise = require('es6-promise').Promise;
var fetch = require('node-fetch');

/**
 * @constructor
 */
function WssHttpClient(connectionUri, mandant, token) {
    this.uri = connectionUri;
    this.mandant = mandant;
    this.token = token;
}

/**
 * Send message to a user via HTTP if he's online. Message will be lost if the user is offline (not connected to WSS).
 *
 * @param data message to send
 * @param userId id of a user to send message to
 * @param sessionId [optional] identifier of user session; see {@link WSSClient#getSessionId}; if session id is skipped, message will be sent to all
 * live sessions of given user
 * @return Promise
 */
WssHttpClient.prototype.sendMessage = function(data, userId, sessionId) {
    var url = this.uri + "/message/send/?userId=" + userId + (sessionId ? "&sessionId=" + sessionId : "") + "&client=" + this.mandant + (this.token ? "&token=" + this.token : "");
    var options = {
        headers: {
            "Content-Type":"application/json"
        },
        method: "POST",
        body: JSON.stringify(data)
    };
    return fetch(url, options);
};

module.exports = WssHttpClient;