"use strict"
should = require "should"
utils = require "./utils.js"
ConcurrentAccessManager = require('../lib/ConcurrentAccessManager');

socket = utils.getStubSocket 'user'
cam = new ConcurrentAccessManager(socket)
testType = 'R_1'
testId = '1'

describe '#WSS client', ()->
  describe '#concurrent access', ()->

    beforeEach ()->
      socket = utils.getStubSocket 'user'
      cam = new ConcurrentAccessManager(socket)

    it 'should subscribe and get message', (done)->
      cam.subscribe testType, testId, (data)->
        JSON.stringify(data).should.be.equal(JSON.stringify(utils.getNotification(testType, testId, 'action', [], 'this is some data')))
        done()
      cam.notify testType, testId, 'action', [], 'this is some data'

    it 'should not unsubscribe and get message', (done)->
      specialTestType = 'R_1'
      specialTestId = '1'

      cam.subscribe specialTestType, specialTestId, (data)->
        JSON.stringify(data).should.be.equal(JSON.stringify(utils.getNotification(specialTestType, specialTestId, 'action', [], 'this is some data')))
        done()
      cam.unsubscribe 'R', '1_1'
      cam.notify specialTestType, specialTestId, 'action', [], 'this is some data'

    it 'should unsubscribe and get nothing', (done)->
      cam.subscribe testType, testId, (data)->
        should.not.exist(data);
      cam.unsubscribe testType, testId
      cam.notify testType, testId, 'action', [], 'this is some data'
      setTimeout(done, 20)

