"use strict";
module.exports = {
    getStubSocket: function getStubSocket(userId) {
        return {
            userId: userId,
            id: userId,
            mandant: "test",
            emit: function (command, message) {
                if (this._callbacks[command])
                    this._callbacks[command].forEach((cb)=>{
                        cb(JSON.stringify(transformMessage(message)));
                    });
            },
            on : function (command, cb) {
                if (!this._callbacks[command])
                    this._callbacks[command] = [];
                this._callbacks[command].push(cb);
            },
            _callbacks: {}
        }
    },
    getNotification: (type, id, action, relations,data)=> {
        return {
            object: {
                type: type,
                id: id,
                relations: relations
            },
            action: action,
            data: data
        }
    }
};

function transformMessage(message){
    switch (message.command) {
        case "notify":
            return {
                command: "notify",
                data: message.data.notification
            };
        default:
            return message;
    }
}