let path	= require('path')

module.exports = {
    "desc": 	"Nils utility plugin",
    "enable": 	"on",
	"log": {
		// Available Log Levels are DEBUG, INFO and ERROR
		// Available Log Levels are DEBUG, INFO, WARN and ERROR
	    "level": process.env[process.env.OXSNPS_SERVER_PREFIX + "LOG_LEVEL_NILS_UTILS"] ||
					process.env[process.env.OXSNPS_SERVER_PREFIX + "LOG_LEVEL"] ||
					"WARN"
	},
    "routes": [
		{
			"path": 	"/services/nils.utils/version",
			"method": 	"get",
			"service": 	"version"
		},
		{	
			"path": 	"/services/nils.utils/conf",
			"method": 	"get",
			"service": 	"conf"
		},		
		{
			"path": 	"/services/nils.utils/conf",
			"method": 	"post",
			"service": 	"conf"
		},
		// HTTP POST route for 'getstack' service
		{
			"path": 	"/services/nils.utils/getstack",
			"method":	"post",
			"service":	"getStapel",
			"maxJobs": 	process.env[process.env.OXSNPS_SERVER_PREFIX + "NILS_UTILS_MAX_JOBS"] *1 || 3, // amount of jobs allowed to run concurrently
		},
		// HTTP POST route for 'getstack' service
		{
			"path": 	"/nils/getstack",
			"method": 	"post",
			"service": 	"getStapel",
			"maxJobs":	process.env[process.env.OXSNPS_SERVER_PREFIX + "NILS_UTILS_MAX_JOBS"] *1 || 3, // amount of jobs allowed to run concurrently
		},
		// HTTP GET route for 'getstack' service
		{
			"enable": 	"on",
			"path": 	"/services/nils.utils/stack/:stackid",
			"method":	"get",
			"service":  "getStapelREST",
			"maxJobs": 	process.env[process.env.OXSNPS_SERVER_PREFIX + "NILS_UTILS_MAX_JOBS"] *1 || 3, // amount of jobs allowed to run concurrently
		}
    ],
    "middlewares":[
        {
            "name":     "body-parser",
            "handler":  "json",
            "routes":[
                {
                    "path":     "/services/nils.utils/*",
                    "parms":    {limit: '25mb'}
                }
            ]
        },
        {
            "name":     "body-parser",
            "handler":  "text",
            "routes":[
                {
                    "path":     ["/services/nils.utils/*", "/nils/getstack"],
                    "parms":    {type:'*/xml', limit: '25mb'}
                }
            ]
        },
        {
			// Add static route for <serverDir>/hal.finalizer
			"name": "express",
            "handler": "static",
            "routes":[
                {
                    "path": ["/nils.utils/api/"],							// define http://<host>:<port>/api to map to the physical dir defined below
                    "parms": path.join(__dirname, '..', 'swagger') 	// physical dir where the files to be served are located (i.e. oxs-xxx-server/node_modules/rest.ish/swagger)
                }
            ]
        }
    ]    
}
