"use strict";
var http = require("http");
var https = require("https");
var Promise = require("bluebird");
/**
 * Sends a 'GET /' request to a server and returns a promise that returns the round trip time in milliseconds.
 * @param url The destination url. E.g. www.google.com
 * @param port Optional: The port number of the destination. Defaults to 80
 * @returns Promise<{responseTime: number }> A promise that returns the round trip time in milliseconds. Returns -1 if an error occurred.
 * */
function ping(url, port) {
    var promise = new Promise(function (resolve, reject) {
        var useHttps = url.indexOf('https') === 0;
        var mod = useHttps ? https.request : http.request;
        var outPort = port || (useHttps ? 443 : 80);
        var baseUrl = url.replace('http://', '').replace('https://', '');
        var options = { host: baseUrl, port: outPort, path: '/' };
        var start = Date.now();
        var pingRequest = mod(options, function () {
            resolve(Date.now() - start);
            pingRequest.abort();
        });
        pingRequest.on('error', function () {
            reject(-1);
            pingRequest.abort();
        });
        pingRequest.write('');
        pingRequest.end();
    });
    return promise;
}
;
ping.default = ping;
module.exports = ping;
