let path	= require('path')

module.exports = {
    "desc": 	"OXSNPS oxsnps-assert plugin",
    "enable": 	"on",
	"log": {
		// Available Log Levels are DEBUG, INFO, WARN and ERROR
		"level": process.env[process.env.OXSNPS_SERVER_PREFIX + "LOG_LEVEL_OXSNPS_ASSERT"] ||
				process.env[process.env.OXSNPS_SERVER_PREFIX + "LOG_LEVEL"] ||
				"WARN"
	},
    "routes": [
		{
			"path": 	"/services/assert/version",
			"method": 	"get",
			"service": 	"version"
		},
		{	
			"path": 	"/services/assert/conf",
			"method": 	"get",
			"service": 	"conf"
		},		
		{
			"path": 	"/services/assert/conf",
			"method": "post",
			"service": "conf"
		},
		// V2.0.2  Begin
        {	
			"path": 	"/services/assert/isalive",
			"method": 	"get",
			"service": 	"isServersAlive"
		},
        // V2.0.2  End
		// V2.0.11  Begin
        {	
			"path": 	"/isalive",
			"method": 	"get",
			"service": 	"isServersAlive"
		},        
		// V2.0.11  End
        // V2.0.6 Begin
        {	
			"path": 	"/services/assert/symlink",
			"method": 	"get",
			"service": 	"assertSymlink"
        },
        {	
			"path": 	"/services/assert/symlink",
			"method": 	"delete",
			"service": 	"removeSymlink"
		}        
        // V2.0.6  End
	],
	// V2.0.2  Begin
    "middlewares":[
        {
            "name":     "body-parser",
            "handler":  "json",
            "routes":[
                {
                    "path":     "/services/assert/*",
                    "parms":    {limit: '25mb'}
                }
            ]
        },
        {
			// Add static route for oxsnps-assert plugin
			"name": "express",
            "handler": "static",
            "routes":[
                {
                    "path": ["/oxsnps-assert/api"],							// define http://<host>:<port>/api to map to the physical dir defined below
                    "parms": path.join(__dirname, '..', 'swagger') 	// physical dir where the files to be served are located (i.e. oxs-xxx-server/node_modules/rest.ish/swagger)
                }
            ]
        }        
	],
    // V2.0.2  End
    "templates" :{
        "isalive": "conf/isalive.html"
    },
    "maxOccurences":{
        "assertServers": process.env[process.env.OXSNPS_SERVER_PREFIX + "MAX_ASSERT_SERVERS"] || 10 
    }
}
