module.exports = [
    {	// PluginManager services
        name: 	    'pluginManager',
        baseRoute: 	'/appservices/pm',
        routes: [
            {method: 'get', 	path: '/appservices/pm/version', 			service: 'version'}, 
            {method: 'get', 	path: '/appservices/pm/routes', 			service: 'getRoutes'},
            {method: 'get', 	path: '/appservices/pm/enable',				service: 'enablePlugin'},
            {method: 'post', 	path: '/appservices/pm/enable', 			service: 'enablePlugin'},
            {method: 'get', 	path: '/appservices/pm/load',				service: 'loadPlugin'},
            {method: 'post', 	path: '/appservices/pm/load', 				service: 'loadPlugin'},		
            {method: 'get', 	path: '/appservices/pm/disable',			service: 'disablePlugin'},
            {method: 'post', 	path: '/appservices/pm/disable', 			service: 'disablePlugin'},				
            {method: 'get', 	path: '/appservices/pm/enableRoute',		service: 'enableRoute'},
            {method: 'post', 	path: '/appservices/pm/enableRoute',		service: 'enableRoute'},
            {method: 'get', 	path: '/appservices/pm/disableRoute',		service: 'disableRoute'},
            {method: 'post', 	path: '/appservices/pm/disableRoute',		service: 'disableRoute'},
            {method: 'get', 	path: '/appservices/pm/disableProxyRoute',	service: 'disableProxyRoute'},
            {method: 'get', 	path: '/appservices/pm/getloglevel',		service: 'getLogLevel'},
            {method: 'get', 	path: '/appservices/pm/setloglevel',		service: 'setLogLevel'},
            {method: 'get', 	path: '/appservices/pm/loghttproutes',		service: 'logHTTPRoutes'},
            {method: 'get', 	path: '/appservices/pm/swaggerconf',		service: 'getSwaggerconf'},	// V4.1.22
        ]
    },
    {	// Cronjob services
        name: 	    'cronjob',
        baseRoute: 	'/appservices/jobs',
        routes: [
            {method: 'get', 	path: '/appservices/jobs/list', 			service: 'list'},
            {method: 'post', 	path: '/appservices/jobs/delete', 			service: 'delete'},
            {method: 'post', 	path: '/appservices/jobs/start', 			service: 'start'},
            {method: 'post', 	path: '/appservices/jobs/stop', 			service: 'stop'},
            {method: 'post', 	path: '/appservices/jobs/stopall', 			service: 'stopAll'},
            {method: 'post', 	path: '/appservices/jobs/exists', 			service: 'exists'},
            {method: 'get', 	path: '/appservices/jobs/getloglevel', 		service: 'getLogLevel'},
            {method: 'get', 	path: '/appservices/jobs/setloglevel',		service: 'setLogLevel'}
        ]
    },
    {	// Cache services
        name: 	    'cache',
        baseRoute: 	'/appservices/cache',
        routes: [
            {method: 'get', 	path: '/appservices/cache/getloglevel', 	service: 'getLogLevel'},
            {method: 'get', 	path: '/appservices/cache/setloglevel',		service: 'setLogLevel'}
        ]
    }
]