/**-----------------------------------------------------------------------------
 * jsonResWriter.js:  Node.js module that provides functions to send OTS JSON response
 * 
 * Author    :  AFP2web Team
 * Copyright :  (C) 2014 by Maas Holding GmbH
 * Email     :  support@oxseed.de
 * Version   :  V1.0.0
 * 
 * History
 *  V100   15.10.2014  Initial release
 *
 *----------------------------------------------------------------------------*/
'use strict';

var log4js      = require('log4js')
  , npsServer   = require('../server')    
  , npsConf 		= npsServer.npsConf				// server-conf.js of oxs-xxx-server
  , npsLogFile 	= npsServer.npsLogFile
  , utils 		= require('./utils')

// Get Logger
var logger = log4js.getLogger('jsonResWriter');
utils.log4jsSetLogLevel(logger, (utils.getAppLogLevel(npsConf.log) || 'INFO'));

/**
 * Send JSON Success Response
 */
exports.sendJSONResponse = function(res, httpStatus, resData, resStatus, resStatusDesc){
	return _sendJSONResponse(res, httpStatus, resData, resStatus, resStatusDesc);
}

/**
 * Send JSON Error Response
 */
exports.sendJSONError = function(res, httpStatus, resData, resStatusDesc){
	return _sendJSONResponse(res, httpStatus, resData, 'Error', resStatusDesc);
}

/**
 * Low Level method  to send JSON  Response
 */
function _sendJSONResponse(res, httpStatus, resData, resStatus, resStatusDesc){

	// Assert resData, resStatus & resStatusDesc
	resData = resData || {};
	resStatus = resStatus || '';
	resStatusDesc = resStatusDesc || '';

	var jsonResp={
		"ResponseMessage":{
		"responseData":              resData,
		"responseStatus":            resStatus,  
		"responseStatusDescription": resStatusDesc
		}
	};

	var resp = JSON.stringify(jsonResp);
	res.setHeader('content-type', 'application/json');
	
	res.setHeader('Content-Length', utils.strLength(resp)); 
	//res.setHeader('Content-Length', resp.length);

	res.status(httpStatus).end(resp);	

/*!!! The call should log the 'over' info
	// Async Trans., Sync Trans. or Status Req. or ?
	var functionName = res._Context.transType + 'Transform';
	if(res._Context.transType === 'status'){
		functionName = res._Context.transType;
	}
	logger.info('--->' + functionName + ': Req. id=' + res._Context.reqId + ', HTTP JSON Response sent back, over');
*/	
}