/**-----------------------------------------------------------------------------
 * mochatest.js: 	Node.js module to test plugins and core functionality
 *
 * Author    :  AFP2web Team
 * Copyright :  (C) 2015 by Maas Holding GmbH
 * Email     :  support@oxseed.de
 * Version   :  V1.0.0
 * 
 * History
 *  
 *  
 *----------------------------------------------------------------------------*/
'use strict';

var NAME 		= 'mochatest'
  , VERSION 	= '2.0.0'
  , fs 			= require('fs')
  , path 		= require('path')
  , log4js 		= require('log4js') 
  ,	async 		= require('async')
  , mocha 		= require('mocha')
  , npsServer	= require('./server')
  , npsConf 	= npsServer.npsConf					// holds the configuration of the Server 
  , npsDir  	= npsServer.npsDir
  , npsConfDir 	= npsServer.npsConfDir
  , npsLogFile 	= npsServer.npsLogFile
  , pluginManager=require('./pluginManager')
  , dateFormat 	= require('./helpers/date_format')
  , utils 		= require('./helpers/utils')
  , pluginTestJSfilename = 'test/test.js'			// Mandatory js test  filename of an OXSNPS Plugin
  ;

// Add Category to Logger
log4js.addAppender(log4js.appenders.file(npsLogFile), NAME);

// Get Logger
var logger = log4js.getLogger(NAME);
utils.log4jsSetLogLevel(logger, (utils.getAppLogLevel(npsConf.log) || 'INFO'));

// Export Module Version
exports.version = VERSION;

/**
 * Test the passed plugin
 * @param  {Request}  	req Request Object
 * @param  {Response} 	res Response Object
 */
exports.pluginTest = function(req, res) {

	logger.debug(__filename, '--->pluginTest: Testing a plugin...');

	// Add Context to the response instance
	res._Context = {};

	// Add the Current Date to the Context
	res._Context.date = new Date();

	// Add a Request Id to the Context
	res._Context.reqId = utils.buildReqId(res._Context.date);

	// Add the plugin name to the Context
	if(req.method === 'GET') res._Context.module = req.query.module;
	else res._Context.module = req.body.module;

	logger.info('--->pluginTest: Req. id=' + res._Context.reqId);
	logger.debug(__filename, '--->pluginTest: Req. id=' + res._Context.reqId + ', Parms: ' + (req.method === 'GET'?JSON.stringify(req.query):JSON.stringify(req.body)));

	exports.pluginTestService(res, function(err, result){
		if(err){
			logger.error('--->pluginTest: Req. id=' + res._Context.reqId + ', failed, Reason: ' + err.message);
			return res.status(404).end('--->pluginTest: Req. id=' + res._Context.reqId + ', failed, Reason: ' + err.message);
		}
		return res.json(result);
	});
}

/**
 * Call the Test Service of the given plugin
 * @param  {Request} 	req      
 * @param  {Function} 	callback(err,result) result contains the JSON output of the test service
 */
exports.pluginTestService = function(res, callback){

	var fqPlugin 	= ''
	  , module 		= undefined
	  ;

	pluginManager.getModule(res._Context.module, function(err, plugin){
    	if(err) return callback(err);

		// Get the module handle
		try{
			fqPlugin = res._Context.module + '/' + pluginTestJSfilename;
			module = require(fqPlugin);
			if(!module){
				return callback(new Error('Error loading Plugin ' + fqPlugin));
			}
		}catch(err){
			return callback(new Error('Error loading Plugin ' + fqPlugin + '. Reason: ' + err.message));
		}

		// Call pluginTestService of the plugin if it exists
		if (typeof(module.testService) === "function"){
			logger.debug(__filename, '--->pluginTestService: Req. id=' + res._Context.reqId + 
									 ', Calling ' + res._Context.module + '.testService...');
			module.testService(res, callback);
		}
		else{
			logger.warn('--->pluginTestService: Req. id=' + res._Context.reqId + 
						', Plugin ' + res._Context.module + '.testService not available.');
			return callback(new Error('Plugin ' + res._Context.module + '.testService not available.'));
		}
    });

/*!!!
	// 1a. Check if res._Context.module is in the plugins list and enabled. If not, leave 
	pm.getPlugin(res._Context.module, function(err, plugin){
		if(err){
			return callback(new Error('Testing the ' + res._Context.module + ' plugin failed: ' + err.message));
		}

		// If plugin is not enabled
		if(plugin.enable && plugin.enable !== 'on'){
			return callback(new Error('Not able to test the ' + res._Context.module + ' plugin since it is not enabled.'));
		}
	});
!!!*/
}

/**
 * Set the log level of this module
 * @param  {req} 	GET req   http://localhost:1026/appservices/deploy/setloglevel?loglevel=DEBUG|INFO|ERROR
 * @param  {res}	res
 */
exports.setLogLevel = function(req, res){
	var loglevel = req.query.loglevel || 'INFO';
	utils.log4jsSetLogLevel(logger, loglevel);
	return res.end('--->setLogLevel: Log level of ' + NAME + ' set to ' + loglevel);
}

/**
 * Return the log level of this module
 * @param  {req} 	GET req   http://localhost:1026/appservices/deploy/getloglevel
 * @param  {res}	res
 */
exports.getLogLevel = function(req, res){
	logger.info('--->getLogLevel: Getting the log level of ' + NAME + '...');
	return res.end(logger.level.levelStr);
}


/******************  Private Functions ********************/	
