let path = require('path')

module.exports = {
    "desc":       "OXSNPS oxsnps-office2any plugin",
    "enable":     "on",
    "log": {
        // Available Log Levels are DEBUG, INFO, WARN and ERROR
        "level": process.env[process.env.OXSNPS_SERVER_PREFIX + "LOG_LEVEL_OXSNPS_OFFICE2ANY"] ||
                 process.env[process.env.OXSNPS_SERVER_PREFIX + "LOG_LEVEL"] ||
                 "WARN"
    },
    "routes": [
        {
            "path":     "/services/office2any/version",
            "method":   "get",
            "service":  "version"
        },
        {    
            "path":     "/services/office2any/conf",
            "method":   "get",
            "service":  "conf"
        },        
        {
            "path":     "/services/office2any/conf",
            "method":   "post",
            "service":  "conf"
        },
		{
			"path": 	"/services/office2any/transform",
			"method": 	"post",
			"service":	"transform"
		},
		{
			"path": 	"/services/office2any/ping",
			"method": 	"get",
			"service":	"ping"
		},
    ],
    "middlewares":[
        {
            "name":     "body-parser",
            "handler":  "json",
            "routes":[
                {
                    "path":     "/services/office2any/*",
                    "parms":    {limit: '25mb'}
                }
            ]
        },
        {
            "name":     "body-parser",
            "handler":  "text",
            "routes":[
                {
                    "path":     "/services/office2any/*",
                    "parms":    {type:'*/xml', limit: '25mb'}
                }
            ]
        }, 
        {
            // Add static route for <serverDir>/ci,baw
            "name":    "express",
            "handler": "static",
            "routes":[
                {
                    "path":  ["/office2any/api"],                    // define http://<host>:<port>/api to map to the physical dir defined below
                    "parms": path.join(__dirname, '..', 'swagger')    // physical dir where the files to be served are located (i.e. oxs-xxx-server/node_modules/rest.ish/swagger)
                }
            ]
        }
    ],
    
    'docExtns':     process.env[process.env.OXSNPS_SERVER_PREFIX + "O2A_DOC_EXTNS"] ?
                        process.env.OXSNPS_SERVER_PREFIX + "O2A_DOC_EXTNS" : 
                        ['doc', 'docx', 'odt', 'rtf'],

    'sheetExtns':   process.env[process.env.OXSNPS_SERVER_PREFIX + "O2A_SHEET_EXTNS"] ?      
                        process.env.OXSNPS_SERVER_PREFIX + "O2A_SHEET_EXTNS" : 
                        ['xls', 'xlsx', 'ods', 'csv'],

    'htmlExtns':   process.env[process.env.OXSNPS_SERVER_PREFIX + "O2A_HTML_EXTNS"] ?      
                        process.env.OXSNPS_SERVER_PREFIX + "O2A_HTML_EXTNS" : 
                        ['html', 'htm'],                        
    'libreOffice':{
        // Default transformation options.  It can be overridden or merged with 'transformOptions' given in HTTP API 
        'transformOptions':{
              'doc2pdf':   process.env[process.env.OXSNPS_SERVER_PREFIX + "O2A_LO_DOC2PDF_OPTIONS"] ? 
                                process.env.OXSNPS_SERVER_PREFIX + "O2A_LO_DOC2PDF_OPTIONS" : 
                                {
                                    'SelectPdfVersion': 0,      // 0 => Standard PDF v1.4, 1 = PDF/A-1
                                    'ExportFormFields': true,   // Export form fields or flatten them
                                    'MaxImageResolution': 300,  // DPI limit for images 
                                    'Quality': 75,              // JPEG Quality
                                    'TaggedPDF': true           // Export with accessibility tags
                                    // 'EncryptFile': true|false    // Password-protect the PDF
                                    // 'DocumentOpenPassword':      // Open password (used with EncryptFile=true)
                                    // 'UserPassword:               // Permissions password (used with EncryptFile=true)
                                },
                'sheet2pdf':   process.env[process.env.OXSNPS_SERVER_PREFIX + "O2A_LO_SHEET2PDF_OPTIONS"] ? 
                                process.env.OXSNPS_SERVER_PREFIX + "O2A_LO_SHEET2PDF_OPTIONS" : 
                                {
                                    'AllSheets': true,      // Export all sheets
                                    'SinglePageSheets': true,   // Force each sheet on a single page
                                    'MaxImageResolution': 300,  // DPI limit for images 
                                    'FitToWidth': true,
                                    'Orientation':'landscape',
                                  //  'PageRange':1,
                                    'Quality': 75               // JPEG Quality
                                    // 'EncryptFile': true|false    // Password-protect the PDF
                                    // 'DocumentOpenPassword':      // Open password (used with EncryptFile=true)
                                    // 'UserPassword:               // Permissions password (used with EncryptFile=true)
                                }                                
        }
    }
}
