/**-----------------------------------------------------------------------------
 * common.js:
 *
 * Common functions used by the utility services
 *
 * Author    :  AFP2web Team
 * Copyright :  (C) 2024 by Maas Holding GmbH
 * Email     :  support@maas.de
 * 
 * History
 * V100      08.04.2024    OXS-15340: Wackler: Initial release
 *----------------------------------------------------------------------------*/
'use strict'

/**
 * letiable declaration
 * @private
 */
let packageJson     = require(__dirname + '/../package.json')
  , PLUGIN_NAME     = packageJson.name
  , fs              = require('fs')
  , path            = require('path')
  , async           = require('async')
  , log4js          = require('log4js')

  , npsServer       = require('oxsnps-core/server')
  , npsName         = npsServer.npsName
  , npsVersion      = npsServer.npsVersion
  , npsTempDir      = npsServer.npsTempDir
  , npsConf         = npsServer.npsConf
  , npsConfDir      = (npsServer.appname) ? path.join(npsServer.npsConfDir, npsServer.appname) : npsServer.npsConfDir

  , utils           = require('oxsnps-core/helpers/utils')
  , httpUtils         = require('oxsnps-core/helpers/httpUtils')  
  , dateFormat      = require('oxsnps-core/helpers/date_format')
  , pluginManager   = require('oxsnps-core/pluginManager')
  , plugin          = require(path.join('..', 'oxsnps.js'))
  , pluginConf      = undefined  
  , logger          = log4js.getLogger(PLUGIN_NAME + '/common.js')  

/************ OPTIONAL PUBLIC FUNCTIONS ***********/
/**
 * Initialize
 * 
 * @param    {string}    serviceName    Service name
 */
/**
 * Initialize Plugin
 */
exports.initialize = function(callback){

    let self = this
    
    if(self._initialized) return callback()

    pluginConf = plugin.pluginConf
    utils.log4jsSetLogLevel(logger, (pluginConf.log.level || 'WARN'))      

    if(logger.isDebugEnabled()) logger.debug('--->initializing common.js...' )

    self._initialized = true
    return callback()
}

exports.setLogLevel = function(logLevel){
    utils.log4jsSetLogLevel(logger, (logLevel || 'WARN'))
}

