/**-----------------------------------------------------------------------------
 * msoffice.js: Service to use MSOffice for transformation
 *
 * Author    :  AFP2web Team
 * Copyright :  (C) 2018 by Maas Holding GmbH
 * Email     :  support@oxseed.de
 * Version   :  1.0.0
 * 
 * History
 *----------------------------------------------------------------------------*/
 'use strict'

 /**
  * letiable declaration
  * @private
  */
 let async           = require('async')
   , log4js          = require('log4js')
   , path            = require('path')
   , packageJson     = require(__dirname + '/../package.json')
   , PLUGIN_NAME     = packageJson.name
   , pluginConf      = require(__dirname + '/../conf/' + PLUGIN_NAME + '.js')
   , npsServer       = require('oxsnps-core/server')
   , npsConf         = npsServer.npsConf     
   , utils           = require('oxsnps-core/helpers/utils')
   , pluginManager   = require('oxsnps-core/pluginManager')
   , SERVICE_NAME    = "msoffice"
   , logger          = log4js.getLogger(PLUGIN_NAME + '/'+ SERVICE_NAME)
   , plugin          = require(path.join('..', 'oxsnps.js'))

utils.log4jsSetLogLevel(logger, (pluginConf.log.level || 'WARN'))
 
/* Add listener for error/ready/connect events */

 /**
  * Set Log Level
  */  
 exports.setLogLevel = function(logLevel){
     utils.log4jsSetLogLevel(logger, (logLevel || 'WARN'))
 } 
 
 /**
  * Initialize 
  */
 exports.initialize = function(callback){
 
     let self = this
     
     if(self._initialized) return 
 
     pluginConf = plugin.pluginConf
     utils.log4jsSetLogLevel(logger, (pluginConf.log.level || 'WARN'))      
     
     if(logger.isDebugEnabled()) logger.debug('--->initializing msoffice.js...' )
 
     self._initialized = true
     return  callback()  
 }
 
  /******************************* TO DO *******************************/
 /**
 * 
 * @param    {JSON}          res  Object
 *                           res._Context.o2a.parms:{
 *                              'input':{
 *                                  'filename': <Fully Qualified input filename>
 *                                  'type': Optional. Input file type like 'doc', 'docx', 'odt', 'rtf' or 'xls', 'xlsx', 'ods', 'csv'. Default it to take it from file extn
 *                                  'readOptions':{   
 *                                      'password': <Password for encrupted documents>
 *                                  }
 *                              },
 *                              'output':{
 *                                  path: <FQ output path>
 *                                  transformOptions:{     // libre office filter options given as key value pairs 
 *                                      'EncryptFile':          true | false,
 *                                      'DocumentOpenPassword': <Document Open Password>,
 *                                      'UserPassword':         <User Permissions password>,
 *                                      'SelectPdfVersion':       <0: standard, 1: PDF/A>
 *                                      ....
 *                                  }
 *                              },
 *                              'execOptions':{   // Refer to https://nodejs.org/api/child_process.html#child_processexecfilefile-args-options-callback
 *                                  'timeout': <Timeout in milliseconds before killing the process.>. Default is 60 seconds, If value is 0, process runs indefinitely and will NOT be killed automatically if in case it is hanging.
 *                                  //env: { ...process.env, LANG: 'en_US.UTF-8' },
 *                              },
 *                              'retry':{
 *                                  'count': <number of times to retry conversion>,
 *                                  'interval': <Delay in milliseconds between retry attempts>
 *                              },
 *                              engine: 'libreoffice' | 'msoffice'. Default is 'libreoffice'
 *                           }
 * @param    {Function}      callback    callback(err)
 * On Error:
 *  error object: err
 * On Suceess:
 *  res._Context.o2a.result : {
 *      'outputFilename' : <FQ outputFilename>
 *  }
 */
exports.transform = function(res, callback){
  let parms       = res._Context.o2a.parms
    , lp          = '--->transform: Req. id=' + res._Context.reqId + ', '
  
    if(logger.isDebugEnabled()) logger.debug(lp + 'parms: ' + JSON.stringify(parms))
    callback()
}
