let path	= require('path')

module.exports = {
	"enable": "on",
	"log": {
		// Available Log Levels are DEBUG, INFO and ERROR
		"level": process.env[process.env.OXSNPS_SERVER_PREFIX + "LOG_LEVEL_REST_ISH"] || 
				 process.env[process.env.OXSNPS_SERVER_PREFIX + "LOG_LEVEL"] || 
				 "WARN"
	},
	"routes": [
		{
			"path": "/services/rest.ish/version",
			"method": "get",
			"service": "version"
		},
		{	
			"path": 	"/services/rest.ish/conf",
			"method": 	"get",
			"service": 	"conf" 
		},
		{	
			"path": 	"/services/rest.ish/conf",
			"method": 	"post",
			"service": 	"conf" 
		},
		{
			"path": 	"/services/rest.ish/document/:guid?",
			"method": 	"get",
			"service": 	"getGuid"
		},
		{
			"path": 	"/services/rest.ish/document/:guid",
			"method": 	"post",
			"service": 	"createGuid"
		},
		{
			"path": 	"/services/rest.ish/document/:guid",
			"method": 	"delete",
			"service": 	"deleteGuid"
		},
		{
			"path": 	"/services/rest.ish/document/:guid/image/:imageid",
			"method": 	"post",
			"service": 	"addImage"
		},
		{
			"path": 	"/services/rest.ish/document/:guid/meta",
			"method": 	"post",
			"service": 	"addMeta"
		},
		{
			"path": 	"/services/rest.ish/document/:guid/operation/complete",
			"method": 	"post",
			"service": 	"complete"
		}
	],
	"middlewares":  [
		{
		  "name": "body-parser",
		  "handler": "json",
		  "routes":[
			{
			  "path": "/services/rest.ish/document/:guid/meta",
			  "parms": {"limit": "25mb"}  
			}
		  ]
		},
        {
			// Add static route for <serverDir>/rest.ish
			"name": "express",
            "handler": "static",
            "routes":[
                {
                    "path": ["/rest.ish/api"],					// define http://<host>:<port>/api to map to the physical dir defined below
                    "parms": path.join(__dirname,'../swagger') 	// physical dir where the files to be served are located (i.e. oxs-xxx-server/node_modules/rest.ish/swagger)
                }
            ]
        } 	
	],
	// Maximum of concurrent qpdf requests; 5 is default if HAL_REST_ISH_MAX_QPDF_REQS is not defined
	"maxOccurences": {
		"qpdf": process.env[process.env.OXSNPS_SERVER_PREFIX + "ISH_MAX_QPDF_REQS"] || 5
	}
}