let path				= require('path')
module.exports = {
    "desc": 	"qpdf client oxsnps plugin",
    "enable": 	"on",
	"log": {
		// Available Log Levels are DEBUG, INFO, WARN and ERROR
		"level": process.env[process.env.OXSNPS_SERVER_PREFIX + "LOG_LEVEL_OXSNPS_QPDFCLIENT"] ||
				process.env[process.env.OXSNPS_SERVER_PREFIX + "LOG_LEVEL"] ||
				"WARN"
	},
    "routes": [
		{
			"path": 	"/services/qpdfclient/version",
			"method": 	"get",
			"service": 	"version"
		},
		{	
			"path": 	"/services/qpdfclient/conf",
			"method": 	"get",
			"service": 	"conf"
		},		
		{
			"path": 	"/services/qpdfclient/conf",
			"method": "post",
			"service": "conf"
		},
		{
			"path": 	"/services/qpdfclient/extractattachments",    //V3.0.5 // 2.0.7
			"method": "post",
			"service": "extractAttachments"
        },          		
		{
			"path": 	"/services/qpdfclient/extractattachment",    //V3.0.5 // 2.0.7
			"method": "post",
			"service": "extractAttachment"
		}
	],
	/* Description
	"qpdf":{
		"server":{
			// oxs-qpdf-sever Server
			"hostname":	"localhost",
			// Port
			"port": 80,
			// context will be prepended to the URL as http://<server>:<port>/<context>/....
			"context": "qpdf",
			// Request Timeout in milliseconds. Default is 10000 milli seconds
			"httptimeout": 30000
		},
		'uris': {
			<API>:	<service URI in qpdf server>
		}
	}
	*/
	"qpdf": {
		"server": process.env.OXSNPS_SERVER_PREFIX + "QPDF_SERVER",
		"uris":{
			"process":		"/services/qpdf/process",
		},
		"options": process.env[process.env.OXSNPS_SERVER_PREFIX + "_QPDF_OPTIONS"] ?	//V3.0.5 //V2.0.7
					process.env.OXSNPS_SERVER_PREFIX + "_QPDF_OPTIONS" :
					{
						"listAttachments":		['--list-attachments'],		// do not specify verbose since we parse stdout to get attachment names
						"extractAttachments":	[]							// --show-attachment=<filename> will be added at runtime
					}
	},
   "middlewares":[
        {
            "name": "body-parser",
            "handler": "json",
            "routes":[
                {
                    "path": ["/services/qpdfclient/*"],
                    "parms": {"limit": "1mb"}  
                }
            ]
        },
        {
			// Add static route for oxsnps-assert plugin
			"name": "express",
            "handler": "static",
            "routes":[
                {
                    "path": ["/oxsnps-qpdfclient/api"],							// define http://<host>:<port>/api to map to the physical dir defined below
                    "parms": path.join(__dirname, '..', 'swagger') 	// physical dir where the files to be served are located (i.e. oxs-xxx-server/node_modules/rest.ish/swagger)
                }
            ]
        }        
		
    ]
}
