*   [Overview](#overview)
*   [Installation](#installation)
*   [Configuration](#configuration)
*   [Dependencies](#dependencies)
*   [Routes](#routes)
    *   [gcqImportStack](#gcqImportStack)
        *   [Request](#gcqImportStackReq)
        *   [Response](#gcqImportStackRes)
*   [Download](#download)

<a name="overview"></a>
<h2 id="overview">Overview</h2>

Plugin to custom import stack from workflow
 * Creates a Order/Process for given stack
 * Process assigned workflow will take care of importing the stack

<a name="installation"></a>
<h2 id="installation">Installation</h2>

Plugin can be installed using Node Package Manager (`npm`):
```bash
    npm install wfl.import
```

<a name="configuration"></a>
<h2 id="configuration">Configuration</h2>

Plugin configuration is maintained in conf/wfl.import.js. It contains the following properties.

|Property Name|Description|
|:--:|:--|
|module|Name of the plugin|
|desc|Plugin description|
|longDesc|Plugin long description|
|enable|Enable Flag. Values: on\|off. Default is 'off'|
|log|Log configuration to set log level. Values: DEBUG\|INFO\|ERROR. Default is 'INFO'|
|routes|Array of Routes|
|middlewares|Middlewares configuration to allow/disallow the parsing of route parameters|

<a name="dependencies"></a>
<h2 id="dependencies">Dependencies</h2>

  * None

<a name="routes"></a>
<h2 id="routes">Routes</h2>

|Path|Description|
|:--:|:--|
|/services/import/version|Returns version information of this plugin|
|/services/import/conf|Set/Get the configuration of this plugin|
|gcqImportStack|Google PubSub API to create Order/Process for the given stack|

<a name="gcqImportStack"></a>
<h3 id="gcqImportStack">gcqImportStack</h3>

 * Google PubSub API to create Order/Process for the given stack

<a name="gcqImportStackReq"></a>
<h4 id="gcqImportStackReq">Request</h4>

 * Method: PubSub
 * Subscription: <subscription name>
 * Content-Type: application/json
 * Parameter JSON:
   ```
   res._Context: {
       route: <route>, 
       message : {
          "id":   <message id>,
          "data": {
              "event":          <Event that triggered this method, Ex: RNTO means ReNameTo>,
              "fqpath":         <Fully qualified input stack dir, Ex: /mnt/shared/wackler/support.wackler/import/cargoline/job1_uploaded>,
              "patternMatches": <Array of pattern matched path elements, Ex: ["import/cargoline/job1_uploaded","cargoline", "job1","_uploaded"]>,
              "channel":        <channel as defined in config server>
          }
       }
   }
   ```

<a name="gcqImportStackRes"></a>
<h4 id="gcqImportStackRes">Response</h4>

  * None

<a name="download"></a>
<h2 id="download">Download</h2>

The source is available from
[CSR](https://source.cloud.google.com/oxs-develop-docker/modules/wfl.import).
