module.exports.getPackageJSON = function(){
    let packageJson   = require(__dirname + '/../package.json')
      , reModName     = /^(oxsnps|ci|ce|wfl)[-\.](.*)/i
      , reResult      = undefined
      , logNamePrefix = undefined

    module.exports.packageJson = {
        'name'    : packageJson.name,
        'desc'    : packageJson.description,
        'version' : packageJson.version
    }

    // Process and set simple name
    reResult = packageJson.name.match(reModName)
    if(reResult.length === 3){
        logNamePrefix = reResult[1].toUpperCase()
        module.exports.packageJson.simpleName = reResult[2].toLowerCase()
    }

    // Evaluate log name
    if(logNamePrefix && module.exports.packageJson.simpleName){
        let simpleName = module.exports.packageJson.simpleName.replace('-', '_')
        module.exports.packageJson.logName = logNamePrefix + '_' + simpleName.toUpperCase()
    }

    return
}

module.exports.getSimpleName = function(){
    // Load package json info (if not loaded already)
    if(!module.exports.packageJson) module.exports.getPackageJSON()

    return module.exports.packageJson.simpleName
}

module.exports.getLogName = function(){
    // Load package json info (if not loaded already)
    if(!module.exports.packageJson) module.exports.getPackageJSON()

    return module.exports.packageJson.logName
}

module.exports = {
    "enable":    "on",
    "log": {
        // Available Log Levels are DEBUG, INFO, WARN and ERROR
        "level": process.env[process.env.OXSNPS_SERVER_PREFIX + "LOG_LEVEL_" + exports.getLogName()] ||
                 process.env[process.env.OXSNPS_SERVER_PREFIX + "LOG_LEVEL"] ||
                 "WARN"
    },
    "routes": [
        {
            "path":     "/services/" + exports.getSimpleName() + "/version",
            "method":   "get",
            "service":  "version"
        },
        {    
            "path":     "/services/" + exports.getSimpleName() + "/conf",
            "method":   "get",
            "service":  "conf"
        },
        {
            "path":     "/services/" + exports.getSimpleName() + "/conf",
            "method":   "post",
            "service":  "conf"
        },
        // V1.0.8b Begin
        {    
            "path":     "/services/" + exports.getSimpleName() + "/resetmultiinputgroupcache",
            "method":   "get",
            "service":  "resetMultipleInputGroupCache"
        },
        {
            "path":     "/services/" + exports.getSimpleName() + "/resetmultiinputgroupcache",
            "method":   "post",
            "service":  "resetMultipleInputGroupCache"
        }
        // V1.0.8b End
    ],
    "middlewares":  [
        {
            "name": "body-parser",
            "handler": "json",
            "routes":[
                {
                    "path": "/services/" + exports.getSimpleName() + "/*",
                    "parms": {"limit": "25mb"}
                }
            ]
        },
        {
            "name": "body-parser",
            "handler": "urlencoded",
            "routes":[
                {
                    "path": "/services/" + exports.getSimpleName() + "/*",
                    "parms": {"extended":false}
                }
            ]
        }
    ]
}
