#-------------------------------------------------------------------------------
#  afp2web.pm: Scripting Facility Template Module. It is meant to be used as 
#			   a template to develop your own Scripting Facility Module.
#
#  Call:
#
#  On Windows:	afp2web.exe -q -c -doc_cold samples\insure.afp
#
#  On Unix:	./afp2web   -q -c -doc_cold samples/insure.afp
#
#  Author  : Fa. Maas
#  Date    : 2008-07-10
#  Version : 1.0.1
#
#  $V100   2005-08-01	Initial Release
#
#  $V101   2008-07-10	Extended to add script file path as module search path
#                       on "BEGIN" block
#-------------------------------------------------------------------------------

# $V101 Begin
#-----------------------------------------------------------------------
# BEGIN block of module
#
# Extends PERL module search path array (@INC) with new element having
# this script modules path in order to have better module portability
#-----------------------------------------------------------------------
BEGIN {
    #---- Fetch script filename
    my $sScriptFilenameTmp = $0;

    #---- Extract script file path from script filename
    my $sScriptFilePathTmp = "";
    if ( $sScriptFilenameTmp =~ /(.*)\/.*\.pm/ ){
        $sScriptFilePathTmp = $1;
    }

    #printf ( "Script filename: " . $0 . " Script filepath: " . $sScriptFilePathTmp . "\n" );

    if ( $sScriptFilePathTmp eq "" ){
        $sScriptFilePathTmp = ".";
    }

    #---- Add script file path to module search path
    unshift( @INC, $sScriptFilePathTmp );
}
# $V101 End

use a2w::Config;
use a2w::Document;
use a2w::Font;
use a2w::Index;
use a2w::Kernel;
use a2w::Line;
use a2w::MediumMap;
use a2w::NOP;
use a2w::Overlay;
use a2w::Page;
use a2w::PSEG;
use a2w::Text;
#-----------------------------------------------------------------------
# Initialize once per process
#-----------------------------------------------------------------------
sub initialize(){

    #---- Get Parameter of initialize( Par: a2w::Config, a2w::Kernel )
    ( $a2wConfigPar, $a2wKernelPar ) = @_;

    #---- Define boolean values
    $TRUE  = 1;	# TRUE  boolean value
    $FALSE = 0;	# FALSE boolean value

    #---- Set/Reset Logging
	$bLog = $FALSE;
	if (index( lc($a2wConfigPar->getAttribute("LoggingLevel")), "sf") >= 0 ){
		$bLog = $TRUE;
	}

    my $svScriptProcTmp = $a2wConfigPar->getAttribute("ScriptProcedure");
    my $svScriptArgsTmp	= $a2wConfigPar->getScriptArgs();
    $svIndexFilePath	= $a2wConfigPar->getIndexFilePath();
    $svOutputFilePath	= $a2wConfigPar->getOutputFilePath();
    $svDocType			= $a2wConfigPar->getAttribute("OutputFormat");
    $svSpoolFilename	= $a2wKernelPar->getSpoolFilename();

    if ( $bLog == $TRUE ){
	    print "Running $svScriptProcTmp...\n";
        print "initialize(): Processing $svSpoolFilename\n";
		print "initialize(): Args: $svScriptArgsTmp, IndexFilePath: $svIndexFilePath, OutputFilePath: $svOutputFilePath\n";
    }

    #---- Reset Page Id
    $PageId = 0;

    #---- Set AutoSplit to true
#INFO: If your AFP Spool contains Page Named Groups and Tag Logical 
#INFO: Elements (TLEs) and if you want AFP2web to automatically split
#INFO: the documents, set AutoSplit on, if not remove following line
	$a2wConfigPar->setAttribute( "AutoSplit", "on" );

    return 0;
}

#-----------------------------------------------------------------------
# InitializeDoc for each document
#-----------------------------------------------------------------------
sub initializeDoc(){

    #---- Get Parameter of initializeDoc( Par: a2w::Document )
    ($a2wDocumentPar) = @_;

	if ( $bLog == $TRUE ){
		print "initializeDoc(): DocId " . $a2wDocumentPar->getId() . "\n";
	}

    #---- Reset Page Id
    $PageId = 0;

#INFO: This is a sample for fetching the document indexes
	printDocumentIndexes();

    return 0;
}

#-----------------------------------------------------------------------
# InitializePage for each page
#-----------------------------------------------------------------------
sub initializePage(){

    #---- Get Parameter of initializePage( Par: a2w::Page )
    ($a2wPagePar) = @_;

    if ( $bLog == $TRUE ){
        print "initializePage()\n";
    }
	return 0;
}

#-----------------------------------------------------------------------
# Main entry method
# Return values:
#  	  < 0:	error
# 		0:	append page to Current Document
# 		1:	skip page
# 		2:	first page / new document
#-----------------------------------------------------------------------
sub afp2web(){

	if ( $bLog == $TRUE ){
        print "afp2web(): PageId " . $a2wPagePar->getParseId() . "\n";
	}

    $APPEND	= 0;	# append page to Current Document
    $SKIP	= 1;	# skip page
    $NEWDOC	= 2;	# new document

	#---- Set default return value
	my $svRetTmp = $APPEND; # append page to Current Document

    #---- Increment Page Id
	$PageId++;

#INFO: If you need to get Information from the Page (NOPs, TLEs, Overlays,etc...), do it here.
#INFO: If you need to add/remove Information to/from the Page, do it here.

#INFO: This is a sample for fetching the page indexes
	printPageIndexes();

    return $svRetTmp;
}

#-----------------------------------------------------------------------
# FinalizePage for each page
#-----------------------------------------------------------------------
sub finalizePage(){

    if ( $bLog == $TRUE ){
        print "finalizePage()\n";
    }
    return 0;
}

#-----------------------------------------------------------------------
# FinalizeDoc for each document
#-----------------------------------------------------------------------
sub finalizeDoc(){

    if ( $bLog == $TRUE ){
        print "finalizeDoc()\n";
    }

#INFO: If you need to write Index Files, do it here.
#INFO: If you need to post process the Output File (for example, sending 
#INFO: it to the archive, do it here.
#INFO: You'll find an example in autosplit.pm and eyecatcher.pm

    return 0;
}

#-----------------------------------------------------------------------
# Finalize once per process
#-----------------------------------------------------------------------
sub finalize(){

    if ( $bLog == $TRUE ){
        print "finalize()\n";
    }
    return 0;
}

#-----------------------------------------------------------------------
# Print Document Indexes
#-----------------------------------------------------------------------
sub printDocumentIndexes(){

    if ( $bLog == $TRUE ){
	    print "printDocumentIndexes()\n";
    }

	#---- Print Document Id
	print "DocId=" . $a2wDocumentPar->getId() . "\n";

	#---- Fetch first Document Index
	my $a2wDocIndexTmp = $a2wDocumentPar->getFirstIndex();

    #---- Add PageGroup Name
    if ( $a2wDocIndexTmp != 0 ){

        #---- Print PageGroup Name 
		print "PageGroup=" . $a2wDocIndexTmp->getIndexedObjectName() . "\n";
	}

	while ( $a2wDocIndexTmp != 0 ){

		#---- Print Index Record
		print $a2wDocIndexTmp->getName() . "=" . $a2wDocIndexTmp->getValue() . "\n";

		#---- Fetch next Document Index
		$a2wDocIndexTmp = $a2wDocumentPar->getNextIndex();
	}
}

#-----------------------------------------------------------------------
# Print Page Indexes
#-----------------------------------------------------------------------
sub printPageIndexes(){

    if ( $bLog == $TRUE ){
	    print "printPageIndexes()\n";
    }

	#---- Print Page Id
	print "PageId=$PageId\n";

    #---- Fetch first Page Index
	my $a2wPageIndexTmp = $a2wPagePar->getFirstIndex();

    while ( $a2wPageIndexTmp != 0 ){

		#---- Print Index Record
		print $a2wPageIndexTmp->getName() . "=" . $a2wPageIndexTmp->getValue() . "\n";

        #---- Fetch next Page Index
        $a2wPageIndexTmp = $a2wPagePar->getNextIndex();
    }
}
__END__
