#-------------------------------------------------------------------------------
#  autosplit.pm: Scripting Facility Module to demonstrate Autosplit functionality
#
#
#  Call:
#
#  On Windows:	afp2web.exe -q -c -doc_cold -sp:autosplit.pm samples\insure.afp
#
#  On Unix:	./afp2web   -q -c -doc_cold -sp:autosplit.pm samples/insure.afp
#
#  Author  : Fa. Maas
#  Date    : 2008-07-10
#  Version : 1.0.1
#
#  $V100   2005-08-01	Initial Release
#
#  $V101   2008-07-10	Extended to add script file path as module search path
#                       on "BEGIN" block
#-------------------------------------------------------------------------------

# $V101 Begin
#-----------------------------------------------------------------------
# BEGIN block of module
#
# Extends PERL module search path array (@INC) with new element having
# this script modules path in order to have better module portability
#-----------------------------------------------------------------------
BEGIN {
    #---- Fetch script filename
    my $sScriptFilenameTmp = $0;

    #---- Extract script file path from script filename
    my $sScriptFilePathTmp = "";
    if ( $sScriptFilenameTmp =~ /(.*)\/.*\.pm/ ){
        $sScriptFilePathTmp = $1;
    }

    #printf ( "Script filename: " . $0 . " Script filepath: " . $sScriptFilePathTmp . "\n" );

    if ( $sScriptFilePathTmp eq "" ){
        $sScriptFilePathTmp = ".";
    }

    #---- Add script file path to module search path
    unshift( @INC, $sScriptFilePathTmp );
}
# $V101 End

use a2w::Config;
use a2w::Document;
use a2w::Font;
use a2w::Index;
use a2w::Kernel;
use a2w::Line;
use a2w::MediumMap;
use a2w::NOP;
use a2w::Overlay;
use a2w::Page;
use a2w::PSEG;
use a2w::Text;
#-----------------------------------------------------------------------
# Initialize once per process
#-----------------------------------------------------------------------
sub initialize(){

    #---- Get Parameter of initialize( Par: a2w::Config, a2w::Kernel )
    ( $a2wConfigPar, $a2wKernelPar ) = @_;

    #---- Define boolean values
    $TRUE  = 1;	# TRUE  boolean value
    $FALSE = 0;	# FALSE boolean value

    #---- Set/Reset Logging
	$bLog = $FALSE;
	if (index( lc($a2wConfigPar->getAttribute("LoggingLevel")), "sf") >= 0 ){
		$bLog = $TRUE;
	}

    my $svScriptProcTmp = $a2wConfigPar->getAttribute("ScriptProcedure");
    my $svScriptArgsTmp	= $a2wConfigPar->getScriptArgs();
    $svIndexFilePath	= $a2wConfigPar->getIndexFilePath();
    $svOutputFilePath	= $a2wConfigPar->getOutputFilePath();
    $svDocType			= $a2wConfigPar->getAttribute("OutputFormat");
    $svSpoolFilename	= $a2wKernelPar->getSpoolFilename();

    if ( $bLog == $TRUE ){
	    print "Running $svScriptProcTmp...\n";
        print "initialize(): Processing $svSpoolFilename\n";
		print "initialize(): Args: $svScriptArgsTmp, IndexFilePath: $svIndexFilePath, OutputFilePath: $svOutputFilePath\n";
    }

    #---- Reset/Create Current Index List
    @IndexList = ();

    #---- Set AutoSplit on
	$a2wConfigPar->setAttribute( "AutoSplit", "on" );

    return 0;
}

#-----------------------------------------------------------------------
# InitializeDoc for each document
#-----------------------------------------------------------------------
sub initializeDoc(){

    #---- Get Parameter of initializeDoc( Par: a2w::Document )
    ($a2wDocumentPar) = @_;

	if ( $bLog == $TRUE ){
		print "initializeDoc(): DocId " . $a2wDocumentPar->getId() . "\n";
	}

    #---- Add Document Indexes to Index List
	addDocumentIndexes();

    return 0;
}

#-----------------------------------------------------------------------
# InitializePage for each page
#-----------------------------------------------------------------------
sub initializePage(){

    #---- Get Parameter of initializePage( Par: a2w::Page )
    ($a2wPagePar) = @_;

    if ( $bLog == $TRUE ){
        print "initializePage()\n";
    }
    return 0;
}

#-----------------------------------------------------------------------
# Main entry method
# Return values:
#  	  < 0:	error
# 		0:	append page to Current Document
# 		1:	skip page
# 		2:	first page / new document
#-----------------------------------------------------------------------
sub afp2web(){

	if ( $bLog == $TRUE ){
        print "afp2web(): PageId " . $a2wPagePar->getParseId() . "\n";
	}

    $APPEND	= 0;	# append page to Current Document
    $SKIP	= 1;	# skip page
    $NEWDOC	= 2;	# new document

	#---- Set default return value
	my $svRetTmp = $APPEND; # default: append page

    #---- Add Page Indexes to Index List
	addPageIndexes();

    return $svRetTmp;
}

#-----------------------------------------------------------------------
# FinalizePage for each page
#-----------------------------------------------------------------------
sub finalizePage(){

	if ( $bLog == $TRUE ){
		print "finalizePage()\n";
	}
    return 0;
}

#-----------------------------------------------------------------------
# FinalizeDoc for each document
#-----------------------------------------------------------------------
sub finalizeDoc(){

    if ( $bLog == $TRUE ){
        print "finalizeDoc()\n";
    }

	#---- Build Index Filename   
    my $svSimpleFilenameTmp = $a2wDocumentPar->getSimpleFilename();	# get document simple filename
    if ( $svSimpleFilenameTmp ne "" ){
        
        my $IndexFilenameTmp = $svIndexFilePath . $svSimpleFilenameTmp . ".idx"; # build Index Filename

        if ( $bLog == $TRUE ){
            print "Writing Index File ==> $IndexFilenameTmp\n";
        }

        #---- Write Indexes
        my $docIndexCountTmp = @IndexList;

        if ( $bLog == $TRUE ){
            print "Printing Index List\n";
            for(my $IndexPtrTmp = 0; $IndexPtrTmp < $docIndexCountTmp; $IndexPtrTmp++){
                print "Index: $IndexPtrTmp ==> @IndexList[$IndexPtrTmp]\n";
            }
        }

        #---- Open Index file
        my $svFileOpenSuccessTmp = open( fIndexFile, ">$IndexFilenameTmp" );

        if ( $svFileOpenSuccessTmp ){

            #---- Write Document Id, Type, Name, PageCount and Size
            print fIndexFile (	  "DocId="		. $a2wDocumentPar->getId() .
								", DocType="	. $svDocType .
								", DocName="	. $svOutputFilePath . $a2wDocumentPar->getOutputFilename() .
								", PageCount="	. $a2wDocumentPar->getPageCount() . 
								", Size="		. $a2wDocumentPar->getSize() . "\n");

            #---- Write Indexes
            for(my $IndexPtrTmp = 0; $IndexPtrTmp < $docIndexCountTmp; $IndexPtrTmp++){
                print fIndexFile ("@IndexList[$IndexPtrTmp]\n");
            }
            print fIndexFile ("\n");
            close( fIndexFile );
        }
		else{
			return(-999, "Unable to open index file $IndexFilenameTmp (rc=$svFileOpenSuccessTmp), leaving...");
		}

        #---- Reset Current Index List
        @IndexList = ();
    }
	else{
		return(-998, "Invalid Simple Filename for Document " . $a2wDocumentPar->getOutputFilename() . ", leaving...");
	}
    return 0;
}

#-----------------------------------------------------------------------
# Finalize once per process
#-----------------------------------------------------------------------
sub finalize(){

    if ( $bLog == $TRUE ){
        print "finalize()\n";
    }
    return 0;
}

#-----------------------------------------------------------------------
# Add Document Indexes to list
#-----------------------------------------------------------------------
sub addDocumentIndexes(){

    if ( $bLog == $TRUE ){
	    print "addDocumentIndexes()\n";
    }

    #---- Define temp variables
    my $IndexPtrTmp = @IndexList;

    #---- Fetch first Document Index
    my $a2wIndexTmp = $a2wDocumentPar->getFirstIndex();

    #---- Add PageGroup Name
    if ( $a2wIndexTmp != 0 ){

        #---- Add PageGroup Name to Index List
        @IndexList[$IndexPtrTmp++] = "PageGroup=" . $a2wIndexTmp->getIndexedObjectName();
	}

    #---- Loop thru Indexes
    while ( $a2wIndexTmp != 0 ){

        #---- Add Index Record to Index List
        @IndexList[$IndexPtrTmp++] = $a2wIndexTmp->getName() . "=" . $a2wIndexTmp->getValue();

        #---- Fetch next Document Index
        $a2wIndexTmp = $a2wDocumentPar->getNextIndex();
    }
}

#-----------------------------------------------------------------------
# Add Page Indexes to list
#-----------------------------------------------------------------------
sub addPageIndexes(){

    if ( $bLog == $TRUE ){
        print "addPageIndexes()\n";
    }

    #---- Define temp variables
    my $IndexPtrTmp = @IndexList;

	#---- Add Page Id to Index List
	@IndexList[$IndexPtrTmp++] = "Page=" . $a2wPagePar->getName();

	#---- Fetch first Page Index
	my $a2wIndexTmp = $a2wPagePar->getFirstIndex();

	#---- Loop thru Indexes
	while ( $a2wIndexTmp != 0 ){

		#---- Add Index Record to Index List
		@IndexList[$IndexPtrTmp++] = $a2wIndexTmp->getName() . "=" . $a2wIndexTmp->getValue();

		#---- Fetch next Page Index
		$a2wIndexTmp = $a2wPagePar->getNextIndex();
	}
}
__END__
