#-------------------------------------------------------------------------------
#  dumpIniParms.pm: Scripting Facility to dump Ini Parameters
#
#
#  Call:
#
#  On Windows:	afp2web.exe -q -c -doc_cold -sp:dumpIniParms.pm samples\medform.afp
#
#  On Unix:	./afp2web   -q -c -doc_cold -sp:dumpIniParms.pm samples/medform.afp
#
#  Author  : Fa. Maas
#  Date    : 2009-02-09
#  Version : 1.0.5
#
#  $V100   2005-08-01	Initial Release
#  $V101   2006-10-05  Extended with following new INI attributes
#                      - PageOutput
#                      - ScriptUnitBase
#                      - MemoryOutputStream
#                      Removed following old INI attributes
#                      - PageOut
#                      - BatchSize
#                      Modified following INI attributes
#                      - "OCDataPath" as "TempPath"
#  $V102   2008-07-10	Extended to add script file path as module search path
#                      on "BEGIN" block
#  $V103   2008-11-27	Added "ResourceGroup" attribute
#  $V104   2009-02-09	Added "ImageResizeFilter" attribute
#  $V105   2009-03-16	Added "ImageRotationFilter" attribute
#-------------------------------------------------------------------------------

# $V102 Begin
#-----------------------------------------------------------------------
# BEGIN block of module
#
# Extends PERL module search path array (@INC) with new element having
# this script modules path in order to have better module portability
#-----------------------------------------------------------------------
BEGIN {
    #---- Fetch script filename
    my $sScriptFilenameTmp = $0;

    #---- Extract script file path from script filename
    my $sScriptFilePathTmp = "";
    if ( $sScriptFilenameTmp =~ /(.*)\/.*\.pm/ ){
        $sScriptFilePathTmp = $1;
    }

    #printf ( "Script filename: " . $0 . " Script filepath: " . $sScriptFilePathTmp . "\n" );

    if ( $sScriptFilePathTmp eq "" ){
        $sScriptFilePathTmp = ".";
    }

    #---- Add script file path to module search path
    unshift( @INC, $sScriptFilePathTmp );
}
# $V102 End

use a2w::Config;
use a2w::Document;
use a2w::Font;
use a2w::Index;
use a2w::Kernel;
use a2w::Line;
use a2w::MediumMap;
use a2w::NOP;
use a2w::Overlay;
use a2w::Page;
use a2w::PSEG;
use a2w::Text;
#-----------------------------------------------------------------------
# Initialize once per process
#-----------------------------------------------------------------------
sub initialize(){

    #---- Get Parameter of initialize( Par: a2w::Config, a2w::Kernel )
    ( $a2wConfigPar, $a2wKernelPar ) = @_;

    #---- Define boolean values
    $TRUE  = 1;	# TRUE  boolean value
    $FALSE = 0;	# FALSE boolean value

    #---- Set/Reset Logging
	$bLog = $FALSE;
	if (index( lc($a2wConfigPar->getAttribute("LoggingLevel")), "sf") >= 0 ){
		$bLog = $TRUE;
	}

    my $svScriptProcTmp = $a2wConfigPar->getAttribute("ScriptProcedure");
    my $svScriptArgsTmp	= $a2wConfigPar->getScriptArgs();
    $svIndexFilePath	= $a2wConfigPar->getIndexFilePath();
    $svOutputFilePath	= $a2wConfigPar->getOutputFilePath();
    $svSpoolFilename	= $a2wKernelPar->getSpoolFilename();

    if ( $bLog == $TRUE ){
        print "initialize(): Processing $svSpoolFilename\n";
		print "initialize(): Args: $svScriptArgsTmp, IndexFilePath: $svIndexFilePath, OutputFilePath: $svOutputFilePath\n";
    }

	#---- Open Dump file
	my ($svSpoolFilenamePathTmp, $svDumpFilenameTmp) = ($svSpoolFilename =~ /^((?:.*[:\\\/])?)(.*)/s);
	$svDumpFilenameTmp = $svOutputFilePath . $svDumpFilenameTmp . ".txt";
    open( fDumpFile, ">$svDumpFilenameTmp" );
    print "Running $svScriptProcTmp: Dumping to $svDumpFilenameTmp...\n";

    my $ptrTmp = 0;
    my @iniParmListTmp = ();

    @iniParmListTmp[$ptrTmp++] = "Licensee";
    @iniParmListTmp[$ptrTmp++] = "SerialNr";
    @iniParmListTmp[$ptrTmp++] = "Title";
    @iniParmListTmp[$ptrTmp++] = "Subject";
    @iniParmListTmp[$ptrTmp++] = "Keywords";
    @iniParmListTmp[$ptrTmp++] = "Logging";
    @iniParmListTmp[$ptrTmp++] = "LoggingFont";
    @iniParmListTmp[$ptrTmp++] = "LoggingLevel";
    @iniParmListTmp[$ptrTmp++] = "ExceptionLoggingLevel";
    @iniParmListTmp[$ptrTmp++] = "LogPath";
    @iniParmListTmp[$ptrTmp++] = "ResPath";
    @iniParmListTmp[$ptrTmp++] = "CpPath";
    @iniParmListTmp[$ptrTmp++] = "CodePage";
    @iniParmListTmp[$ptrTmp++] = "OutputFilePath";
    @iniParmListTmp[$ptrTmp++] = "IndexPath";
    @iniParmListTmp[$ptrTmp++] = "IndexFormat";
    @iniParmListTmp[$ptrTmp++] = "IndexRecord";
    @iniParmListTmp[$ptrTmp++] = "PageParse";
    @iniParmListTmp[$ptrTmp++] = "Alias";
    @iniParmListTmp[$ptrTmp++] = "OutputFormat";
    @iniParmListTmp[$ptrTmp++] = "InputFormat";
    @iniParmListTmp[$ptrTmp++] = "Resolution";
    @iniParmListTmp[$ptrTmp++] = "FormatType";
    @iniParmListTmp[$ptrTmp++] = "IOMode";
    @iniParmListTmp[$ptrTmp++] = "Color";
    @iniParmListTmp[$ptrTmp++] = "PageOutput";
    @iniParmListTmp[$ptrTmp++] = "Statistic";
    @iniParmListTmp[$ptrTmp++] = "Protocol";
    @iniParmListTmp[$ptrTmp++] = "PDFCompression";
    @iniParmListTmp[$ptrTmp++] = "FileCreationMode";
    @iniParmListTmp[$ptrTmp++] = "PageLength";
    @iniParmListTmp[$ptrTmp++] = "Quietmode";
    @iniParmListTmp[$ptrTmp++] = "Creator";
    @iniParmListTmp[$ptrTmp++] = "PDFFontPath";
    @iniParmListTmp[$ptrTmp++] = "AFPFontPath";
    @iniParmListTmp[$ptrTmp++] = "MFMFontPath";
    @iniParmListTmp[$ptrTmp++] = "GenerateUniqueFile";
    @iniParmListTmp[$ptrTmp++] = "PDFDocLimits";
    @iniParmListTmp[$ptrTmp++] = "PDFUIOptions";
    @iniParmListTmp[$ptrTmp++] = "PDFWinOptions";
    @iniParmListTmp[$ptrTmp++] = "FormdefExt";
    @iniParmListTmp[$ptrTmp++] = "OverlayExt";
    @iniParmListTmp[$ptrTmp++] = "PageSegExt";
    @iniParmListTmp[$ptrTmp++] = "CharSetExt";
    @iniParmListTmp[$ptrTmp++] = "CodePageExt";
    @iniParmListTmp[$ptrTmp++] = "CodedFontExt";
    @iniParmListTmp[$ptrTmp++] = "CodePageDefaultChar";
    @iniParmListTmp[$ptrTmp++] = "LaunchPreview";
    @iniParmListTmp[$ptrTmp++] = "PKEY";
    @iniParmListTmp[$ptrTmp++] = "PKEYParam";
    @iniParmListTmp[$ptrTmp++] = "PDFBookmark";
    @iniParmListTmp[$ptrTmp++] = "MaxCols";
    @iniParmListTmp[$ptrTmp++] = "MaxRows";
    @iniParmListTmp[$ptrTmp++] = "FontMetric";
    @iniParmListTmp[$ptrTmp++] = "OverlayPath";
    @iniParmListTmp[$ptrTmp++] = "PageSegmentPath";
    @iniParmListTmp[$ptrTmp++] = "FormDefPath";    
    @iniParmListTmp[$ptrTmp++] = "Strict";
    @iniParmListTmp[$ptrTmp++] = "DocumentCount";
    @iniParmListTmp[$ptrTmp++] = "StartingDocument";
    @iniParmListTmp[$ptrTmp++] = "EndingDocument";
    @iniParmListTmp[$ptrTmp++] = "StartingPage";
    @iniParmListTmp[$ptrTmp++] = "EndingPage";
    @iniParmListTmp[$ptrTmp++] = "JPEGQuality";
    @iniParmListTmp[$ptrTmp++] = "Watermark";
    @iniParmListTmp[$ptrTmp++] = "SaveOCDataOnDisk";
    @iniParmListTmp[$ptrTmp++] = "TempPath";
    @iniParmListTmp[$ptrTmp++] = "MarkerHeight";
    @iniParmListTmp[$ptrTmp++] = "MarkerWidth";
    @iniParmListTmp[$ptrTmp++] = "ScriptArgument";
    @iniParmListTmp[$ptrTmp++] = "ScriptProcedure";
    @iniParmListTmp[$ptrTmp++] = "ScriptUnitBase";
    @iniParmListTmp[$ptrTmp++] = "ColdFormat";
    @iniParmListTmp[$ptrTmp++] = "FilenamePattern";
    @iniParmListTmp[$ptrTmp++] = "MHTNOP";
    @iniParmListTmp[$ptrTmp++] = "SkipPage";
    @iniParmListTmp[$ptrTmp++] = "SkipObjectSize";
    @iniParmListTmp[$ptrTmp++] = "PDFSecurity";
    @iniParmListTmp[$ptrTmp++] = "CMYKTORGB";
    @iniParmListTmp[$ptrTmp++] = "AutoSplit";
    @iniParmListTmp[$ptrTmp++] = "MemoryOutputStream";
	# $V103 Begin
	@iniParmListTmp[$ptrTmp++] = "ResourceGroup";
	# $V103 End
	# $V104 Begin
	@iniParmListTmp[$ptrTmp++] = "ImageResizeFilter";
	# $V104 End
	# $V105 Begin
	@iniParmListTmp[$ptrTmp++] = "ImageRotationFilter";
	# $V105 End

	my $iniParmCountTmp = @iniParmListTmp;

	print fDumpFile ("================================= Ini Parameter List =================================\n");
	for ( $ptrTmp = 0; $ptrTmp < $iniParmCountTmp; $ptrTmp++ ){
		print fDumpFile ( "\t" . @iniParmListTmp[$ptrTmp] . "=>" . $a2wConfigPar->getAttribute(@iniParmListTmp[$ptrTmp]) . "<=\n" );

	}
	print fDumpFile ("======================================================================================\n");
    close(fDumpFile);
    return 0;
}

#-----------------------------------------------------------------------
# InitializeDoc for each document
#-----------------------------------------------------------------------
sub initializeDoc(){

    #---- Get Parameter of initializeDoc( Par: a2w::Document )
    ($a2wDocumentPar) = @_;

	if ( $bLog == $TRUE ){
		print "initializeDoc(): DocId " . $a2wDocumentPar->getId() . "\n";
	}
    return 0;
}

#-----------------------------------------------------------------------
# InitializePage for each page
#-----------------------------------------------------------------------
sub initializePage(){

    #---- Get Parameter of initializePage( Par: a2w::Page )
    ($a2wPagePar) = @_;

    if ( $bLog == $TRUE ){
        print "initializePage()\n";
    }
	return 0;
}

#-----------------------------------------------------------------------
# Main entry method
# Return values:
#  	  < 0:	error
# 		0:	append page to Current Document
# 		1:	skip page
# 		2:	first page / new document
#-----------------------------------------------------------------------
sub afp2web(){

	if ( $bLog == $TRUE ){
        print "afp2web(): PageId " . $a2wPagePar->getParseId() . "\n";
	}

    $APPEND	= 0;	# append page to Current Document
    $SKIP	= 1;	# skip page
    $NEWDOC	= 2;	# new document

	#---- Set default return value
	my $svRetTmp = $SKIP; # skip page

    return $svRetTmp;
}

#-----------------------------------------------------------------------
# FinalizePage for each page
#-----------------------------------------------------------------------
sub finalizePage(){

    if ( $bLog == $TRUE ){
        print "finalizePage()\n";
    }
    return 0;
}

#-----------------------------------------------------------------------
# FinalizeDoc for each document
#-----------------------------------------------------------------------
sub finalizeDoc(){

    if ( $bLog == $TRUE ){
        print "finalizeDoc()\n";
    }
    return 0;
}

#-----------------------------------------------------------------------
# Finalize once per process
#-----------------------------------------------------------------------
sub finalize(){

    if ( $bLog == $TRUE ){
        print "finalize()\n";
    }
    return 0;
}

__END__
