/*
 * Decompiled with CFR 0.152.
 */
package de.maas.afp2web;

import de.maas.afp2web.A2WDefaultDocumentReader;
import de.maas.afp2web.A2WDefaultDocumentWriter;
import de.maas.afp2web.A2WDependencyLoader;
import de.maas.afp2web.A2WDocumentHandler;
import de.maas.afp2web.A2WDocumentObject;
import de.maas.afp2web.A2WDocumentReader;
import de.maas.afp2web.A2WDocumentWriter;
import de.maas.afp2web.A2WException;
import de.maas.afp2web.ext.A2WDocWriterForHandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public class A2WSDK {
    private static A2WSDK a2wsdkThe;
    private A2WException a2weError;
    A2WDocumentWriter a2wDocumentWriter;
    private A2WDocumentReader a2wDocumentReader;
    private String sActiveSpoolname;
    private String sCharsetName;
    A2WDocumentObject a2wDocObject;
    private static final byte A2W_OUTPUT_TIFF = 0;
    private static final byte A2W_OUTPUT_PDF = 1;
    private static final byte A2W_OUTPUT_PDFA = 2;
    private static final byte A2W_OUTPUT_ASCII = 3;
    private static final byte A2W_OUTPUT_JPEG = 4;
    private static final byte A2W_OUTPUT_PNG = 5;
    private static final byte A2W_OUTPUT_AFP = 6;
    private static final byte A2W_OUTPUT_GIF = 7;
    private static final byte A2W_OUTPUT_PCX = 8;
    private static final byte A2W_OUTPUT_HTML = 9;
    boolean bJNILog;

    public static A2WSDK getSingleton() {
        return a2wsdkThe;
    }

    private A2WException getException() {
        return this.a2weError;
    }

    public String getActiveSpoolname() {
        return this.sActiveSpoolname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int afp2web(Properties properties, ByteArrayInputStream byteArrayInputStream, ByteArrayOutputStream byteArrayOutputStream) throws A2WException {
        A2WSDK a2WSDK = this;
        synchronized (a2WSDK) {
            String string;
            String string2;
            String string3;
            String string4;
            if (byteArrayInputStream == null || byteArrayOutputStream == null) {
                return 0;
            }
            Properties properties2 = new Properties();
            properties2.putAll((Map<?, ?>)properties);
            this.sCharsetName = properties2.getProperty("JDKCharsetName");
            if (this.sCharsetName != null) {
                properties2.remove("JDKCharsetName");
            }
            if ((string4 = properties2.getProperty("NoConsoleMessage")) != null && string4.equalsIgnoreCase("on")) {
                this.setParameter("NoConsoleMessage", "on");
            }
            if ((string3 = properties2.getProperty("JNILog")) != null && string3.equalsIgnoreCase("on")) {
                this.setParameter("JNILog", "on");
                this.bJNILog = true;
                System.err.println("A2WJDK: int afp2web( Properties, ByteArrayInputStream, ByteArrayOutputStreaam )");
            }
            this.a2weError = null;
            String string5 = properties2.getProperty("IniFilePath");
            String string6 = "IniFilePath";
            if (string5 == null) {
                string6 = "IniPath";
                string5 = properties2.getProperty(string6);
            }
            if (string5 != null) {
                this.setIniPath(string5, this.sCharsetName);
                properties2.remove(string6);
            }
            if ((string2 = properties2.getProperty("IniFilename")) != null) {
                this.setParameter("IniFilename", string2);
                properties2.remove("IniFilename");
            }
            int n = this.initAFP2web();
            if (this.bJNILog) {
                System.err.println("A2WJDK: \tinitAFP2web returned: " + n);
            }
            if (n < 0 && this.a2weError != null) {
                throw this.a2weError;
            }
            long l = 1L;
            String string7 = this.getLocalizedParameter("OutputFormat");
            if (string7 != null) {
                if (string7.equalsIgnoreCase("ASCII")) {
                    l = 3L;
                } else if (string7.equalsIgnoreCase("JPEG")) {
                    l = 4L;
                } else if (string7.equalsIgnoreCase("PDFA") || string7.equalsIgnoreCase("PDF/A")) {
                    l = 2L;
                } else if (string7.equalsIgnoreCase("PNG")) {
                    l = 5L;
                } else if (string7.equalsIgnoreCase("TIFF") || string7.equalsIgnoreCase("TIF")) {
                    l = 0L;
                } else if (string7.equalsIgnoreCase("AFP")) {
                    l = 6L;
                } else if (string7.equalsIgnoreCase("GIF")) {
                    l = 7L;
                } else if (string7.equalsIgnoreCase("PCX")) {
                    l = 8L;
                } else if (string7.equalsIgnoreCase("HTML")) {
                    l = 9L;
                }
            }
            if ((string = properties2.getProperty("OutputFormat")) != null) {
                if (string.equalsIgnoreCase("ASCII")) {
                    l = 3L;
                } else if (string.equalsIgnoreCase("JPEG")) {
                    l = 4L;
                } else if (string.equalsIgnoreCase("PDFA")) {
                    l = 2L;
                } else if (string.equalsIgnoreCase("PNG")) {
                    l = 5L;
                } else if (string.equalsIgnoreCase("TIFF") || string.equalsIgnoreCase("TIF")) {
                    l = 0L;
                } else if (string.equalsIgnoreCase("AFP")) {
                    l = 6L;
                } else if (string7.equalsIgnoreCase("GIF")) {
                    l = 7L;
                } else if (string7.equalsIgnoreCase("PCX")) {
                    l = 8L;
                } else if (string7.equalsIgnoreCase("HTML")) {
                    l = 9L;
                }
                properties2.remove("OutputFormat");
            }
            this.setSDKIniParameters(properties2);
            if (this.bJNILog) {
                System.err.println("A2WJDK: \tINI parameters set on Kernel");
            }
            n = this.afp2web(l, byteArrayInputStream, byteArrayOutputStream);
            if (this.bJNILog) {
                System.err.println("A2WJDK: \tafp2web returned: " + n);
            }
            this.cleanAFP2web();
            if (this.bJNILog) {
                System.err.println("A2WJDK: \tcleanAFP2web");
            }
            if (n < 0 && this.a2weError != null) {
                throw this.a2weError;
            }
            if (this.bJNILog) {
                this.bJNILog = false;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int afp2web(Properties properties, String[] stringArray, ByteArrayOutputStream byteArrayOutputStream) throws A2WException {
        A2WSDK a2WSDK = this;
        synchronized (a2WSDK) {
            String string;
            String string2;
            String string3;
            if (stringArray == null || stringArray.length == 0 || byteArrayOutputStream == null) {
                return 0;
            }
            Properties properties2 = new Properties();
            properties2.putAll((Map<?, ?>)properties);
            this.sCharsetName = properties2.getProperty("JDKCharsetName");
            if (this.sCharsetName != null) {
                properties2.remove("JDKCharsetName");
            }
            if ((string3 = properties2.getProperty("NoConsoleMessage")) != null && string3.equalsIgnoreCase("on")) {
                this.setParameter("NoConsoleMessage", "on");
            }
            if ((string2 = properties2.getProperty("JNILog")) != null && string2.equalsIgnoreCase("on")) {
                this.setParameter("JNILog", "on");
                this.bJNILog = true;
                System.err.println("A2WJDK: \tafp2web( Properties, String[], ByteArrayOutputStream )");
            }
            this.a2weError = null;
            String string4 = properties2.getProperty("IniFilePath");
            String string5 = "IniFilePath";
            if (string4 == null) {
                string5 = "IniPath";
                string4 = properties2.getProperty(string5);
            }
            if (string4 != null) {
                this.setIniPath(string4, this.sCharsetName);
                properties2.remove(string5);
            }
            if ((string = properties2.getProperty("IniFilename")) != null) {
                this.setParameter("IniFilename", string);
                properties2.remove("IniFilename");
            }
            int n = -1;
            String string6 = properties2.getProperty("InputFormat");
            String string7 = properties2.getProperty("FileCreationMode");
            if (string6.equalsIgnoreCase("TIFFIN") && string7.equalsIgnoreCase("DOC_MERGE")) {
                String string8;
                n = this.initTIFF2PDF();
                if (this.bJNILog) {
                    System.err.println("A2WJDK: \tinitTIFF2PDF returned: " + n);
                }
                if (n < 0 && this.a2weError != null) {
                    throw this.a2weError;
                }
                long l = 1L;
                String string9 = this.getLocalizedParameter("OutputFormat");
                if (string9 != null) {
                    if (string9.equalsIgnoreCase("ASCII")) {
                        l = 3L;
                    } else if (string9.equalsIgnoreCase("JPEG")) {
                        l = 4L;
                    } else if (string9.equalsIgnoreCase("PDFA") || string9.equalsIgnoreCase("PDF/A")) {
                        l = 2L;
                    } else if (string9.equalsIgnoreCase("PNG")) {
                        l = 5L;
                    } else if (string9.equalsIgnoreCase("TIFF") || string9.equalsIgnoreCase("TIF")) {
                        l = 0L;
                    } else if (string9.equalsIgnoreCase("AFP")) {
                        l = 6L;
                    }
                }
                if ((string8 = properties2.getProperty("OutputFormat")) != null) {
                    if (string8.equalsIgnoreCase("ASCII")) {
                        l = 3L;
                    } else if (string8.equalsIgnoreCase("JPEG")) {
                        l = 4L;
                    } else if (string8.equalsIgnoreCase("PDFA")) {
                        l = 2L;
                    } else if (string8.equalsIgnoreCase("PNG")) {
                        l = 5L;
                    } else if (string8.equalsIgnoreCase("TIFF") || string8.equalsIgnoreCase("TIF")) {
                        l = 0L;
                    } else if (string9.equalsIgnoreCase("AFP")) {
                        l = 6L;
                    }
                    properties2.remove("OutputFormat");
                }
                if (l == 1L || l == 2L) {
                    this.setSDKIniParameters(properties2);
                    if (this.bJNILog) {
                        System.err.println("A2WJDK: \tINI parameters set on kernel");
                    }
                    n = this.tiff2pdf(stringArray, byteArrayOutputStream);
                    if (this.bJNILog) {
                        System.err.println("A2WJDK: \tTIFF2PDF returned: " + n);
                    }
                }
                this.cleanTIFF2PDF();
                if (this.bJNILog) {
                    System.err.println("A2WJDK: \tcleanTIFF2PDF");
                }
                if (n < 0 && this.a2weError != null) {
                    throw this.a2weError;
                }
            }
            if (this.bJNILog) {
                this.bJNILog = false;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int afp2web(Properties properties, String[] stringArray) throws A2WException {
        A2WSDK a2WSDK = this;
        synchronized (a2WSDK) {
            String string;
            String string2;
            String string3;
            if (stringArray == null || stringArray.length == 0) {
                return 0;
            }
            Properties properties2 = new Properties();
            properties2.putAll((Map<?, ?>)properties);
            this.sCharsetName = properties2.getProperty("JDKCharsetName");
            if (this.sCharsetName != null) {
                properties2.remove("JDKCharsetName");
            }
            if ((string3 = properties2.getProperty("NoConsoleMessage")) != null && string3.equalsIgnoreCase("on")) {
                this.setParameter("NoConsoleMessage", "on");
            }
            if ((string2 = properties2.getProperty("JNILog")) != null && string2.equalsIgnoreCase("on")) {
                this.setParameter("JNILog", "on");
                this.bJNILog = true;
                System.err.println("A2WJDK: afp2web( Properties, String[] )");
            }
            int n = 0;
            this.a2weError = null;
            String string4 = properties2.getProperty("IniFilePath");
            String string5 = "IniFilePath";
            if (string4 == null) {
                string5 = "IniPath";
                string4 = properties2.getProperty(string5);
            }
            if (string4 != null) {
                this.setIniPath(string4, this.sCharsetName);
                properties2.remove(string5);
            }
            if ((string = properties2.getProperty("IniFilename")) != null) {
                this.setParameter("IniFilename", string);
                properties2.remove("IniFilename");
            }
            this.setParameter("MemoryOutputStream", "off");
            properties2.remove("MemoryOutputStream");
            n = this.initAFP2webFile();
            if (this.bJNILog) {
                System.err.println("A2WJDK: \tinitAFP2webFile returned: " + n);
            }
            if (n < 0 && this.a2weError != null) {
                throw this.a2weError;
            }
            this.setSDKIniParameters(properties2);
            if (this.bJNILog) {
                System.err.println("A2WJDK: \tINI parameters set on kernel");
            }
            n = this.afp2web_f(stringArray);
            if (this.bJNILog) {
                System.err.println("A2WJDK: \tafp2web_f returned: " + n);
            }
            this.cleanAFP2webFile();
            if (this.bJNILog) {
                System.err.println("A2WJDK: \tcleanAFP2webFile");
            }
            if (n < 0 && this.a2weError != null) {
                throw this.a2weError;
            }
            if (this.bJNILog) {
                this.bJNILog = false;
            }
            return n;
        }
    }

    public int afp2web(Properties properties, String[] stringArray, A2WDocumentHandler a2WDocumentHandler) throws A2WException {
        if (a2WDocumentHandler == null) {
            throw new A2WException(-9999, "A2WDocumentHandler is null.");
        }
        A2WDocWriterForHandler a2WDocWriterForHandler = new A2WDocWriterForHandler(a2WDocumentHandler);
        int n = this.afp2web(properties, stringArray, a2WDocWriterForHandler);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int afp2web(Properties properties, String[] stringArray, A2WDocumentWriter a2WDocumentWriter) throws A2WException {
        A2WSDK a2WSDK = this;
        synchronized (a2WSDK) {
            String string;
            String string2;
            String string3;
            if (stringArray == null || stringArray.length == 0) {
                return 0;
            }
            if (a2WDocumentWriter == null) {
                throw new A2WException(-9999, "A2WDocumentWriter is null.");
            }
            Properties properties2 = new Properties();
            properties2.putAll((Map<?, ?>)properties);
            this.sCharsetName = properties2.getProperty("JDKCharsetName");
            if (this.sCharsetName != null) {
                properties2.remove("JDKCharsetName");
            }
            if ((string3 = properties2.getProperty("NoConsoleMessage")) != null && string3.equalsIgnoreCase("on")) {
                this.setParameter("NoConsoleMessage", "on");
            }
            if ((string2 = properties2.getProperty("JNILog")) != null && string2.equalsIgnoreCase("on")) {
                this.setParameter("JNILog", "on");
                this.bJNILog = true;
                System.err.println("A2WJDK: \tafp2web( Properties, String[], A2WDocumentWriter )");
            }
            int n = 0;
            String string4 = properties2.getProperty("IniFilePath");
            String string5 = "IniFilePath";
            if (string4 == null) {
                string5 = "IniPath";
                string4 = properties2.getProperty(string5);
            }
            if (string4 != null) {
                properties2.remove(string5);
            }
            if ((string = properties2.getProperty("IniFilename")) != null) {
                properties2.remove("IniFilename");
            }
            this.a2wDocumentWriter = a2WDocumentWriter;
            for (int i = 0; i < stringArray.length; ++i) {
                this.a2weError = null;
                if (string4 != null) {
                    this.setIniPath(string4, this.sCharsetName);
                }
                if (string != null) {
                    this.setParameter("IniFilename", string);
                }
                this.setActiveSpoolname(stringArray[i]);
                n = this.initCheckIn();
                if (this.bJNILog) {
                    System.err.println("A2WJDK: \tinitCheckIn returned: " + n);
                }
                if (n < 0 && this.a2weError != null) {
                    this.a2wDocumentWriter = null;
                    this.a2wDocObject = null;
                    throw this.a2weError;
                }
                this.setSDKIniParameters(properties2);
                this.setParameter("MemoryOutputStream", "on");
                if (this.bJNILog) {
                    System.err.println("A2WJDK: \tINI parameters set on kernel");
                }
                n = this.parse(stringArray[i]);
                if (this.bJNILog) {
                    System.err.println("A2WJDK: \tparse returned: " + n);
                }
                this.cleanCheckIn();
                if (this.bJNILog) {
                    System.err.println("A2WJDK: \tcleanCheckIn");
                }
                this.setActiveSpoolname(null);
                if (n >= 0 || this.a2weError == null) continue;
                this.a2wDocumentWriter = null;
                this.a2wDocObject = null;
                throw this.a2weError;
            }
            this.a2wDocumentWriter = null;
            this.a2wDocObject = null;
            if (this.bJNILog) {
                this.bJNILog = false;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int afp2web(Properties properties, InputStream[] inputStreamArray, InputStream[] inputStreamArray2, InputStream[] inputStreamArray3, InputStream[] inputStreamArray4) throws A2WException {
        A2WSDK a2WSDK = this;
        synchronized (a2WSDK) {
            int n = this.afp2webStream(properties, inputStreamArray, inputStreamArray2, inputStreamArray3, inputStreamArray4, null, false);
            return n;
        }
    }

    public int afp2web(Properties properties, InputStream[] inputStreamArray, InputStream[] inputStreamArray2, InputStream[] inputStreamArray3, InputStream[] inputStreamArray4, A2WDocumentHandler a2WDocumentHandler) throws A2WException {
        if (a2WDocumentHandler == null) {
            throw new A2WException(-9999, "A2WDocumentHandler is null.");
        }
        A2WDocWriterForHandler a2WDocWriterForHandler = new A2WDocWriterForHandler(a2WDocumentHandler);
        int n = this.afp2web(properties, inputStreamArray, inputStreamArray2, inputStreamArray3, inputStreamArray4, a2WDocWriterForHandler);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int afp2web(Properties properties, InputStream[] inputStreamArray, InputStream[] inputStreamArray2, InputStream[] inputStreamArray3, InputStream[] inputStreamArray4, A2WDocumentWriter a2WDocumentWriter) throws A2WException {
        A2WSDK a2WSDK = this;
        synchronized (a2WSDK) {
            int n = this.afp2webStream(properties, inputStreamArray, inputStreamArray2, inputStreamArray3, inputStreamArray4, a2WDocumentWriter, true);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int afp2webStream(Properties properties, InputStream[] inputStreamArray, InputStream[] inputStreamArray2, InputStream[] inputStreamArray3, InputStream[] inputStreamArray4, A2WDocumentWriter a2WDocumentWriter, boolean bl) throws A2WException {
        boolean bl2 = bl;
        if (bl2 && a2WDocumentWriter == null) {
            throw new A2WException(-9999, "A2WDocumentWriter is null.");
        }
        A2WSDK a2WSDK = this;
        synchronized (a2WSDK) {
            String string;
            String string2;
            String string3;
            if (inputStreamArray == null || inputStreamArray.length <= 0) {
                return 0;
            }
            Properties properties2 = new Properties();
            properties2.putAll((Map<?, ?>)properties);
            this.sCharsetName = properties2.getProperty("JDKCharsetName");
            if (this.sCharsetName != null) {
                properties2.remove("JDKCharsetName");
            }
            if ((string3 = properties2.getProperty("NoConsoleMessage")) != null && string3.equalsIgnoreCase("on")) {
                this.setParameter("NoConsoleMessage", "on");
            }
            if ((string2 = properties2.getProperty("JNILog")) != null && string2.equalsIgnoreCase("on")) {
                this.setParameter("JNILog", "on");
                this.bJNILog = true;
                System.err.println("A2WJDK: \tafp2web( Properties, InputStream[], InputStream[], InputStream[], InputStream[], A2WDocumentWriter, boolean )");
            }
            int n = 0;
            String string4 = properties2.getProperty("IniFilePath");
            String string5 = "IniFilePath";
            if (string4 == null) {
                string5 = "IniPath";
                string4 = properties2.getProperty(string5);
            }
            if (string4 != null) {
                properties2.remove(string5);
            }
            if ((string = properties2.getProperty("IniFilename")) != null) {
                properties2.remove("IniFilename");
            }
            InputStream inputStream = null;
            InputStream inputStream2 = null;
            InputStream inputStream3 = null;
            InputStream inputStream4 = null;
            for (int i = 0; i < inputStreamArray.length; ++i) {
                inputStream = null;
                inputStream2 = null;
                inputStream3 = null;
                inputStream4 = null;
                this.a2weError = null;
                n = 0;
                if (string4 != null) {
                    this.setIniPath(string4, this.sCharsetName);
                }
                if (string != null) {
                    this.setParameter("IniFilename", string);
                }
                if (inputStreamArray[i] != null) {
                    inputStream = inputStreamArray[i] instanceof BufferedInputStream ? inputStreamArray[i] : new BufferedInputStream(inputStreamArray[i]);
                    this.setActiveSpoolname("" + inputStream.hashCode());
                    if (inputStreamArray2 != null && i < inputStreamArray2.length && inputStreamArray2[i] != null) {
                        inputStream2 = inputStreamArray2[i] instanceof BufferedInputStream ? inputStreamArray2[i] : new BufferedInputStream(inputStreamArray2[i]);
                    }
                    if (inputStreamArray3 != null && i < inputStreamArray3.length && inputStreamArray3[i] != null) {
                        inputStream3 = inputStreamArray3[i] instanceof BufferedInputStream ? inputStreamArray3[i] : new BufferedInputStream(inputStreamArray3[i]);
                    }
                    if (inputStreamArray4 != null && i < inputStreamArray4.length && inputStreamArray4[i] != null) {
                        inputStream4 = inputStreamArray4[i] instanceof BufferedInputStream ? inputStreamArray4[i] : new BufferedInputStream(inputStreamArray4[i]);
                    }
                    n = this.initAFP2webStream(bl2);
                    if (this.bJNILog) {
                        System.err.println("A2WJDK: \tinitAFP2webStream returned: " + n);
                    }
                    if (n >= 0) {
                        this.setSDKIniParameters(properties2);
                        if (bl2) {
                            this.setParameter("MemoryOutputStream", "on");
                            this.a2wDocumentWriter = a2WDocumentWriter;
                        } else {
                            this.setParameter("MemoryOutputStream", "off");
                            this.a2wDocumentWriter = null;
                            this.a2wDocObject = null;
                        }
                        n = this.afp2web_s(inputStream, inputStream2, inputStream3, inputStream4);
                        if (this.bJNILog) {
                            System.err.println("A2WJDK: \tafp2web_s returned: " + n);
                        }
                        this.cleanAFP2webStream();
                        if (this.bJNILog) {
                            System.err.println("A2WJDK: \tcleanAFP2webStream");
                        }
                    }
                }
                this.setActiveSpoolname(null);
                if (n >= 0 || this.a2weError == null) continue;
                this.a2wDocumentWriter = null;
                this.a2wDocObject = null;
                throw this.a2weError;
            }
            this.a2wDocumentWriter = null;
            this.a2wDocObject = null;
            if (this.bJNILog) {
                this.bJNILog = false;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUniqueSystemId(Properties properties) throws A2WException {
        A2WSDK a2WSDK = this;
        synchronized (a2WSDK) {
            Object object;
            if (properties != null) {
                String string;
                String string2;
                String string3;
                object = new Properties();
                ((Properties)object).putAll((Map<?, ?>)properties);
                this.sCharsetName = ((Properties)object).getProperty("JDKCharsetName");
                if (this.sCharsetName != null) {
                    ((Properties)object).remove("JDKCharsetName");
                }
                if ((string3 = ((Properties)object).getProperty("NoConsoleMessage")) != null && string3.equalsIgnoreCase("on")) {
                    this.setParameter("NoConsoleMessage", "on");
                }
                if ((string2 = ((Properties)object).getProperty("JNILog")) != null && string2.equalsIgnoreCase("on")) {
                    this.setParameter("JNILog", "on");
                    this.bJNILog = true;
                }
                if ((string = ((Properties)object).getProperty("Macid")) != null) {
                    this.setParameter("Macid", string);
                }
            }
            this.a2weError = null;
            object = this.getUniqueSystemId();
            if (this.a2weError != null) {
                throw this.a2weError;
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int afp2web(Properties properties, String[] stringArray, A2WDocumentReader a2WDocumentReader, String string) throws A2WException {
        A2WSDK a2WSDK = this;
        synchronized (a2WSDK) {
            String string2;
            String string3;
            String string4;
            int n = -1;
            if (stringArray == null || stringArray.length == 0 || string == null) {
                return 0;
            }
            if (a2WDocumentReader == null) {
                throw new A2WException(-999, "Null A2WDocumentReader instance");
            }
            Properties properties2 = new Properties();
            properties2.putAll((Map<?, ?>)properties);
            this.sCharsetName = properties2.getProperty("JDKCharsetName");
            if (this.sCharsetName != null) {
                properties2.remove("JDKCharsetName");
            }
            if ((string4 = properties2.getProperty("NoConsoleMessage")) != null && string4.equalsIgnoreCase("on")) {
                this.setParameter("NoConsoleMessage", "on");
            }
            if ((string3 = properties2.getProperty("JNILog")) != null && string3.equalsIgnoreCase("on")) {
                this.setParameter("JNILOG", "on");
                this.bJNILog = true;
            }
            String string5 = properties2.getProperty("IniFilePath");
            String string6 = "IniFilePath";
            if (string5 == null) {
                string6 = "IniPath";
                string5 = properties2.getProperty(string6);
            }
            if (string5 != null) {
                this.setIniPath(string5, this.sCharsetName);
                properties2.remove(string6);
            }
            if ((string2 = properties2.getProperty("IniFilename")) != null) {
                this.setParameter("IniFilename", string2);
                properties2.remove("IniFilename");
            }
            this.a2wDocumentReader = a2WDocumentReader;
            n = this.initCheckOut();
            if (n < 0 && this.a2weError != null) {
                throw this.a2weError;
            }
            String string7 = properties2.getProperty("FileCreationMode");
            if (string7 != null && !string7.equalsIgnoreCase("doc_cold")) {
                properties2.setProperty("FileCreationMode", "doc_merge");
            }
            this.setSDKIniParameters(properties2);
            if (this.bJNILog) {
                System.err.println("A2WJDK: \tINI parameters set on kernel");
            }
            n = this.build(stringArray, string);
            if (this.bJNILog) {
                System.err.println("A2WJDK: \tbuild returned: " + n);
            }
            this.cleanCheckOut();
            if (this.bJNILog) {
                System.err.println("A2WJDK: \tcleanCheckOut");
            }
            if (n < 0 && this.a2weError != null) {
                throw this.a2weError;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int afp2web(Properties properties, String[] stringArray, A2WDocumentReader a2WDocumentReader, ByteArrayOutputStream byteArrayOutputStream) throws A2WException {
        A2WSDK a2WSDK = this;
        synchronized (a2WSDK) {
            String string;
            String string2;
            String string3;
            if (stringArray == null || stringArray.length == 0 || byteArrayOutputStream == null) {
                return 0;
            }
            if (a2WDocumentReader == null) {
                throw new A2WException(-999, "A2WDocumentReader is null.");
            }
            Properties properties2 = new Properties();
            properties2.putAll((Map<?, ?>)properties);
            this.sCharsetName = properties2.getProperty("JDKCharsetName");
            if (this.sCharsetName != null) {
                properties2.remove("JDKCharsetName");
            }
            if ((string3 = properties2.getProperty("NoConsoleMessage")) != null && string3.equalsIgnoreCase("on")) {
                this.setParameter("NoConsoleMessage", "on");
            }
            if ((string2 = properties2.getProperty("JNILog")) != null && string2.equalsIgnoreCase("on")) {
                this.setParameter("JNILog", "on");
                this.bJNILog = true;
                System.err.println("A2WJDK: \tafp2web( Properties, String[], ByteArrayOutputStream )");
            }
            this.a2weError = null;
            String string4 = properties2.getProperty("IniFilePath");
            String string5 = "IniFilePath";
            if (string4 == null) {
                string5 = "IniPath";
                string4 = properties2.getProperty(string5);
            }
            if (string4 != null) {
                this.setIniPath(string4, this.sCharsetName);
                properties2.remove(string5);
            }
            if ((string = properties2.getProperty("IniFilename")) != null) {
                this.setParameter("IniFilename", string);
                properties2.remove("IniFilename");
            }
            this.a2wDocumentReader = a2WDocumentReader;
            int n = this.initCheckOut();
            if (n < 0 && this.a2weError != null) {
                throw this.a2weError;
            }
            properties2.setProperty("FileCreationMode", "doc_merge");
            this.setSDKIniParameters(properties2);
            if (this.bJNILog) {
                System.err.println("A2WJDK: \tINI parameters set on kernel");
            }
            n = this.build(stringArray, byteArrayOutputStream);
            if (this.bJNILog) {
                System.err.println("A2WJDK: \tbuild returned: " + n);
            }
            this.cleanCheckOut();
            if (this.bJNILog) {
                System.err.println("A2WJDK: \tcleanCheckOut");
            }
            if (n < 0 && this.a2weError != null) {
                throw this.a2weError;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createCredit(Properties properties, String string) throws A2WException {
        A2WSDK a2WSDK = this;
        synchronized (a2WSDK) {
            String string2;
            if (string == null) {
                return 0;
            }
            long l = -1L;
            Properties properties2 = new Properties();
            properties2.putAll((Map<?, ?>)properties);
            this.sCharsetName = properties2.getProperty("JDKCharsetName");
            if (this.sCharsetName != null) {
                properties2.remove("JDKCharsetName");
            }
            if ((string2 = properties2.getProperty("JNILog")) != null && string2.equalsIgnoreCase("on")) {
                this.setParameter("JNILog", "on");
                this.bJNILog = true;
                System.err.println("A2WJDK: tafp2web_createCredit( Properties, String )");
            }
            String string3 = properties2.getProperty("IniFilePath");
            String string4 = "IniFilePath";
            if (string3 == null) {
                string4 = "IniPath";
                string3 = properties2.getProperty(string4);
            }
            if (string3 != null) {
                this.setIniPath(string3, this.sCharsetName);
                properties2.remove(string4);
            }
            this.setSDKIniParameters(properties2);
            if (this.bJNILog) {
                System.err.println("A2WJDK: \tINI parameters set on kernel");
            }
            this.a2weError = null;
            l = this.afp2web_createCredit(string);
            if (this.bJNILog) {
                System.err.println("A2WJDK: \tafp2web_createCredit returned: " + l);
            }
            return (int)l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int importCredit(Properties properties, String string) throws A2WException {
        A2WSDK a2WSDK = this;
        synchronized (a2WSDK) {
            String string2;
            if (string == null) {
                return 0;
            }
            long l = -1L;
            Properties properties2 = new Properties();
            properties2.putAll((Map<?, ?>)properties);
            this.sCharsetName = properties2.getProperty("JDKCharsetName");
            if (this.sCharsetName != null) {
                properties2.remove("JDKCharsetName");
            }
            if ((string2 = properties2.getProperty("JNILog")) != null && string2.equalsIgnoreCase("on")) {
                this.setParameter("JNILog", "on");
                this.bJNILog = true;
                System.err.println("A2WJDK: tafp2web_importCredit( Properties, String )");
            }
            String string3 = properties2.getProperty("IniFilePath");
            String string4 = "IniFilePath";
            if (string3 == null) {
                string4 = "IniPath";
                string3 = properties2.getProperty(string4);
            }
            if (string3 != null) {
                this.setIniPath(string3, this.sCharsetName);
                properties2.remove(string4);
            }
            this.setSDKIniParameters(properties2);
            if (this.bJNILog) {
                System.err.println("A2WJDK: \tINI parameters set on kernel");
            }
            l = this.afp2web_importCredit(string);
            if (this.bJNILog) {
                System.err.println("A2WJDK: \tafp2web_importCredit returned: " + l);
            }
            return (int)l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int exportCredit(Properties properties, String string) throws A2WException {
        A2WSDK a2WSDK = this;
        synchronized (a2WSDK) {
            String string2;
            if (string == null) {
                return 0;
            }
            long l = -1L;
            Properties properties2 = new Properties();
            properties2.putAll((Map<?, ?>)properties);
            this.sCharsetName = properties2.getProperty("JDKCharsetName");
            if (this.sCharsetName != null) {
                properties2.remove("JDKCharsetName");
            }
            if ((string2 = properties2.getProperty("JNILog")) != null && string2.equalsIgnoreCase("on")) {
                this.setParameter("JNILog", "on");
                this.bJNILog = true;
                System.err.println("A2WJDK: \tafp2web_exportCredit( Properties, String )");
            }
            String string3 = properties2.getProperty("IniFilePath");
            String string4 = "IniFilePath";
            if (string3 == null) {
                string4 = "IniPath";
                string3 = properties2.getProperty(string4);
            }
            if (string3 != null) {
                this.setIniPath(string3, this.sCharsetName);
                properties2.remove(string4);
            }
            this.setSDKIniParameters(properties2);
            if (this.bJNILog) {
                System.err.println("A2WJDK: \tINI parameters set on kernel");
            }
            this.a2weError = null;
            l = this.afp2web_exportCredit(string);
            if (this.bJNILog) {
                System.err.println("A2WJDK: \tafp2web_exportCredit returned: " + l);
            }
            return (int)l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int displayCredit(Properties properties, String string) throws A2WException {
        A2WSDK a2WSDK = this;
        synchronized (a2WSDK) {
            String string2;
            long l = -1L;
            Properties properties2 = new Properties();
            properties2.putAll((Map<?, ?>)properties);
            this.sCharsetName = properties2.getProperty("JDKCharsetName");
            if (this.sCharsetName != null) {
                properties2.remove("JDKCharsetName");
            }
            if ((string2 = properties2.getProperty("JNILog")) != null && string2.equalsIgnoreCase("on")) {
                this.setParameter("JNILog", "on");
                this.bJNILog = true;
                System.err.println("A2WJDK: \tafp2web_displayCredit( Properties, String )");
            }
            String string3 = properties2.getProperty("IniFilePath");
            String string4 = "IniFilePath";
            if (string3 == null) {
                string4 = "IniPath";
                string3 = properties2.getProperty(string4);
            }
            if (string3 != null) {
                this.setIniPath(string3, this.sCharsetName);
                properties2.remove(string4);
            }
            this.setSDKIniParameters(properties2);
            if (this.bJNILog) {
                System.err.println("A2WJDK: \tINI parameters set on kernel");
            }
            this.a2weError = null;
            l = this.afp2web_displayCredit(string);
            if (this.bJNILog) {
                System.err.println("A2WJDK: \tafp2web_displayCredit returned: " + l);
            }
            return (int)l;
        }
    }

    private A2WSDK() {
        this.initialize();
        this.a2weError = null;
        this.a2wDocumentWriter = null;
        this.a2wDocumentReader = null;
        this.sActiveSpoolname = null;
        this.sCharsetName = null;
        this.a2wDocObject = null;
        this.bJNILog = false;
    }

    private void setActiveSpoolname(String string) {
        this.sActiveSpoolname = string;
    }

    private int initialize() {
        this.a2wDocumentWriter = new A2WDefaultDocumentWriter();
        this.a2wDocumentReader = new A2WDefaultDocumentReader();
        return 0;
    }

    private int initAFP2web() {
        return this.initAFP2webAndSetErrorHandler();
    }

    private int initTIFF2PDF() {
        return this.initTIFF2PDFAndSetErrorHandler();
    }

    private int initAFP2webFile() {
        return this.initAFP2webFileAndSetErrorHandler();
    }

    private int initAFP2webStream(boolean bl) {
        return this.initAFP2webStreamAndSetErrorHandler(bl);
    }

    private int initCheckIn() {
        return this.initCheckInAndSetErrorHandler();
    }

    private int initCheckOut() {
        return this.initCheckOutAndSetErrorHandler();
    }

    private A2WDocumentObject readDocument(String string) {
        A2WDocumentObject a2WDocumentObject = this.a2wDocumentReader.read(string);
        return a2WDocumentObject;
    }

    private void createException(int n, String string) {
        if (this.a2weError == null) {
            this.a2weError = new A2WException(n, string);
            if (this.bJNILog) {
                System.err.println("A2WJDK: \tcreateException( " + n + ", " + string + " )");
            }
        }
    }

    private void setSDKIniParameters(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        if (enumeration != null) {
            String string = null;
            String string2 = null;
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                string2 = properties.getProperty(string);
                this.setParameter(string, string2);
            }
        }
    }

    private void cleanIndexList() {
        if (this.a2wDocObject != null) {
            this.a2wDocObject.cleanIndexList();
        }
    }

    private void cleanUserDataList() {
        if (this.a2wDocObject != null) {
            this.a2wDocObject.cleanUserDataList();
        }
    }

    private void cleanDocumentProperties() {
        if (this.a2wDocObject != null) {
            this.a2wDocObject.cleanProperties();
        }
    }

    private void addDocumentIndex(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            return;
        }
        if (this.a2wDocObject == null) {
            this.a2wDocObject = new A2WDocumentObject();
        }
        String string = null;
        if (this.sCharsetName != null) {
            try {
                string = new String(byArray, this.sCharsetName);
            }
            catch (Exception exception) {
                if (this.bJNILog) {
                    System.err.println("A2WJDK: \taddDocumentIndex( " + byArray + ", " + byArray2 + " ): Unable to create name string using given character set " + this.sCharsetName + ", creating system localized name string");
                }
                string = new String(byArray);
            }
        } else {
            string = new String(byArray);
        }
        String string2 = null;
        if (byArray2 != null) {
            if (this.sCharsetName != null) {
                try {
                    string2 = new String(byArray2, this.sCharsetName);
                }
                catch (Exception exception) {
                    if (this.bJNILog) {
                        System.err.println("A2WJDK: \taddDocumentIndex( " + byArray + ", " + byArray2 + " ): Unable to create value string using given character set " + this.sCharsetName + ", creating system localized value string");
                    }
                    string2 = new String(byArray2);
                }
            } else {
                string2 = new String(byArray2);
            }
        }
        this.a2wDocObject.addIndex(string, string2);
    }

    private void addUserData(String string, byte[] byArray) {
        if (string == null) {
            return;
        }
        if (this.a2wDocObject == null) {
            this.a2wDocObject = new A2WDocumentObject();
        }
        this.a2wDocObject.addUserData(string, byArray);
    }

    private void addDocumentProperty(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            return;
        }
        if (this.a2wDocObject == null) {
            this.a2wDocObject = new A2WDocumentObject();
        }
        String string = null;
        if (this.sCharsetName != null) {
            try {
                string = new String(byArray, this.sCharsetName);
            }
            catch (Exception exception) {
                if (this.bJNILog) {
                    System.err.println("A2WJDK: \taddDocumentProperty( " + byArray + ", " + byArray2 + " ): Unable to create name string using given character set " + this.sCharsetName + ", creating system localized name string");
                }
                string = new String(byArray);
            }
        } else {
            string = new String(byArray);
        }
        String string2 = null;
        if (byArray2 != null) {
            if (this.sCharsetName != null) {
                try {
                    string2 = new String(byArray2, this.sCharsetName);
                }
                catch (Exception exception) {
                    if (this.bJNILog) {
                        System.err.println("A2WJDK: \taddDocumentProperty( " + byArray + ", " + byArray2 + " ): Unable to create value string using given character set " + this.sCharsetName + ", creating system localized value string");
                    }
                    string2 = new String(byArray2);
                }
            } else {
                string2 = new String(byArray2);
            }
        }
        this.a2wDocObject.addProperty(string, string2);
    }

    private int handleDocument(byte[] byArray) {
        if (byArray == null || byArray.length <= 0 || this.a2wDocumentWriter == null) {
            return -1;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(byArray, 0, byArray.length);
        int n = 0;
        if (this.a2wDocObject == null) {
            this.a2wDocObject = new A2WDocumentObject();
        }
        this.a2wDocObject.setOutputStream(byteArrayOutputStream);
        n = this.a2wDocumentWriter.write(this.a2wDocObject);
        this.a2wDocObject = null;
        return n;
    }

    private int setParameter(String string, String string2) {
        int n = -1;
        int n2 = 0;
        if (this.sCharsetName != null) {
            try {
                n = this.setParameter(string, string2.getBytes(this.sCharsetName));
                n2 = 1;
            }
            catch (Exception exception) {
                if (this.bJNILog) {
                    System.err.println("A2WJDK: \tsetParameter( " + string + ", " + string2 + " ): Unable to convert value using given character set " + this.sCharsetName + ", converting value using system regional default charset");
                }
                n2 = 0;
            }
        }
        if (n2 <= 0) {
            n = this.setParameter(string, string2.getBytes());
        }
        return n;
    }

    private String getLocalizedParameter(String string) {
        byte[] byArray = this.getParameter(string);
        String string2 = null;
        if (this.sCharsetName == null) {
            string2 = new String(byArray);
        } else {
            try {
                string2 = new String(byArray, this.sCharsetName);
            }
            catch (Exception exception) {
                if (this.bJNILog) {
                    System.err.println("A2WJDK: \tgetLocalizedParameter( " + string + " ): Unable to create value string using given character set " + this.sCharsetName + ", creating system localized value string");
                }
                string2 = new String(byArray);
            }
        }
        return string2;
    }

    private byte[] getLocalizedData(String string) {
        byte[] byArray;
        block2: {
            byArray = null;
            try {
                byArray = this.sCharsetName == null ? string.getBytes() : string.getBytes(this.sCharsetName);
            }
            catch (Exception exception) {
                if (!this.bJNILog) break block2;
                System.err.println("A2WJDK: \tgetLocalizedData( " + string + " ): Unable to convert data using given character set " + this.sCharsetName + ", reason=" + exception);
            }
        }
        return byArray;
    }

    public native String getVersion();

    public native String getVersionAll();

    public native String getUniqueSystemId();

    private native void setIniPath(String var1, String var2);

    private native int setParameter(String var1, byte[] var2);

    private native byte[] getParameter(String var1);

    private native int initAFP2webAndSetErrorHandler();

    private native int afp2web(long var1, ByteArrayInputStream var3, ByteArrayOutputStream var4);

    private native int cleanAFP2web();

    private native int initAFP2webFileAndSetErrorHandler();

    private native int afp2web_f(String[] var1);

    private native int cleanAFP2webFile();

    private native int initAFP2webStreamAndSetErrorHandler(boolean var1);

    private native int afp2web_s(InputStream var1, InputStream var2, InputStream var3, InputStream var4);

    private native int cleanAFP2webStream();

    private native int initCheckInAndSetErrorHandler();

    private native int parse(String var1);

    private native int cleanCheckIn();

    private native int initTIFF2PDFAndSetErrorHandler();

    private native int tiff2pdf(String[] var1, ByteArrayOutputStream var2);

    private native int cleanTIFF2PDF();

    private native int initCheckOutAndSetErrorHandler();

    private native int build(String[] var1, String var2);

    private native int build(String[] var1, ByteArrayOutputStream var2);

    private native int cleanCheckOut();

    private native long afp2web_createCredit(String var1);

    private native long afp2web_importCredit(String var1);

    private native long afp2web_exportCredit(String var1);

    private native long afp2web_displayCredit(String var1);

    static {
        A2WDependencyLoader.load();
        a2wsdkThe = new A2WSDK();
    }
}

