/**
 * AFP2webMergeMem: Java program to convert N documents into 1 document using 
 *              buffer using AFP2web SDK
 *
 *  Author      : Fa. OXSEED
 *  Date        : 2010-11-10
 *  Version     : 1.0.4
 *
 *  $V100   2009-02-05  Initial Release
 * 
 *  $V101   2009-07-02  Extended with "-nco" option to support Coded and NonCoded Output
 *
 *  $V102   2009-09-25  Extended with "PNG" output support
 *
 *  $V103   2010-04-07  Extended with "MMD", "pd" options to support MMD input
 *
 *  $V104   2010-11-10  - Extended to turn on "Bookmark" option for PDF output to show up "CustomDocumentReader" added indexes
 *                      - Extended to auto detect output file extension based on requested output format
 *
 *  $V105   2012-03-15  Extended with "-crp" option
 *
 */
 
 /**
 * Usage :
 *
 * java -classpath .;./a2wjdk33.jar AFP2PDF [options] <AFP filename> <PDF filename>
 *
 * where options are
 * -pr:200/240/300          --> Set page resolution
 * -AFP/PDF/TIFF/JPEG/ASCII --> Output file format
 * -PDFA                    --> PDF/A output file format, Level B is default
 * -PAGE                    --> One file for each page in AFP document
 * -DOC                     --> One file for each AFP document
 * -ALL                     --> One file for all documents
 * -DOC_INDEX               --> One file for each Document Index
 * -DOC_COLD                --> Use COLD option
 * -dc                      --> Document Count - Sub Directory creation
 * -c                       --> Colored image. For PDF, JPEG, PNG and TIFF JPEG/UNCOMPRESSED
 * -G4/G4D/G3/G3D/UNCOMPRESSED/PACK/JPG/HUFFMAN/LZW --> Output TIFF format. Only for TIFF
 * -r:90,180,270            --> Page Rotation
 * -bm                      --> Create book mark for PDF files
 * -ip:C:\afp2web           --> Set ini path
 * -if:C:\afp2web\afp2web.ini --> Set ini file name
 * -rp:C:\afp2web\Resource  --> Set resource path
 * -lp:C:\afp2web\Log       --> Set log path
 * -cp:C:\afp2web\AFPCP     --> Set AFP-codepage path
 * -dcp:T1V10273            --> Code Page to be used for Indexes
 * -ap:C:\afp2web\Resource  --> Set AFP font resource path
 * -mp:C:\afp2web\AFPCP\mfm --> Set MFM font path
 * -fp:C:\afp2web\extfont   --> Set font path to additional Type1 and TrueType fonts
 * -op:C:\afp2web\pdf       --> Set output file path
 * -xp:C:\afp2web\Index     --> Set index file path
 * -ovp:C:\afp2web\Resource --> Set Overlay path
 * -psp:C:\afp2web\Resource --> Set Page Segment path
 * -fdp:C:\afp2web\Resource --> Set FormDef path
 * -sd:n                    --> Starting Document Id
 * -ed:n                    --> Ending Document Id
 * -jq:n                    --> JPEG Quality used to compress object data, where n could be 1 to 100
 * -sa:script arguments     --> Set script arguments
 * -sp:script procedure     --> Set script procedure filename
 * -fd:F1hqsd               --> Formdef to be used
 * -rf:ResFile              --> Explicit Resource File to be used
 * -xf:DocIndexFile         --> Explicit Document Index File to be used
 * -Strict                  --> Stop the process when a resource is not found
 * -p                       --> Write Protocol Information
 * -q                       --> Turn quiet mode on
 * -ncm                     --> No console message, turn on standard error redirection to file
 *                              (NOTE: Messages are redirected to "a2w_msg_<timestamp>.txt" file in system path)
 * -l                       --> Turn logging on
 * -ll:1,2,3,4,5,6,[RES|(ResType)+],[INFO|WARN|DEBUG] --> Sets the logging level.ResType is one or more out of OLY,PSEG,FNTR,CDP,MMAP,FDEF,IOB"
 * -s                       --> Write Statistics
 * -tp                      --> Set Temporary Path
 * -ell:1|2                 --> Set Exception Logging Level
 * -ps:[<OwnerPwd>][,[<UserPwd>][,[<Key Length>][,<Permission Flags>]]] --> Set PDF Security Options
 * -nocmyktorgb                 --> Pass through CMYK color images as is to PDF
 * -pk:<privatekey>        --> Private key value
 * -csn:<CharsetName>      --> Charset Name used to convert Property strings to C String.
 * -h or -?                 --> Display that help
 * -v                       --> Display version
 * -vall                    --> Display version product and its sub components
 */
 
 /**
 * Import required packages
 */
import de.maas.afp2web.A2WSDK;
import de.maas.afp2web.A2WException;
import de.maas.afp2web.A2WIniConstants;
import de.maas.afp2web.A2WDocumentReader;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

import java.util.Properties;
import java.util.ArrayList;

/**
 * AFP2webMergeMem class
 */
public class AFP2webMergeMem{
    // "afp2web.ini" parameters
    public Properties propA2WIni;

    // Filenames array
    public String[] sInputFilenames;    

    // Constructor
    public AFP2webMergeMem(){
        propA2WIni = null;
        sInputFilenames = null;        
    }

    public static void main( String[] args ){
        int iRetTmp = -1;
        try {
            AFP2webMergeMem a2wConversionEngineTmp = new AFP2webMergeMem();

            //---- Process command line options ----//
            if ( a2wConversionEngineTmp.processCommandLineOptions( args ) <= 0 ){
                System.exit( iRetTmp );
            }

            if ( a2wConversionEngineTmp.propA2WIni != null
                 && a2wConversionEngineTmp.sInputFilenames.length > 0 ){

                // Get AFP2web SDK singleton instance
                A2WSDK a2wsdkThe = A2WSDK.getSingleton();

                // Create and set document reader
                CustomDocumentReader a2wDocReaderTmp = new CustomDocumentReader();
                
                // Allocate stream to hold Output buffer 
                ByteArrayOutputStream baosOutputBufferTmp = new ByteArrayOutputStream();

                // $V104 Begin
                String sRequestedOutputFormatTmp = a2wConversionEngineTmp.propA2WIni.getProperty( A2WIniConstants.OUTPUTFORMAT );
                if (    sRequestedOutputFormatTmp.equalsIgnoreCase( "pdf" )
                     || sRequestedOutputFormatTmp.equalsIgnoreCase( "pdfa" )
                   ){
                    // Turn on bookmarks option
                    a2wConversionEngineTmp.propA2WIni.setProperty( A2WIniConstants.PDFBOOKMARK, "on" );
                }
                // $V104 End

                // Call conversion process of AFP2web SDK
                iRetTmp = a2wsdkThe.afp2web(   a2wConversionEngineTmp.propA2WIni
                                             , a2wConversionEngineTmp.sInputFilenames
                                             , a2wDocReaderTmp
                                             , baosOutputBufferTmp
                                           );
                // Fetch output buffer data
                byte[] byarrOutputTmp = baosOutputBufferTmp.toByteArray();

                // $V104 Begin
                String sOutputFileExtensionTmp = ".pdf";
                if ( sRequestedOutputFormatTmp != null ){
                    sOutputFileExtensionTmp = "." + sRequestedOutputFormatTmp.substring( 0, 3 );
                }
                // Create output file
                //FileOutputStream fosOutputTmp = new FileOutputStream("pdf/merge.pdf");
                FileOutputStream fosOutputTmp = new FileOutputStream( "pdf/merge" + sOutputFileExtensionTmp );
                // $V104 End

                // Write output data
                fosOutputTmp.write( byarrOutputTmp );

                // Close output file
                fosOutputTmp.close();
            }
        }
        catch ( A2WException a2weErrorPar ){
            iRetTmp = a2weErrorPar.getErrorCode();
            System.out.println( "[AFP2webMergeMem] Error (rc=" +
                                iRetTmp +
                                "): " +
                                a2weErrorPar.getMessage() ); 
        }
        catch ( Throwable t ){
            iRetTmp = -2;
            t.printStackTrace();
        }
        System.exit( iRetTmp );
    }


/**
     * Print usage of program
     *
     */
    private void usage(){
        System.out.println( "Usage:" );
        System.out.println( "" );
        System.out.println( "java -classpath .;./a2wjdk32.jar AFP2web [options] filename(s)" );
        System.out.println( "" );
        System.out.println( "where options are" );
        System.out.println( "-pr:200/240/300          --> Set page resolution" );
        System.out.println( "-AFP/PDF/TIFF/JPEG/ASCII --> Output file format" );
        System.out.println( "-PDFA                    --> PDF/A output file format, Level B is default" );
        System.out.println( "-PAGE                    --> One file for each page in AFP document" );
        System.out.println( "-DOC                     --> One file for each AFP document" );
        System.out.println( "-ALL                     --> One file for all documents" );
        System.out.println( "-DOC_INDEX               --> One file for each Document Index" );
        System.out.println( "-DOC_COLD                --> Use COLD option" );
        System.out.println( "-dc                      --> Document Count - Sub Directory creation" );
        System.out.println( "-c                       --> Colored image. For PDF, JPEG, PNG and TIFF JPEG/UNCOMPRESSED" );
        System.out.println( "-G4/G4D/G3/G3D/UNCOMPRESSED/PACK/JPG/HUFFMAN/LZW --> Output TIFF format. Only for TIFF" );
        System.out.println( "-r:90,180,270            --> Page Rotation" );
        System.out.println( "-bm                      --> Create book mark for PDF files" );
        System.out.println( "-ip:C:\\afp2web           --> Set ini path" );
        System.out.println( "-if:C:\\afp2web\\afp2web.ini --> Set ini file name" );
        System.out.println( "-rp:C:\\afp2web\\Resource  --> Set resource path" );
        System.out.println( "-lp:C:\\afp2web\\Log       --> Set log path" );
        System.out.println( "-cp:C:\\afp2web\\AFPCP     --> Set AFP-codepage path" );
        System.out.println( "-dcp:T1V10273            --> Code Page to be used for Indexes" );
        System.out.println( "-ap:C:\\afp2web\\Resource  --> Set AFP font resource path" );
        System.out.println( "-mp:C:\\afp2web\\AFPCP\\mfm --> Set MFM font path" );
        System.out.println( "-fp:C:\\afp2web\\extfont   --> Set font path to additional Type1 and TrueType fonts" );
        System.out.println( "-op:C:\\afp2web\\pdf       --> Set output file path" );
        System.out.println( "-xp:C:\\afp2web\\Index     --> Set index file path" );
        System.out.println( "-ovp:C:\\afp2web\\Resource --> Set Overlay path" );
        System.out.println( "-psp:C:\\afp2web\\Resource --> Set Page Segment path" );
        System.out.println( "-fdp:C:\\afp2web\\Resource --> Set FormDef path" );
        System.out.println( "-sd:n                    --> Starting Document Id" );
        System.out.println( "-ed:n                    --> Ending Document Id" );
        System.out.println( "-jq:n                    --> JPEG Quality used to compress object data, where n could be 1 to 100" );
        System.out.println( "-sa:script arguments     --> Set script arguments" );
        System.out.println( "-sp:script procedure     --> Set script procedure filename" );
        System.out.println( "-fd:F1hqsd               --> Formdef to be used" );
        System.out.println( "-rf:ResFile              --> Explicit Resource File to be used" );
        System.out.println( "-xf:DocIndexFile         --> Explicit Document Index File to be used" );
        System.out.println( "-Strict                  --> Stop the process when a resource is not found" );
        System.out.println( "-p                       --> Write Protocol Information" );
        System.out.println( "-q                       --> Turn quiet mode on" );
        // $V101 Begin
        System.out.println( "-ncm                     --> No console message, turn on standard error redirection to file" );
        System.out.println( "                             (NOTE: Messages are redirected to \"a2w_msg_<timestamp>.txt\" file in system path)" );
        // $V101 End
        System.out.println( "-l                       --> Turn logging on" );
        System.out.println( "-ll:1,2,3,4,5,6,[RES|(ResType)+],[INFO|WARN|DEBUG] --> Sets the logging level.ResType is one or more out of OLY,PSEG,FNTR,CDP,MMAP,FDEF,IOB" );
        System.out.println( "-s                       --> Write Statistics" );
        System.out.println( "-tp                      --> Set Temporary Path" );
        System.out.println( "-ell:1|2                 --> Set Exception Logging Level" );
        System.out.println( "-ps:[<OwnerPwd>][,[<UserPwd>][,[<Key Length>][,<Permission Flags>]]] --> Set PDF Security Options" );
        System.out.println( "-nocmyktorgb                 --> Pass through CMYK color images as is to PDF" );
        System.out.println( "-h or -?                 --> Display that help" );
        System.out.println( "-v                       --> Display version" );
        System.out.println( "-vall                    --> Display version product and its sub components" );
    }

    /**
     * Process command line options
     *
     * Processes command line options and updates "propA2WIni" and "sInputFilenames"
     * class attributes with appropriate details based on options
     */
    private int processCommandLineOptions( String[] sOptionsPar ){
        //---- Assert parameter ----//
        if ( sOptionsPar.length <= 0 ){
            usage();

            return -1;
        }

        ArrayList alInputFilenamesTmp = null;        

        //---- Process each options ----//
        for ( int i = 0; i < sOptionsPar.length; i++ ){
            if ( sOptionsPar[ i ].charAt( 0 ) == '-' ){                // Option
                String[] sOptionTmp = sOptionsPar[ i ].split( ":", 2 );

                // Help
                if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-h" )
                     || sOptionTmp[ 0 ].equalsIgnoreCase( "-?" ) ){
                    propA2WIni = null;
                    sInputFilenames = null;

                    usage();

                    return 0;
                }
                // Page resolution
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-pr" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.RESOLUTION, sOptionTmp[ 1 ] );
                }
                
                // $V103 Begin 
                // MMD Input Format
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-mmd" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.INPUTFORMAT, "mmd" );
                }
                // $V103 End

                // LPD Input Format
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-lpd" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.INPUTFORMAT, "lpd" );
                }

                // LPD Spool File type
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-sf" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.SPOOLFILETYPE, sOptionTmp[ 1 ] );
                }                

                // Output format (PDF)
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-pdf" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.OUTPUTFORMAT, "pdf" );
                }

                // Output format (PDF/A)
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-pdfa" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.OUTPUTFORMAT, "pdfa" );
                }

                // Output format (TIFF)
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-tif" )
                          || sOptionTmp[ 0 ].equalsIgnoreCase( "-tiff" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.OUTPUTFORMAT, "tif" );
                    if( sOptionTmp.length >= 2 ){
                            propA2WIni.setProperty( A2WIniConstants.FORMATTYPE, sOptionTmp[1] );
                    }
                }

                // TIFF Format Type 
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-g4" )
                          || sOptionTmp[ 0 ].equalsIgnoreCase( "-g4d" )
                          || sOptionTmp[ 0 ].equalsIgnoreCase( "-g3" )
                          || sOptionTmp[ 0 ].equalsIgnoreCase( "-g3d" )
                          || sOptionTmp[ 0 ].equalsIgnoreCase( "-lzw" )
                          || sOptionTmp[ 0 ].equalsIgnoreCase( "-uncompressed" )
                          || sOptionTmp[ 0 ].equalsIgnoreCase( "-pack" )
                          || sOptionTmp[ 0 ].equalsIgnoreCase( "-jpg" )
                          || sOptionTmp[ 0 ].equalsIgnoreCase( "HUFFMAN" )
                        ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }
                    String sTemp = sOptionTmp[ 0 ].substring( 1 );
                    propA2WIni.setProperty( A2WIniConstants.FORMATTYPE, sTemp );
                }

                // Output format (ASCII)
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-ascii" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.OUTPUTFORMAT, "ascii" );
                }

                // Output format (AFP)
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-afp" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.OUTPUTFORMAT, "afp" );
                }

                // Output format (JPEG)
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-jpeg" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.OUTPUTFORMAT, "jpeg" );
                    propA2WIni.setProperty( A2WIniConstants.FILECREATIONMODE, "page" );
                }

                // $V102 Begin
                // Output format (PNG)
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-png" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.OUTPUTFORMAT, "png" );
                    propA2WIni.setProperty( A2WIniConstants.FILECREATIONMODE, "page" );
                }
                // $V102 End
                
                // File creation mode (Page)
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-page" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.FILECREATIONMODE, "page" );
                }

                // File creation mode (DOC)
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-doc" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.FILECREATIONMODE, "doc" );
                }

                // File creation mode (ALL)
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-all" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.FILECREATIONMODE, "all" );
                }

                // File creation mode (Document Index)
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-doc_index" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.FILECREATIONMODE, "doc_index" );
                }
                // File creation mode (Document Cold)
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-doc_cold" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.FILECREATIONMODE, "doc_cold" );
                }

                // Document count
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-dc" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.DOCUMENTCOUNT, sOptionTmp[ 1 ] );
                }

                // Color
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-c" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.COLOR, "on" );
                }

                // Page rotation
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-r" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.PAGEROTATION, sOptionTmp[ 1 ] );
                }

                // PDF bookmark
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-bm" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.PDFBOOKMARK, "on" );
                }

                // Ini path
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-ip" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.INIPATH, sOptionTmp[ 1 ] );
                }

                // Ini filename
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-if" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.INIFILENAME, sOptionTmp[ 1 ] );
                }

                // Resource path
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-rp" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.RESPATH, sOptionTmp[ 1 ] );
                }

                // Log path
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-lp" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.LOGPATH, sOptionTmp[ 1 ] );
                }

                // CP file path
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-cp" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.CPPATH, sOptionTmp[ 1 ] );
                }

                // Default code page
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-dcp" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.CODEPAGEDEFAULTCHAR, sOptionTmp[ 1 ] );
                }

                // AFP font path list
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-ap" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.AFPFONTPATH, sOptionTmp[ 1 ] );
                }

                // External font directory
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-fp" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.EXTFONTPATH, sOptionTmp[ 1 ] );
                }

                // Output path
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-op" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.OUTPUTFILEPATH, sOptionTmp[ 1 ] );
                }

                // Index file path
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-xp" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.INDEXPATH, sOptionTmp[ 1 ] );
                }

                // Overlay path list
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-ovp" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.OVERLAYPATH, sOptionTmp[ 1 ] );
                }

                // Page segment path list
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-psp" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.PAGESEGMENTPATH, sOptionTmp[ 1 ] );
                }

                // Formdef path list
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-fdp" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.FORMDEFPATH, sOptionTmp[ 1 ] );
                }

                // Starting document
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-sd" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.STARTINGDOCUMENT, sOptionTmp[ 1 ] );
                }

                // Ending document
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-ed" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.ENDINGDOCUMENT, sOptionTmp[ 1 ] );
                }

                // JPEG quality
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-jq" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.JPEGQUALITY, sOptionTmp[ 1 ] );
                }

                // Script argument
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-sa" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.SCRIPTARGUMENT, sOptionTmp[ 1 ] );
                }

                // Script procedure
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-sp" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.SCRIPTPROCEDURE, sOptionTmp[ 1 ] );
                }

                // External formdef filename
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-fd" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.FORMDEFFILENAME, sOptionTmp[ 1 ] );
                }
                
                // $V103 Begin                
                // External pagedef filename
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-pd" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.PAGEDEFFILENAME, sOptionTmp[ 1 ] );
                }
                // $V103 End
                
                // External resource group filename
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-rf" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.RESOURCEGROUPFILENAME, sOptionTmp[ 1 ] );
                }

                // External document index filename
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-xf" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.DOCUMENTINDEXFILENAME, sOptionTmp[ 1 ] );
                }

                // Strict
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-strict" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.STRICT, "on" );
                }

                // Turn on protocol
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-p" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.PROTOCOL, "on" );
                }

                // Quiet mode
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-q" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.QUIETMODE, "on" );
                }

                // Turn on logging
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-l" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.LOGGING, "on" );
                }

                // Set Logging Level
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-ll" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.LOGGINGLEVEL, sOptionTmp[ 1 ] );
                }

                // Turn on statistics 
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-s" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.STATISTIC, "on" );
                }

                // Temporary path
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-tp" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.TEMPPATH, sOptionTmp[ 1 ] );
                }

                // Set Exception Logging Level
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-ell" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.EXCEPTIONLOGGINGLEVEL , sOptionTmp[ 1 ] );
                }

                // Set PDF Security
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-ps" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.PDFSECURITY, sOptionTmp[ 1 ] );
                }

                // Set CMYKTORGB flag on
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-nocmyktorgb" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.CMYKTORGB , "on" );
                }

                // $V101 Begin
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-nco" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.CODEDOUTPUT , "off" );
                }
                // $V101 End
                
                // Set Character Set Name
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-csn" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }
                    propA2WIni.setProperty( A2WIniConstants.JDK_CHARSETNAME, sOptionTmp[ 1 ] );
                }
                
                // Set Private Key
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-pk" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }
                    propA2WIni.setProperty( A2WIniConstants.PKEY, sOptionTmp[ 1 ] );
                }
                
                // $V101 Begin
                // Set no console message
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-ncm" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }
                    propA2WIni.setProperty( A2WIniConstants.NOCONSOLEMESSAGE, "on" );
                }
                // $V101 End
                // $V105 Begin
                // Set Credit file path
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-crp" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.CREDITFILEPATH, sOptionTmp[ 1 ] );
                }
                // $V105 End
                // Version
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-v" ) ){
                    A2WSDK a2wsdkThe = A2WSDK.getSingleton();
                    System.out.println( a2wsdkThe.getVersion() );

                    return 0;
                }

                // Version all
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-vall" ) ){
                    A2WSDK a2wsdkThe = A2WSDK.getSingleton();
                    System.out.println( a2wsdkThe.getVersionAll() );

                    return 0;
                }                
            }
            else {                                                    // Filename
                if ( alInputFilenamesTmp == null ){
                    alInputFilenamesTmp = new ArrayList();
                }
                alInputFilenamesTmp.add( sOptionsPar[ i ] );
            }
        }

        sInputFilenames = (String [])alInputFilenamesTmp.toArray( new String[ alInputFilenamesTmp.size() ] );

        return 1;
    }
}