/**
 * DisplayCredit: Java program to display credit for volume based conversion
 *
 *  Author  : Fa. OXSEED
 *  Date    : 2012-02-22
 *  Version : 1.0.0
 *
 *  $V100   2012-02-22    Initial Release 
 *
 */
 
 /**
 * Usage :
 *
 * java -classpath .;./a2wjdk42.jar DisplayCredit [options]
 *
 * where option are
 * -crd:<credit file path>      --> Display the available credit
 * -crp:<credit file path>      --> Crdit File path
 * -ip:C:\afp2web               --> Set ini path
 * -if:C:\afp2web\afp2web.ini   --> Set ini file name 
 * -h or -?                     --> Display that help
 * -v                           --> Display version
 * -vall                        --> Display version product and its sub components 
 *
 */
 
 /**
 * Import required packages
 */
import de.maas.afp2web.A2WSDK;
import de.maas.afp2web.A2WException;
import de.maas.afp2web.A2WIniConstants;

import java.util.Properties;

/**
 * Create Credit class
 */
public class DisplayCredit{
    // afp2web.ini parameters
    public Properties propA2WIni;
    
    public DisplayCredit(){
        propA2WIni = null;
    }
    
    public static void main( String[] sArrArgsPar ){
        long lRetTmp = -1;
        try{
            DisplayCredit a2wDisplayCreditTmp = new DisplayCredit();
            
            /*---- Process Command line options ----*/
            if ( a2wDisplayCreditTmp.processCommandLineOptions( sArrArgsPar ) <= 0 ){
                System.exit( (int)lRetTmp );
            }
            
            if ( a2wDisplayCreditTmp.propA2WIni != null ){
                
                // Get AFP2web SDK singleton instance
                A2WSDK a2wsdkTmp = A2WSDK.getSingleton();
                
                // Fetch Credit File path
                String sCreditFilePathTmp = a2wDisplayCreditTmp.propA2WIni.getProperty( A2WIniConstants.CREDITFILEPATH );
                
                // Invoke Display credit process of AFP2web SDK
                lRetTmp = a2wsdkTmp.displayCredit(   a2wDisplayCreditTmp.propA2WIni 
                                                   , sCreditFilePathTmp
                                                 );
            }
        }
        catch( A2WException a2weErrorPar ){
            lRetTmp = a2weErrorPar.getErrorCode();
            System.out.println(    "[AFP2web] Error (rc=" 
                                +  lRetTmp 
                                +  "): "
                                +  a2weErrorPar.getMessage()
                              );
        }
        catch( Throwable t ){
            lRetTmp = -2;
            t.printStackTrace();
        }
        
        System.exit( (int)lRetTmp );

    }
        
    /**
     * Print Usage of the program
     */
    private void usage(){
        System.out.println( "Usage:" );
        System.out.println( "" );
        System.out.println( "java -classpath .;./a2wjdk42.jar DisplayCredit [options]" );
        System.out.println( "" );
        System.out.println( "where options are" ); 
        System.out.println( "-crd                          --> Display the available credit" );
        System.out.println( "-crp:<credit File path        --> Credit File path" );
        System.out.println( "-ip:C:\\afp2web               --> Set ini path" );
        System.out.println( "-if:C:\\afp2web\\afp2web.ini  --> Set ini file name" ); 
        System.out.println( "-h or -?                      --> Display that help" );
        System.out.println( "-v                            --> Display version" );
        System.out.println( "-vall                         --> Display version product and its sub components" );
    }
        
    /**
     * Process command line options and updates propA2WIni class attribute with appropriate details based on options
     */
    private int processCommandLineOptions( String[] sArrOptionsPar ){
        // Assert the parameter
        if ( sArrOptionsPar.length <=0 ){
            usage();
            
            return -1;
        }
        
        for( int i=0; i<sArrOptionsPar.length; i++){
            if ( sArrOptionsPar[ i ].charAt( 0 ) == '-' ){                // Option
            String[] sOptionTmp = sArrOptionsPar[ i ].split( ":", 2 );

                // Help
                if (    sOptionTmp[ 0 ].equalsIgnoreCase( "-h" )
                     || sOptionTmp[ 0 ].equalsIgnoreCase( "-?" )
                   ){
                    propA2WIni = null;
                    
                    usage();

                    return 0;
                }
                // Create Credit
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-crd" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.PROCESSINGMODE, A2WIniConstants.DISPLAYCREDIT );
                    propA2WIni.setProperty( A2WIniConstants.CREDITFILEPATH, sOptionTmp[ 1 ] );
                }
                // Credit File path
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-crp" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.CREDITFILEPATH, sOptionTmp[ 1 ] );
                }
                // Ini filename
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-if" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.INIFILENAME, sOptionTmp[ 1 ] );
                } 
                // Ini path
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-ip" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.INIPATH, sOptionTmp[ 1 ] );
                }
           }
       } // for( int i=0; i<sArrOptionsPar.length; i++){
       
       return 1;
    }
}