/**
 * ExportCredit: Java program to Export the credit for volume based conversion
 *
 *  Author  : Fa. OXSEED
 *  Date    : 2012-02-22
 *  Version : 1.0.0
 *
 *  $V100   2012-02-22    Initial Release 
 *
 */
 
 /**
 * Usage :
 *
 * java -classpath .;./a2wjdk42.jar ExportCredit [options]
 *
 * where option are
 * -cre:<UCID Filename>         --> Export the Credit
 * -crp:<credit file path>      --> Credit File path
 * -ip:C:\afp2web               --> Set ini path
 * -if:C:\afp2web\afp2web.ini   --> Set ini file name 
 * -h or -?                     --> Display that help
 * -v                           --> Display version
 * -vall                        --> Display version product and its sub components 
 *
 */
 
 /**
 * Import required packages
 */
import de.maas.afp2web.A2WSDK;
import de.maas.afp2web.A2WException;
import de.maas.afp2web.A2WIniConstants;

import java.util.Properties;

/**
 * Create Credit class
 */
public class ExportCredit{
    // afp2web.ini parameters
    public Properties propA2WIni;
    
    public ExportCredit(){
        propA2WIni = null;
    }
    
    public static void main( String[] sArrArgsPar ){
        long lRetTmp = -1;
        try{
            ExportCredit a2wExportCreditTmp = new ExportCredit();
            
            /*---- Process Command line options ----*/
            if ( a2wExportCreditTmp.processCommandLineOptions( sArrArgsPar ) <= 0 ){
                System.exit( (int)lRetTmp );
            }
            
            if ( a2wExportCreditTmp.propA2WIni != null ){
                
                // Get AFP2web SDK singleton instance
                A2WSDK a2wsdkTmp = A2WSDK.getSingleton();
                
                // Fetch Voucher filename
                String sUCIDFilenameTmp = a2wExportCreditTmp.propA2WIni.getProperty( A2WIniConstants.UCIDFILENAME );
                
                if ( sUCIDFilenameTmp != null ){
                    // Invoke Export credit process of AFP2web SDK
                    lRetTmp = a2wsdkTmp.exportCredit(   a2wExportCreditTmp.propA2WIni
                                                             , sUCIDFilenameTmp
                                                           );
                }
            }
        }
        catch( A2WException a2weErrorPar ){
            lRetTmp = a2weErrorPar.getErrorCode();
            System.out.println(    "[AFP2web] Error (rc=" 
                                +  lRetTmp 
                                +  "): "
                                +  a2weErrorPar.getMessage()
                              );
        }
        catch( Throwable t ){
            lRetTmp = -2;
            t.printStackTrace();
        }
        
        System.exit( (int)lRetTmp );

    }
        
    /**
     * Print Usage of the program
     */
    private void usage(){
        System.out.println( "Usage:" );
        System.out.println( "" );
        System.out.println( "java -classpath .;./a2wjdk42.jar ExportCredit [options]" );
        System.out.println( "" );
        System.out.println( "where options are" ); 
        System.out.println( "-cre:<UCID Filename>          --> Export the Credit" );
        System.out.println( "-crp:<credit file path>       --> Credit File path" );
        System.out.println( "-ip:C:\\afp2web               --> Set ini path" );
        System.out.println( "-if:C:\\afp2web\\afp2web.ini  --> Set ini file name" ); 
        System.out.println( "-h or -?                      --> Display that help" );
        System.out.println( "-v                            --> Display version" );
        System.out.println( "-vall                         --> Display version product and its sub components" );
    }
        
    /**
     * Process command line options and updates propA2WIni class attribute with appropriate details based on options
     */
    private int processCommandLineOptions( String[] sArrOptionsPar ){
        // Assert the parameter
        if ( sArrOptionsPar.length <=0 ){
            usage();
            
            return -1;
        }
        
        for( int i=0; i<sArrOptionsPar.length; i++){
            if ( sArrOptionsPar[ i ].charAt( 0 ) == '-' ){                // Option
            String[] sOptionTmp = sArrOptionsPar[ i ].split( ":", 2 );

                // Help
                if (    sOptionTmp[ 0 ].equalsIgnoreCase( "-h" )
                     || sOptionTmp[ 0 ].equalsIgnoreCase( "-?" )
                   ){
                    propA2WIni = null;
                    
                    usage();

                    return 0;
                }
                // Create Credit
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-cre" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.PROCESSINGMODE, A2WIniConstants.EXPORTCREDIT );
                    propA2WIni.setProperty( A2WIniConstants.UCIDFILENAME, sOptionTmp[ 1 ] );
                }
                // Credit File path
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-crp" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }
                    
                    propA2WIni.setProperty( A2WIniConstants.CREDITFILEPATH, sOptionTmp[ 1 ] );
                }
                // Ini filename
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-if" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.INIFILENAME, sOptionTmp[ 1 ] );
                } 
                // Ini path
                else if ( sOptionTmp[ 0 ].equalsIgnoreCase( "-ip" ) ){
                    if ( propA2WIni == null ){
                        propA2WIni = new Properties();
                    }

                    propA2WIni.setProperty( A2WIniConstants.INIPATH, sOptionTmp[ 1 ] );
                }                
           }
       } // for( int i=0; i<sArrOptionsPar.length; i++){
       
       return 1;
    }
}