/*
 * Decompiled with CFR 0.152.
 */
package de.maas.afp2web;

import de.maas.afp2web.A2WIndex;
import de.maas.afp2web.A2WUserData;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Properties;

public class A2WDocumentObject {
    private InputStream isDataIn;
    private ByteArrayOutputStream baosDataOut;
    private LinkedList lstIndex;
    private LinkedList lstUserData;
    ListIterator lstitrIndex;
    private Properties propObject;

    public A2WDocumentObject() {
        this.initInstance();
    }

    public void setInputStream(InputStream inputStream) {
        this.isDataIn = inputStream;
    }

    void setOutputStream(ByteArrayOutputStream byteArrayOutputStream) {
        this.baosDataOut = byteArrayOutputStream;
    }

    public void setIndexList(LinkedList linkedList) {
        this.lstIndex = linkedList;
    }

    void setUserDataList(LinkedList linkedList) {
        this.lstUserData = linkedList;
    }

    public void setProperties(Properties properties) {
        this.propObject = properties;
    }

    public InputStream getInputStream() {
        return this.isDataIn;
    }

    public ByteArrayOutputStream getOutputStream() {
        return this.baosDataOut;
    }

    public LinkedList getIndexList() {
        return this.lstIndex;
    }

    public LinkedList getUserDataList() {
        return this.lstUserData;
    }

    public Properties getProperties() {
        return this.propObject;
    }

    private void initInstance() {
        this.isDataIn = null;
        this.baosDataOut = null;
        this.lstIndex = null;
        this.lstUserData = null;
        this.lstitrIndex = null;
        this.propObject = null;
    }

    private byte[] getInputStreamData() {
        byte[] byArray = null;
        try {
            if (this.isDataIn == null) {
                return null;
            }
            int n = this.isDataIn.available();
            if (n <= 0) {
                return null;
            }
            byArray = new byte[n];
            if (byArray == null) {
                return null;
            }
            this.isDataIn.read(byArray);
        }
        catch (Exception exception) {
            System.err.println("[A2WDocumentObject::getInputStreamData] Reading input stream failed" + exception);
        }
        return byArray;
    }

    void addIndex(String string, String string2) {
        if (string == null) {
            return;
        }
        A2WIndex a2WIndex = new A2WIndex(string, string2);
        if (a2WIndex != null) {
            if (this.lstIndex == null) {
                this.lstIndex = new LinkedList();
            }
            if (this.lstIndex != null) {
                this.lstIndex.add(a2WIndex);
            }
        }
    }

    void cleanIndexList() {
        this.lstIndex = null;
    }

    void addUserData(String string, byte[] byArray) {
        if (string == null) {
            return;
        }
        A2WUserData a2WUserData = new A2WUserData(string, byArray);
        if (a2WUserData != null) {
            if (this.lstUserData == null) {
                this.lstUserData = new LinkedList();
            }
            if (this.lstUserData != null) {
                this.lstUserData.add(a2WUserData);
            }
        }
    }

    void cleanUserDataList() {
        this.lstUserData = null;
    }

    private A2WIndex getFirstIndex() {
        this.lstitrIndex = null;
        if (this.lstIndex == null) {
            return null;
        }
        this.lstitrIndex = this.lstIndex.listIterator(0);
        if (this.lstitrIndex == null) {
            return null;
        }
        A2WIndex a2WIndex = null;
        if (this.lstitrIndex.hasNext()) {
            a2WIndex = (A2WIndex)this.lstitrIndex.next();
        }
        return a2WIndex;
    }

    private A2WIndex getNextIndex() {
        if (this.lstitrIndex == null) {
            return null;
        }
        A2WIndex a2WIndex = null;
        if (this.lstitrIndex.hasNext()) {
            a2WIndex = (A2WIndex)this.lstitrIndex.next();
        }
        return a2WIndex;
    }

    private void resetIndexIterator() {
        this.lstitrIndex = null;
    }

    private A2WIndex iterateIndex() {
        if (this.lstIndex == null) {
            return null;
        }
        if (this.lstitrIndex == null) {
            this.lstitrIndex = this.lstIndex.listIterator(0);
        }
        if (this.lstitrIndex == null) {
            return null;
        }
        A2WIndex a2WIndex = null;
        if (this.lstitrIndex.hasNext()) {
            a2WIndex = (A2WIndex)this.lstitrIndex.next();
        }
        return a2WIndex;
    }

    void addProperty(String string, String string2) {
        if (string == null) {
            return;
        }
        if (this.propObject == null) {
            this.propObject = new Properties();
        }
        this.propObject.setProperty(string, string2);
    }

    void cleanProperties() {
        this.propObject = null;
    }
}

