/**
 * Custom document Reader
 *
 *  Author  : Fa. OXSEED
 *  Date    : 2009-03-10
 *  Version : 1.0.0
 *  Version : 1.0.1     Extended to Add Indexe to the Document Object
 *  
 */
 
 // Import required packages
import de.maas.afp2web.A2WSDK;
import de.maas.afp2web.A2WIndex;
import de.maas.afp2web.A2WDocumentReader;
import de.maas.afp2web.A2WIniConstants;
import de.maas.afp2web.A2WDocumentObject;

import java.lang.Exception;
import java.io.FileInputStream;

import java.util.LinkedList;

/**
 * <p>
 * AFP2web SDK's default document reader.
 *
 * Stores passed document ID on file stream 
 * </p>
 */
public class CustomDocumentReader implements A2WDocumentReader{
    // Default Constructor
    public CustomDocumentReader(){
    
    }
    /**
     * Call back to read/retrieve document based on given document ID with custom definition
     *
     * <p>
     * @param sDocumentIDPar String ( java.lang.String ) based on which document will be read/retrieved 
     * <br>     
     * @return 
     * <PRE>
     *  A2WDocumentObject on Success with document details
     *  "null" on Error
     * </PRE>
     * </p>
     */    
    public A2WDocumentObject read( String sDocumentIDPar ){ 
        A2WDocumentObject a2wDocumentObjTmp = new A2WDocumentObject();
        
        if ( sDocumentIDPar != null
             && a2wDocumentObjTmp != null ){

             try{
                 FileInputStream fisDocumentIDTmp = new FileInputStream( sDocumentIDPar );
                 a2wDocumentObjTmp.setInputStream( fisDocumentIDTmp );
                 
                 // $V101 Begin
                 // Create and add index list
                 createAndAddIndexList( sDocumentIDPar, a2wDocumentObjTmp );
                 // $V101 End
             }
             catch( Exception e){
             
             }
        }    
        return a2wDocumentObjTmp;
    }
    
    // $V101 Begin
    public void createAndAddIndexList( String sDocumentIDPar, A2WDocumentObject a2wDocumentObjectPar ){
        if ( a2wDocumentObjectPar == null ){
            return;
        }

        //---- Create index list ----//
        LinkedList lstIndexTmp = new LinkedList();
        if ( lstIndexTmp == null ){
            return;
        }
        
        //---- Create index ----//
        A2WIndex a2wIndexTmp = new A2WIndex( "I_A2W_DOC_ID", sDocumentIDPar );
        lstIndexTmp.add( a2wIndexTmp );        

        // Set index list on document object
        a2wDocumentObjectPar.setIndexList( lstIndexTmp );
    }
    // $V101 End
}
