/**
 * PrintSDKVersion: Java program to print AFP2web SDK version
 *
 *  Author  : Fa. OXSEED
 *  Date    : 2005-11-18
 *  Version : 1.0.0
 *
 *  $V100   2005-11-18    Initial Release
 *
 */

/**
 * Import required packages
 */
import de.maas.afp2web.A2WSDK;

/**
 * PrintSDKVersion class
 */
public class PrintSDKVersion{

    public static void main( String[] args ){

        try {

            // Get AFP2web SDK singleton instance
            A2WSDK a2wsdkthe = A2WSDK.getSingleton();

                        if ( args.length > 0
                             && args[ 0 ].equalsIgnoreCase( "-all" ) ){
                            // Print AFP2web SDK sub component's version
                            System.out.println( a2wsdkthe.getVersionAll() );
                        }
                        else {
                            // Print AFP2web SDK version
                            System.out.println( a2wsdkthe.getVersion() );
                        }
        }
        catch ( Throwable t ){
            t.printStackTrace();
        }
    }
}
