#-------------------------------------------------------------------------------
#  a2w::blockdef::insure:
#  PERL module to define the content blocks of page/document
#
#  Author  : AFP2web Team
#
#  Date:   2023-07-31    Initial Release
#
#-------------------------------------------------------------------------------
package a2w::blockdef::insure;

#---- Define blocks ----#
my $iBlockId = 1;
%Blocks = (
    #---- Page 1 blocks ----#
	'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'          => 'logo',
		'StartAnchor' => {
            # start anchor: Image@(7329, 648) Rot=0 Name=IMAG_BLK Width=-1 Height=-1
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'IMAGE', 'CONDITION' => 'ATTR_XPOS EQ 7329' }, 
				'COND2' => { 'OBJ_TYPE'  => 'IMAGE', 'CONDITION' => 'ATTR_NAME EQ IMAG_BLK' },
				'COND3' => { 'OBJ_TYPE'  => 'IMAGE', 'CONDITION' => 'ATTR_UNIQUENAME EQ Img0001000001' }
			}
		},
		'EndAnchor'   => {
            # end anchor: Image@(7329, 648) Rot=0 Name=IMAG_BLK Width=-1 Height=-1
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'IMAGE', 'CONDITION' => 'ATTR_XPOS EQ 7329' }, 
				'COND2' => { 'OBJ_TYPE'  => 'IMAGE', 'CONDITION' => 'ATTR_NAME EQ IMAG_BLK' },
				'COND3' => { 'OBJ_TYPE'  => 'IMAGE', 'CONDITION' => 'ATTR_UNIQUENAME EQ Img0001000001' }
			}
		},
		'Width'       => 1150,
		'Quantifier'  => '*',
		'Info'        => '{ "alt": "Insurance Specialists Logo" }',
		'ContentDef'  => { 'Type' => 'Illustration' }
	}
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'          => 'companyname',
        # Region: (8450, 850) to (11550, 1720)
        'StartX'      => 8450,
        'StartY'      => 850,
        'Width'       => 3100,
        'Height'      => 870,
        'Quantifier'  => '*',
		'ContentDef'  => { 'Type' => 'Paragraph' }
	}
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'         => 'policyheader1',
		'StartAnchor' => {
            # start anchor:
            # Text@(792, 2308) Rot=0 Length=24 Text=>Disability Income Policy< SeqId=3
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 792' },
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^Disability Income Policy$/' }
			}
		},
		'EndAnchor'   => {
            # end anchor:
            # Text@(792, 2638) Rot=0 Length=26 Text=>The Preferred Professional< SeqId=4
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS GE 792' },
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^The Preferred Professional$/' }
			}
		},
		'Width'       => 4000,
		'ContentDef'  => { 'Type' => 'Paragraph' },
		'Next'        => 'companyaddress'
	}
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'         => 'companyaddress',
		'StartAnchor' => {
            # start anchor:
            # Text@(7330, 2209) Rot=0 Length=29 Text=>Insurance Specialists Company< SeqId=5
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 7330' },
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^Insurance Specialists Company$/' }
			}
		},
		'EndAnchor'   => {
            # end anchor:
            # Text@(7330, 2627) Rot=0 Length=28 Text=>Anycity, Anystate 99999-9999< SeqId=7
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 7330' },
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^Anycity, Anystate 99999-9999$/' }
			}
		},
		'Width'       => 3500,
		'ContentDef'  => { 'Type' => 'Paragraph' }
	}
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'          => 'policyintroduction',
		'StartAnchor' => {
            # start anchor: Line@(792, 3544) Rot=0 Width=80 Length=10008 SeqId=43
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'LINE', 'CONDITION' => 'ATTR_XPOS EQ 792' },
				'COND2' => { 'OBJ_TYPE'  => 'LINE', 'CONDITION' => 'ATTR_YPOS GE 3500' },
				'COND3' => { 'OBJ_TYPE'  => 'LINE', 'CONDITION' => 'ATTR_LENGTH EQ 10008' },
				'Skip'  => 1
			}
		},
		'EndAnchor'   => {
            # end anchor: Text@(792, 5353) Rot=0 Length=7 Text=>Insured< SeqId=11
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 792' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^Insured$/' },
				'Skip' => 1
			}
		},
		'Width'       => 5000,
		'ContentDef'  => { 'Type' => 'Paragraph' }
	}
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'          => 'insured1',
		'StartAnchor' => {
            # start anchor:
            # Text@(792, 5353) Rot=0 Length=7 Text=>Insured< SeqId=11
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 792' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^Insured$/' }
			}
		},
		'EndAnchor'   => {
            # end anchor:
            # Text@(792, 6097) Rot=0 Length=13 Text=>Policy Number< SeqId=13
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS GE 792' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^Policy/' },
				'Skip' => 1
			}
		},
		'Width'       => 9200,
		'ContentDef'  => { 'Type' => 'Paragraph' }
	}
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'          => 'policynumber1',
		'StartAnchor' => {
            # start anchor:
            # Text@(792, 6097) Rot=0 Length=13 Text=>Policy Number< SeqId=13
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 792' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^Policy Number$/' }
			}
		},
		'EndAnchor'   => {
            # end anchor:
            # Text@(2448, 6097) Rot=0 Length=14 Text=>324-1443255-11< SeqId=14
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 2448' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^\d{3}-\d{7}-\d{2}/' }
			}
		},
		'Width'       => 3600,
		'ContentDef'  => { 'Type' => 'Paragraph' }
	}
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'         => 'dateofissue1',
		'StartAnchor' => {
            # start anchor:
            # Text@(9048, 6097) Rot=0 Length=13 Text=>Date of Issue< SeqId=16
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS GE 9000' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^Date of Issue/' }
			}
		},
		'EndAnchor'   => {
            # end anchor:
            # Text@(9048, 6097) Rot=0 Length=13 Text=>Date of Issue< SeqId=16
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS GE 9000' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^Date of Issue/' }
			}
		},
		'ContentDef' => { 'Type' => 'Paragraph' },
		'Next'       => 'dateofissue2'
	}
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'         => 'dateofissue2',
		'StartAnchor' => {
            # start anchor:
            # Text@(7114, 6097) Rot=0 Length=8 Text=>03-25-53< SeqId=15
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS GE 7100' }, 
				'COND3' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^\d{2}-\d{2}-\d{2}$/' }
			}
		},
		'EndAnchor'   => {
            # end anchor:
            # Text@(7114, 6097) Rot=0 Length=8 Text=>03-25-53< SeqId=15
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS GE 7100' }, 
				'COND3' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^\d{2}-\d{2}-\d{2}$/' }
			}
		},
		'ContentDef' => { 'Type' => 'Paragraph' }
	}
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'          => 'policyterm1title',
		'StartAnchor' => {
            # start anchor: Text@(792, 6825) Rot=0 Length=81 Text=>NON-CANCELLABLE AND GUARANTEED CONTINUABLE TO AGE 65. NO CHANGE IN PREMIUM RATES.< SeqId=17
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 792' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^NON-CANCELLABLE/' }
			}
		},
		'EndAnchor'   => {
            # end anchor: Text@(792, 6825) Rot=0 Length=81 Text=>NON-CANCELLABLE AND GUARANTEED CONTINUABLE TO AGE 65. NO CHANGE IN PREMIUM RATES.< SeqId=17
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 792' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^NON-CANCELLABLE/' }
			}
		},
		'Width'       => 10000,
		'ContentDef'  => { 'Type' => 'Paragraph' },
	}
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'          => 'policyterm1',
		'StartAnchor' => {
            # start anchor: Text@(792, 6825) Rot=0 Length=81 Text=>NON-CANCELLABLE AND GUARANTEED CONTINUABLE TO AGE 65. NO CHANGE IN PREMIUM RATES.< SeqId=17
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 792' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^NON-CANCELLABLE/' },
				'Skip' => 1
			}
		},
		'EndAnchor'   => {
            # end anchor: Text@(792, 7822) Rot=0 Length=75 Text=>RENEWAL OPTIONS AFTER YOU REACH AGE 65. SUBJECT TO CHANGE IN PREMIUM RATES.< SeqId=20
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 792' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^RENEWAL OPTIONS/' },
				'Skip' => 1
			}
		},
		'Width'       => 10000,
		'ContentDef'  => { 'Type' => 'Paragraph' },
	}
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'          => 'policyterm2title',
		'StartAnchor' => {
            # start anchor: Text@(792, 7822) Rot=0 Length=75 Text=>RENEWAL OPTIONS AFTER YOU REACH AGE 65. SUBJECT TO CHANGE IN PREMIUM RATES.< SeqId=20
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 792' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^RENEWAL OPTIONS/' }
			}
		},
		'EndAnchor'   => {
            # end anchor: Text@(792, 7822) Rot=0 Length=75 Text=>RENEWAL OPTIONS AFTER YOU REACH AGE 65. SUBJECT TO CHANGE IN PREMIUM RATES.< SeqId=20
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 792' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^RENEWAL OPTIONS/' }
			}
		},
		'Width'       => 10000,
		'ContentDef'  => { 'Type' => 'Paragraph' },
	}
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'          => 'policyterm2',
		'StartAnchor' => {
            # start anchor: Text@(792, 7822) Rot=0 Length=75 Text=>RENEWAL OPTIONS AFTER YOU REACH AGE 65. SUBJECT TO CHANGE IN PREMIUM RATES.< SeqId=20
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 792' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^RENEWAL OPTIONS/' },
				'Skip' => 1
			}
		},
		'EndAnchor'   => {
            # end anchor: Text@(792, 9607) Rot=0 Length=21 Text=>YOUR RIGHT TO CANCEL.< SeqId=27
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 792' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^YOUR RIGHT TO CANCEL/' },
				'Skip' => 1
			}
		},
		'Width'       => 10000,
		'ContentDef'  => { 'Type' => 'Paragraph' },
	}
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'          => 'policyterm3title',
		'StartAnchor' => {
            # start anchor: Text@(792, 9607) Rot=0 Length=21 Text=>YOUR RIGHT TO CANCEL.< SeqId=27
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 792' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^YOUR RIGHT TO CANCEL/' }
			}
		},
		'EndAnchor'   => {
            # end anchor: Text@(792, 9607) Rot=0 Length=21 Text=>YOUR RIGHT TO CANCEL.< SeqId=27
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 792' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^YOUR RIGHT TO CANCEL/' }
			}
		},
		'Width'       => 4000,
		'ContentDef'  => { 'Type' => 'Paragraph' },
	}
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'          => 'policyterm3',
		'StartAnchor' => {
            # start anchor: Text@(792, 9607) Rot=0 Length=21 Text=>YOUR RIGHT TO CANCEL.< SeqId=27
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 792' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^YOUR RIGHT TO CANCEL/' },
				'Skip' => 1
			}
		},
		'EndAnchor'   => {
            # end anchor: Text@(792, 11025) Rot=0 Length=27 Text=>READ YOUR POLICY CAREFULLY.< SeqId=33
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 792' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^READ YOUR POLICY CAREFULLY/' },
				'Skip' => 1
			}
		},
		'Width'       => 10000,
		'ContentDef'  => { 'Type' => 'Paragraph' },
	}
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'          => 'policyterm4title',
		'StartAnchor' => {
            # start anchor: Text@(792, 11025) Rot=0 Length=27 Text=>READ YOUR POLICY CAREFULLY.< SeqId=33
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 792' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^READ YOUR POLICY CAREFULLY/' }
			}
		},
		'EndAnchor'   => {
            # end anchor: Text@(792, 11025) Rot=0 Length=27 Text=>READ YOUR POLICY CAREFULLY.< SeqId=33
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 792' },
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^READ YOUR POLICY CAREFULLY/' }
			}
		},
		'Width'      => 5000,
		'ContentDef' => { 'Type' => 'Paragraph' },
	}
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'          => 'policyterm4',
		'StartAnchor' => {
            # start anchor: Text@(792, 11025) Rot=0 Length=27 Text=>READ YOUR POLICY CAREFULLY.< SeqId=33
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 792' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^READ YOUR POLICY CAREFULLY/' },
				'Skip' => 1
			}
		},
		'EndAnchor'   => {
            # end anchor: Text@(792, 11392) Rot=0 Length=41 Text=>Signed for Insurance Specialists Company.< SeqId=35
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 792' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^Signed for Insurance Specialists Company/' },
				'Skip' => 1
			}
		},
		'Width'       => 10000,
		'ContentDef'  => { 'Type' => 'Paragraph' },
	}
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'          => 'policysign',
		'StartAnchor' => {
            # start anchor: Text@(792, 11392) Rot=0 Length=41 Text=>Signed for Insurance Specialists Company.< SeqId=35
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 792' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^Signed for Insurance Specialists Company/' }
			}
		},
		'EndAnchor'   => {
            # end anchor: Text@(792, 11392) Rot=0 Length=41 Text=>Signed for Insurance Specialists Company.< SeqId=35
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 792' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^Signed for Insurance Specialists Company/' }
			}
		},
		'Width'       => 10000,
		'ContentDef'  => { 'Type' => 'Paragraph' },
	}
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'          => 'secretarysign',
		'StartAnchor' => {
            # start anchor: Image@(1008, 11992) Rot=0 Name=S1JRSMTH Width=-1 Height=-1 SeqId=51
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'IMAGE', 'CONDITION' => 'ATTR_XPOS EQ 1008' }, 
				'COND2' => { 'OBJ_TYPE'  => 'IMAGE', 'CONDITION' => 'ATTR_NAME EQ S1JRSMTH' }
			}
		},
		'EndAnchor'   => {
            # end anchor: Image@(1008, 11992) Rot=0 Name=S1JRSMTH Width=-1 Height=-1 SeqId=51
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'IMAGE', 'CONDITION' => 'ATTR_XPOS EQ 1008' }, 
				'COND2' => { 'OBJ_TYPE'  => 'IMAGE', 'CONDITION' => 'ATTR_NAME EQ S1JRSMTH' }
			}
		},
		'Width'       => 1150,
		'Info'        => '{ "alt": "Secretary James R. Smith" }',
		'ContentDef'  => { 'Type' => 'Illustration' }
	}
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'          => 'presidentsign',
		'StartAnchor' => {
            # start anchor: Image@(4896, 11992) Rot=0 Name=IBL00001 Width=-1 Height=-1 SeqId=52
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'IMAGE', 'CONDITION' => 'ATTR_XPOS EQ 4896' }, 
				'COND2' => { 'OBJ_TYPE'  => 'IMAGE', 'CONDITION' => 'ATTR_NAME EQ IBL00001' }
			}
		},
		'EndAnchor'   => {
            # end anchor: Image@(4896, 11992) Rot=0 Name=IBL00001 Width=-1 Height=-1 SeqId=52
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'IMAGE', 'CONDITION' => 'ATTR_XPOS EQ 4896' }, 
				'COND2' => { 'OBJ_TYPE'  => 'IMAGE', 'CONDITION' => 'ATTR_NAME EQ IBL00001' }
			}
		},
		'Width'       => 1150,
		'Info'        => '{ "alt": "President DL" }',
		'ContentDef'  => { 'Type' => 'Illustration' }
	}
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'          => 'countersign',
		'StartAnchor' => {
            # start anchor: Image@(8640, 11992) Rot=0 Name=IMG00000 Width=-1 Height=-1 SeqId=53
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'IMAGE', 'CONDITION' => 'ATTR_XPOS EQ 8640' }, 
				'COND2' => { 'OBJ_TYPE'  => 'IMAGE', 'CONDITION' => 'ATTR_NAME EQ IMG00000' }
			}
		},
		'EndAnchor'   => {
            # end anchor: Image@(8640, 11992) Rot=0 Name=IMG00000 Width=-1 Height=-1 SeqId=53
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'IMAGE', 'CONDITION' => 'ATTR_XPOS EQ 8640' }, 
				'COND2' => { 'OBJ_TYPE'  => 'IMAGE', 'CONDITION' => 'ATTR_NAME EQ IMG00000' }
			}
		},
		'Width'       => 1150,
		'Info'        => '{ "alt": "Countersigned by: Henry P. Dugan" }',
		'ContentDef'  => { 'Type' => 'Illustration' }
	}

	#---- Page 2 blocks ----#
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'         => 'policyheader2',
		'StartAnchor' => {
            # start anchor:
            # Text@(720, 2296) Rot=0 Length=6 Text=>Policy< SeqId=3
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 720' },
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_YPOS EQ 2296' },
				'COND3' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^Policy$/' }
			}
		},
		'EndAnchor'   => {
            # end anchor:
            # Text@(720, 2896) Rot=0 Length=26 Text=>The Preferred Professional< SeqId=6
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS GE 720' },
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^The Preferred Professional$/' }
			}
		},
		'Width'       => 4000,
		'ContentDef'  => { 'Type' => 'Paragraph' }
	}
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'          => 'insured2',
		'StartAnchor' => {
            # start anchor:
            # Text@(720, 3756) Rot=0 Length=7 Text=>Insured< SeqId=7
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 720' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^Insured$/' }
			}
		},
		'EndAnchor'   => {
            # end anchor:
            # Text@(720, 4206) Rot=0 Length=6 Text=>Policy< SeqId=9
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS GE 720' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^Policy/' },
				'Skip' => 1
			}
		},
		'Width'       => 3600,
		'ContentDef'  => { 'Type' => 'Paragraph', 'Definition'=> { 'TagLineAsParagraph'=>1 } }
	}
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'          => 'policynumber2',
		'StartAnchor' => {
            # start anchor:
            # Text@(720, 4206) Rot=0 Length=6 Text=>Policy< SeqId=9
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS GE 720' },
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_YPOS GE 4206' },
				'COND3' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^Policy$/' }
			}
		},
		'EndAnchor'   => {
            # end anchor:
            # Text@(2448, 4446) Rot=0 Length=14 Text=>324-1443255-11< SeqId=13
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 2448' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^\d{3}-\d{7}-\d{2}$/' }
			}
		},
		'Width'       => 5400,
		'ContentDef'  => { 'Type' => 'Paragraph', 'Definition'=> { 'TagLineAsParagraph'=>1 } }
	}
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'         => 'policydate',
		'StartAnchor' => {
            # start anchor:
            # Text@(7344, 4206) Rot=0 Length=4 Text=>Date< SeqId=10
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS GE 7300' },
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^Date$/' }
			}
		},
		'EndAnchor'   => {
            # end anchor:
            # Text@(9072, 4446) Rot=0 Length=8 Text=>03-25-53< SeqId=15
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS GE 9000' },
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^\d{2}-\d{2}-\d{2}$/' }
			}
		},
		'Width'       => 5400,
		'ContentDef'  => { 'Type' => 'Paragraph', 'Definition'=> { 'TagLineAsParagraph'=>1 } }
	}
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'         => 'tableofbenefitstitle',
		'StartAnchor' => {
            # start anchor:
            # Text@(720, 5226) Rot=0 Length=17 Text=>Table of Benefits< SeqId=16
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 720' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^Table of Benefits$/' }
			}
		},
		'EndAnchor'   => {
            # end anchor:
            # Text@(720, 5226) Rot=0 Length=17 Text=>Table of Benefits< SeqId=16
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 720' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^Table of Benefits$/' }
			}
		},
		'Width'       => 5400,
		'ContentDef' => { 'Type' => 'Paragraph' }
	}
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'         => 'tableofbenefits',
		'StartAnchor' => {
            # start anchor:
            # Text@(720, 5541) Rot=0 Length=5 Text=>Total< SeqId=18
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 720' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^Total$/' }
			}
		},
		'EndAnchor'   => {
            # end anchor:
            # Text@(1008, 7056) Rot=0 Length=61 Text=>BUT FOR ANY MAXIMUM BENEFIT PERIOD OTHER THAN LIFETIME, TOTAL< SeqId=37
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 1008' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^BUT FOR ANY MAXIMUM BENEFIT PERIOD/' },
				'Skip' => 1
			}
		},
		'Width'       => 10200,
		'ContentDef' => {
			'Type' => 'Table',
			'Definition' => {
				'Header' => '1stRow',
				'HeaderLineCount' => 2,
				'Columns' => {
					'C1' => 720,
					'C2' => 3528,
					'C3' => 7344,
					'C4' => 9749
				},
				'PrimaryColumns' => [ 'C1' ]
			}
		}
	}
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'         => 'tableofbenefitsinfo',
		'StartAnchor' => {
            # start anchor:
            # Text@(1008, 7056) Rot=0 Length=61 Text=>BUT FOR ANY MAXIMUM BENEFIT PERIOD OTHER THAN LIFETIME, TOTAL< SeqId=37
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 1008' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^BUT FOR ANY MAXIMUM BENEFIT PERIOD/' }
			}
		},
		'EndAnchor'   => {
            # end anchor:
            # Text@(720, 9276) Rot=0 Length=28 Text=>Table of Additional Benefits< SeqId=44
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 720' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^Table of Additional Benefits$/' },
				'Skip'  => 1
			}
		},
		'StartX'      => 720,
		'Width'       => 10200,
		'ContentDef' => { 'Type' => 'Paragraph' }
	}
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'         => 'tableofaddlbenefitstitle',
		'StartAnchor' => {
            # start anchor:
            # Text@(720, 9276) Rot=0 Length=28 Text=>Table of Additional Benefits< SeqId=44
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 720' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^Table of Additional Benefits$/' }
			}
		},
		'EndAnchor'   => {
            # end anchor:
            # Text@(720, 9276) Rot=0 Length=28 Text=>Table of Additional Benefits< SeqId=44
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 720' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^Table of Additional Benefits$/' }
			}
		},
		'Width'       => 5400,
		'ContentDef' => { 'Type' => 'Paragraph' }
	}
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'          => 'tableofaddlbenefits',
		'StartAnchor' => {
            # start anchor:
            # Text@(720, 9591) Rot=0 Length=10 Text=>Additional< SeqId=46
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 720' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^Additional$/' }
			}
		},
		'EndAnchor'   => {
            # end anchor:
            # Text@(720, 12576) Rot=0 Length=7 Text=>Premium< SeqId=71
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 720' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^Premium/' },
				'Skip' => 1
			}
		},
		'Width'       => 10200,
		'ContentDef' => {
			'Type' => 'Table',
			'Definition' => {
				'Header' => '1stRow',
				'HeaderLineCount' => 3,
				'Columns' => {
					'C1' => 720,
					'C2' => 4824,
					'C3' => 7344,
					'C4' => 9547
				},
				'PrimaryColumns' => [ 'C1' ]
			}
		}
	}
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'         => 'premiumsummarystitle',
		'StartAnchor' => {
            # start anchor:
            # Text@(720, 12576) Rot=0 Length=7 Text=>Premium< SeqId=71
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 720' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^Premium/' }
			}
		},
		'EndAnchor'   => {
            # end anchor:
            # Text@(1992, 12576) Rot=0 Length=7 Text=>Summary< SeqId=72
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 1992' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^Summary$/' }
			}
		},
		'Width'       => 5400,
		'ContentDef' => { 'Type' => 'Paragraph' }
	}
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'          => 'premiumsummary',
		'StartAnchor' => {
            # start anchor:
            # Text@(720, 12921) Rot=0 Length=39 Text=>Annual Premium for Additional Benefits:< SeqId=74
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 720' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^Annual Premium for/' }
			}
		},
		'EndAnchor'   => {
            # end anchor:
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'ANY', 'CONDITION' => 'ATTR_PAGELAST EQ 1' }
			}
		},
		'Width'       => 10200,
		'ContentDef' => { 'Type' => 'Paragraph' }
	}

	#---- Page 3 blocks ----#
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'         => 'part1definitions',
		'StartAnchor' => {
            # start anchor:
            # Text@(3744, 2338) Rot=0 Length=20 Text=>Part 1 - Definitions< SeqId=3
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 3744' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^Part 1 - Definitions/' }
			}
		},
		'EndAnchor'   => {
            # end anchor:
            # Text@(3744, 2338) Rot=0 Length=20 Text=>Part 1 - Definitions< SeqId=3
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 3744' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^Part 1 - Definitions/' }
			}
		},
		'StartX'      => 3700,
		'Width'       => 3400,
		'ContentDef' => { 'Type' => 'Paragraph' }
	}
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'         => 'meaningsintro',
		'StartAnchor' => {
            # start anchor:
            # Text@(3744, 3022) Rot=0 Length=58 Text=>THE FOLLOWING WORDS HAVE SPECIAL MEANINGS. THEY ARE IMPOR-< SeqId=4
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 3744' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^THE FOLLOWING WORDS HAVE SPECIAL MEANINGS/' }
			}
		},
		'EndAnchor'   => {
            # end anchor:
            # Text@(3744, 3442) Rot=0 Length=58 Text=>ICY. REFER BACK TO THESE MEANINGS AS YOU READ YOUR POLICY.< SeqId=6
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 3744' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^ICY. REFER BACK TO THESE MEANINGS/' }
			}
		},
		'StartX'      => 3700,
		'Width'       => 6300,
		'ContentDef' => { 'Type' => 'Paragraph' }
	}
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'         => 'meanings1',
		'StartAnchor' => {
            # start anchor:
            # Text@(720, 3862) Rot=0 Length=11 Text=> “ Policy ”< SeqId=7
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 720' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^ . Policy ./' }
			}
		},
		'EndAnchor'   => {
            # end anchor:
            # Text@(3744, 4240) Rot=0 Length=60 Text=>endorsements make up the entire contract between You and Us.< SeqId=11
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 3744' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^endorsements make up the entire contract/' }
			}
		},
		'StartX'      => 720,
		'Width'       => 10000,
		'ContentDef' => { 'Type' => 'Paragraph' }
	}
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'         => 'meanings2',
		'StartAnchor' => {
            # start anchor:
            # Text@(720, 4639) Rot=0 Length=13 Text=> “ You ”  and< SeqId=12
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 720' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^ . You .  and/' }
			}
		},
		'EndAnchor'   => {
            # end anchor:
            # Text@(3744, 4639) Rot=0 Length=50 Text=>refer to the Insured named in the Policy Schedule.< SeqId=15
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 3744' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^refer to the Insured named in the Policy Schedule./' }
			}
		},
		'StartX'      => 720,
		'Width'       => 10000,
		'ContentDef' => { 'Type' => 'Paragraph' }
	}
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'         => 'meanings3',
		'StartAnchor' => {
            # start anchor:
            # Text@(720, 5059) Rot=0 Length=9 Text=> “ We ” ,< SeqId=16
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 720' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^ . We . ,/' }
			}
		},
		'EndAnchor'   => {
            # end anchor:
            # Text@(3744, 5248) Rot=0 Length=28 Text=>Anycity, Anystate 99999-9999< SeqId=25
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 3744' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^Anycity, Anystate 99999-9999/' }
			}
		},
		'StartX'      => 720,
		'Width'       => 10000,
		'ContentDef' => { 'Type' => 'Paragraph' }
	}
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'         => 'meanings4',
		'StartAnchor' => {
            # start anchor:
            # Text@(720, 5647) Rot=0 Length=18 Text=> “ Date of Issue ”< SeqId=26
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 720' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^ . Date of Issue ./' }
			}
		},
		'EndAnchor'   => {
            # end anchor:
            # Text@(3744, 5836) Rot=0 Length=9 Text=>Schedule.< SeqId=29
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 3744' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^Schedule./' }
			}
		},
		'StartX'      => 720,
		'Width'       => 10000,
		'ContentDef' => { 'Type' => 'Paragraph' }
	}
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'         => 'meanings5',
		'StartAnchor' => {
            # start anchor:
            # Text@(720, 6235) Rot=0 Length=11 Text=> “ Injury ”< SeqId=30
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 720' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^ . Injury ./' }
			}
		},
		'EndAnchor'   => {
            # end anchor:
            # Text@(3744, 6424) Rot=0 Length=19 Text=>Policy is in force.< SeqId=33
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 3744' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^Policy is in force./' }
			}
		},
		'StartX'      => 720,
		'Width'       => 10000,
		'ContentDef' => { 'Type' => 'Paragraph' }
	}
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'         => 'meanings6',
		'StartAnchor' => {
            # start anchor:
            # Text@(720, 6823) Rot=0 Length=13 Text=> “ Sickness ”< SeqId=34
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 720' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^ . Sickness ./' }
			}
		},
		'EndAnchor'   => {
            # end anchor:
            # Text@(3744, 7012) Rot=0 Length=34 Text=>and while Your Policy is in force.< SeqId=37
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 3744' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^and while Your Policy is in force./' }
			}
		},
		'StartX'      => 720,
		'Width'       => 10000,
		'ContentDef' => { 'Type' => 'Paragraph' }
	}
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'         => 'meanings7',
		'StartAnchor' => {
            # start anchor:
            # Text@(720, 7411) Rot=0 Length=14 Text=> “ Physician ”< SeqId=38
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 720' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^ . Physician ./' }
			}
		},
		'EndAnchor'   => {
            # end anchor:
            # Text@(3744, 7600) Rot=0 Length=67 Text=>of his or her license. A Physician must be a person other than You.< SeqId=41
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 3744' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^of his or her license./' }
			}
		},
		'StartX'      => 720,
		'Width'       => 10000,
		'ContentDef' => { 'Type' => 'Paragraph' }
	}
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'         => 'meanings8',
		'StartAnchor' => {
            # start anchor:
            # Text@(720, 7999) Rot=0 Length=21 Text=> “ Monthly Earnings ”< SeqId=42
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 720' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_YPOS EQ 7999' }, 
				'COND3' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^ . Monthly Earnings ./' }
			}
		},
		'EndAnchor'   => {
            # end anchor:
            # Text@(3744, 10220) Rot=0 Length=10 Text=>performed.< SeqId=60
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 3744' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_YPOS EQ 10220' }, 
				'COND3' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^performed./' }
			}
		},
		'StartX'      => 720,
		'Width'       => 10000,
		'ContentDef' => { 'Type' => 'Paragraph' }
	}
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'         => 'meanings9',
		'StartAnchor' => {
            # start anchor:
            # Text@(720, 10619) Rot=0 Length=21 Text=> “ Monthly Earnings ”< SeqId=61
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 720' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_YPOS EQ 10619' }, 
				'COND3' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^ . Monthly Earnings ./' }
			}
		},
		'EndAnchor'   => {
            # end anchor:
            # Text@(4152, 11328) Rot=0 Length=51 Text=>Income not derived from Your vocational activities.< SeqId=68
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 4152' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_YPOS EQ 11328' }, 
				'COND3' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^Income not derived from Your vocational activities./' }
			}
		},
		'StartX'      => 720,
		'Width'       => 10000,
		'ContentDef' => { 'Type' => 'Paragraph' }
	}
	, 'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id'         => 'meanings10',
		'StartAnchor' => {
            # start anchor:
            # Text@(720, 11727) Rot=0 Length=19 Text=> “ Prior Earnings ”< SeqId=69
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 720' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^ . Prior Earnings ./' }
			}
		},
		'EndAnchor'   => {
            # end anchor:
            # Text@(4152, 12624) Rot=0 Length=59 Text=>ing the five-year period just before Your Disability began.< SeqId=77 PageLast=Y
			'Constraints' => {
				'COND1' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_XPOS EQ 4152' }, 
				'COND2' => { 'OBJ_TYPE'  => 'TEXT', 'CONDITION' => 'ATTR_TEXT EQ qr/^ing the five-year period just before Your Disability began./' }
			}
		},
		'StartX'      => 720,
		'Width'       => 10000,
		'ContentDef' => { 'Type' => 'Paragraph' }
	}
);
1;
__END__
