#-------------------------------------------------------------------------------
#  a2w::core::dm::Anchor.pm:
#  Data Mining Framework Anchor
#
#  Author  : AFP2web Team, Maas Holding GmbH
#
#  $V100   2014-05-08    Initial Release
#
#  $V101   2018-01-26    Redesigned to have multiple constraints to have OR conditionals
#
#  $V102   2018-09-11    - OXS-8490: Extended with parser anchors to preprocess objects and to invoke callback
#                          when anchor matching object is found
#
#-------------------------------------------------------------------------------
package a2w::core::dm::Anchor;

#-----------------------------------------------------------------------
# Include required modules
#-----------------------------------------------------------------------
use a2w::TypeConstants;
use a2w::core::log::Logger;
use a2w::core::dm::Constants;
use a2w::core::dm::Constraints;

#-----------------------------------------------------------------------
# Inherit from base class
#-----------------------------------------------------------------------
our @ISA = qw( a2w::core::dm::Constraints );

#-----------------------------------------------------------------------
# Constructor
#-----------------------------------------------------------------------
sub new{
    my $proto = shift;
    my $class = ref( $proto ) || $proto;

    #---- Define boolean values
    $TRUE  = $a2w::TypeConstants::TRUE;     # TRUE  boolean value
    $FALSE = $a2w::TypeConstants::FALSE;    # FALSE boolean value

    #---- Instantiate from base class to inherit base class attributes
    my $this = a2w::core::dm::Constraints->new( @_ );

    #---- Add this derived class specific attributes
    $this->{ 'Id' } = ''; # V102 Change
    #$this->{ '???' } = ???;

    bless( $this, $class );

    #---- Get logger
    our $theLogger = a2w::core::log::Logger->getSingleton();
    our $bLog = $theLogger->isRegistered( __PACKAGE__ );

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "new()" );
    #}
    return $this;
}

#-----------------------------------------------------------------------
# Destructor
#-----------------------------------------------------------------------
sub DESTROY{
    my $this = shift;
}

#-----------------------------------------------------------------------
# Mutators
#-----------------------------------------------------------------------
# V102 Begin
sub setId{
    my $this = shift;

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "setId()" );
    #}

    $this->{ 'Id' } = shift;
}
# V102 End

#-----------------------------------------------------------------------
# Accessors
#-----------------------------------------------------------------------
# V102 Begin
sub getId{
    my $this = shift;

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "getId()" );
    #}

    return $this->{ 'Id' };
}
# V102 End

#-----------------------------------------------------------------------
# Workers
#-----------------------------------------------------------------------
#...

#-----------------------------------------------------------------------
# Don't remove the following lines !!!
#-----------------------------------------------------------------------
1;
__END__
