#-------------------------------------------------------------------------------
#  a2w::core::dm::BlockFormatter.pm:
#  Data Mining Framework Block Formatter
#
#  Author  : AFP2web Team, Maas Holding GmbH
#
#  $V100   2014-05-08    Initial Release
#
#  $V101   2018-10-03    a. Extended to handle multi type chained blocks
#
#-------------------------------------------------------------------------------
package a2w::core::dm::BlockFormatter;

#-----------------------------------------------------------------------
# Include required modules
#-----------------------------------------------------------------------
use a2w::TypeConstants;
use a2w::core::log::Logger;
use a2w::core::dm::Constants;
use a2w::core::visitor::Visitor;

#-----------------------------------------------------------------------
# Constructor
#-----------------------------------------------------------------------
sub new{
    my $proto = shift;
    my $class = ref( $proto ) || $proto;

    #---- Define boolean values
    $TRUE  = $a2w::TypeConstants::TRUE;     # TRUE  boolean value
    $FALSE = $a2w::TypeConstants::FALSE;    # FALSE boolean value

    my $this = {
        #---- Flad indicating whether formatter specific finalization is done already or not
        'bFinalized' => $FALSE # V101 Change
    };
    bless( $this, $class );

    #---- Get logger
    our $theLogger = a2w::core::log::Logger->getSingleton();
    our $bLog = $theLogger->isRegistered( __PACKAGE__ );

    #if ( $bLog == $TRUE ){ $theLogger->logFunctionName( __PACKAGE__, "new()" ); }
    return $this;
}

#-----------------------------------------------------------------------
# Destructor
#-----------------------------------------------------------------------
sub DESTROY{
    my $this = shift;
}

#-----------------------------------------------------------------------
# Mutators
#-----------------------------------------------------------------------
# V101 Begin
sub setFinalized{
    my $this = shift;

    #if ( $bLog == $TRUE ){ $theLogger->logFunctionName( __PACKAGE__, "setFinalized()" ); }

    $this->{ 'bFinalized' } = shift;
}
# V101 End

#-----------------------------------------------------------------------
# Accessors
#-----------------------------------------------------------------------
# V101 Begin
sub isFinalized{
    my $this = shift;

    #if ( $bLog == $TRUE ){ $theLogger->logFunctionName( __PACKAGE__, "isFinalized()" ); }

    return $this->{ 'bFinalized' };
}
# V101 End

#-----------------------------------------------------------------------
# Workers
#-----------------------------------------------------------------------
#-----------------------------------------------------------------------
# writeFormattedBlock
#
# Asserts whether object fall in given block and returns following value
#
# 1, if object fall in given block defined region
# 0, if object does not fall in given block defined region
#
#-----------------------------------------------------------------------
sub writeFormattedBlock{
    my $this = shift;

    if ( $bLog == $TRUE ){ $theLogger->logFunctionName( __PACKAGE__, "writeFormattedBlock()" ); }

    #---- Parameter
    #
    # 1. Block
    # 2. Visitor
    #
    my $blkCurrentPar = shift;
    my $outVisitorPar = shift;
    if ( $bLog == $TRUE ){ $theLogger->logMessage( "Block: Id=>" . $blkCurrentPar->getId() . "<" ); }

    return 0;
}

#-----------------------------------------------------------------------
# Don't remove the following lines !!!
#-----------------------------------------------------------------------
1;
__END__
