#-------------------------------------------------------------------------------
#  a2w::core::dm::CompositeContentDef.pm:
#  Data Mining Framework Composite Content Definition
#
#  Must have the 'SubBlocks' attribute defined as an array reference with list of sub block ids
#
#  Collects sub blocks of current block and writes them with appropriate formatting
#
#  Author  : AFP2web Team, Maas Holding GmbH
#
#  $V100   2018-10-03    Initial Release
#
#-------------------------------------------------------------------------------
package a2w::core::dm::CompositeContentDef;

#-----------------------------------------------------------------------
# Include required modules
#-----------------------------------------------------------------------
use a2w::TypeConstants;
use a2w::core::log::Logger;
use a2w::core::dm::Constants;
use a2w::core::dm::ContentDef;

#-----------------------------------------------------------------------
# Inherit from base class
#-----------------------------------------------------------------------
our @ISA = qw( a2w::core::dm::ContentDef );

#-----------------------------------------------------------------------
# Constructor
#-----------------------------------------------------------------------
sub new{
    my $proto = shift;
    my $class = ref( $proto ) || $proto;

    #---- Define boolean values
    $TRUE  = $a2w::TypeConstants::TRUE;     # TRUE  boolean value
    $FALSE = $a2w::TypeConstants::FALSE;    # FALSE boolean value

    #---- Instantiate from base class to inherit base class attributes
    my $this = a2w::core::dm::ContentDef->new( @_ );

    #---- Add this derived class specific attributes
    $this->{ 'SubBlocks' }       = undef; # Array of sub block definitions
    $this->{ 'SubBlockObjects' } = undef; # Array of sub block objects

    bless( $this, $class );

    #---- Set base class details
    $this->{ 'Type' } = 'composite';

    #---- Get logger
    our $theLogger = a2w::core::log::Logger->getSingleton();
    our $bLog = $theLogger->isRegistered( __PACKAGE__ );

    #if ( $bLog == $TRUE ){ $theLogger->logFunctionName( __PACKAGE__, "new" ); }

    return $this;
}

#-----------------------------------------------------------------------
# Destructor
#-----------------------------------------------------------------------
sub DESTROY{
    my $this = shift;
}

#-----------------------------------------------------------------------
# Mutators
#-----------------------------------------------------------------------
sub setSubBlocks{
    my $this = shift;

    if ( $bLog == $TRUE ){ $theLogger->logFunctionName( __PACKAGE__, "setSubBlocks" ); }

    $this->{ 'SubBlocks' } = shift;
}

sub setSubBlockObjects{
    my $this = shift;

    if ( $bLog == $TRUE ){ $theLogger->logFunctionName( __PACKAGE__, "setSubBlockObjects" ); }

    $this->{ 'SubBlockObjects' } = shift;
}

#-----------------------------------------------------------------------
# Accessors
#-----------------------------------------------------------------------
sub getSubBlocks{
    my $this = shift;

    if ( $bLog == $TRUE ){ $theLogger->logFunctionName( __PACKAGE__, "getSubBlocks" ); }

    return $this->{ 'SubBlocks' };
}

sub getSubBlockObjects{
    my $this = shift;

    if ( $bLog == $TRUE ){ $theLogger->logFunctionName( __PACKAGE__, "getSubBlockObjects" ); }

    return $this->{ 'SubBlockObjects' };
}

#-----------------------------------------------------------------------
# Workers
#-----------------------------------------------------------------------
sub addSubBlockObject{
    my $this = shift;

    if ( $bLog == $TRUE ){ $theLogger->logFunctionName( __PACKAGE__, "addSubBlockObject" ); }

    #---- Get parameter
    # 1. Block object
    #
    my $subBlockPar = shift;

    #---- Check and create sub block objects list
    if ( $this->{ 'SubBlockObjects' } == undef ){ $this->{ 'SubBlockObjects' } = []; }

    #---- Add block object to list
    $this->{ 'SubBlockObjects' }[ @{ $this->{ 'SubBlockObjects' } } ] = $subBlockPar;
}

#-----------------------------------------------------------------------
# Don't remove the following lines !!!
#-----------------------------------------------------------------------
1;
__END__
