#-------------------------------------------------------------------------------
#  a2w/core/dm/Constants.pm
#
#  Perl module with constants needed for data mining
#
#  Author   : Panneer, AFP2web Team
#
#  $V109   2023-08-03    AFP-934: Extended to collect image/container unique name
#
#  $V108   2020-07-01    AFP-951: Extended with constants for annotation object
#
#  $V107   2018-10-26    a. AFP-756: Extended with constant for adjusted Y position
#                        b. AFP-756: Extended with data mining APIs to find and fetch eyecatcher/value
#
#  $V106   2018-10-22    a. AFP-743: Extended to parse page included resources recursively
#
#  $V105   2018-10-03    a. AFP-743: Extended with composite block
#                        b. Incremented Y position tolerance factor
#
#  $V104   2018-01-10    a. Extended with constants for container objects (AFP-456, AFP-623)
#                        b. Extended with constants for page begin/end marking (AFP-456)
#
#  $V103   2015-12-09    Extended with constant for page margins (AFP-320)
#
#  $V102   2015-11-17    Extended with constant for object sequence id attribute
#
#  $V101   2015-08-21    Extended to tolerate texts with minor Y position difference as one line
#
#  $V100   2014-05-08    Initial Release
#
#-------------------------------------------------------------------------------
package a2w::core::dm::Constants;

#-----------------------------------------------------------------------
# Declare constants
#-----------------------------------------------------------------------
#---- Define resource type values
$RT_FONT          = 1;            #---- Font resource
$RT_PSEG          = 2;            #---- Page segment resource
$RT_OVERLAY       = 3;            #---- Overlay resource

#---- Define object type values
$OT_TEXT          = 1;            #---- Text object
$OT_LINE          = 2;            #---- Line object
$OT_VECTOR        = 3;            #---- Vector object
$OT_IMAGE         = 4;            #---- Image object
$OT_CONTAINER     = 5;            #---- Container object # V104 Change
$OT_ANNOTATION    = 6;            #---- Annotation object # V108 Change

#---- Define attribute type values
$AT_OBJTYPE       =  1;           #---- Object type
$AT_OBJINFO       =  2;           #---- Object info
$AT_XPOS          =  3;           #---- X position
$AT_YPOS          =  4;           #---- Y position
$AT_ANGLE         =  5;           #---- Angle
$AT_ID            =  6;           #---- Id
$AT_PAGE_COUNT    =  7;           #---- Page count
$AT_PAGE_ID       =  8;           #---- Page Id
$AT_COLOR         =  9;           #---- Color
$AT_RESOLUTION    = 10;           #---- Resolution
# $V102 Begin
$AT_OBJSEQID      = 11;           #---- Object sequence id
# $V102 End
# $V104 Begin
$AT_PAGEFIRST     = 12;           #---- Flag indicating object is first of page
$AT_PAGELAST      = 13;           #---- Flag indicating object is last of page
# $V104 End
$AT_PAGEREF       = 14;           #---- Page reference (of type a2w::core::dm::Database) # $V105 Change
$AT_ADJ_YPOS      = 15;           #---- Adjusted Y position # $V107 Change
$AT_SEARCH_INDEX  = 16;           #---- Eyecatcher search iterator's index # $V107 Change
$AT_SEARCH_RESULT = 17;           #---- Eyecatcher search result (matching regexp) # $V107 Change

# $V108 Begin
$AT_SF_OBJECT     = 18;           #---- Flag indicating object is added through Scripting Facility
$AT_OBJSEQID_BG   = 19;           #---- Object's sequence id for background ordering
$AT_OBJSEQID_FG   = 20;           #---- Object's sequence id for foreground ordering
# $V108 End

#---- Define object type specific info
$OI_TEXT_VALUE       = 1;         #---- Text value
$OI_TEXT_LENGTH      = 2;         #---- Text value length
$OI_TEXT_FONTID      = 3;         #---- Text applied font local id
$OI_TEXT_FONTHT      = 4;         #---- Text applied font height
                  
$OI_LINE_WIDTH       = 1;         #---- Line width
$OI_LINE_LENGTH      = 2;         #---- Line length
                  
$OI_VECTOR_WIDTH     = 1;         #---- Line width
$OI_VECTOR_HEIGHT    = 2;         #---- Line length
                  
$OI_IMAGE_WIDTH       = 1;        #---- Image width
$OI_IMAGE_HEIGHT      = 2;        #---- Image height
$OI_IMAGE_NAME        = 3;        #---- Image name
$OI_IMAGE_RESOLUTION  = 4;        #---- Image resolution
$OI_IMAGE_UNIQUE_NAME = 5;        #---- Image unique name # V109 Change

# $V104 Begin
$OI_CONTAINER_WIDTH       = 1;    #---- Container width
$OI_CONTAINER_HEIGHT      = 2;    #---- Container height
$OI_CONTAINER_NAME        = 3;    #---- Container name
$OI_CONTAINER_RESOLUTION  = 4;    #---- Container resolution
$OI_CONTAINER_OBJECTTYPE  = 5;    #---- Container object type
$OI_CONTAINER_UNIQUE_NAME = 6;    #---- Image unique name # V109 Change
# $V104 End

# $V108 Begin
$OI_ANNOTATION_WIDTH        = 1;     #---- Annotation width
$OI_ANNOTATION_HEIGHT       = 2;     #---- Annotation height
$OI_ANNOTATION_URL          = 3;     #---- Annotation name
$OI_ANNOTATION_BORDER_WIDTH = 4;     #---- Annotation border width
$OI_ANNOTATION_FLAGS        = 5;     #---- Annotation flags
$OI_ANNOTATION_ACTION_FLAGS = 6;     #---- Annotation action flags
# $V108 End

#---- Define block id constants ----#
$BLK_DMF_PREFIX      = "A2W_DMF_";
$BLK_PAGE_DEF_PREFIX = $BLK_DMF_PREFIX . "PAGE_DEF_";

#---- Page related predefined block ids
$BLK_DOC_HEADER      = $BLK_DMF_PREFIX . "DOCUMENT_HEADER";
$BLK_PAGE_HEADER     = $BLK_DMF_PREFIX . "PAGE_HEADER";
$BLK_PAGE_BODY       = $BLK_DMF_PREFIX . "PAGE_BODY";
$BLK_PAGE_FOOTER     = $BLK_DMF_PREFIX . "PAGE_FOOTER";
$BLK_DOC_FOOTER      = $BLK_DMF_PREFIX . "DOCUMENT_FOOTER";

# $V101 Begin
#---- Content processing constants ----#
# V105 Change: Incremented value from 0.025 to 0.05
$CONT_LINE_TOLERANCE = 0.05;       #---- Value in Inches, Tolerate lines occurring consecutive within given range as ONE line
# $V101 End

# $V103 Begin
$PAGE_MARGIN_LEFT   = 0.1;         #---- Value in Inches, page left margin
$PAGE_MARGIN_RIGHT  = 0.1;         #---- Value in Inches, page right margin
$PAGE_MARGIN_TOP    = 0.1;         #---- Value in Inches, page top margin
$PAGE_MARGIN_BOTTOM = 0.1;         #---- Value in Inches, page bottom margin
# $V103 End

# $V106 Begin
# Type in parent context. Used to determine parent type and evaluate factor based on type
$PARENT_TYPE_PAGE        = 1;
$PARENT_TYPE_OVERLAY     = 2;
$PARENT_TYPE_PAGESEGMENT = 3;
$PARENT_TYPE_TEXT        = 4;
$PARENT_TYPE_IMAGE       = 5;
$PARENT_TYPE_CONTAINER   = 6;
$PARENT_TYPE_LINE        = 7;
$PARENT_TYPE_VECTOR      = 8;
# $V106 End

# $V107 Begin
# Search direction of eyecatcher value from eyecatcher
$EYECATCHER_SEARCH_DIR_RIGHT  = 1;
$EYECATCHER_SEARCH_DIR_LEFT   = 2;
$EYECATCHER_SEARCH_DIR_TOP    = 3;
$EYECATCHER_SEARCH_DIR_BOTTOM = 4;
# $V107 End

#-----------------------------------------------------------------------
# Don't remove the following lines !!!
#-----------------------------------------------------------------------
1;
__END__
