#-------------------------------------------------------------------------------
#  a2w/core/dm/FindAndPrepend.pm
#
#  Perl module to add output specific custom content before the eyecatcher found
#  in block content
#
#  Author   : Panneer, AFP2web Team
#  Date     : 2021-09-21
#  Version  : 1.0.0
#
#  V100   2021-09-21    AFP-1068: Initial Release
#
#-------------------------------------------------------------------------------
package a2w::core::dm::FindAndPrepend;

#-----------------------------------------------------------------------
# Include required modules
#-----------------------------------------------------------------------
use a2w::TypeConstants;
use a2w::core::log::Logger;

use a2w::core::dm::Constants;
use a2w::core::dm::Constraint;
use a2w::core::dm::Constraints;

#-----------------------------------------------------------------------
# Inherit from base class
#-----------------------------------------------------------------------
our @ISA = qw( a2w::core::dm::Constraints );

#-----------------------------------------------------------------------
# Constructor
#-----------------------------------------------------------------------
sub new{
    my $proto = shift;
    my $class = ref( $proto ) || $proto;

    #---- Instantiate from base class to inherit base class attributes
    my $this = a2w::core::dm::Constraints->new( @_ );

    #---- Add this derived class specific attributes
    $this->{ 'Name' }    = '';            # Name
    $this->{ 'Prepend' } = '';            # Prepend value
    $this->{ 'Column' }  = '';            # Column name (optional)
    $this->{ 'ProcessedResult' } = '';    # Processed result value

    bless( $this, $class );

    #---- Define boolean values
    $TRUE  = $a2w::TypeConstants::TRUE;     # TRUE  boolean value
    $FALSE = $a2w::TypeConstants::FALSE;    # FALSE boolean value

    #---- Get logger
    our $theLogger = a2w::core::log::Logger->getSingleton();
    our $bLog = $theLogger->isRegistered( __PACKAGE__ );

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "new()" );
    #}

    return $this;
}

#-----------------------------------------------------------------------
# Destructor
#-----------------------------------------------------------------------
sub DESTROY{
    my $this = shift;
}

#-----------------------------------------------------------------------
# Mutators
#-----------------------------------------------------------------------
sub setName{
    my $this = shift;

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "setName()" );
    #}

    $this->{ 'Name' } = shift;
}

sub setPrepend{
    my $this = shift;

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "setPrepend()" );
    #}

    $this->{ 'Prepend' } = shift;
}

sub setColumn{
    my $this = shift;

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "setColumn()" );
    #}

    $this->{ 'Column' } = shift;
}

sub setProcessedResult{
    my $this = shift;

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "setProcessedResult()" );
    #}

    $this->{ 'ProcessedResult' } = shift;
}

#-----------------------------------------------------------------------
# Accessors
#-----------------------------------------------------------------------
sub getName{
    my $this = shift;

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "getName()" );
    #}

    return $this->{ 'Name' };
}

sub getPrepend{
    my $this = shift;

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "getPrepend()" );
    #}

    return $this->{ 'Prepend' };
}

sub getColumn{
    my $this = shift;

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "getColumn()" );
    #}

    return $this->{ 'Column' };
}

sub getProcessedResult{
    my $this = shift;

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "getProcessedResult()" );
    #}

    return $this->{ 'ProcessedResult' };
}

#-----------------------------------------------------------------------
# Workers
#-----------------------------------------------------------------------
sub execute{
    my $this = shift;

    if ( $bLog == $TRUE ){
        $theLogger->logFunctionName( __PACKAGE__, "execute()" );
    }

    #---- Get parameter
    #
    # 1. Object
    # 2. POM object wrapper
    # 3. Text Reference
    #
    my $a2wObjectPar = shift;
    my $pomObjectPar = shift;
    my $sTextRefPar  = shift;

    #---- Reset result
    $this->resetResults();
    $this->setProcessedResult( undef );

    #---- Assert whether object match constraints
    my $iRetTmp     = -1;
    my $sResultTmp  = '';
    my $sPrependTmp = $this->{ 'Prepend' };
    if (    $this->doesConstraintsMatch( $a2wObjectPar, $pomObjectPar ) == $TRUE
         && $pomObjectPar->{ $a2w::core::dm::Constants::AT_OBJTYPE } == $a2w::core::dm::Constants::OT_TEXT
       ){
        #---- Constraints match, evaluate the result
        $iRetTmp = 0;
        $sResultTmp = $this->getResult();

        #---- Check whether prepend has any 'FIND_RESULT' place holder, if so replace place holder with find result
        $sPrependTmp =~ s/\FIND\_RESULT\/$sResultTmp/g;
        $this->setProcessedResult( $sPrependTmp );

        if ( $bLog == $TRUE ){
            $theLogger->logMessage( "FNP: " . $this->{ 'Name' } . "=>" . $sResultTmp . "< Prepend:>" . $this->{ 'Prepend' } . "< ReplacedValue:>" . $sPrependTmp . "<" );
        }
    }

    return $iRetTmp;
}

#-----------------------------------------------------------------------
# Don't remove the following lines !!!
#-----------------------------------------------------------------------
1;
__END__

