#-------------------------------------------------------------------------------
#  a2w/core/dm/Index.pm
#
#  Perl module to process block contents and to evaluate index
#
#  Author   : Panneer, AFP2web Team
#  Date     : 2018-01-26
#  Version  : 1.0.1
#
#  $V100   2014-02-14    Initial Release
#
#  $V101   2018-01-26    Redesigned to have multiple constraints to have OR conditionals
#
#  $V102   2018-09-04    Fixed minor bug in detecting index
#
#-------------------------------------------------------------------------------
package a2w::core::dm::Index;

#-----------------------------------------------------------------------
# Include required modules
#-----------------------------------------------------------------------
use a2w::TypeConstants;
use a2w::core::log::Logger;

use a2w::core::dm::Constants;
use a2w::core::dm::Constraint;
use a2w::core::dm::Constraints;

#-----------------------------------------------------------------------
# Inherit from base class
#-----------------------------------------------------------------------
our @ISA = qw( a2w::core::dm::Constraints );

#-----------------------------------------------------------------------
# Constructor
#-----------------------------------------------------------------------
sub new{
    my $proto = shift;
    my $class = ref( $proto ) || $proto;

    #---- Instantiate from base class to inherit base class attributes
    my $this = a2w::core::dm::Constraints->new( @_ );

    #---- Add this derived class specific attributes
    $this->{ 'Name' }   = '';    # Name
    $this->{ 'Value' }  = '';    # Value

    bless( $this, $class );

    #---- Define boolean values
    $TRUE  = $a2w::TypeConstants::TRUE;     # TRUE  boolean value
    $FALSE = $a2w::TypeConstants::FALSE;    # FALSE boolean value

    #---- Get logger
    our $theLogger = a2w::core::log::Logger->getSingleton();
    our $bLog = $theLogger->isRegistered( __PACKAGE__ );

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "new()" );
    #}

    return $this;
}

#-----------------------------------------------------------------------
# Destructor
#-----------------------------------------------------------------------
sub DESTROY{
    my $this = shift;
}

#-----------------------------------------------------------------------
# Mutators
#-----------------------------------------------------------------------
sub setName{
    my $this = shift;

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "setName()" );
    #}

    $this->{ 'Name' } = shift;
}

sub setValue{
    my $this = shift;

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "setValue()" );
    #}

    $this->{ 'Value' } = shift;
}

#-----------------------------------------------------------------------
# Accessors
#-----------------------------------------------------------------------
sub getName{
    my $this = shift;

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "getName()" );
    #}

    return $this->{ 'Name' };
}

sub getValue{
    my $this = shift;

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "getValue()" );
    #}

    return $this->{ 'Value' };
}

#-----------------------------------------------------------------------
# Workers
#-----------------------------------------------------------------------
sub evaluate{
    my $this = shift;

    if ( $bLog == $TRUE ){
        $theLogger->logFunctionName( __PACKAGE__, "evaluate()" );
    }

    #---- Get parameter
    #
    # 1. Object
    # 2. POM object wrapper
    #
    my $a2wObjectPar = shift;
    my $pomObjectPar = shift;

    if ( $bLog == $TRUE ){ $theLogger->logMessage( "Evaluating " . $this->{ 'Name' } . " index value" ); } # $V101 Change

    #---- Assert whether object match constraints
    my $iRetTmp = -1;
    if (    $this->doesConstraintsMatch( $a2wObjectPar, $pomObjectPar ) == $TRUE # $V101 Change
         && $pomObjectPar->{ $a2w::core::dm::Constants::AT_OBJTYPE } == $a2w::core::dm::Constants::OT_TEXT
       ){
        #---- Constraints match, get the index value
        if ( $this->{ 'Value' } =~ /^qr\/(.*)\/$/ ){
            my $reValueTmp = qr/$1/;
            my $sTextTmp = $pomObjectPar->{ $a2w::core::dm::Constants::AT_OBJINFO }{ $a2w::core::dm::Constants::OI_TEXT_VALUE };
            if ( $sTextTmp =~ $reValueTmp ){
                $iRetTmp = 0; # V102 Change
                $this->{ 'RecentConstraints' }{ 'Result' } = $1; # $V101 Change
            }
        }
        else {
            #---- Value is not regular expression, just use value AS result
            $iRetTmp = 0; # V102 Change
            $this->{ 'RecentConstraints' }{ 'Result' } = $this->{ 'Value' }; # $V101 Change
        }
        if ( $bLog == $TRUE ){
            $theLogger->logMessage( "Index: " . $this->{ 'Name' } . "=>" . $this->{ 'RecentConstraints' }{ 'Result' } . "<" ); # $V101 Change
        }
    }

    return $iRetTmp;
}

#-----------------------------------------------------------------------
# Don't remove the following lines !!!
#-----------------------------------------------------------------------
1;
__END__

