#-------------------------------------------------------------------------------
#  a2w::core::dm::ListContentDef.pm
#  Data Mining Framework List Content Definition
#
#  Author  : AFP2web Team, Maas Holding GmbH
#
#  $V100   2018-11-29    Initial Release
#
#-------------------------------------------------------------------------------
package a2w::core::dm::ListContentDef;

#-----------------------------------------------------------------------
# Include required modules
#-----------------------------------------------------------------------
use a2w::TypeConstants;
use a2w::core::log::Logger;
use a2w::core::dm::Constants;
use a2w::core::dm::ContentDef;

#-----------------------------------------------------------------------
# Inherit from base class
#-----------------------------------------------------------------------
our @ISA = qw( a2w::core::dm::ContentDef );

#-----------------------------------------------------------------------
# Constructor
#-----------------------------------------------------------------------
sub new{
    my $proto = shift;
    my $class = ref( $proto ) || $proto;

    #---- Define boolean values
    $TRUE  = $a2w::TypeConstants::TRUE;     # TRUE  boolean value
    $FALSE = $a2w::TypeConstants::FALSE;    # FALSE boolean value

    #---- Instantiate from base class to inherit base class attributes
    my $this = a2w::core::dm::ContentDef->new( @_ );

    #---- Add this derived class specific attributes
    # Ordered or Unordered list flag
    #
    # Default is TRUE
    #
    $this->{ 'Ordered' } = $TRUE;

    # Start X position of list item body text
    $this->{ 'BodyPosition' } = undef;

    # List caption flag
    #
    # When turned on, list formatting will use the first line of content as list caption
    # Default is off
    #
    $this->{ 'Caption' } = $FALSE;

    bless( $this, $class );

    #---- Set base class details
    $this->{ 'Type' } = 'list';

    #---- Get logger
    our $theLogger = a2w::core::log::Logger->getSingleton();
    our $bLog = $theLogger->isRegistered( __PACKAGE__ );

    #if ( $bLog == $TRUE ){ $theLogger->logFunctionName( __PACKAGE__, "new" ); }

    return $this;
}

#-----------------------------------------------------------------------
# Destructor
#-----------------------------------------------------------------------
sub DESTROY{
    my $this = shift;
}

#-----------------------------------------------------------------------
# Mutators
#-----------------------------------------------------------------------
sub setOrdered{
    my $this = shift;

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "setOrdered()" );
    #}

    $this->{ 'Ordered' } = shift;
}

sub setBodyPosition{
    my $this = shift;

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "setBodyPosition()" );
    #}

    $this->{ 'BodyPosition' } = shift;
}

sub setCaption{
    my $this = shift;

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "setCaption()" );
    #}

    $this->{ 'Caption' } = shift;
}

#-----------------------------------------------------------------------
# Accessors
#-----------------------------------------------------------------------
sub isOrdered{
    my $this = shift;

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "isOrdered()" );
    #}

    return $this->{ 'Ordered' };
}

sub getBodyPosition{
    my $this = shift;

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "getBodyPosition()" );
    #}

    return $this->{ 'BodyPosition' };
}

sub hasCaption{
    my $this = shift;

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "hasCaption()" );
    #}

    return $this->{ 'Caption' };
}

#-----------------------------------------------------------------------
# Workers
#-----------------------------------------------------------------------

#-----------------------------------------------------------------------
# Don't remove the following lines !!!
#-----------------------------------------------------------------------
1;
__END__
