#-------------------------------------------------------------------------------
#  a2w/core/ext/Annotation.pm:
#  Extension module with additional processing functionalities
#
#  Author  : Fa. Maas
#
#  V102   2021-06-10    AFP-1046: Extended to get page id (in which object exists)
#
#  V101   2020-10-12    AFP-979: Extended with _toString() API to dump object
#
#  V100   2020-09-29    Initial Release
#
#-------------------------------------------------------------------------------

#
# NOTE:
# Though the filename is a2w/core/ext/Annotation.pm, in actual it is 'a2w::Annotation' module extension
#

package a2w::Annotation;

use a2w::Annotation;
use a2w::core::log::Logger;

#-----------------------------------------------------------------------
# Workers
#-----------------------------------------------------------------------
#------------------------------------------------------------------------
# _getType
#
# Get type of object
#
# Returns
#   Object type
#
#------------------------------------------------------------------------
sub _getType{
    $this = shift;
    
    #---- Get logger
    $theLoggerLocal = a2w::core::log::Logger->getSingleton();
    my $bLogTmp = $theLoggerLocal->isRegistered( __PACKAGE__ );

    if ( $bLogTmp ){
        $theLoggerLocal->logFunctionName( __PACKAGE__, "_getType" );
    }

    return "annotation";
}

#------------------------------------------------------------------------
# _getAttribute
#
# Get value of given attribute
#
# Parameter
# 1. Attribute name
#
# Returns
#   Attribute value, if such attribute exists
#   undef otherwise
#
#------------------------------------------------------------------------
sub _getAttribute{
    $this = shift;
    
    #---- Get logger
    $theLoggerLocal = a2w::core::log::Logger->getSingleton();
    my $bLogTmp = $theLoggerLocal->isRegistered( __PACKAGE__ );

    if ( $bLogTmp ){
        $theLoggerLocal->logFunctionName( __PACKAGE__, "_getAttribute" );
    }

    #---- Get Parameter
    # 1. Attribute name
    # 2. POM object wrapper (optional)
    #
    my $sAttrNamePar = lc( shift );
    my $pomObjectPar = undef;
    if ( @_ > 0 ){
        $pomObjectPar = shift;
    }

    #---- Searches POM object first and then kernel object ----#
    if ( $pomObjectPar != undef ){
        #---- Attribute name to id mapping
        my $hrefObjAttrMapTmp = {
              'xpos'  => $a2w::core::dm::Constants::AT_XPOS
            , 'ypos'  => $a2w::core::dm::Constants::AT_YPOS
            , 'color' => $a2w::core::dm::Constants::AT_COLOR
            , 'pagefirst' => $a2w::core::dm::Constants::AT_PAGEFIRST
            , 'pagelast' => $a2w::core::dm::Constants::AT_PAGELAST
            , 'pageid' => $a2w::core::dm::Constants::AT_PAGE_ID       # V102 Change
        };
        if ( $hrefObjAttrMapTmp->{ $sAttrNamePar } != undef ){
            return $pomObjectPar->{ $hrefObjAttrMapTmp->{ $sAttrNamePar } };
        }
        my $hrefContAttrMapTmp = {
              'width'       => $a2w::core::dm::Constants::OI_ANNOTATION_WIDTH
            , 'height'      => $a2w::core::dm::Constants::OI_ANNOTATION_HEIGHT
            , 'url'         => $a2w::core::dm::Constants::OI_ANNOTATION_NAME
            , 'borderwidth' => $a2w::core::dm::Constants::OI_ANNOTATION_BORDER_WIDTH
            , 'flags'       => $a2w::core::dm::Constants::OI_ANNOTATION_FLAGS
            , 'actionflags' => $a2w::core::dm::Constants::OI_ANNOTATION_ACTION_FLAGS
        };
        if ( $hrefContAttrMapTmp->{ $sAttrNamePar } != undef ){
            return $pomObjectPar->{ $a2w::core::dm::Constants::AT_OBJINFO }{ $hrefContAttrMapTmp->{ $sAttrNamePar } };
        }
    }

    #---- Attribute name to accessor method mapping
    my $hrefMethodMapTmp = {
          'xpos'               => 'getXPos'
        , 'ypos'               => 'getYPos'
        , 'width'              => 'getWidth'
        , 'height'             => 'getHeight'
        , 'color'              => 'getColor'
        , 'url'                => 'getURL'
        , 'borderwidth'        => 'getBorderWidth'
        , 'flags'              => 'getFlags'
        , 'actionflags'        => 'getActionFlags'
    };
    my $sMethodNameTmp = $hrefMethodMapTmp->{ $sAttrNamePar };
    if ( $sMethodNameTmp eq "" ){
        #---- Name to method mapping undefined, return undef
        return undef;
    }

    return $this->$sMethodNameTmp();
}

# V101 Begin
#------------------------------------------------------------------------
# _toString
#
# Returns stringified object info
#
#------------------------------------------------------------------------
sub _toString{
    $this = shift;

    #---- Get logger
    $theLoggerLocal = a2w::core::log::Logger->getSingleton();
    my $bLogTmp = $theLoggerLocal->isRegistered( __PACKAGE__ );

    if ( $bLogTmp ){
        $theLoggerLocal->logFunctionName( __PACKAGE__, "_toString" );
    }

    return   "ant>" . $this->getURL() . "<"
           . "@(" . $this->getXPos() . "," . $this->getYPos() . ")"
           . " W=" . $this->getWidth()
           . " H=". $this->getHeight()
           ;
}
# V101 End

1;
__END__
